"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtWidgets, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import Any, List, Optional, Sequence, Union, overload
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets

bytes = str


class QTextEdit(PySide6.QtWidgets.QAbstractScrollArea):
    """
    https://doc.qt.io/qt-6/qtextedit.html

    **Detailed Description**

    **Introduction and Concepts**

    QTextEdit is an advanced WYSIWYG viewer/editor supporting rich text
    formatting using HTML-style tags, or Markdown format. It is optimized to
    handle large documents and to respond quickly to user input.

    QTextEdit works on paragraphs and characters. A paragraph is a formatted
    string which is word-wrapped to fit into the width of the widget. By default
    when reading plain text, one newline signifies a paragraph. A document
    consists of zero or more paragraphs. The words in the paragraph are aligned
    in accordance with the paragraph's alignment. Paragraphs are separated by
    hard line breaks. Each character within a paragraph has its own attributes,
    for example, font and color.

    QTextEdit can display images, lists and tables. If the text is too large to
    view within the text edit's viewport, scroll bars will appear. The text edit
    can load both plain text and rich text files. Rich text can be described
    using a subset of HTML 4 markup; refer to the **Supported HTML Subset**
    page for more information.

    If you just need to display a small piece of rich text use **QLabel** .

    The rich text support in Qt is designed to provide a fast, portable and
    efficient way to add reasonable online help facilities to applications, and
    to provide a basis for rich text editors. If you find the HTML support
    insufficient for your needs you may consider the use of Qt WebKit, which
    provides a full-featured web browser widget.

    The shape of the mouse cursor on a QTextEdit is **Qt::IBeamCursor**  by
    default. It can be changed through the **viewport** ()'s cursor property.

    **Using QTextEdit as a Display Widget**

    QTextEdit can display a large HTML subset, including tables and images.

    The text can be set or replaced using **setHtml** () which deletes any
    existing text and replaces it with the text passed in the **setHtml** ()
    call. If you call **setHtml** () with legacy HTML, and then call **toHtml**
    (), the text that is returned may have different markup, but will render the
    same. The entire text can be deleted with **clear** ().

    Text can also be set or replaced using **setMarkdown** (), and the same
    caveats apply: if you then call **toMarkdown** (), the text that is returned
    may be different, but the meaning is preserved as much as possible. Markdown
    with some embedded HTML can be parsed, with the same limitations that
    **setHtml** () has; but **toMarkdown** () only writes "pure" Markdown,
    without any embedded HTML.

    Text itself can be inserted using the **QTextCursor**  class or using the
    convenience functions **insertHtml** (), **insertPlainText** (), **append**
    () or **paste** (). **QTextCursor**  is also able to insert complex objects
    like tables or lists into the document, and it deals with creating
    selections and applying changes to selected text.

    By default the text edit wraps words at whitespace to fit within the text
    edit widget. The **setLineWrapMode** () function is used to specify the kind
    of line wrap you want, or **NoWrap**  if you don't want any wrapping. Call
    **setLineWrapMode** () to set a fixed pixel width **FixedPixelWidth** , or
    character column (e.g. 80 column) **FixedColumnWidth**  with the pixels or
    columns specified with **setLineWrapColumnOrWidth** (). If you use word wrap
    to the widget's width **WidgetWidth** , you can specify whether to break on
    whitespace or anywhere with **setWordWrapMode** ().

    The **find** () function can be used to find and select a given string
    within the text.

    If you want to limit the total number of paragraphs in a QTextEdit, as for
    example it is often useful in a log viewer, then you can use
    **QTextDocument** 's maximumBlockCount property for that.

    **Read-only Key Bindings**

    When QTextEdit is used read-only the key bindings are limited to navigation,
    and text may only be selected with the mouse:

    KeypressesAction
    UpMoves one line up.
    DownMoves one line down.
    LeftMoves one character to the left.
    RightMoves one character to the
    right.
    PageUpMoves one (viewport) page up.
    PageDownMoves one (viewport)
    page down.
    HomeMoves to the beginning of the text.
    EndMoves to the end
    of the text.
    Alt+WheelScrolls the page horizontally (the Wheel is the
    mouse wheel).
    Ctrl+WheelZooms the text.
    Ctrl+ASelects all text.

    The text edit may be able to provide some meta-information. For example, the
    **documentTitle** () function will return the text from within HTML
    `<title>` tags.

    **Note:** Zooming into HTML documents only works if the font-size is not set
    to a fixed size.

    **Using QTextEdit as an Editor**

    All the information about using QTextEdit as a display widget also applies
    here.

    The current char format's attributes are set with **setFontItalic** (),
    **setFontWeight** (), **setFontUnderline** (), **setFontFamily** (),
    **setFontPointSize** (), **setTextColor** () and **setCurrentFont** (). The
    current paragraph's alignment is set with **setAlignment** ().

    Selection of text is handled by the **QTextCursor**  class, which provides
    functionality for creating selections, retrieving the text contents or
    deleting selections. You can retrieve the object that corresponds with the
    user-visible cursor using the **textCursor** () method. If you want to set a
    selection in QTextEdit just create one on a **QTextCursor**  object and then
    make that cursor the visible cursor using **setTextCursor** (). The
    selection can be copied to the clipboard with **copy** (), or cut to the
    clipboard with **cut** (). The entire text can be selected using
    **selectAll** ().

    When the cursor is moved and the underlying formatting attributes change,
    the **currentCharFormatChanged** () signal is emitted to reflect the new
    attributes at the new cursor position.

    The **textChanged** () signal is emitted whenever the text changes (as a
    result of **setText** () or through the editor itself).

    QTextEdit holds a **QTextDocument**  object which can be retrieved using the
    **document** () method. You can also set your own document object using
    **setDocument** ().

    **QTextDocument**  provides an **isModified** () function which will return
    true if the text has been modified since it was either loaded or since the
    last call to setModified with false as argument. In addition it provides
    methods for undo and redo.

    **Drag and Drop**

    QTextEdit also supports custom drag and drop behavior. By default, QTextEdit
    will insert plain text, HTML and rich text when the user drops data of these
    MIME types onto a document. Reimplement **canInsertFromMimeData** () and
    **insertFromMimeData** () to add support for additional MIME types.

    For example, to allow the user to drag and drop an image onto a QTextEdit,
    you could the implement these functions in the following way:

    bool TextEdit::canInsertFromMimeData( const **QMimeData**  *source ) const
    {
            if (source->hasImage())
                return true;
            else
    return **QTextEdit** ::canInsertFromMimeData(source);
        }

    We add support for image MIME types by returning true. For all other MIME
    types, we use the default implementation.

    void TextEdit::insertFromMimeData( const **QMimeData**  *source )
        {
    if (source->hasImage())
            {
                **QImage**  image =
    qvariant_cast<**QImage** >(source->imageData());
                **QTextCursor**
    cursor = this->textCursor();
                **QTextDocument**  *document =
    this->document();
                document->addResource(**QTextDocument**
    ::ImageResource, **QUrl** ("image"), image);
    cursor.insertImage("image");
            }
        }

    We unpack the image from the **QVariant**  held by the MIME source and
    insert it into the document as a resource.

    **Editing Key Bindings**

    The list of key bindings which are implemented for editing:

    KeypressesAction
    BackspaceDeletes the character to the left of the cursor.
    DeleteDeletes the character to the right of the cursor.
    Ctrl+CCopy the
    selected text to the clipboard.
    Ctrl+InsertCopy the selected text to the
    clipboard.
    Ctrl+KDeletes to the end of the line.
    Ctrl+VPastes the
    clipboard text into text edit.
    Shift+InsertPastes the clipboard text into
    text edit.
    Ctrl+XDeletes the selected text and copies it to the clipboard.
    Shift+DeleteDeletes the selected text and copies it to the clipboard.
    Ctrl+ZUndoes the last operation.
    Ctrl+YRedoes the last operation.
    LeftMoves the cursor one character to the left.
    Ctrl+LeftMoves the cursor
    one word to the left.
    RightMoves the cursor one character to the right.
    Ctrl+RightMoves the cursor one word to the right.
    UpMoves the cursor one
    line up.
    DownMoves the cursor one line down.
    PageUpMoves the cursor one
    page up.
    PageDownMoves the cursor one page down.
    HomeMoves the cursor to
    the beginning of the line.
    Ctrl+HomeMoves the cursor to the beginning of
    the text.
    EndMoves the cursor to the end of the line.
    Ctrl+EndMoves the
    cursor to the end of the text.
    Alt+WheelScrolls the page horizontally (the
    Wheel is the mouse wheel).

    To select (mark) text hold down the Shift key whilst pressing one of the
    movement keystrokes, for example, **Shift+Right** will select the character
    to the right, and **Shift+Ctrl+Right** will select the word to the right,
    etc.

    **See also** **QTextDocument** , **QTextCursor** , **Qt Widgets -
    Application Example** , **Syntax Highlighter Example** , and **Rich Text
    Processing** .
    """

    AutoAll: QTextEdit.AutoFormattingFlag = ...
    AutoNone: QTextEdit.AutoFormattingFlag = ...
    AutoBulletList: QTextEdit.AutoFormattingFlag = ...
    NoWrap: QTextEdit.LineWrapMode = ...
    WidgetWidth: QTextEdit.LineWrapMode = ...
    FixedPixelWidth: QTextEdit.LineWrapMode = ...
    FixedColumnWidth: QTextEdit.LineWrapMode = ...

    class AutoFormatting(object):
        ...

    class AutoFormattingFlag(Enum):
        AutoAll: QTextEdit.AutoFormattingFlag = ...
        AutoNone: QTextEdit.AutoFormattingFlag = ...
        AutoBulletList: QTextEdit.AutoFormattingFlag = ...

    class ExtraSelection(object):
        @overload
        def __init__(self) -> None:
            ...

        @overload
        def __init__(
            self, ExtraSelection: PySide6.QtWidgets.QTextEdit.ExtraSelection
        ) -> None:
            ...

        @staticmethod
        def __copy__() -> None:
            ...

    class LineWrapMode(Enum):
        NoWrap: QTextEdit.LineWrapMode = ...
        WidgetWidth: QTextEdit.LineWrapMode = ...
        FixedPixelWidth: QTextEdit.LineWrapMode = ...
        FixedColumnWidth: QTextEdit.LineWrapMode = ...

    @overload
    def __init__(self, parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qtextedit.html#QTextEdit

        **QTextEdit::QTextEdit(QWidget * parent = nullptr)**

        Constructs an empty QTextEdit with parent **parent**.
        """
        ...

    @overload
    def __init__(
        self, text: str, parent: Optional[PySide6.QtWidgets.QWidget] = ...
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtextedit.html#QTextEdit-1

        **QTextEdit::QTextEdit(const QString & text , QWidget * parent =
        nullptr)**

        Constructs a QTextEdit with parent **parent**. The text edit will
        display the text **text**. The text is interpreted as html.
        """
        ...

    def acceptRichText(self) -> bool:
        """
        https://doc.qt.io/qt-6/qtextedit.html#acceptRichText-prop

        **acceptRichText : bool**

        This property holds whether the text edit accepts rich text insertions
        by the user

        When this propery is set to false text edit will accept only plain text
        input from the user. For example through clipboard or drag and drop.

        This property's default is true.

        **Access functions:**

        bool **acceptRichText** () const
        void **setAcceptRichText** (bool
        **accept** )
        """
        ...

    def alignment(self) -> PySide6.QtCore.Qt.Alignment:
        """
        https://doc.qt.io/qt-6/qtextedit.html#alignment

        **Qt::Alignment QTextEdit::alignment() const**

        Returns the alignment of the current paragraph.

        **See also** **setAlignment** ().
        """
        ...

    def anchorAt(self, pos: PySide6.QtCore.QPoint) -> str:
        """
        https://doc.qt.io/qt-6/qtextedit.html#anchorAt

        **QString QTextEdit::anchorAt(const QPoint & pos ) const**

        Returns the reference of the anchor at position **pos** , or an empty
        string if no anchor exists at that point.
        """
        ...

    def append(self, text: str) -> None:
        """
        https://doc.qt.io/qt-6/qtextedit.html#append

        **[slot] void QTextEdit::append(const QString & text )**

        Appends a new paragraph with **text** to the end of the text edit.

        **Note:** The new paragraph appended will have the same character format
        and block format as the current paragraph, determined by the position of
        the cursor.

        **See also** **currentCharFormat** () and **QTextCursor::blockFormat**
        ().
        """
        ...

    def autoFormatting(self) -> PySide6.QtWidgets.QTextEdit.AutoFormatting:
        """
        https://doc.qt.io/qt-6/qtextedit.html#autoFormatting-prop

        **autoFormatting : AutoFormatting**

        This property holds the enabled set of auto formatting features

        The value can be any combination of the values in the
        **AutoFormattingFlag**  enum. The default is **AutoNone** . Choose
        **AutoAll**  to enable all automatic formatting.

        Currently, the only automatic formatting feature provided is
        **AutoBulletList** ; future versions of Qt may offer more.

        **Access functions:**

        QTextEdit::AutoFormatting **autoFormatting** () const
        void
        **setAutoFormatting** (QTextEdit::AutoFormatting **features** )
        """
        ...

    def canInsertFromMimeData(self, source: PySide6.QtCore.QMimeData) -> bool:
        """
        https://doc.qt.io/qt-6/qtextedit.html#canInsertFromMimeData

        **[virtual protected] bool QTextEdit::canInsertFromMimeData(const
        QMimeData * source ) const**

        This function returns `true` if the contents of the MIME data object,
        specified by **source** , can be decoded and inserted into the document.
        It is called for example when during a drag operation the mouse enters
        this widget and it is necessary to determine whether it is possible to
        accept the drag and drop operation.

        Reimplement this function to enable drag and drop support for additional
        MIME types.
        """
        ...

    def canPaste(self) -> bool:
        """
        https://doc.qt.io/qt-6/qtextedit.html#canPaste

        **bool QTextEdit::canPaste() const**

        Returns whether text can be pasted from the clipboard into the textedit.
        """
        ...

    def changeEvent(self, e: PySide6.QtCore.QEvent) -> None:
        """
        https://doc.qt.io/qt-6/qtextedit.html#changeEvent

        **[override virtual protected] void QTextEdit::changeEvent(QEvent * e
        )**

        Reimplements: **QFrame::changeEvent** (QEvent *ev).
        """
        ...

    def clear(self) -> None:
        """
        https://doc.qt.io/qt-6/qtextedit.html#clear

        **[slot] void QTextEdit::clear()**

        Deletes all the text in the text edit.

        Notes:

        * The undo/redo history is also cleared.
          * **currentCharFormat** () is
        reset, unless **textCursor** () is already at the beginning of the
        document.

        **See also** **cut** (), **setPlainText** (), and **setHtml** ().
        """
        ...

    def contextMenuEvent(self, e: PySide6.QtGui.QContextMenuEvent) -> None:
        """
        https://doc.qt.io/qt-6/qtextedit.html#contextMenuEvent

        **[override virtual protected] void
        QTextEdit::contextMenuEvent(QContextMenuEvent * event )**

        Reimplements: **QAbstractScrollArea::contextMenuEvent**
        (QContextMenuEvent *e).

        Shows the standard context menu created with
        **createStandardContextMenu** ().

        If you do not want the text edit to have a context menu, you can set its
        **contextMenuPolicy**  to **Qt::NoContextMenu** . If you want to
        customize the context menu, reimplement this function. If you want to
        extend the standard context menu, reimplement this function, call
        **createStandardContextMenu** () and extend the menu returned.

        Information about the event is passed in the **event** object.

        void MyTextEdit::contextMenuEvent(**QContextMenuEvent**  *event)
            {
        **QMenu**  *menu = createStandardContextMenu();
        menu->addAction(tr("My Menu Item"));
                //...
        menu->exec(event->globalPos());
                delete menu;
            }
        """
        ...

    def copy(self) -> None:
        """
        https://doc.qt.io/qt-6/qtextedit.html#copy

        **[slot] void QTextEdit::copy()**

        Copies any selected text to the clipboard.

        **See also** **copyAvailable** ().
        """
        ...

    def createMimeDataFromSelection(self) -> PySide6.QtCore.QMimeData:
        """
        https://doc.qt.io/qt-6/qtextedit.html#createMimeDataFromSelection

        **[virtual protected] QMimeData
        *QTextEdit::createMimeDataFromSelection() const**

        This function returns a new MIME data object to represent the contents
        of the text edit's current selection. It is called when the selection
        needs to be encapsulated into a new **QMimeData**  object; for example,
        when a drag and drop operation is started, or when data is copied to the
        clipboard.

        If you reimplement this function, note that the ownership of the
        returned **QMimeData**  object is passed to the caller. The selection
        can be retrieved by using the **textCursor** () function.
        """
        ...

    @overload
    def createStandardContextMenu(self) -> PySide6.QtWidgets.QMenu:
        """
        https://doc.qt.io/qt-6/qtextedit.html#createStandardContextMenu

        **QMenu *QTextEdit::createStandardContextMenu()**

        This function creates the standard context menu which is shown when the
        user clicks on the text edit with the right mouse button. It is called
        from the default **contextMenuEvent** () handler. The popup menu's
        ownership is transferred to the caller.

        We recommend that you use the createStandardContextMenu(**QPoint** )
        version instead which will enable the actions that are sensitive to
        where the user clicked.
        """
        ...

    @overload
    def createStandardContextMenu(
        self, position: PySide6.QtCore.QPoint
    ) -> PySide6.QtWidgets.QMenu:
        """
        https://doc.qt.io/qt-6/qtextedit.html#createStandardContextMenu-1

        **QMenu *QTextEdit::createStandardContextMenu(const QPoint & position
        )**

        This function creates the standard context menu which is shown when the
        user clicks on the text edit with the right mouse button. It is called
        from the default **contextMenuEvent** () handler and it takes the
        **position** in document coordinates where the mouse click was. This can
        enable actions that are sensitive to the position where the user
        clicked. The popup menu's ownership is transferred to the caller.
        """
        ...

    def currentCharFormat(self) -> PySide6.QtGui.QTextCharFormat:
        """
        https://doc.qt.io/qt-6/qtextedit.html#currentCharFormat

        **QTextCharFormat QTextEdit::currentCharFormat() const**

        Returns the char format that is used when inserting new text.

        **See also** **setCurrentCharFormat** ().
        """
        ...

    def currentFont(self) -> PySide6.QtGui.QFont:
        """
        https://doc.qt.io/qt-6/qtextedit.html#currentFont

        **QFont QTextEdit::currentFont() const**

        Returns the font of the current format.

        **See also** **setCurrentFont** (), **setFontFamily** (), and
        **setFontPointSize** ().
        """
        ...

    def cursorForPosition(
        self, pos: PySide6.QtCore.QPoint
    ) -> PySide6.QtGui.QTextCursor:
        """
        https://doc.qt.io/qt-6/qtextedit.html#cursorForPosition

        **QTextCursor QTextEdit::cursorForPosition(const QPoint & pos ) const**

        returns a **QTextCursor**  at position **pos** (in viewport
        coordinates).
        """
        ...

    @overload
    def cursorRect(self) -> PySide6.QtCore.QRect:
        """
        https://doc.qt.io/qt-6/qtextedit.html#cursorRect

        **QRect QTextEdit::cursorRect(const QTextCursor & cursor ) const**

        returns a rectangle (in viewport coordinates) that includes the
        **cursor**.
        """
        ...

    @overload
    def cursorRect(self, cursor: PySide6.QtGui.QTextCursor) -> PySide6.QtCore.QRect:
        """
        https://doc.qt.io/qt-6/qtextedit.html#cursorRect-1

        **QRect QTextEdit::cursorRect() const**

        returns a rectangle (in viewport coordinates) that includes the cursor
        of the text edit.
        """
        ...

    def cursorWidth(self) -> int:
        """
        https://doc.qt.io/qt-6/qtextedit.html#cursorWidth-prop

        **cursorWidth : int**

        This property specifies the width of the cursor in pixels. The default
        value is 1.

        **Access functions:**

        int **cursorWidth** () const
        void **setCursorWidth** (int **width** )
        """
        ...

    def cut(self) -> None:
        """
        https://doc.qt.io/qt-6/qtextedit.html#cut

        **[slot] void QTextEdit::cut()**

        Copies the selected text to the clipboard and deletes it from the text
        edit.

        If there is no selected text nothing happens.

        **See also** **copy** () and **paste** ().
        """
        ...

    def doSetTextCursor(self, cursor: PySide6.QtGui.QTextCursor) -> None:
        ...

    def document(self) -> PySide6.QtGui.QTextDocument:
        """
        https://doc.qt.io/qt-6/qtextedit.html#document-prop

        **document : QTextDocument***

        This property holds the underlying document of the text editor.

        **Note:** The editor **does not take ownership of the document** unless
        it is the document's parent object. The parent object of the provided
        document remains the owner of the object. If the previously assigned
        document is a child of the editor then it will be deleted.

        **Access functions:**

        QTextDocument * **document** () const
        void **setDocument**
        (QTextDocument * **document** )
        """
        ...

    def documentTitle(self) -> str:
        """
        https://doc.qt.io/qt-6/qtextedit.html#documentTitle-prop

        **documentTitle : QString**

        This property holds the title of the document parsed from the text.

        By default, for a newly-created, empty document, this property contains
        an empty string.

        **Access functions:**

        QString **documentTitle** () const
        void **setDocumentTitle** (const
        QString & **title** )
        """
        ...

    def dragEnterEvent(self, e: PySide6.QtGui.QDragEnterEvent) -> None:
        """
        https://doc.qt.io/qt-6/qtextedit.html#dragEnterEvent

        **[override virtual protected] void
        QTextEdit::dragEnterEvent(QDragEnterEvent * e )**

        Reimplements: **QAbstractScrollArea::dragEnterEvent** (QDragEnterEvent
        *event).
        """
        ...

    def dragLeaveEvent(self, e: PySide6.QtGui.QDragLeaveEvent) -> None:
        """
        https://doc.qt.io/qt-6/qtextedit.html#dragLeaveEvent

        **[override virtual protected] void
        QTextEdit::dragLeaveEvent(QDragLeaveEvent * e )**

        Reimplements: **QAbstractScrollArea::dragLeaveEvent** (QDragLeaveEvent
        *event).
        """
        ...

    def dragMoveEvent(self, e: PySide6.QtGui.QDragMoveEvent) -> None:
        """
        https://doc.qt.io/qt-6/qtextedit.html#dragMoveEvent

        **[override virtual protected] void
        QTextEdit::dragMoveEvent(QDragMoveEvent * e )**

        Reimplements: **QAbstractScrollArea::dragMoveEvent** (QDragMoveEvent
        *event).
        """
        ...

    def dropEvent(self, e: PySide6.QtGui.QDropEvent) -> None:
        """
        https://doc.qt.io/qt-6/qtextedit.html#dropEvent

        **[override virtual protected] void QTextEdit::dropEvent(QDropEvent * e
        )**

        Reimplements: **QAbstractScrollArea::dropEvent** (QDropEvent *event).
        """
        ...

    def ensureCursorVisible(self) -> None:
        """
        https://doc.qt.io/qt-6/qtextedit.html#ensureCursorVisible

        **void QTextEdit::ensureCursorVisible()**

        Ensures that the cursor is visible by scrolling the text edit if
        necessary.
        """
        ...

    def event(self, e: PySide6.QtCore.QEvent) -> bool:
        ...

    def extraSelections(self) -> List[PySide6.QtWidgets.QTextEdit.ExtraSelection]:
        """
        https://doc.qt.io/qt-6/qtextedit.html#extraSelections

        **QList<QTextEdit::ExtraSelection> QTextEdit::extraSelections() const**

        Returns previously set extra selections.

        **See also** **setExtraSelections** ().
        """
        ...

    @overload
    def find(
        self, exp: str, options: PySide6.QtGui.QTextDocument.FindFlags = ...
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qtextedit.html#find

        **bool QTextEdit::find(const QString & exp , QTextDocument::FindFlags
        options = QTextDocument::FindFlags())**

        Finds the next occurrence of the string, **exp** , using the given
        **options**. Returns `true` if **exp** was found and changes the cursor
        to select the match; otherwise returns `false`.
        """
        ...

    @overload
    def find(
        self,
        exp: Union[PySide6.QtCore.QRegularExpression, str],
        options: PySide6.QtGui.QTextDocument.FindFlags = ...,
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qtextedit.html#find-1

        **[since 5.13] bool QTextEdit::find(const QRegularExpression & exp ,
        QTextDocument::FindFlags options = QTextDocument::FindFlags())**

        This is an overloaded function.

        Finds the next occurrence, matching the regular expression, **exp** ,
        using the given **options**. The **QTextDocument::FindCaseSensitively**
        option is ignored for this overload, use
        **QRegularExpression::CaseInsensitiveOption**  instead.

        Returns `true` if a match was found and changes the cursor to select the
        match; otherwise returns `false`.

        This function was introduced in Qt 5.13.
        """
        ...

    def focusInEvent(self, e: PySide6.QtGui.QFocusEvent) -> None:
        """
        https://doc.qt.io/qt-6/qtextedit.html#focusInEvent

        **[override virtual protected] void QTextEdit::focusInEvent(QFocusEvent
        * e )**

        Reimplements: **QWidget::focusInEvent** (QFocusEvent *event).
        """
        ...

    def focusNextPrevChild(self, next: bool) -> bool:
        """
        https://doc.qt.io/qt-6/qtextedit.html#focusNextPrevChild

        **[override virtual protected] bool QTextEdit::focusNextPrevChild(bool
        next )**

        Reimplements: **QWidget::focusNextPrevChild** (bool next).
        """
        ...

    def focusOutEvent(self, e: PySide6.QtGui.QFocusEvent) -> None:
        """
        https://doc.qt.io/qt-6/qtextedit.html#focusOutEvent

        **[override virtual protected] void QTextEdit::focusOutEvent(QFocusEvent
        * e )**

        Reimplements: **QWidget::focusOutEvent** (QFocusEvent *event).
        """
        ...

    def fontFamily(self) -> str:
        """
        https://doc.qt.io/qt-6/qtextedit.html#fontFamily

        **QString QTextEdit::fontFamily() const**

        Returns the font family of the current format.

        **See also** **setFontFamily** (), **setCurrentFont** (), and
        **setFontPointSize** ().
        """
        ...

    def fontItalic(self) -> bool:
        """
        https://doc.qt.io/qt-6/qtextedit.html#fontItalic

        **bool QTextEdit::fontItalic() const**

        Returns `true` if the font of the current format is italic; otherwise
        returns false.

        **See also** **setFontItalic** ().
        """
        ...

    def fontPointSize(self) -> float:
        """
        https://doc.qt.io/qt-6/qtextedit.html#fontPointSize

        **qreal QTextEdit::fontPointSize() const**

        Returns the point size of the font of the current format.

        **See also** **setFontFamily** (), **setCurrentFont** (), and
        **setFontPointSize** ().
        """
        ...

    def fontUnderline(self) -> bool:
        """
        https://doc.qt.io/qt-6/qtextedit.html#fontUnderline

        **bool QTextEdit::fontUnderline() const**

        Returns `true` if the font of the current format is underlined;
        otherwise returns false.

        **See also** **setFontUnderline** ().
        """
        ...

    def fontWeight(self) -> int:
        """
        https://doc.qt.io/qt-6/qtextedit.html#fontWeight

        **int QTextEdit::fontWeight() const**

        Returns the font weight of the current format.

        **See also** **setFontWeight** (), **setCurrentFont** (),
        **setFontPointSize** (), and **QFont::Weight** .
        """
        ...

    def inputMethodEvent(self, arg__1: PySide6.QtGui.QInputMethodEvent) -> None:
        """
        https://doc.qt.io/qt-6/qtextedit.html#inputMethodEvent

        **[override virtual protected] void
        QTextEdit::inputMethodEvent(QInputMethodEvent * e )**

        Reimplements: **QWidget::inputMethodEvent** (QInputMethodEvent *event).
        """
        ...

    @overload
    def inputMethodQuery(self, property: PySide6.QtCore.Qt.InputMethodQuery) -> Any:
        """
        https://doc.qt.io/qt-6/qtextedit.html#inputMethodQuery

        **[override virtual] QVariant
        QTextEdit::inputMethodQuery(Qt::InputMethodQuery property ) const**

        Reimplements: **QWidget::inputMethodQuery(Qt::InputMethodQuery query)
        const** .
        """
        ...

    @overload
    def inputMethodQuery(
        self, query: PySide6.QtCore.Qt.InputMethodQuery, argument: Any
    ) -> Any:
        """
        https://doc.qt.io/qt-6/qtextedit.html#inputMethodQuery

        **[override virtual] QVariant
        QTextEdit::inputMethodQuery(Qt::InputMethodQuery property ) const**

        Reimplements: **QWidget::inputMethodQuery(Qt::InputMethodQuery query)
        const** .
        """
        ...

    def insertFromMimeData(self, source: PySide6.QtCore.QMimeData) -> None:
        """
        https://doc.qt.io/qt-6/qtextedit.html#insertFromMimeData

        **[virtual protected] void QTextEdit::insertFromMimeData(const QMimeData
        * source )**

        This function inserts the contents of the MIME data object, specified by
        **source** , into the text edit at the current cursor position. It is
        called whenever text is inserted as the result of a clipboard paste
        operation, or when the text edit accepts data from a drag and drop
        operation.

        Reimplement this function to enable drag and drop support for additional
        MIME types.
        """
        ...

    def insertHtml(self, text: str) -> None:
        """
        https://doc.qt.io/qt-6/qtextedit.html#insertHtml

        **[slot] void QTextEdit::insertHtml(const QString & text )**

        Convenience slot that inserts **text** which is assumed to be of html
        formatting at the current cursor position.

        It is equivalent to:

        edit->textCursor().insertHtml(fragment);

        **Note:** When using this function with a style sheet, the style sheet
        will only apply to the current block in the document. In order to apply
        a style sheet throughout a document, use
        **QTextDocument::setDefaultStyleSheet** () instead.
        """
        ...

    def insertPlainText(self, text: str) -> None:
        """
        https://doc.qt.io/qt-6/qtextedit.html#insertPlainText

        **[slot] void QTextEdit::insertPlainText(const QString & text )**

        Convenience slot that inserts **text** at the current cursor position.

        It is equivalent to

        edit->textCursor().insertText(text);
        """
        ...

    def isReadOnly(self) -> bool:
        ...

    def isUndoRedoEnabled(self) -> bool:
        ...

    def keyPressEvent(self, e: PySide6.QtGui.QKeyEvent) -> None:
        """
        https://doc.qt.io/qt-6/qtextedit.html#keyPressEvent

        **[override virtual protected] void QTextEdit::keyPressEvent(QKeyEvent *
        e )**

        Reimplements: **QAbstractScrollArea::keyPressEvent** (QKeyEvent *e).
        """
        ...

    def keyReleaseEvent(self, e: PySide6.QtGui.QKeyEvent) -> None:
        """
        https://doc.qt.io/qt-6/qtextedit.html#keyReleaseEvent

        **[override virtual protected] void QTextEdit::keyReleaseEvent(QKeyEvent
        * e )**

        Reimplements: **QWidget::keyReleaseEvent** (QKeyEvent *event).
        """
        ...

    def lineWrapColumnOrWidth(self) -> int:
        """
        https://doc.qt.io/qt-6/qtextedit.html#lineWrapColumnOrWidth-prop

        **lineWrapColumnOrWidth : int**

        This property holds the position (in pixels or columns depending on the
        wrap mode) where text will be wrapped

        If the wrap mode is **FixedPixelWidth** , the value is the number of
        pixels from the left edge of the text edit at which text should be
        wrapped. If the wrap mode is **FixedColumnWidth** , the value is the
        column number (in character columns) from the left edge of the text edit
        at which text should be wrapped.

        By default, this property contains a value of 0.

        **Access functions:**

        int **lineWrapColumnOrWidth** () const
        void
        **setLineWrapColumnOrWidth** (int **w** )

        **See also** **lineWrapMode** .
        """
        ...

    def lineWrapMode(self) -> PySide6.QtWidgets.QTextEdit.LineWrapMode:
        """
        https://doc.qt.io/qt-6/qtextedit.html#lineWrapMode-prop

        **lineWrapMode : LineWrapMode**

        This property holds the line wrap mode

        The default mode is **WidgetWidth**  which causes words to be wrapped at
        the right edge of the text edit. Wrapping occurs at whitespace, keeping
        whole words intact. If you want wrapping to occur within words use
        **setWordWrapMode** (). If you set a wrap mode of **FixedPixelWidth**
        or **FixedColumnWidth**  you should also call
        **setLineWrapColumnOrWidth** () with the width you want.

        **Access functions:**

        QTextEdit::LineWrapMode **lineWrapMode** () const
        void
        **setLineWrapMode** (QTextEdit::LineWrapMode **mode** )

        **See also** **lineWrapColumnOrWidth** .
        """
        ...

    def loadResource(self, type: int, name: Union[PySide6.QtCore.QUrl, str]) -> Any:
        """
        https://doc.qt.io/qt-6/qtextedit.html#loadResource

        **[virtual invokable] QVariant QTextEdit::loadResource(int type , const
        QUrl & name )**

        Loads the resource specified by the given **type** and **name**.

        This function is an extension of **QTextDocument::loadResource** ().

        **Note:** This function can be invoked via the meta-object system and
        from QML. See **Q_INVOKABLE** .

        **See also** **QTextDocument::loadResource** ().
        """
        ...

    def mergeCurrentCharFormat(self, modifier: PySide6.QtGui.QTextCharFormat) -> None:
        """
        https://doc.qt.io/qt-6/qtextedit.html#mergeCurrentCharFormat

        **void QTextEdit::mergeCurrentCharFormat(const QTextCharFormat &
        modifier )**

        Merges the properties specified in **modifier** into the current
        character format by calling **QTextCursor::mergeCharFormat**  on the
        editor's cursor. If the editor has a selection then the properties of
        **modifier** are directly applied to the selection.

        **See also** **QTextCursor::mergeCharFormat** ().
        """
        ...

    def mouseDoubleClickEvent(self, e: PySide6.QtGui.QMouseEvent) -> None:
        """
        https://doc.qt.io/qt-6/qtextedit.html#mouseDoubleClickEvent

        **[override virtual protected] void
        QTextEdit::mouseDoubleClickEvent(QMouseEvent * e )**

        Reimplements: **QAbstractScrollArea::mouseDoubleClickEvent**
        (QMouseEvent *e).
        """
        ...

    def mouseMoveEvent(self, e: PySide6.QtGui.QMouseEvent) -> None:
        """
        https://doc.qt.io/qt-6/qtextedit.html#mouseMoveEvent

        **[override virtual protected] void
        QTextEdit::mouseMoveEvent(QMouseEvent * e )**

        Reimplements: **QAbstractScrollArea::mouseMoveEvent** (QMouseEvent *e).
        """
        ...

    def mousePressEvent(self, e: PySide6.QtGui.QMouseEvent) -> None:
        """
        https://doc.qt.io/qt-6/qtextedit.html#mousePressEvent

        **[override virtual protected] void
        QTextEdit::mousePressEvent(QMouseEvent * e )**

        Reimplements: **QAbstractScrollArea::mousePressEvent** (QMouseEvent *e).
        """
        ...

    def mouseReleaseEvent(self, e: PySide6.QtGui.QMouseEvent) -> None:
        """
        https://doc.qt.io/qt-6/qtextedit.html#mouseReleaseEvent

        **[override virtual protected] void
        QTextEdit::mouseReleaseEvent(QMouseEvent * e )**

        Reimplements: **QAbstractScrollArea::mouseReleaseEvent** (QMouseEvent
        *e).
        """
        ...

    def moveCursor(
        self,
        operation: PySide6.QtGui.QTextCursor.MoveOperation,
        mode: PySide6.QtGui.QTextCursor.MoveMode = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtextedit.html#moveCursor

        **void QTextEdit::moveCursor(QTextCursor::MoveOperation operation ,
        QTextCursor::MoveMode mode = QTextCursor::MoveAnchor)**

        Moves the cursor by performing the given **operation**.

        If **mode** is **QTextCursor::KeepAnchor** , the cursor selects the text
        it moves over. This is the same effect that the user achieves when they
        hold down the Shift key and move the cursor with the cursor keys.

        **See also** **QTextCursor::movePosition** ().
        """
        ...

    def overwriteMode(self) -> bool:
        """
        https://doc.qt.io/qt-6/qtextedit.html#overwriteMode-prop

        **overwriteMode : bool**

        This property holds whether text entered by the user will overwrite
        existing text

        As with many text editors, the text editor widget can be configured to
        insert or overwrite existing text with new text entered by the user.

        If this property is `true`, existing text is overwritten, character-for-
        character by new text; otherwise, text is inserted at the cursor
        position, displacing existing text.

        By default, this property is `false` (new text does not overwrite
        existing text).

        **Access functions:**

        bool **overwriteMode** () const
        void **setOverwriteMode** (bool
        **overwrite** )
        """
        ...

    def paintEvent(self, e: PySide6.QtGui.QPaintEvent) -> None:
        """
        https://doc.qt.io/qt-6/qtextedit.html#paintEvent

        **[override virtual protected] void QTextEdit::paintEvent(QPaintEvent *
        event )**

        Reimplements: **QAbstractScrollArea::paintEvent** (QPaintEvent *event).

        This event handler can be reimplemented in a subclass to receive paint
        events passed in **event**. It is usually unnecessary to reimplement
        this function in a subclass of **QTextEdit** .

        **Warning:** The underlying text document must not be modified from
        within a reimplementation of this function.
        """
        ...

    def paste(self) -> None:
        """
        https://doc.qt.io/qt-6/qtextedit.html#paste

        **[slot] void QTextEdit::paste()**

        Pastes the text from the clipboard into the text edit at the current
        cursor position.

        If there is no text in the clipboard nothing happens.

        To change the behavior of this function, i.e. to modify what
        **QTextEdit**  can paste and how it is being pasted, reimplement the
        virtual **canInsertFromMimeData** () and **insertFromMimeData** ()
        functions.

        **See also** **cut** () and **copy** ().
        """
        ...

    def placeholderText(self) -> str:
        """
        https://doc.qt.io/qt-6/qtextedit.html#placeholderText-prop

        **[since 5.2] placeholderText : QString**

        This property holds the editor placeholder text

        Setting this property makes the editor display a grayed-out placeholder
        text as long as the **document** () is empty.

        By default, this property contains an empty string.

        This property was introduced in Qt 5.2.

        **Access functions:**

        QString **placeholderText** () const
        void **setPlaceholderText**
        (const QString & **placeholderText** )

        **See also** **document** ().
        """
        ...

    def print_(self, printer: PySide6.QtGui.QPagedPaintDevice) -> None:
        """
        https://doc.qt.io/qt-6/qtextedit.html#print

        **void QTextEdit::print(QPagedPaintDevice * printer ) const**

        Convenience function to print the text edit's document to the given
        **printer**. This is equivalent to calling the print method on the
        document directly except that this function also supports
        QPrinter::Selection as print range.

        **See also** **QTextDocument::print** ().
        """
        ...

    def redo(self) -> None:
        """
        https://doc.qt.io/qt-6/qtextedit.html#redo

        **[slot] void QTextEdit::redo()**

        Redoes the last operation.

        If there is no operation to redo, i.e. there is no redo step in the
        undo/redo history, nothing happens.

        **See also** **undo** ().
        """
        ...

    def resizeEvent(self, e: PySide6.QtGui.QResizeEvent) -> None:
        """
        https://doc.qt.io/qt-6/qtextedit.html#resizeEvent

        **[override virtual protected] void QTextEdit::resizeEvent(QResizeEvent
        * e )**

        Reimplements: **QAbstractScrollArea::resizeEvent** (QResizeEvent
        *event).
        """
        ...

    def scrollContentsBy(self, dx: int, dy: int) -> None:
        """
        https://doc.qt.io/qt-6/qtextedit.html#scrollContentsBy

        **[override virtual protected] void QTextEdit::scrollContentsBy(int dx ,
        int dy )**

        Reimplements: **QAbstractScrollArea::scrollContentsBy** (int dx, int
        dy).
        """
        ...

    def scrollToAnchor(self, name: str) -> None:
        """
        https://doc.qt.io/qt-6/qtextedit.html#scrollToAnchor

        **[slot] void QTextEdit::scrollToAnchor(const QString & name )**

        Scrolls the text edit so that the anchor with the given **name** is
        visible; does nothing if the **name** is empty, or is already visible,
        or isn't found.
        """
        ...

    def selectAll(self) -> None:
        """
        https://doc.qt.io/qt-6/qtextedit.html#selectAll

        **[slot] void QTextEdit::selectAll()**

        Selects all text.

        **See also** **copy** (), **cut** (), and **textCursor** ().
        """
        ...

    def setAcceptRichText(self, accept: bool) -> None:
        """
        https://doc.qt.io/qt-6/qtextedit.html#acceptRichText-prop

        **acceptRichText : bool**

        This property holds whether the text edit accepts rich text insertions
        by the user

        When this propery is set to false text edit will accept only plain text
        input from the user. For example through clipboard or drag and drop.

        This property's default is true.

        **Access functions:**

        bool **acceptRichText** () const
        void **setAcceptRichText** (bool
        **accept** )
        """
        ...

    def setAlignment(self, a: PySide6.QtCore.Qt.Alignment) -> None:
        """
        https://doc.qt.io/qt-6/qtextedit.html#setAlignment

        **[slot] void QTextEdit::setAlignment(Qt::Alignment a )**

        Sets the alignment of the current paragraph to **a**. Valid alignments
        are **Qt::AlignLeft** , **Qt::AlignRight** , **Qt::AlignJustify**  and
        **Qt::AlignCenter**  (which centers horizontally).

        **See also** **alignment** ().
        """
        ...

    def setAutoFormatting(
        self, features: PySide6.QtWidgets.QTextEdit.AutoFormatting
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtextedit.html#autoFormatting-prop

        **autoFormatting : AutoFormatting**

        This property holds the enabled set of auto formatting features

        The value can be any combination of the values in the
        **AutoFormattingFlag**  enum. The default is **AutoNone** . Choose
        **AutoAll**  to enable all automatic formatting.

        Currently, the only automatic formatting feature provided is
        **AutoBulletList** ; future versions of Qt may offer more.

        **Access functions:**

        QTextEdit::AutoFormatting **autoFormatting** () const
        void
        **setAutoFormatting** (QTextEdit::AutoFormatting **features** )
        """
        ...

    def setCurrentCharFormat(self, format: PySide6.QtGui.QTextCharFormat) -> None:
        """
        https://doc.qt.io/qt-6/qtextedit.html#setCurrentCharFormat

        **void QTextEdit::setCurrentCharFormat(const QTextCharFormat & format
        )**

        Sets the char format that is be used when inserting new text to
        **format** by calling **QTextCursor::setCharFormat** () on the editor's
        cursor. If the editor has a selection then the char format is directly
        applied to the selection.

        **See also** **currentCharFormat** ().
        """
        ...

    def setCurrentFont(self, f: Union[PySide6.QtGui.QFont, str, Sequence[str]]) -> None:
        """
        https://doc.qt.io/qt-6/qtextedit.html#setCurrentFont

        **[slot] void QTextEdit::setCurrentFont(const QFont & f )**

        Sets the font of the current format to **f**.

        **See also** **currentFont** (), **setFontPointSize** (), and
        **setFontFamily** ().
        """
        ...

    def setCursorWidth(self, width: int) -> None:
        """
        https://doc.qt.io/qt-6/qtextedit.html#cursorWidth-prop

        **cursorWidth : int**

        This property specifies the width of the cursor in pixels. The default
        value is 1.

        **Access functions:**

        int **cursorWidth** () const
        void **setCursorWidth** (int **width** )
        """
        ...

    def setDocument(self, document: PySide6.QtGui.QTextDocument) -> None:
        """
        https://doc.qt.io/qt-6/qtextedit.html#document-prop

        **document : QTextDocument***

        This property holds the underlying document of the text editor.

        **Note:** The editor **does not take ownership of the document** unless
        it is the document's parent object. The parent object of the provided
        document remains the owner of the object. If the previously assigned
        document is a child of the editor then it will be deleted.

        **Access functions:**

        QTextDocument * **document** () const
        void **setDocument**
        (QTextDocument * **document** )
        """
        ...

    def setDocumentTitle(self, title: str) -> None:
        """
        https://doc.qt.io/qt-6/qtextedit.html#documentTitle-prop

        **documentTitle : QString**

        This property holds the title of the document parsed from the text.

        By default, for a newly-created, empty document, this property contains
        an empty string.

        **Access functions:**

        QString **documentTitle** () const
        void **setDocumentTitle** (const
        QString & **title** )
        """
        ...

    def setExtraSelections(
        self, selections: Sequence[PySide6.QtWidgets.QTextEdit.ExtraSelection]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtextedit.html#setExtraSelections

        **void QTextEdit::setExtraSelections(const
        QList<QTextEdit::ExtraSelection> & selections )**

        This function allows temporarily marking certain regions in the document
        with a given color, specified as **selections**. This can be useful for
        example in a programming editor to mark a whole line of text with a
        given background color to indicate the existence of a breakpoint.

        **See also** **QTextEdit::ExtraSelection**  and **extraSelections** ().
        """
        ...

    def setFontFamily(self, fontFamily: str) -> None:
        """
        https://doc.qt.io/qt-6/qtextedit.html#setFontFamily

        **[slot] void QTextEdit::setFontFamily(const QString & fontFamily )**

        Sets the font family of the current format to **fontFamily**.

        **See also** **fontFamily** () and **setCurrentFont** ().
        """
        ...

    def setFontItalic(self, b: bool) -> None:
        """
        https://doc.qt.io/qt-6/qtextedit.html#setFontItalic

        **[slot] void QTextEdit::setFontItalic(bool italic )**

        If **italic** is true, sets the current format to italic; otherwise sets
        the current format to non-italic.

        **See also** **fontItalic** ().
        """
        ...

    def setFontPointSize(self, s: float) -> None:
        """
        https://doc.qt.io/qt-6/qtextedit.html#setFontPointSize

        **[slot] void QTextEdit::setFontPointSize(qreal s )**

        Sets the point size of the current format to **s**.

        Note that if **s** is zero or negative, the behavior of this function is
        not defined.

        **See also** **fontPointSize** (), **setCurrentFont** (), and
        **setFontFamily** ().
        """
        ...

    def setFontUnderline(self, b: bool) -> None:
        """
        https://doc.qt.io/qt-6/qtextedit.html#setFontUnderline

        **[slot] void QTextEdit::setFontUnderline(bool underline )**

        If **underline** is true, sets the current format to underline;
        otherwise sets the current format to non-underline.

        **See also** **fontUnderline** ().
        """
        ...

    def setFontWeight(self, w: int) -> None:
        """
        https://doc.qt.io/qt-6/qtextedit.html#setFontWeight

        **[slot] void QTextEdit::setFontWeight(int weight )**

        Sets the font weight of the current format to the given **weight** ,
        where the value used is in the range defined by the **QFont::Weight**
        enum.

        **See also** **fontWeight** (), **setCurrentFont** (), and
        **setFontFamily** ().
        """
        ...

    def setHtml(self, text: str) -> None:
        """
        https://doc.qt.io/qt-6/qtextedit.html#html-prop

        **html : QString**

        This property provides an HTML interface to the text of the text edit.

        toHtml() returns the text of the text edit as html.

        setHtml() changes the text of the text edit. Any previous text is
        removed and the undo/redo history is cleared. The input text is
        interpreted as rich text in html format. **currentCharFormat** () is
        also reset, unless **textCursor** () is already at the beginning of the
        document.

        **Note:** It is the responsibility of the caller to make sure that the
        text is correctly decoded when a **QString**  containing HTML is created
        and passed to setHtml().

        By default, for a newly-created, empty document, this property contains
        text to describe an HTML 4.0 document with no body text.

        **Access functions:**

        QString **toHtml** () const
        void **setHtml** (const QString & **text**
        )

        **Notifier signal:**

        void ****textChanged** ** ()

        **See also** **Supported HTML Subset**  and **plainText** .
        """
        ...

    def setLineWrapColumnOrWidth(self, w: int) -> None:
        """
        https://doc.qt.io/qt-6/qtextedit.html#lineWrapColumnOrWidth-prop

        **lineWrapColumnOrWidth : int**

        This property holds the position (in pixels or columns depending on the
        wrap mode) where text will be wrapped

        If the wrap mode is **FixedPixelWidth** , the value is the number of
        pixels from the left edge of the text edit at which text should be
        wrapped. If the wrap mode is **FixedColumnWidth** , the value is the
        column number (in character columns) from the left edge of the text edit
        at which text should be wrapped.

        By default, this property contains a value of 0.

        **Access functions:**

        int **lineWrapColumnOrWidth** () const
        void
        **setLineWrapColumnOrWidth** (int **w** )

        **See also** **lineWrapMode** .
        """
        ...

    def setLineWrapMode(self, mode: PySide6.QtWidgets.QTextEdit.LineWrapMode) -> None:
        """
        https://doc.qt.io/qt-6/qtextedit.html#lineWrapMode-prop

        **lineWrapMode : LineWrapMode**

        This property holds the line wrap mode

        The default mode is **WidgetWidth**  which causes words to be wrapped at
        the right edge of the text edit. Wrapping occurs at whitespace, keeping
        whole words intact. If you want wrapping to occur within words use
        **setWordWrapMode** (). If you set a wrap mode of **FixedPixelWidth**
        or **FixedColumnWidth**  you should also call
        **setLineWrapColumnOrWidth** () with the width you want.

        **Access functions:**

        QTextEdit::LineWrapMode **lineWrapMode** () const
        void
        **setLineWrapMode** (QTextEdit::LineWrapMode **mode** )

        **See also** **lineWrapColumnOrWidth** .
        """
        ...

    def setMarkdown(self, markdown: str) -> None:
        """
        https://doc.qt.io/qt-6/qtextedit.html#markdown-prop

        **[since 5.14] markdown : QString**

        This property provides a Markdown interface to the text of the text
        edit.

        `toMarkdown()` returns the text of the text edit as "pure" Markdown,
        without any embedded HTML formatting. Some features that
        **QTextDocument**  supports (such as the use of specific colors and
        named fonts) cannot be expressed in "pure" Markdown, and they will be
        omitted.

        `setMarkdown()` changes the text of the text edit. Any previous text is
        removed and the undo/redo history is cleared. The input text is
        interpreted as rich text in Markdown format.

        Parsing of HTML included in the **markdown** string is handled in the
        same way as in **setHtml** ; however, Markdown formatting inside HTML
        blocks is not supported.

        Some features of the parser can be enabled or disabled via the
        **features** argument:

        ConstantDescription
        `MarkdownNoHTML`Any HTML tags in the Markdown text
        will be discarded
        `MarkdownDialectCommonMark`The parser supports only
        the features standardized by CommonMark
        `MarkdownDialectGitHub`The
        parser supports the GitHub dialect

        The default is `MarkdownDialectGitHub`.

        This property was introduced in Qt 5.14.

        **Access functions:**

        QString **toMarkdown** (QTextDocument::MarkdownFeatures **features** =
        QTextDocument::MarkdownDialectGitHub) const
        void **setMarkdown**
        (const QString & **markdown** )

        **Notifier signal:**

        void ****textChanged** ** ()

        **See also** **plainText** , **html** , **QTextDocument::toMarkdown**
        (), and **QTextDocument::setMarkdown** ().
        """
        ...

    def setOverwriteMode(self, overwrite: bool) -> None:
        """
        https://doc.qt.io/qt-6/qtextedit.html#overwriteMode-prop

        **overwriteMode : bool**

        This property holds whether text entered by the user will overwrite
        existing text

        As with many text editors, the text editor widget can be configured to
        insert or overwrite existing text with new text entered by the user.

        If this property is `true`, existing text is overwritten, character-for-
        character by new text; otherwise, text is inserted at the cursor
        position, displacing existing text.

        By default, this property is `false` (new text does not overwrite
        existing text).

        **Access functions:**

        bool **overwriteMode** () const
        void **setOverwriteMode** (bool
        **overwrite** )
        """
        ...

    def setPlaceholderText(self, placeholderText: str) -> None:
        """
        https://doc.qt.io/qt-6/qtextedit.html#placeholderText-prop

        **[since 5.2] placeholderText : QString**

        This property holds the editor placeholder text

        Setting this property makes the editor display a grayed-out placeholder
        text as long as the **document** () is empty.

        By default, this property contains an empty string.

        This property was introduced in Qt 5.2.

        **Access functions:**

        QString **placeholderText** () const
        void **setPlaceholderText**
        (const QString & **placeholderText** )

        **See also** **document** ().
        """
        ...

    def setPlainText(self, text: str) -> None:
        """
        https://doc.qt.io/qt-6/qtextedit.html#setPlainText

        **[slot] void QTextEdit::setPlainText(const QString & text )**

        Changes the text of the text edit to the string **text**. Any previous
        text is removed.

        Notes:

        * **text** is interpreted as plain text.
          * The undo/redo history is
        also cleared.
          * **currentCharFormat** () is reset, unless
        **textCursor** () is already at the beginning of the document.

        **Note:** Setter function for property **plainText** .

        **See also** **toPlainText** ().
        """
        ...

    def setReadOnly(self, ro: bool) -> None:
        """
        https://doc.qt.io/qt-6/qtextedit.html#readOnly-prop

        **readOnly : bool**

        This property holds whether the text edit is read-only

        In a read-only text edit the user can only navigate through the text and
        select text; modifying the text is not possible.

        This property's default is false.

        **Access functions:**

        bool **isReadOnly** () const
        void **setReadOnly** (bool **ro** )
        """
        ...

    def setTabChangesFocus(self, b: bool) -> None:
        """
        https://doc.qt.io/qt-6/qtextedit.html#tabChangesFocus-prop

        **tabChangesFocus : bool**

        This property holds whether **Tab** changes focus or is accepted as
        input

        In some occasions text edits should not allow the user to input
        tabulators or change indentation using the **Tab** key, as this breaks
        the focus chain. The default is false.

        **Access functions:**

        bool **tabChangesFocus** () const
        void **setTabChangesFocus** (bool
        **b** )
        """
        ...

    def setTabStopDistance(self, distance: float) -> None:
        """
        https://doc.qt.io/qt-6/qtextedit.html#tabStopDistance-prop

        **[since 5.10] tabStopDistance : qreal**

        This property holds the tab stop distance in pixels

        By default, this property contains a value of 80 pixels.

        Do not set a value less than the **horizontalAdvance** () of the
        **QChar::VisualTabCharacter**  character, otherwise the tab-character
        will be drawn incompletely.

        This property was introduced in Qt 5.10.

        **Access functions:**

        qreal **tabStopDistance** () const
        void **setTabStopDistance** (qreal
        **distance** )

        **See also** **QTextOption::ShowTabsAndSpaces**  and
        **QTextDocument::defaultTextOption** .
        """
        ...

    def setText(self, text: str) -> None:
        """
        https://doc.qt.io/qt-6/qtextedit.html#setText

        **[slot] void QTextEdit::setText(const QString & text )**

        Sets the text edit's **text**. The text can be plain text or HTML and
        the text edit will try to guess the right format.

        Use **setHtml** () or **setPlainText** () directly to avoid text edit's
        guessing.

        **See also** **toPlainText** () and **toHtml** ().
        """
        ...

    def setTextBackgroundColor(
        self,
        c: Union[
            PySide6.QtGui.QColor,
            PySide6.QtGui.QRgba64,
            Any,
            PySide6.QtCore.Qt.GlobalColor,
            str,
            int,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtextedit.html#setTextBackgroundColor

        **[slot] void QTextEdit::setTextBackgroundColor(const QColor & c )**

        Sets the text background color of the current format to **c**.

        **See also** **textBackgroundColor** ().
        """
        ...

    def setTextColor(
        self,
        c: Union[
            PySide6.QtGui.QColor,
            PySide6.QtGui.QRgba64,
            Any,
            PySide6.QtCore.Qt.GlobalColor,
            str,
            int,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtextedit.html#setTextColor

        **[slot] void QTextEdit::setTextColor(const QColor & c )**

        Sets the text color of the current format to **c**.

        **See also** **textColor** ().
        """
        ...

    def setTextCursor(self, cursor: PySide6.QtGui.QTextCursor) -> None:
        """
        https://doc.qt.io/qt-6/qtextedit.html#setTextCursor

        **void QTextEdit::setTextCursor(const QTextCursor & cursor )**

        Sets the visible **cursor**.

        **See also** **textCursor** ().
        """
        ...

    def setTextInteractionFlags(
        self, flags: PySide6.QtCore.Qt.TextInteractionFlags
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtextedit.html#textInteractionFlags-prop

        **textInteractionFlags : Qt::TextInteractionFlags**

        Specifies how the widget should interact with user input.

        The default value depends on whether the **QTextEdit**  is read-only or
        editable, and whether it is a **QTextBrowser**  or not.

        **Access functions:**

        Qt::TextInteractionFlags **textInteractionFlags** () const
        void
        **setTextInteractionFlags** (Qt::TextInteractionFlags **flags** )
        """
        ...

    def setUndoRedoEnabled(self, enable: bool) -> None:
        """
        https://doc.qt.io/qt-6/qtextedit.html#undoRedoEnabled-prop

        **undoRedoEnabled : bool**

        This property holds whether undo and redo are enabled.

        Users are only able to undo or redo actions if this property is true,
        and if there is an action that can be undone (or redone).

        **Access functions:**

        bool **isUndoRedoEnabled** () const
        void **setUndoRedoEnabled** (bool
        **enable** )
        """
        ...

    def setWordWrapMode(self, policy: PySide6.QtGui.QTextOption.WrapMode) -> None:
        """
        https://doc.qt.io/qt-6/qtextedit.html#wordWrapMode-prop

        **wordWrapMode : QTextOption::WrapMode**

        This property holds the mode **QTextEdit**  will use when wrapping text
        by words

        By default, this property is set to
        **QTextOption::WrapAtWordBoundaryOrAnywhere** .

        **Access functions:**

        QTextOption::WrapMode **wordWrapMode** () const
        void
        **setWordWrapMode** (QTextOption::WrapMode **policy** )

        **See also** **QTextOption::WrapMode** .

        **Member Function Documentation**
        """
        ...

    def showEvent(self, arg__1: PySide6.QtGui.QShowEvent) -> None:
        """
        https://doc.qt.io/qt-6/qtextedit.html#showEvent

        **[override virtual protected] void QTextEdit::showEvent(QShowEvent *)**

        Reimplements: **QWidget::showEvent** (QShowEvent *event).
        """
        ...

    def tabChangesFocus(self) -> bool:
        """
        https://doc.qt.io/qt-6/qtextedit.html#tabChangesFocus-prop

        **tabChangesFocus : bool**

        This property holds whether **Tab** changes focus or is accepted as
        input

        In some occasions text edits should not allow the user to input
        tabulators or change indentation using the **Tab** key, as this breaks
        the focus chain. The default is false.

        **Access functions:**

        bool **tabChangesFocus** () const
        void **setTabChangesFocus** (bool
        **b** )
        """
        ...

    def tabStopDistance(self) -> float:
        """
        https://doc.qt.io/qt-6/qtextedit.html#tabStopDistance-prop

        **[since 5.10] tabStopDistance : qreal**

        This property holds the tab stop distance in pixels

        By default, this property contains a value of 80 pixels.

        Do not set a value less than the **horizontalAdvance** () of the
        **QChar::VisualTabCharacter**  character, otherwise the tab-character
        will be drawn incompletely.

        This property was introduced in Qt 5.10.

        **Access functions:**

        qreal **tabStopDistance** () const
        void **setTabStopDistance** (qreal
        **distance** )

        **See also** **QTextOption::ShowTabsAndSpaces**  and
        **QTextDocument::defaultTextOption** .
        """
        ...

    def textBackgroundColor(self) -> PySide6.QtGui.QColor:
        """
        https://doc.qt.io/qt-6/qtextedit.html#textBackgroundColor

        **QColor QTextEdit::textBackgroundColor() const**

        Returns the text background color of the current format.

        **See also** **setTextBackgroundColor** ().
        """
        ...

    def textColor(self) -> PySide6.QtGui.QColor:
        """
        https://doc.qt.io/qt-6/qtextedit.html#textColor

        **QColor QTextEdit::textColor() const**

        Returns the text color of the current format.

        **See also** **setTextColor** ().
        """
        ...

    def textCursor(self) -> PySide6.QtGui.QTextCursor:
        """
        https://doc.qt.io/qt-6/qtextedit.html#textCursor

        **QTextCursor QTextEdit::textCursor() const**

        Returns a copy of the **QTextCursor**  that represents the currently
        visible cursor. Note that changes on the returned cursor do not affect
        **QTextEdit** 's cursor; use **setTextCursor** () to update the visible
        cursor.

        **See also** **setTextCursor** ().
        """
        ...

    def textInteractionFlags(self) -> PySide6.QtCore.Qt.TextInteractionFlags:
        """
        https://doc.qt.io/qt-6/qtextedit.html#textInteractionFlags-prop

        **textInteractionFlags : Qt::TextInteractionFlags**

        Specifies how the widget should interact with user input.

        The default value depends on whether the **QTextEdit**  is read-only or
        editable, and whether it is a **QTextBrowser**  or not.

        **Access functions:**

        Qt::TextInteractionFlags **textInteractionFlags** () const
        void
        **setTextInteractionFlags** (Qt::TextInteractionFlags **flags** )
        """
        ...

    def timerEvent(self, e: PySide6.QtCore.QTimerEvent) -> None:
        ...

    def toHtml(self) -> str:
        ...

    def toMarkdown(
        self, features: PySide6.QtGui.QTextDocument.MarkdownFeatures = ...
    ) -> str:
        ...

    def toPlainText(self) -> str:
        """
        https://doc.qt.io/qt-6/qtextedit.html#toPlainText

        **QString QTextEdit::toPlainText() const**

        **QString**  QTextEdit::toPlainText() const

        Returns the text of the text edit as plain text.

        **Note:** Getter function for property **plainText** .

        **See also** **QTextEdit::setPlainText** ().
        """
        ...

    def undo(self) -> None:
        """
        https://doc.qt.io/qt-6/qtextedit.html#undo

        **[slot] void QTextEdit::undo()**

        Undoes the last operation.

        If there is no operation to undo, i.e. there is no undo step in the
        undo/redo history, nothing happens.

        **See also** **redo** ().
        """
        ...

    def wheelEvent(self, e: PySide6.QtGui.QWheelEvent) -> None:
        """
        https://doc.qt.io/qt-6/qtextedit.html#wheelEvent

        **[override virtual protected] void QTextEdit::wheelEvent(QWheelEvent *
        e )**

        Reimplements: **QAbstractScrollArea::wheelEvent** (QWheelEvent *e).
        """
        ...

    def wordWrapMode(self) -> PySide6.QtGui.QTextOption.WrapMode:
        """
        https://doc.qt.io/qt-6/qtextedit.html#wordWrapMode-prop

        **wordWrapMode : QTextOption::WrapMode**

        This property holds the mode **QTextEdit**  will use when wrapping text
        by words

        By default, this property is set to
        **QTextOption::WrapAtWordBoundaryOrAnywhere** .

        **Access functions:**

        QTextOption::WrapMode **wordWrapMode** () const
        void
        **setWordWrapMode** (QTextOption::WrapMode **policy** )

        **See also** **QTextOption::WrapMode** .

        **Member Function Documentation**
        """
        ...

    def zoomIn(self, range: int = ...) -> None:
        """
        https://doc.qt.io/qt-6/qtextedit.html#zoomIn

        **[slot] void QTextEdit::zoomIn(int range = 1)**

        Zooms in on the text by making the base font size **range** points
        larger and recalculating all font sizes to be the new size. This does
        not change the size of any images.

        **See also** **zoomOut** ().
        """
        ...

    def zoomInF(self, range: float) -> None:
        ...

    def zoomOut(self, range: int = ...) -> None:
        """
        https://doc.qt.io/qt-6/qtextedit.html#zoomOut

        **[slot] void QTextEdit::zoomOut(int range = 1)**

        Zooms out on the text by making the base font size **range** points
        smaller and recalculating all font sizes to be the new size. This does
        not change the size of any images.

        **See also** **zoomIn** ().
        """
        ...

    @property
    def copyAvailable(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qtextedit.html#copyAvailable

        **[signal] void QTextEdit::copyAvailable(bool yes )**

        This signal is emitted when text is selected or de-selected in the text
        edit.

        When text is selected this signal will be emitted with **yes** set to
        true. If no text has been selected or if the selected text is de-
        selected this signal is emitted with **yes** set to false.

        If **yes** is true then **copy** () can be used to copy the selection to
        the clipboard. If **yes** is false then **copy** () does nothing.

        **See also** **selectionChanged** ().
        """
        ...

    @property
    def currentCharFormatChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qtextedit.html#currentCharFormatChanged

        **[signal] void QTextEdit::currentCharFormatChanged(const
        QTextCharFormat & f )**

        This signal is emitted if the current character format has changed, for
        example caused by a change of the cursor position.

        The new format is **f**.

        **See also** **setCurrentCharFormat** ().
        """
        ...

    @property
    def cursorPositionChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qtextedit.html#cursorPositionChanged

        **[signal] void QTextEdit::cursorPositionChanged()**

        This signal is emitted whenever the position of the cursor changed.
        """
        ...

    @property
    def redoAvailable(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qtextedit.html#redoAvailable

        **[signal] void QTextEdit::redoAvailable(bool available )**

        This signal is emitted whenever redo operations become available (
        **available** is true) or unavailable ( **available** is false).
        """
        ...

    @property
    def selectionChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qtextedit.html#selectionChanged

        **[signal] void QTextEdit::selectionChanged()**

        This signal is emitted whenever the selection changes.

        **See also** **copyAvailable** ().
        """
        ...

    @property
    def textChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qtextedit.html#textChanged

        **[signal] void QTextEdit::textChanged()**

        This signal is emitted whenever the document's content changes; for
        example, when text is inserted or deleted, or when formatting is
        applied.

        **Note:** Notifier signal for property **html** . Notifier signal for
        property **markdown** .
        """
        ...

    @property
    def undoAvailable(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qtextedit.html#undoAvailable

        **[signal] void QTextEdit::undoAvailable(bool available )**

        This signal is emitted whenever undo operations become available (
        **available** is true) or unavailable ( **available** is false).
        """
        ...
