"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtWidgets, except for defaults which are replaced by "...".
"""
from typing import Optional, Union
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets

bytes = str


class QTapAndHoldGesture(PySide6.QtWidgets.QGesture):
    """
    https://doc.qt.io/qt-6/qtapandholdgesture.html

    **Detailed Description**

    For an overview of gesture handling in Qt and information on using gestures
    in your applications, see the **Gestures in Widgets and Graphics View**
    document.

    **See also** **QPanGesture**  and **QPinchGesture** .
    """

    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None:
        ...

    def position(self) -> PySide6.QtCore.QPointF:
        """
        https://doc.qt.io/qt-6/qtapandholdgesture.html#position-prop

        **position : QPointF**

        This property holds the position of the tap

        **Access functions:**

        QPointF **position** () const
        void **setPosition** (const QPointF &
        **pos** )

        **Member Function Documentation**
        """
        ...

    def setPosition(
        self,
        pos: Union[
            PySide6.QtCore.QPointF,
            PySide6.QtCore.QPoint,
            PySide6.QtGui.QPainterPath.Element,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtapandholdgesture.html#position-prop

        **position : QPointF**

        This property holds the position of the tap

        **Access functions:**

        QPointF **position** () const
        void **setPosition** (const QPointF &
        **pos** )

        **Member Function Documentation**
        """
        ...

    @staticmethod
    def setTimeout(msecs: int) -> None:
        """
        https://doc.qt.io/qt-6/qtapandholdgesture.html#setTimeout

        **[static] void QTapAndHoldGesture::setTimeout(int msecs )**

        Set the timeout, in milliseconds, before the gesture triggers.

        The recognizer will detect a touch down and if **msecs** later the touch
        is still down, it will trigger the **QTapAndHoldGesture** . The default
        value is 700 milliseconds.

        **See also** **timeout** ().
        """
        ...

    @staticmethod
    def timeout() -> int:
        """
        https://doc.qt.io/qt-6/qtapandholdgesture.html#timeout

        **[static] int QTapAndHoldGesture::timeout()**

        Gets the timeout, in milliseconds, before the gesture triggers.

        The recognizer will detect a touch down and if timeout() later the touch
        is still down, it will trigger the **QTapAndHoldGesture** . The default
        value is 700 milliseconds.

        **See also** **setTimeout** ().
        """
        ...
