"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtWidgets, except for defaults which are replaced by "...".
"""
from typing import overload
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets

bytes = str


class QTableWidgetSelectionRange(object):
    """
    https://doc.qt.io/qt-6/qtablewidgetselectionrange.html

    **Detailed Description**

    The QTableWidgetSelectionRange class stores the top left and bottom right
    rows and columns of a selection range in a table. The selections in the
    table may consist of several selection ranges.

    **Note:** If the item within the selection range is marked as not
    selectable, e.g., `itemFlags() & Qt::ItemIsSelectable == 0` then it will not
    appear in the selection range.

    **See also** **QTableWidget** .
    """

    @overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qtablewidgetselectionrange.html#QTableWidgetSelec
        tionRange

        **QTableWidgetSelectionRange::QTableWidgetSelectionRange()**

        Constructs an empty table selection range, i.e. a range whose
        **rowCount** () and **columnCount** () are 0.

        **See also** **topRow** (), **leftColumn** (), **bottomRow** (), and
        **rightColumn** ().
        """
        ...

    @overload
    def __init__(
        self, QTableWidgetSelectionRange: PySide6.QtWidgets.QTableWidgetSelectionRange
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtablewidgetselectionrange.html#QTableWidgetSelec
        tionRange-1

        **QTableWidgetSelectionRange::QTableWidgetSelectionRange(int top , int
        left , int bottom , int right )**

        Constructs the table selection range from the given **top** , **left** ,
        **bottom** and **right** table rows and columns.

        **See also** **topRow** (), **leftColumn** (), **bottomRow** (), and
        **rightColumn** ().
        """
        ...

    @overload
    def __init__(self, top: int, left: int, bottom: int, right: int) -> None:
        """
        https://doc.qt.io/qt-6/qtablewidgetselectionrange.html#QTableWidgetSelec
        tionRange

        **QTableWidgetSelectionRange::QTableWidgetSelectionRange()**

        Constructs an empty table selection range, i.e. a range whose
        **rowCount** () and **columnCount** () are 0.

        **See also** **topRow** (), **leftColumn** (), **bottomRow** (), and
        **rightColumn** ().
        """
        ...

    @staticmethod
    def __copy__() -> None:
        ...

    def bottomRow(self) -> int:
        """
        https://doc.qt.io/qt-6/qtablewidgetselectionrange.html#bottomRow

        **int QTableWidgetSelectionRange::bottomRow() const**

        Returns the bottom row of the range.

        **See also** **topRow** (), **rightColumn** (), and **rowCount** ().
        """
        ...

    def columnCount(self) -> int:
        """
        https://doc.qt.io/qt-6/qtablewidgetselectionrange.html#columnCount

        **int QTableWidgetSelectionRange::columnCount() const**

        Returns the number of columns in the range.

        This is equivalent to **rightColumn** () - **leftColumn** () + 1.

        **See also** **rowCount** (), **leftColumn** (), and **rightColumn** ().
        """
        ...

    def leftColumn(self) -> int:
        """
        https://doc.qt.io/qt-6/qtablewidgetselectionrange.html#leftColumn

        **int QTableWidgetSelectionRange::leftColumn() const**

        Returns the left column of the range.

        **See also** **rightColumn** (), **topRow** (), and **columnCount** ().
        """
        ...

    def rightColumn(self) -> int:
        """
        https://doc.qt.io/qt-6/qtablewidgetselectionrange.html#rightColumn

        **int QTableWidgetSelectionRange::rightColumn() const**

        Returns the right column of the range.

        **See also** **leftColumn** (), **bottomRow** (), and **columnCount**
        ().
        """
        ...

    def rowCount(self) -> int:
        """
        https://doc.qt.io/qt-6/qtablewidgetselectionrange.html#rowCount

        **int QTableWidgetSelectionRange::rowCount() const**

        Returns the number of rows in the range.

        This is equivalent to **bottomRow** () - **topRow** () + 1.

        **See also** **columnCount** (), **topRow** (), and **bottomRow** ().
        """
        ...

    def topRow(self) -> int:
        """
        https://doc.qt.io/qt-6/qtablewidgetselectionrange.html#topRow

        **int QTableWidgetSelectionRange::topRow() const**

        Returns the top row of the range.

        **See also** **bottomRow** (), **leftColumn** (), and **rowCount** ().
        """
        ...
