"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtWidgets, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import Any, Sequence, Union, overload
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets

bytes = str


class QTableWidgetItem(object):
    """
    https://doc.qt.io/qt-6/qtablewidgetitem.html

    **Detailed Description**

    Table items are used to hold pieces of information for table widgets. Items
    usually contain text, icons, or checkboxes

    The QTableWidgetItem class is a convenience class that replaces the
    `QTableItem` class in Qt 3. It provides an item for use with the
    **QTableWidget**  class.

    Top-level items are constructed without a parent then inserted at the
    position specified by a pair of row and column numbers:

    **QTableWidgetItem**  *newItem = new **QTableWidgetItem** (tr("%1").arg(
    pow(row, column+1)));
            tableWidget->setItem(row, column, newItem);

    Each item can have its own background brush which is set with the
    **setBackground** () function. The current background brush can be found
    with **background** (). The text label for each item can be rendered with
    its own font and brush. These are specified with the **setFont** () and
    **setForeground** () functions, and read with **font** () and **foreground**
    ().

    By default, items are enabled, editable, selectable, checkable, and can be
    used both as the source of a drag and drop operation and as a drop target.
    Each item's flags can be changed by calling **setFlags** () with the
    appropriate value (see **Qt::ItemFlags** ). Checkable items can be checked
    and unchecked with the **setCheckState** () function. The corresponding
    **checkState** () function indicates whether the item is currently checked.

    **Subclassing**

    When subclassing QTableWidgetItem to provide custom items, it is possible to
    define new types for them so that they can be distinguished from standard
    items. The constructors for subclasses that require this feature need to
    call the base class constructor with a new type value equal to or greater
    than **UserType** .

    **See also** **QTableWidget** , **Model/View Programming** ,
    **QListWidgetItem** , and **QTreeWidgetItem** .
    """

    Type: QTableWidgetItem.ItemType = ...
    UserType: QTableWidgetItem.ItemType = ...

    class ItemType(Enum):
        Type: QTableWidgetItem.ItemType = ...
        UserType: QTableWidgetItem.ItemType = ...

    @overload
    def __init__(
        self,
        icon: Union[PySide6.QtGui.QIcon, PySide6.QtGui.QPixmap],
        text: str,
        type: int = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtablewidgetitem.html#QTableWidgetItem

        **QTableWidgetItem::QTableWidgetItem(int type = Type)**

        Constructs a table item of the specified **type** that does not belong
        to any table.

        **See also** **type** ().
        """
        ...

    @overload
    def __init__(self, other: PySide6.QtWidgets.QTableWidgetItem) -> None:
        """
        https://doc.qt.io/qt-6/qtablewidgetitem.html#QTableWidgetItem-1

        **QTableWidgetItem::QTableWidgetItem(const QString & text , int type =
        Type)**

        Constructs a table item with the given **text**.

        **See also** **type** ().
        """
        ...

    @overload
    def __init__(self, text: str, type: int = ...) -> None:
        """
        https://doc.qt.io/qt-6/qtablewidgetitem.html#QTableWidgetItem-2

        **QTableWidgetItem::QTableWidgetItem(const QIcon & icon , const QString
        & text , int type = Type)**

        Constructs a table item with the given **icon** and **text**.

        **See also** **type** ().
        """
        ...

    @overload
    def __init__(self, type: int = ...) -> None:
        """
        https://doc.qt.io/qt-6/qtablewidgetitem.html#QTableWidgetItem-3

        **QTableWidgetItem::QTableWidgetItem(const QTableWidgetItem & other )**

        Constructs a copy of **other**. Note that **type** () and
        **tableWidget** () are not copied.

        This function is useful when reimplementing **clone** ().

        **See also** **data** () and **flags** ().
        """
        ...

    def __lshift__(self, out: PySide6.QtCore.QDataStream) -> PySide6.QtCore.QDataStream:
        ...

    def __rshift__(self, in_: PySide6.QtCore.QDataStream) -> PySide6.QtCore.QDataStream:
        ...

    def background(self) -> PySide6.QtGui.QBrush:
        """
        https://doc.qt.io/qt-6/qtablewidgetitem.html#background

        **QBrush QTableWidgetItem::background() const**

        Returns the brush used to render the item's background.

        **See also** **setBackground** () and **foreground** ().
        """
        ...

    def checkState(self) -> PySide6.QtCore.Qt.CheckState:
        """
        https://doc.qt.io/qt-6/qtablewidgetitem.html#checkState

        **Qt::CheckState QTableWidgetItem::checkState() const**

        Returns the checked state of the table item.

        **See also** **setCheckState** () and **flags** ().
        """
        ...

    def clone(self) -> PySide6.QtWidgets.QTableWidgetItem:
        """
        https://doc.qt.io/qt-6/qtablewidgetitem.html#clone

        **[virtual] QTableWidgetItem *QTableWidgetItem::clone() const**

        Creates a copy of the item.
        """
        ...

    def column(self) -> int:
        """
        https://doc.qt.io/qt-6/qtablewidgetitem.html#column

        **int QTableWidgetItem::column() const**

        Returns the column of the item in the table. If the item is not in a
        table, this function will return -1.

        **See also** **row** ().
        """
        ...

    def data(self, role: int) -> Any:
        """
        https://doc.qt.io/qt-6/qtablewidgetitem.html#data

        **[virtual] QVariant QTableWidgetItem::data(int role ) const**

        Returns the item's data for the given **role**.

        **See also** **setData** ().
        """
        ...

    def flags(self) -> PySide6.QtCore.Qt.ItemFlags:
        """
        https://doc.qt.io/qt-6/qtablewidgetitem.html#flags

        **Qt::ItemFlags QTableWidgetItem::flags() const**

        Returns the flags used to describe the item. These determine whether the
        item can be checked, edited, and selected.

        **See also** **setFlags** ().
        """
        ...

    def font(self) -> PySide6.QtGui.QFont:
        """
        https://doc.qt.io/qt-6/qtablewidgetitem.html#font

        **QFont QTableWidgetItem::font() const**

        Returns the font used to render the item's text.

        **See also** **setFont** ().
        """
        ...

    def foreground(self) -> PySide6.QtGui.QBrush:
        """
        https://doc.qt.io/qt-6/qtablewidgetitem.html#foreground

        **QBrush QTableWidgetItem::foreground() const**

        Returns the brush used to render the item's foreground (e.g. text).

        **See also** **setForeground** () and **background** ().
        """
        ...

    def icon(self) -> PySide6.QtGui.QIcon:
        """
        https://doc.qt.io/qt-6/qtablewidgetitem.html#icon

        **QIcon QTableWidgetItem::icon() const**

        Returns the item's icon.

        **See also** **setIcon** () and **iconSize** .
        """
        ...

    def isSelected(self) -> bool:
        """
        https://doc.qt.io/qt-6/qtablewidgetitem.html#isSelected

        **bool QTableWidgetItem::isSelected() const**

        Returns `true` if the item is selected, otherwise returns `false`.

        **See also** **setSelected** ().
        """
        ...

    def read(self, in_: PySide6.QtCore.QDataStream) -> None:
        """
        https://doc.qt.io/qt-6/qtablewidgetitem.html#read

        **[virtual] void QTableWidgetItem::read(QDataStream & in )**

        Reads the item from stream **in**.

        **See also** **write** ().
        """
        ...

    def row(self) -> int:
        """
        https://doc.qt.io/qt-6/qtablewidgetitem.html#row

        **int QTableWidgetItem::row() const**

        Returns the row of the item in the table. If the item is not in a table,
        this function will return -1.

        **See also** **column** ().
        """
        ...

    def setBackground(
        self,
        brush: Union[
            PySide6.QtGui.QBrush,
            PySide6.QtCore.Qt.BrushStyle,
            PySide6.QtCore.Qt.GlobalColor,
            PySide6.QtGui.QColor,
            PySide6.QtGui.QGradient,
            PySide6.QtGui.QImage,
            PySide6.QtGui.QPixmap,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtablewidgetitem.html#setBackground

        **void QTableWidgetItem::setBackground(const QBrush & brush )**

        Sets the item's background brush to the specified **brush**. Setting a
        default-constructed brush will let the view use the default color from
        the style.

        **See also** **background** () and **setForeground** ().
        """
        ...

    def setCheckState(self, state: PySide6.QtCore.Qt.CheckState) -> None:
        """
        https://doc.qt.io/qt-6/qtablewidgetitem.html#setCheckState

        **void QTableWidgetItem::setCheckState(Qt::CheckState state )**

        Sets the check state of the table item to be **state**.

        **See also** **checkState** ().
        """
        ...

    def setData(self, role: int, value: Any) -> None:
        """
        https://doc.qt.io/qt-6/qtablewidgetitem.html#setData

        **[virtual] void QTableWidgetItem::setData(int role , const QVariant &
        value )**

        Sets the item's data for the given **role** to the specified **value**.

        **Note:** The default implementation treats **Qt::EditRole**  and
        **Qt::DisplayRole**  as referring to the same data.

        **See also** **Qt::ItemDataRole**  and **data** ().
        """
        ...

    def setFlags(self, flags: PySide6.QtCore.Qt.ItemFlags) -> None:
        """
        https://doc.qt.io/qt-6/qtablewidgetitem.html#setFlags

        **void QTableWidgetItem::setFlags(Qt::ItemFlags flags )**

        Sets the flags for the item to the given **flags**. These determine
        whether the item can be selected or modified.

        **See also** **flags** ().
        """
        ...

    def setFont(self, font: Union[PySide6.QtGui.QFont, str, Sequence[str]]) -> None:
        """
        https://doc.qt.io/qt-6/qtablewidgetitem.html#setFont

        **void QTableWidgetItem::setFont(const QFont & font )**

        Sets the font used to display the item's text to the given **font**.

        **See also** **font** (), **setText** (), and **setForeground** ().
        """
        ...

    def setForeground(
        self,
        brush: Union[
            PySide6.QtGui.QBrush,
            PySide6.QtCore.Qt.BrushStyle,
            PySide6.QtCore.Qt.GlobalColor,
            PySide6.QtGui.QColor,
            PySide6.QtGui.QGradient,
            PySide6.QtGui.QImage,
            PySide6.QtGui.QPixmap,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtablewidgetitem.html#setForeground

        **void QTableWidgetItem::setForeground(const QBrush & brush )**

        Sets the item's foreground brush to the specified **brush**. Setting a
        default-constructed brush will let the view use the default color from
        the style.

        **See also** **foreground** () and **setBackground** ().
        """
        ...

    def setIcon(self, icon: Union[PySide6.QtGui.QIcon, PySide6.QtGui.QPixmap]) -> None:
        """
        https://doc.qt.io/qt-6/qtablewidgetitem.html#setIcon

        **void QTableWidgetItem::setIcon(const QIcon & icon )**

        Sets the item's icon to the **icon** specified.

        **See also** **icon** (), **setText** (), and **iconSize** .
        """
        ...

    def setSelected(self, select: bool) -> None:
        """
        https://doc.qt.io/qt-6/qtablewidgetitem.html#setSelected

        **void QTableWidgetItem::setSelected(bool select )**

        Sets the selected state of the item to **select**.

        **See also** **isSelected** ().
        """
        ...

    def setSizeHint(self, size: PySide6.QtCore.QSize) -> None:
        """
        https://doc.qt.io/qt-6/qtablewidgetitem.html#setSizeHint

        **void QTableWidgetItem::setSizeHint(const QSize & size )**

        Sets the size hint for the table item to be **size**. If no size hint is
        set or **size** is invalid, the item delegate will compute the size hint
        based on the item data.

        **See also** **sizeHint** ().
        """
        ...

    def setStatusTip(self, statusTip: str) -> None:
        """
        https://doc.qt.io/qt-6/qtablewidgetitem.html#setStatusTip

        **void QTableWidgetItem::setStatusTip(const QString & statusTip )**

        Sets the status tip for the table item to the text specified by
        **statusTip**. **QTableWidget**  mouse tracking needs to be enabled for
        this feature to work.

        **See also** **statusTip** (), **setToolTip** (), and **setWhatsThis**
        ().
        """
        ...

    def setText(self, text: str) -> None:
        """
        https://doc.qt.io/qt-6/qtablewidgetitem.html#setText

        **void QTableWidgetItem::setText(const QString & text )**

        Sets the item's text to the **text** specified.

        **See also** **text** (), **setFont** (), and **setForeground** ().
        """
        ...

    def setTextAlignment(self, alignment: int) -> None:
        """
        https://doc.qt.io/qt-6/qtablewidgetitem.html#setTextAlignment

        **void QTableWidgetItem::setTextAlignment(int alignment )**

        Sets the text alignment for the item's text to the **alignment**
        specified.

        **See also** **textAlignment** () and **Qt::Alignment** .
        """
        ...

    def setToolTip(self, toolTip: str) -> None:
        """
        https://doc.qt.io/qt-6/qtablewidgetitem.html#setToolTip

        **void QTableWidgetItem::setToolTip(const QString & toolTip )**

        Sets the item's tooltip to the string specified by **toolTip**.

        **See also** **toolTip** (), **setStatusTip** (), and **setWhatsThis**
        ().
        """
        ...

    def setWhatsThis(self, whatsThis: str) -> None:
        """
        https://doc.qt.io/qt-6/qtablewidgetitem.html#setWhatsThis

        **void QTableWidgetItem::setWhatsThis(const QString & whatsThis )**

        Sets the item's "What's This?" help to the string specified by
        **whatsThis**.

        **See also** **whatsThis** (), **setStatusTip** (), and **setToolTip**
        ().
        """
        ...

    def sizeHint(self) -> PySide6.QtCore.QSize:
        """
        https://doc.qt.io/qt-6/qtablewidgetitem.html#sizeHint

        **QSize QTableWidgetItem::sizeHint() const**

        Returns the size hint set for the table item.

        **See also** **setSizeHint** ().
        """
        ...

    def statusTip(self) -> str:
        """
        https://doc.qt.io/qt-6/qtablewidgetitem.html#statusTip

        **QString QTableWidgetItem::statusTip() const**

        Returns the item's status tip.

        **See also** **setStatusTip** ().
        """
        ...

    def tableWidget(self) -> PySide6.QtWidgets.QTableWidget:
        """
        https://doc.qt.io/qt-6/qtablewidgetitem.html#tableWidget

        **QTableWidget *QTableWidgetItem::tableWidget() const**

        Returns the table widget that contains the item.
        """
        ...

    def text(self) -> str:
        """
        https://doc.qt.io/qt-6/qtablewidgetitem.html#text

        **QString QTableWidgetItem::text() const**

        Returns the item's text.

        **See also** **setText** ().
        """
        ...

    def textAlignment(self) -> int:
        """
        https://doc.qt.io/qt-6/qtablewidgetitem.html#textAlignment

        **int QTableWidgetItem::textAlignment() const**

        Returns the text alignment for the item's text.

        **See also** **setTextAlignment** () and **Qt::Alignment** .
        """
        ...

    def toolTip(self) -> str:
        """
        https://doc.qt.io/qt-6/qtablewidgetitem.html#toolTip

        **QString QTableWidgetItem::toolTip() const**

        Returns the item's tooltip.

        **See also** **setToolTip** ().
        """
        ...

    def type(self) -> int:
        """
        https://doc.qt.io/qt-6/qtablewidgetitem.html#type

        **int QTableWidgetItem::type() const**

        Returns the type passed to the **QTableWidgetItem**  constructor.
        """
        ...

    def whatsThis(self) -> str:
        """
        https://doc.qt.io/qt-6/qtablewidgetitem.html#whatsThis

        **QString QTableWidgetItem::whatsThis() const**

        Returns the item's "What's This?" help.

        **See also** **setWhatsThis** ().
        """
        ...

    def write(self, out: PySide6.QtCore.QDataStream) -> None:
        """
        https://doc.qt.io/qt-6/qtablewidgetitem.html#write

        **[virtual] void QTableWidgetItem::write(QDataStream & out ) const**

        Writes the item to stream **out**.

        **See also** **read** ().
        """
        ...
