"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtWidgets, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import Any, Optional, Union, overload
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets

bytes = str


class QTabBar(PySide6.QtWidgets.QWidget):
    """
    https://doc.qt.io/qt-6/qtabbar.html

    **Detailed Description**

    QTabBar is straightforward to use; it draws the tabs using one of the
    predefined **shapes** , and emits a signal when a tab is selected. It can be
    subclassed to tailor the look and feel. Qt also provides a ready-made
    **QTabWidget** .

    Each tab has a **tabText** (), an optional **tabIcon** (), an optional
    **tabToolTip** (), optional **tabWhatsThis** () and optional **tabData** ().
    The tabs's attributes can be changed with **setTabText** (), **setTabIcon**
    (), **setTabToolTip** (), **setTabWhatsThis**  and **setTabData** (). Each
    tabs can be enabled or disabled individually with **setTabEnabled** ().

    Each tab can display text in a distinct color. The current text color for a
    tab can be found with the **tabTextColor** () function. Set the text color
    for a particular tab with **setTabTextColor** ().

    Tabs are added using **addTab** (), or inserted at particular positions
    using **insertTab** (). The total number of tabs is given by **count** ().
    Tabs can be removed from the tab bar with **removeTab** (). Combining
    **removeTab** () and **insertTab** () allows you to move tabs to different
    positions.

    The **shape**  property defines the tabs' appearance. The choice of shape is
    a matter of taste, although tab dialogs (for preferences and similar)
    invariably use **RoundedNorth** . Tab controls in windows other than dialogs
    almost always use either **RoundedSouth**  or **TriangularSouth** . Many
    spreadsheets and other tab controls in which all the pages are essentially
    similar use **TriangularSouth** , whereas **RoundedSouth**  is used mostly
    when the pages are different (e.g. a multi-page tool palette). The default
    in QTabBar is **RoundedNorth** .

    The most important part of QTabBar's API is the **currentChanged** ()
    signal. This is emitted whenever the current tab changes (even at startup,
    when the current tab changes from 'none'). There is also a slot,
    **setCurrentIndex** (), which can be used to select a tab programmatically.
    The function **currentIndex** () returns the index of the current tab,
    **count**  holds the number of tabs.

    QTabBar creates automatic mnemonic keys in the manner of **QAbstractButton**
    ; e.g. if a tab's label is "&Graphics", Alt+G becomes a shortcut key for
    switching to that tab.

    The following virtual functions may need to be reimplemented in order to
    tailor the look and feel or store extra data with each tab:

    * **tabSizeHint** () calcuates the size of a tab.
      * **tabInserted** ()
    notifies that a new tab was added.
      * **tabRemoved** () notifies that a tab
    was removed.
      * **tabLayoutChange** () notifies that the tabs have been re-
    laid out.
      * **paintEvent** () paints all tabs.

    For subclasses, you might also need the **tabRect** () functions which
    returns the visual geometry of a single tab.

    ![Screenshot of a Fusion style tab bar](images/fusion-tabbar.png)A tab bar
    shown in the **Fusion widget style** .
    ![Screenshot of a truncated Fusion
    tab bar](images/fusion-tabbar-truncated.png)A truncated tab bar shown in the
    Fusion widget style.

    **See also** **QTabWidget** .
    """

    LeftSide: QTabBar.ButtonPosition = ...
    RightSide: QTabBar.ButtonPosition = ...
    SelectLeftTab: QTabBar.SelectionBehavior = ...
    SelectRightTab: QTabBar.SelectionBehavior = ...
    SelectPreviousTab: QTabBar.SelectionBehavior = ...
    RoundedNorth: QTabBar.Shape = ...
    RoundedSouth: QTabBar.Shape = ...
    RoundedWest: QTabBar.Shape = ...
    RoundedEast: QTabBar.Shape = ...
    TriangularNorth: QTabBar.Shape = ...
    TriangularSouth: QTabBar.Shape = ...
    TriangularWest: QTabBar.Shape = ...
    TriangularEast: QTabBar.Shape = ...

    class ButtonPosition(Enum):
        LeftSide: QTabBar.ButtonPosition = ...
        RightSide: QTabBar.ButtonPosition = ...

    class SelectionBehavior(Enum):
        SelectLeftTab: QTabBar.SelectionBehavior = ...
        SelectRightTab: QTabBar.SelectionBehavior = ...
        SelectPreviousTab: QTabBar.SelectionBehavior = ...

    class Shape(Enum):
        RoundedNorth: QTabBar.Shape = ...
        RoundedSouth: QTabBar.Shape = ...
        RoundedWest: QTabBar.Shape = ...
        RoundedEast: QTabBar.Shape = ...
        TriangularNorth: QTabBar.Shape = ...
        TriangularSouth: QTabBar.Shape = ...
        TriangularWest: QTabBar.Shape = ...
        TriangularEast: QTabBar.Shape = ...

    def __init__(self, parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qtabbar.html#QTabBar

        **QTabBar::QTabBar(QWidget * parent = nullptr)**

        Creates a new tab bar with the given **parent**.
        """
        ...

    def accessibleTabName(self, index: int) -> str:
        """
        https://doc.qt.io/qt-6/qtabbar.html#accessibleTabName

        **QString QTabBar::accessibleTabName(int index ) const**

        Returns the accessibleName of the tab at position **index** , or an
        empty string if **index** is out of range.

        **See also** **setAccessibleTabName** ().
        """
        ...

    @overload
    def addTab(
        self, icon: Union[PySide6.QtGui.QIcon, PySide6.QtGui.QPixmap], text: str
    ) -> int:
        """
        https://doc.qt.io/qt-6/qtabbar.html#addTab

        **int QTabBar::addTab(const QString & text )**

        Adds a new tab with text **text**. Returns the new tab's index.
        """
        ...

    @overload
    def addTab(self, text: str) -> int:
        """
        https://doc.qt.io/qt-6/qtabbar.html#addTab-1

        **int QTabBar::addTab(const QIcon & icon , const QString & text )**

        This is an overloaded function.

        Adds a new tab with icon **icon** and text **text**. Returns the new
        tab's index.
        """
        ...

    def autoHide(self) -> bool:
        """
        https://doc.qt.io/qt-6/qtabbar.html#autoHide-prop

        **[since 5.4] autoHide : bool**

        If true, the tab bar is automatically hidden when it contains less than
        2 tabs.

        By default, this property is false.

        This property was introduced in Qt 5.4.

        **Access functions:**

        bool **autoHide** () const
        void **setAutoHide** (bool **hide** )

        **See also** **QWidget::visible** .
        """
        ...

    def changeCurrentOnDrag(self) -> bool:
        """
        https://doc.qt.io/qt-6/qtabbar.html#changeCurrentOnDrag-prop

        **[since 5.4] changeCurrentOnDrag : bool**

        If true, then the current tab is automatically changed when dragging
        over the tabbar.

        **Note:** You should also set acceptDrops property to true to make this
        feature work.

        By default, this property is false.

        This property was introduced in Qt 5.4.

        **Access functions:**

        bool **changeCurrentOnDrag** () const
        void **setChangeCurrentOnDrag**
        (bool **change** )
        """
        ...

    def changeEvent(self, arg__1: PySide6.QtCore.QEvent) -> None:
        """
        https://doc.qt.io/qt-6/qtabbar.html#changeEvent

        **[override virtual protected] void QTabBar::changeEvent(QEvent * event
        )**

        Reimplements: **QWidget::changeEvent** (QEvent *event).
        """
        ...

    def count(self) -> int:
        """
        https://doc.qt.io/qt-6/qtabbar.html#count-prop

        **[read-only] count : const int**

        This property holds the number of tabs in the tab bar

        **Access functions:**

        int **count** () const
        """
        ...

    def currentIndex(self) -> int:
        """
        https://doc.qt.io/qt-6/qtabbar.html#currentIndex-prop

        **currentIndex : int**

        This property holds the index of the tab bar's visible tab

        The current index is -1 if there is no current tab.

        **Access functions:**

        int **currentIndex** () const
        void **setCurrentIndex** (int **index**
        )

        **Notifier signal:**

        void ****currentChanged** ** (int **index** )
        """
        ...

    def documentMode(self) -> bool:
        """
        https://doc.qt.io/qt-6/qtabbar.html#documentMode-prop

        **documentMode : bool**

        This property holds whether or not the tab bar is rendered in a mode
        suitable for the main window.

        This property is used as a hint for styles to draw the tabs in a
        different way then they would normally look in a tab widget. On macOS
        this will look similar to the tabs in Safari or Sierra's Terminal.app.

        **Access functions:**

        bool **documentMode** () const
        void **setDocumentMode** (bool **set**
        )

        **See also** **QTabWidget::documentMode** .
        """
        ...

    def drawBase(self) -> bool:
        """
        https://doc.qt.io/qt-6/qtabbar.html#drawBase-prop

        **drawBase : bool**

        defines whether or not tab bar should draw its base.

        If true then **QTabBar**  draws a base in relation to the styles
        overlap. Otherwise only the tabs are drawn.

        **Access functions:**

        bool **drawBase** () const
        void **setDrawBase** (bool **drawTheBase**
        )

        **See also** **QStyle::pixelMetric** (),
        **QStyle::PM_TabBarBaseOverlap** , and **QStyleOptionTabBarBase** .
        """
        ...

    def elideMode(self) -> PySide6.QtCore.Qt.TextElideMode:
        """
        https://doc.qt.io/qt-6/qtabbar.html#elideMode-prop

        **elideMode : Qt::TextElideMode**

        how to elide text in the tab bar

        This property controls how items are elided when there is not enough
        space to show them for a given tab bar size.

        By default the value is style-dependent.

        **Access functions:**

        Qt::TextElideMode **elideMode** () const
        void **setElideMode**
        (Qt::TextElideMode **mode** )

        **See also** **QTabWidget::elideMode** , **usesScrollButtons** , and
        **QStyle::SH_TabBar_ElideMode** .
        """
        ...

    def event(self, arg__1: PySide6.QtCore.QEvent) -> bool:
        """
        https://doc.qt.io/qt-6/qtabbar.html#event

        **[override virtual protected] bool QTabBar::event(QEvent * event )**

        Reimplements: **QWidget::event** (QEvent *event).
        """
        ...

    def expanding(self) -> bool:
        """
        https://doc.qt.io/qt-6/qtabbar.html#expanding-prop

        **expanding : bool**

        When expanding is true **QTabBar**  will expand the tabs to use the
        empty space.

        By default the value is true.

        **Access functions:**

        bool **expanding** () const
        void **setExpanding** (bool **enabled** )

        **See also** **QTabWidget::documentMode** .
        """
        ...

    def hideEvent(self, arg__1: PySide6.QtGui.QHideEvent) -> None:
        """
        https://doc.qt.io/qt-6/qtabbar.html#hideEvent

        **[override virtual protected] void QTabBar::hideEvent(QHideEvent *)**

        Reimplements: **QWidget::hideEvent** (QHideEvent *event).
        """
        ...

    def iconSize(self) -> PySide6.QtCore.QSize:
        """
        https://doc.qt.io/qt-6/qtabbar.html#iconSize-prop

        **iconSize : QSize**

        This property holds the size for icons in the tab bar

        The default value is style-dependent. `iconSize` is a maximum size;
        icons that are smaller are not scaled up.

        **Access functions:**

        QSize **iconSize** () const
        void **setIconSize** (const QSize &
        **size** )

        **See also** **QTabWidget::iconSize** .
        """
        ...

    def initStyleOption(
        self, option: PySide6.QtWidgets.QStyleOptionTab, tabIndex: int
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtabbar.html#initStyleOption

        **[virtual protected] void QTabBar::initStyleOption(QStyleOptionTab *
        option , int tabIndex ) const**

        Initialize **option** with the values from the tab at **tabIndex**. This
        method is useful for subclasses when they need a **QStyleOptionTab** ,
        but don't want to fill in all the information themselves.

        **See also** **QStyleOption::initFrom** () and
        **QTabWidget::initStyleOption** ().
        """
        ...

    @overload
    def insertTab(
        self,
        index: int,
        icon: Union[PySide6.QtGui.QIcon, PySide6.QtGui.QPixmap],
        text: str,
    ) -> int:
        """
        https://doc.qt.io/qt-6/qtabbar.html#insertTab

        **int QTabBar::insertTab(int index , const QString & text )**

        Inserts a new tab with text **text** at position **index**. If **index**
        is out of range, the new tab is appened. Returns the new tab's index.
        """
        ...

    @overload
    def insertTab(self, index: int, text: str) -> int:
        """
        https://doc.qt.io/qt-6/qtabbar.html#insertTab-1

        **int QTabBar::insertTab(int index , const QIcon & icon , const QString
        & text )**

        This is an overloaded function.

        Inserts a new tab with icon **icon** and text **text** at position
        **index**. If **index** is out of range, the new tab is appended.
        Returns the new tab's index.

        If the **QTabBar**  was empty before this function is called, the
        inserted tab becomes the current tab.

        Inserting a new tab at an index less than or equal to the current index
        will increment the current index, but keep the current tab.
        """
        ...

    def isMovable(self) -> bool:
        ...

    def isTabEnabled(self, index: int) -> bool:
        """
        https://doc.qt.io/qt-6/qtabbar.html#isTabEnabled

        **bool QTabBar::isTabEnabled(int index ) const**

        Returns `true` if the tab at position **index** is enabled; otherwise
        returns `false`.
        """
        ...

    def isTabVisible(self, index: int) -> bool:
        """
        https://doc.qt.io/qt-6/qtabbar.html#isTabVisible

        **[since 5.15] bool QTabBar::isTabVisible(int index ) const**

        Returns true if the tab at position **index** is visible; otherwise
        returns false.

        This function was introduced in Qt 5.15.
        """
        ...

    def keyPressEvent(self, arg__1: PySide6.QtGui.QKeyEvent) -> None:
        """
        https://doc.qt.io/qt-6/qtabbar.html#keyPressEvent

        **[override virtual protected] void QTabBar::keyPressEvent(QKeyEvent *
        event )**

        Reimplements: **QWidget::keyPressEvent** (QKeyEvent *event).
        """
        ...

    def minimumSizeHint(self) -> PySide6.QtCore.QSize:
        """
        https://doc.qt.io/qt-6/qtabbar.html#minimumSizeHint

        **[override virtual] QSize QTabBar::minimumSizeHint() const**

        Reimplements an access function for property:
        **QWidget::minimumSizeHint** .
        """
        ...

    def minimumTabSizeHint(self, index: int) -> PySide6.QtCore.QSize:
        """
        https://doc.qt.io/qt-6/qtabbar.html#minimumTabSizeHint

        **[virtual protected, since 5.0] QSize QTabBar::minimumTabSizeHint(int
        index ) const**

        Returns the minimum tab size hint for the tab at position **index**.

        This function was introduced in Qt 5.0.
        """
        ...

    def mouseDoubleClickEvent(self, arg__1: PySide6.QtGui.QMouseEvent) -> None:
        """
        https://doc.qt.io/qt-6/qtabbar.html#mouseDoubleClickEvent

        **[override virtual protected] void
        QTabBar::mouseDoubleClickEvent(QMouseEvent * event )**

        Reimplements: **QWidget::mouseDoubleClickEvent** (QMouseEvent *event).
        """
        ...

    def mouseMoveEvent(self, arg__1: PySide6.QtGui.QMouseEvent) -> None:
        """
        https://doc.qt.io/qt-6/qtabbar.html#mouseMoveEvent

        **[override virtual protected] void QTabBar::mouseMoveEvent(QMouseEvent
        * event )**

        Reimplements: **QWidget::mouseMoveEvent** (QMouseEvent *event).
        """
        ...

    def mousePressEvent(self, arg__1: PySide6.QtGui.QMouseEvent) -> None:
        """
        https://doc.qt.io/qt-6/qtabbar.html#mousePressEvent

        **[override virtual protected] void QTabBar::mousePressEvent(QMouseEvent
        * event )**

        Reimplements: **QWidget::mousePressEvent** (QMouseEvent *event).
        """
        ...

    def mouseReleaseEvent(self, arg__1: PySide6.QtGui.QMouseEvent) -> None:
        """
        https://doc.qt.io/qt-6/qtabbar.html#mouseReleaseEvent

        **[override virtual protected] void
        QTabBar::mouseReleaseEvent(QMouseEvent * event )**

        Reimplements: **QWidget::mouseReleaseEvent** (QMouseEvent *event).
        """
        ...

    def moveTab(self, from_: int, to: int) -> None:
        """
        https://doc.qt.io/qt-6/qtabbar.html#moveTab

        **void QTabBar::moveTab(int from , int to )**

        Moves the item at index position **from** to index position **to**.

        **See also** **tabMoved** () and **tabLayoutChange** ().
        """
        ...

    def paintEvent(self, arg__1: PySide6.QtGui.QPaintEvent) -> None:
        """
        https://doc.qt.io/qt-6/qtabbar.html#paintEvent

        **[override virtual protected] void QTabBar::paintEvent(QPaintEvent *)**

        Reimplements: **QWidget::paintEvent** (QPaintEvent *event).
        """
        ...

    def removeTab(self, index: int) -> None:
        """
        https://doc.qt.io/qt-6/qtabbar.html#removeTab

        **void QTabBar::removeTab(int index )**

        Removes the tab at position **index**.

        **See also** **SelectionBehavior** .
        """
        ...

    def resizeEvent(self, arg__1: PySide6.QtGui.QResizeEvent) -> None:
        """
        https://doc.qt.io/qt-6/qtabbar.html#resizeEvent

        **[override virtual protected] void QTabBar::resizeEvent(QResizeEvent
        *)**

        Reimplements: **QWidget::resizeEvent** (QResizeEvent *event).
        """
        ...

    def selectionBehaviorOnRemove(self) -> PySide6.QtWidgets.QTabBar.SelectionBehavior:
        """
        https://doc.qt.io/qt-6/qtabbar.html#selectionBehaviorOnRemove-prop

        **selectionBehaviorOnRemove : SelectionBehavior**

        What tab should be set as current when **removeTab**  is called if the
        removed tab is also the current tab.

        By default the value is **SelectRightTab** .

        **Access functions:**

        QTabBar::SelectionBehavior **selectionBehaviorOnRemove** () const
        void
        **setSelectionBehaviorOnRemove** (QTabBar::SelectionBehavior
        **behavior** )

        **See also** **removeTab** ().
        """
        ...

    def setAccessibleTabName(self, index: int, name: str) -> None:
        """
        https://doc.qt.io/qt-6/qtabbar.html#setAccessibleTabName

        **void QTabBar::setAccessibleTabName(int index , const QString & name
        )**

        Sets the accessibleName of the tab at position **index** to **name**.

        **See also** **accessibleTabName** ().
        """
        ...

    def setAutoHide(self, hide: bool) -> None:
        """
        https://doc.qt.io/qt-6/qtabbar.html#autoHide-prop

        **[since 5.4] autoHide : bool**

        If true, the tab bar is automatically hidden when it contains less than
        2 tabs.

        By default, this property is false.

        This property was introduced in Qt 5.4.

        **Access functions:**

        bool **autoHide** () const
        void **setAutoHide** (bool **hide** )

        **See also** **QWidget::visible** .
        """
        ...

    def setChangeCurrentOnDrag(self, change: bool) -> None:
        """
        https://doc.qt.io/qt-6/qtabbar.html#changeCurrentOnDrag-prop

        **[since 5.4] changeCurrentOnDrag : bool**

        If true, then the current tab is automatically changed when dragging
        over the tabbar.

        **Note:** You should also set acceptDrops property to true to make this
        feature work.

        By default, this property is false.

        This property was introduced in Qt 5.4.

        **Access functions:**

        bool **changeCurrentOnDrag** () const
        void **setChangeCurrentOnDrag**
        (bool **change** )
        """
        ...

    def setCurrentIndex(self, index: int) -> None:
        """
        https://doc.qt.io/qt-6/qtabbar.html#currentIndex-prop

        **currentIndex : int**

        This property holds the index of the tab bar's visible tab

        The current index is -1 if there is no current tab.

        **Access functions:**

        int **currentIndex** () const
        void **setCurrentIndex** (int **index**
        )

        **Notifier signal:**

        void ****currentChanged** ** (int **index** )
        """
        ...

    def setDocumentMode(self, set: bool) -> None:
        """
        https://doc.qt.io/qt-6/qtabbar.html#documentMode-prop

        **documentMode : bool**

        This property holds whether or not the tab bar is rendered in a mode
        suitable for the main window.

        This property is used as a hint for styles to draw the tabs in a
        different way then they would normally look in a tab widget. On macOS
        this will look similar to the tabs in Safari or Sierra's Terminal.app.

        **Access functions:**

        bool **documentMode** () const
        void **setDocumentMode** (bool **set**
        )

        **See also** **QTabWidget::documentMode** .
        """
        ...

    def setDrawBase(self, drawTheBase: bool) -> None:
        """
        https://doc.qt.io/qt-6/qtabbar.html#drawBase-prop

        **drawBase : bool**

        defines whether or not tab bar should draw its base.

        If true then **QTabBar**  draws a base in relation to the styles
        overlap. Otherwise only the tabs are drawn.

        **Access functions:**

        bool **drawBase** () const
        void **setDrawBase** (bool **drawTheBase**
        )

        **See also** **QStyle::pixelMetric** (),
        **QStyle::PM_TabBarBaseOverlap** , and **QStyleOptionTabBarBase** .
        """
        ...

    def setElideMode(self, mode: PySide6.QtCore.Qt.TextElideMode) -> None:
        """
        https://doc.qt.io/qt-6/qtabbar.html#elideMode-prop

        **elideMode : Qt::TextElideMode**

        how to elide text in the tab bar

        This property controls how items are elided when there is not enough
        space to show them for a given tab bar size.

        By default the value is style-dependent.

        **Access functions:**

        Qt::TextElideMode **elideMode** () const
        void **setElideMode**
        (Qt::TextElideMode **mode** )

        **See also** **QTabWidget::elideMode** , **usesScrollButtons** , and
        **QStyle::SH_TabBar_ElideMode** .
        """
        ...

    def setExpanding(self, enabled: bool) -> None:
        """
        https://doc.qt.io/qt-6/qtabbar.html#expanding-prop

        **expanding : bool**

        When expanding is true **QTabBar**  will expand the tabs to use the
        empty space.

        By default the value is true.

        **Access functions:**

        bool **expanding** () const
        void **setExpanding** (bool **enabled** )

        **See also** **QTabWidget::documentMode** .
        """
        ...

    def setIconSize(self, size: PySide6.QtCore.QSize) -> None:
        """
        https://doc.qt.io/qt-6/qtabbar.html#iconSize-prop

        **iconSize : QSize**

        This property holds the size for icons in the tab bar

        The default value is style-dependent. `iconSize` is a maximum size;
        icons that are smaller are not scaled up.

        **Access functions:**

        QSize **iconSize** () const
        void **setIconSize** (const QSize &
        **size** )

        **See also** **QTabWidget::iconSize** .
        """
        ...

    def setMovable(self, movable: bool) -> None:
        """
        https://doc.qt.io/qt-6/qtabbar.html#movable-prop

        **movable : bool**

        This property holds whether the user can move the tabs within the tabbar
        area.

        By default, this property is `false`;

        **Access functions:**

        bool **isMovable** () const
        void **setMovable** (bool **movable** )
        """
        ...

    def setSelectionBehaviorOnRemove(
        self, behavior: PySide6.QtWidgets.QTabBar.SelectionBehavior
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtabbar.html#selectionBehaviorOnRemove-prop

        **selectionBehaviorOnRemove : SelectionBehavior**

        What tab should be set as current when **removeTab**  is called if the
        removed tab is also the current tab.

        By default the value is **SelectRightTab** .

        **Access functions:**

        QTabBar::SelectionBehavior **selectionBehaviorOnRemove** () const
        void
        **setSelectionBehaviorOnRemove** (QTabBar::SelectionBehavior
        **behavior** )

        **See also** **removeTab** ().
        """
        ...

    def setShape(self, shape: PySide6.QtWidgets.QTabBar.Shape) -> None:
        """
        https://doc.qt.io/qt-6/qtabbar.html#shape-prop

        **shape : Shape**

        This property holds the shape of the tabs in the tab bar

        Possible values for this property are described by the Shape enum.

        **Access functions:**

        QTabBar::Shape **shape** () const
        void **setShape** (QTabBar::Shape
        **shape** )
        """
        ...

    def setTabButton(
        self,
        index: int,
        position: PySide6.QtWidgets.QTabBar.ButtonPosition,
        widget: PySide6.QtWidgets.QWidget,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtabbar.html#setTabButton

        **void QTabBar::setTabButton(int index , QTabBar::ButtonPosition
        position , QWidget * widget )**

        Sets **widget** on the tab **index**. The widget is placed on the left
        or right hand side depending upon the **position**.

        Any previously set widget in **position** is hidden.

        The tab bar will take ownership of the widget and so all widgets set
        here will be deleted by the tab bar when it is destroyed unless you
        separately reparent the widget after setting some other widget (or
        `nullptr`).

        **See also** **tabButton** () and **tabsClosable** ().
        """
        ...

    def setTabData(self, index: int, data: Any) -> None:
        """
        https://doc.qt.io/qt-6/qtabbar.html#setTabData

        **void QTabBar::setTabData(int index , const QVariant & data )**

        Sets the data of the tab at position **index** to **data**.

        **See also** **tabData** ().
        """
        ...

    def setTabEnabled(self, index: int, enabled: bool) -> None:
        """
        https://doc.qt.io/qt-6/qtabbar.html#setTabEnabled

        **void QTabBar::setTabEnabled(int index , bool enabled )**

        If **enabled** is true then the tab at position **index** is enabled;
        otherwise the item at position **index** is disabled.

        **See also** **isTabEnabled** ().
        """
        ...

    def setTabIcon(
        self, index: int, icon: Union[PySide6.QtGui.QIcon, PySide6.QtGui.QPixmap]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtabbar.html#setTabIcon

        **void QTabBar::setTabIcon(int index , const QIcon & icon )**

        Sets the icon of the tab at position **index** to **icon**.

        **See also** **tabIcon** ().
        """
        ...

    def setTabText(self, index: int, text: str) -> None:
        """
        https://doc.qt.io/qt-6/qtabbar.html#setTabText

        **void QTabBar::setTabText(int index , const QString & text )**

        Sets the text of the tab at position **index** to **text**.

        **See also** **tabText** ().
        """
        ...

    def setTabTextColor(
        self,
        index: int,
        color: Union[
            PySide6.QtGui.QColor,
            PySide6.QtGui.QRgba64,
            Any,
            PySide6.QtCore.Qt.GlobalColor,
            str,
            int,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtabbar.html#setTabTextColor

        **void QTabBar::setTabTextColor(int index , const QColor & color )**

        Sets the color of the text in the tab with the given **index** to the
        specified **color**.

        If an invalid color is specified, the tab will use the **QTabBar**
        foreground role instead.

        **See also** **tabTextColor** ().
        """
        ...

    def setTabToolTip(self, index: int, tip: str) -> None:
        """
        https://doc.qt.io/qt-6/qtabbar.html#setTabToolTip

        **void QTabBar::setTabToolTip(int index , const QString & tip )**

        Sets the tool tip of the tab at position **index** to **tip**.

        **See also** **tabToolTip** ().
        """
        ...

    def setTabVisible(self, index: int, visible: bool) -> None:
        """
        https://doc.qt.io/qt-6/qtabbar.html#setTabVisible

        **[since 5.15] void QTabBar::setTabVisible(int index , bool visible )**

        If **visible** is true, make the tab at position **index** visible,
        otherwise make it hidden.

        This function was introduced in Qt 5.15.

        **See also** **isTabVisible** ().
        """
        ...

    def setTabWhatsThis(self, index: int, text: str) -> None:
        """
        https://doc.qt.io/qt-6/qtabbar.html#setTabWhatsThis

        **void QTabBar::setTabWhatsThis(int index , const QString & text )**

        Sets the What's This help text of the tab at position **index** to
        **text**.

        **See also** **tabWhatsThis** ().
        """
        ...

    def setTabsClosable(self, closable: bool) -> None:
        """
        https://doc.qt.io/qt-6/qtabbar.html#tabsClosable-prop

        **tabsClosable : bool**

        This property holds whether or not a tab bar should place close buttons
        on each tab

        When tabsClosable is set to true a close button will appear on the tab
        on either the left or right hand side depending upon the style. When the
        button is clicked the tab the signal **tabCloseRequested**  will be
        emitted.

        By default the value is false.

        **Access functions:**

        bool **tabsClosable** () const
        void **setTabsClosable** (bool
        **closable** )

        **See also** **setTabButton** () and **tabRemoved** ().
        """
        ...

    def setUsesScrollButtons(self, useButtons: bool) -> None:
        """
        https://doc.qt.io/qt-6/qtabbar.html#usesScrollButtons-prop

        **usesScrollButtons : bool**

        This property holds whether or not a tab bar should use buttons to
        scroll tabs when it has many tabs.

        When there are too many tabs in a tab bar for its size, the tab bar can
        either choose to expand its size or to add buttons that allow you to
        scroll through the tabs.

        By default the value is style-dependent.

        **Access functions:**

        bool **usesScrollButtons** () const
        void **setUsesScrollButtons**
        (bool **useButtons** )

        **See also** **elideMode** , **QTabWidget::usesScrollButtons** , and
        **QStyle::SH_TabBar_PreferNoArrows** .

        **Member Function Documentation**
        """
        ...

    def shape(self) -> PySide6.QtWidgets.QTabBar.Shape:
        """
        https://doc.qt.io/qt-6/qtabbar.html#shape-prop

        **shape : Shape**

        This property holds the shape of the tabs in the tab bar

        Possible values for this property are described by the Shape enum.

        **Access functions:**

        QTabBar::Shape **shape** () const
        void **setShape** (QTabBar::Shape
        **shape** )
        """
        ...

    def showEvent(self, arg__1: PySide6.QtGui.QShowEvent) -> None:
        """
        https://doc.qt.io/qt-6/qtabbar.html#showEvent

        **[override virtual protected] void QTabBar::showEvent(QShowEvent *)**

        Reimplements: **QWidget::showEvent** (QShowEvent *event).
        """
        ...

    def sizeHint(self) -> PySide6.QtCore.QSize:
        """
        https://doc.qt.io/qt-6/qtabbar.html#sizeHint

        **[override virtual] QSize QTabBar::sizeHint() const**

        Reimplements an access function for property: **QWidget::sizeHint** .
        """
        ...

    def tabAt(self, pos: PySide6.QtCore.QPoint) -> int:
        """
        https://doc.qt.io/qt-6/qtabbar.html#tabAt

        **int QTabBar::tabAt(const QPoint & position ) const**

        Returns the index of the tab that covers **position** or -1 if no tab
        covers **position** ;
        """
        ...

    def tabButton(
        self, index: int, position: PySide6.QtWidgets.QTabBar.ButtonPosition
    ) -> PySide6.QtWidgets.QWidget:
        """
        https://doc.qt.io/qt-6/qtabbar.html#tabButton

        **QWidget *QTabBar::tabButton(int index , QTabBar::ButtonPosition
        position ) const**

        Returns the widget set a tab **index** and **position** or `nullptr` if
        one is not set.

        **See also** **setTabButton** ().
        """
        ...

    def tabData(self, index: int) -> Any:
        """
        https://doc.qt.io/qt-6/qtabbar.html#tabData

        **QVariant QTabBar::tabData(int index ) const**

        Returns the data of the tab at position **index** , or a null variant if
        **index** is out of range.

        **See also** **setTabData** ().
        """
        ...

    def tabIcon(self, index: int) -> PySide6.QtGui.QIcon:
        """
        https://doc.qt.io/qt-6/qtabbar.html#tabIcon

        **QIcon QTabBar::tabIcon(int index ) const**

        Returns the icon of the tab at position **index** , or a null icon if
        **index** is out of range.

        **See also** **setTabIcon** ().
        """
        ...

    def tabInserted(self, index: int) -> None:
        """
        https://doc.qt.io/qt-6/qtabbar.html#tabInserted

        **[virtual protected] void QTabBar::tabInserted(int index )**

        This virtual handler is called after a new tab was added or inserted at
        position **index**.

        **See also** **tabRemoved** ().
        """
        ...

    def tabLayoutChange(self) -> None:
        """
        https://doc.qt.io/qt-6/qtabbar.html#tabLayoutChange

        **[virtual protected] void QTabBar::tabLayoutChange()**

        This virtual handler is called whenever the tab layout changes.

        **See also** **tabRect** ().
        """
        ...

    def tabRect(self, index: int) -> PySide6.QtCore.QRect:
        """
        https://doc.qt.io/qt-6/qtabbar.html#tabRect

        **QRect QTabBar::tabRect(int index ) const**

        Returns the visual rectangle of the tab at position **index** , or a
        null rectangle if **index** is hidden, or out of range.
        """
        ...

    def tabRemoved(self, index: int) -> None:
        """
        https://doc.qt.io/qt-6/qtabbar.html#tabRemoved

        **[virtual protected] void QTabBar::tabRemoved(int index )**

        This virtual handler is called after a tab was removed from position
        **index**.

        **See also** **tabInserted** ().
        """
        ...

    def tabSizeHint(self, index: int) -> PySide6.QtCore.QSize:
        """
        https://doc.qt.io/qt-6/qtabbar.html#tabSizeHint

        **[virtual protected] QSize QTabBar::tabSizeHint(int index ) const**

        Returns the size hint for the tab at position **index**.
        """
        ...

    def tabText(self, index: int) -> str:
        """
        https://doc.qt.io/qt-6/qtabbar.html#tabText

        **QString QTabBar::tabText(int index ) const**

        Returns the text of the tab at position **index** , or an empty string
        if **index** is out of range.

        **See also** **setTabText** ().
        """
        ...

    def tabTextColor(self, index: int) -> PySide6.QtGui.QColor:
        """
        https://doc.qt.io/qt-6/qtabbar.html#tabTextColor

        **QColor QTabBar::tabTextColor(int index ) const**

        Returns the text color of the tab with the given **index** , or a
        invalid color if **index** is out of range.

        **See also** **setTabTextColor** ().
        """
        ...

    def tabToolTip(self, index: int) -> str:
        """
        https://doc.qt.io/qt-6/qtabbar.html#tabToolTip

        **QString QTabBar::tabToolTip(int index ) const**

        Returns the tool tip of the tab at position **index** , or an empty
        string if **index** is out of range.

        **See also** **setTabToolTip** ().
        """
        ...

    def tabWhatsThis(self, index: int) -> str:
        """
        https://doc.qt.io/qt-6/qtabbar.html#tabWhatsThis

        **QString QTabBar::tabWhatsThis(int index ) const**

        Returns the What's This help text of the tab at position **index** , or
        an empty string if **index** is out of range.

        **See also** **setTabWhatsThis** ().
        """
        ...

    def tabsClosable(self) -> bool:
        """
        https://doc.qt.io/qt-6/qtabbar.html#tabsClosable-prop

        **tabsClosable : bool**

        This property holds whether or not a tab bar should place close buttons
        on each tab

        When tabsClosable is set to true a close button will appear on the tab
        on either the left or right hand side depending upon the style. When the
        button is clicked the tab the signal **tabCloseRequested**  will be
        emitted.

        By default the value is false.

        **Access functions:**

        bool **tabsClosable** () const
        void **setTabsClosable** (bool
        **closable** )

        **See also** **setTabButton** () and **tabRemoved** ().
        """
        ...

    def timerEvent(self, event: PySide6.QtCore.QTimerEvent) -> None:
        """
        https://doc.qt.io/qt-6/qtabbar.html#timerEvent

        **[override virtual protected] void QTabBar::timerEvent(QTimerEvent *
        event )**

        Reimplements: **QObject::timerEvent** (QTimerEvent *event).
        """
        ...

    def usesScrollButtons(self) -> bool:
        """
        https://doc.qt.io/qt-6/qtabbar.html#usesScrollButtons-prop

        **usesScrollButtons : bool**

        This property holds whether or not a tab bar should use buttons to
        scroll tabs when it has many tabs.

        When there are too many tabs in a tab bar for its size, the tab bar can
        either choose to expand its size or to add buttons that allow you to
        scroll through the tabs.

        By default the value is style-dependent.

        **Access functions:**

        bool **usesScrollButtons** () const
        void **setUsesScrollButtons**
        (bool **useButtons** )

        **See also** **elideMode** , **QTabWidget::usesScrollButtons** , and
        **QStyle::SH_TabBar_PreferNoArrows** .

        **Member Function Documentation**
        """
        ...

    def wheelEvent(self, event: PySide6.QtGui.QWheelEvent) -> None:
        """
        https://doc.qt.io/qt-6/qtabbar.html#wheelEvent

        **[override virtual protected] void QTabBar::wheelEvent(QWheelEvent *
        event )**

        Reimplements: **QWidget::wheelEvent** (QWheelEvent *event).
        """
        ...

    @property
    def currentChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qtabbar.html#currentChanged

        **[signal] void QTabBar::currentChanged(int index )**

        This signal is emitted when the tab bar's current tab changes. The new
        current has the given **index** , or -1 if there isn't a new one (for
        example, if there are no tab in the **QTabBar** )

        **Note:** Notifier signal for property **currentIndex** .
        """
        ...

    @property
    def tabBarClicked(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qtabbar.html#tabBarClicked

        **[signal, since 5.2] void QTabBar::tabBarClicked(int index )**

        This signal is emitted when user clicks on a tab at an **index**.

        **index** is the index of a clicked tab, or -1 if no tab is under the
        cursor.

        This function was introduced in Qt 5.2.
        """
        ...

    @property
    def tabBarDoubleClicked(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qtabbar.html#tabBarDoubleClicked

        **[signal, since 5.2] void QTabBar::tabBarDoubleClicked(int index )**

        This signal is emitted when the user double clicks on a tab at
        **index**.

        **index** refers to the tab clicked, or -1 if no tab is under the
        cursor.

        This function was introduced in Qt 5.2.
        """
        ...

    @property
    def tabCloseRequested(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qtabbar.html#tabCloseRequested

        **[signal] void QTabBar::tabCloseRequested(int index )**

        This signal is emitted when the close button on a tab is clicked. The
        **index** is the index that should be removed.

        **See also** **setTabsClosable** ().
        """
        ...

    @property
    def tabMoved(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qtabbar.html#tabMoved

        **[signal] void QTabBar::tabMoved(int from , int to )**

        This signal is emitted when the tab has moved the tab at index position
        **from** to index position **to**.

        note: **QTabWidget**  will automatically move the page when this signal
        is emitted from its tab bar.

        **See also** **moveTab** ().
        """
        ...
