"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtWidgets, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import Optional
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets

bytes = str


class QSwipeGesture(PySide6.QtWidgets.QGesture):
    """
    https://doc.qt.io/qt-6/qswipegesture.html

    **Detailed Description**

    ![](images/swipegesture.png)

    For an overview of gesture handling in Qt and information on using gestures
    in your applications, see the **Gestures in Widgets and Graphics View**
    document.

    **See also** **QPanGesture**  and **QPinchGesture** .
    """

    NoDirection: QSwipeGesture.SwipeDirection = ...
    Left: QSwipeGesture.SwipeDirection = ...
    Right: QSwipeGesture.SwipeDirection = ...
    Up: QSwipeGesture.SwipeDirection = ...
    Down: QSwipeGesture.SwipeDirection = ...

    class SwipeDirection(Enum):
        NoDirection: QSwipeGesture.SwipeDirection = ...
        Left: QSwipeGesture.SwipeDirection = ...
        Right: QSwipeGesture.SwipeDirection = ...
        Up: QSwipeGesture.SwipeDirection = ...
        Down: QSwipeGesture.SwipeDirection = ...

    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None:
        ...

    def horizontalDirection(self) -> PySide6.QtWidgets.QSwipeGesture.SwipeDirection:
        """
        https://doc.qt.io/qt-6/qswipegesture.html#horizontalDirection-prop

        **[read-only] horizontalDirection : const SwipeDirection**

        This property holds the horizontal direction of the gesture

        If the gesture has a horizontal component, the horizontal direction is
        either Left or Right; otherwise, it is **NoDirection** .

        **Access functions:**

        QSwipeGesture::SwipeDirection **horizontalDirection** () const

        **See also** **verticalDirection**  and **swipeAngle** .
        """
        ...

    def setSwipeAngle(self, value: float) -> None:
        """
        https://doc.qt.io/qt-6/qswipegesture.html#swipeAngle-prop

        **swipeAngle : qreal**

        This property holds the angle of the motion associated with the gesture

        If the gesture has either a horizontal or vertical component, the swipe
        angle describes the angle between the direction of motion and the x-axis
        as defined using the standard widget **coordinate system** .

        **Access functions:**

        qreal **swipeAngle** () const
        void **setSwipeAngle** (qreal **value**
        )

        **See also** **horizontalDirection**  and **verticalDirection** .
        """
        ...

    def swipeAngle(self) -> float:
        """
        https://doc.qt.io/qt-6/qswipegesture.html#swipeAngle-prop

        **swipeAngle : qreal**

        This property holds the angle of the motion associated with the gesture

        If the gesture has either a horizontal or vertical component, the swipe
        angle describes the angle between the direction of motion and the x-axis
        as defined using the standard widget **coordinate system** .

        **Access functions:**

        qreal **swipeAngle** () const
        void **setSwipeAngle** (qreal **value**
        )

        **See also** **horizontalDirection**  and **verticalDirection** .
        """
        ...

    def verticalDirection(self) -> PySide6.QtWidgets.QSwipeGesture.SwipeDirection:
        """
        https://doc.qt.io/qt-6/qswipegesture.html#verticalDirection-prop

        **[read-only] verticalDirection : const SwipeDirection**

        This property holds the vertical direction of the gesture

        If the gesture has a vertical component, the vertical direction is
        either Up or Down; otherwise, it is **NoDirection** .

        **Access functions:**

        QSwipeGesture::SwipeDirection **verticalDirection** () const

        **See also** **horizontalDirection**  and **swipeAngle** .

        **Member Function Documentation**
        """
        ...
