"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtWidgets, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import overload
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets

bytes = str


class QStyleOptionToolBar(PySide6.QtWidgets.QStyleOption):
    """
    https://doc.qt.io/qt-6/qstyleoptiontoolbar.html

    **Detailed Description**

    QStyleOptionToolBar contains all the information that **QStyle**  functions
    need to draw **QToolBar** .

    The QStyleOptionToolBar class holds the **lineWidth**  and the
    **midLineWidth**  for drawing the widget. It also stores information about
    which **area**  the toolbar should be located in, whether it is movable or
    not, which position the toolbar line should have (**positionOfLine** ), and
    the toolbar's position within the line (**positionWithinLine** ).

    In addition, the class provides a couple of enums: The **ToolBarFeature**
    enum is used to describe whether a toolbar is movable or not, and the
    **ToolBarPosition**  enum is used to describe the position of a toolbar
    line, as well as the toolbar's position within the line.

    For performance reasons, there are few member functions and the access to
    the member variables is direct (i.e., using the `.` or `->` operator). This
    makes the structures straightforward to use and emphasizes that these are
    simply parameters used by the style functions.

    For an example demonstrating how style options can be used, see the
    **Styles**  example.

    **See also** **QStyleOption** .
    """

    Type: QStyleOptionToolBar.StyleOptionType = ...
    Version: QStyleOptionToolBar.StyleOptionVersion = ...
    None_: QStyleOptionToolBar.ToolBarFeature = ...
    Movable: QStyleOptionToolBar.ToolBarFeature = ...
    Beginning: QStyleOptionToolBar.ToolBarPosition = ...
    Middle: QStyleOptionToolBar.ToolBarPosition = ...
    End: QStyleOptionToolBar.ToolBarPosition = ...
    OnlyOne: QStyleOptionToolBar.ToolBarPosition = ...

    class StyleOptionType(Enum):
        Type: QStyleOptionToolBar.StyleOptionType = ...

    class StyleOptionVersion(Enum):
        Version: QStyleOptionToolBar.StyleOptionVersion = ...

    class ToolBarFeature(Enum):
        None_: QStyleOptionToolBar.ToolBarFeature = ...
        Movable: QStyleOptionToolBar.ToolBarFeature = ...

    class ToolBarFeatures(object):
        ...

    class ToolBarPosition(Enum):
        Beginning: QStyleOptionToolBar.ToolBarPosition = ...
        Middle: QStyleOptionToolBar.ToolBarPosition = ...
        End: QStyleOptionToolBar.ToolBarPosition = ...
        OnlyOne: QStyleOptionToolBar.ToolBarPosition = ...

    @overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qstyleoptiontoolbar.html#QStyleOptionToolBar

        **QStyleOptionToolBar::QStyleOptionToolBar()**

        Constructs a QStyleOptionToolBar, initializing the members variables to
        their default values.
        """
        ...

    @overload
    def __init__(self, other: PySide6.QtWidgets.QStyleOptionToolBar) -> None:
        """
        https://doc.qt.io/qt-6/qstyleoptiontoolbar.html#QStyleOptionToolBar-1

        **QStyleOptionToolBar::QStyleOptionToolBar(const QStyleOptionToolBar &
        other )**

        Constructs a copy of the **other** style option.
        """
        ...

    @overload
    def __init__(self, version: int) -> None:
        """
        https://doc.qt.io/qt-6/qstyleoptiontoolbar.html#QStyleOptionToolBar

        **QStyleOptionToolBar::QStyleOptionToolBar()**

        Constructs a QStyleOptionToolBar, initializing the members variables to
        their default values.
        """
        ...
