"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtWidgets, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import overload
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets

bytes = str


class QStyleOptionTab(PySide6.QtWidgets.QStyleOption):
    """
    https://doc.qt.io/qt-6/qstyleoptiontab.html

    **Detailed Description**

    The QStyleOptionTab class is used for drawing several built-in Qt widgets
    including **QTabBar**  and the panel for **QTabWidget** .

    An instance of the QStyleOptionTab class has **type**  **SO_Tab**  and
    **version**  3\\. The type is used internally by **QStyleOption** , its
    subclasses, and **qstyleoption_cast** () to determine the type of style
    option. In general you do not need to worry about this unless you want to
    create your own **QStyleOption**  subclass and your own styles. The version
    is used by **QStyleOption**  subclasses to implement extensions without
    breaking compatibility. If you use **qstyleoption_cast** (), you normally do
    not need to check it.

    For performance reasons, there are few member functions and the access to
    the member variables is direct (i.e., using the `.` or `->` operator). This
    makes the structures straightforward to use and emphasizes that these are
    simply parameters used by the style functions.

    For an example demonstrating how style options can be used, see the
    **Styles**  example.

    **See also** **QStyleOption** .
    """

    NoCornerWidgets: QStyleOptionTab.CornerWidget = ...
    LeftCornerWidget: QStyleOptionTab.CornerWidget = ...
    RightCornerWidget: QStyleOptionTab.CornerWidget = ...
    NotAdjacent: QStyleOptionTab.SelectedPosition = ...
    NextIsSelected: QStyleOptionTab.SelectedPosition = ...
    PreviousIsSelected: QStyleOptionTab.SelectedPosition = ...
    Type: QStyleOptionTab.StyleOptionType = ...
    Version: QStyleOptionTab.StyleOptionVersion = ...
    None_: QStyleOptionTab.TabFeature = ...
    HasFrame: QStyleOptionTab.TabFeature = ...
    Beginning: QStyleOptionTab.TabPosition = ...
    Middle: QStyleOptionTab.TabPosition = ...
    End: QStyleOptionTab.TabPosition = ...
    OnlyOneTab: QStyleOptionTab.TabPosition = ...

    class CornerWidget(Enum):
        NoCornerWidgets: QStyleOptionTab.CornerWidget = ...
        LeftCornerWidget: QStyleOptionTab.CornerWidget = ...
        RightCornerWidget: QStyleOptionTab.CornerWidget = ...

    class CornerWidgets(object):
        ...

    class SelectedPosition(Enum):
        NotAdjacent: QStyleOptionTab.SelectedPosition = ...
        NextIsSelected: QStyleOptionTab.SelectedPosition = ...
        PreviousIsSelected: QStyleOptionTab.SelectedPosition = ...

    class StyleOptionType(Enum):
        Type: QStyleOptionTab.StyleOptionType = ...

    class StyleOptionVersion(Enum):
        Version: QStyleOptionTab.StyleOptionVersion = ...

    class TabFeature(Enum):
        None_: QStyleOptionTab.TabFeature = ...
        HasFrame: QStyleOptionTab.TabFeature = ...

    class TabFeatures(object):
        ...

    class TabPosition(Enum):
        Beginning: QStyleOptionTab.TabPosition = ...
        Middle: QStyleOptionTab.TabPosition = ...
        End: QStyleOptionTab.TabPosition = ...
        OnlyOneTab: QStyleOptionTab.TabPosition = ...

    @overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qstyleoptiontab.html#QStyleOptionTab

        **QStyleOptionTab::QStyleOptionTab()**

        Constructs a QStyleOptionTab object, initializing the members variables
        to their default values.
        """
        ...

    @overload
    def __init__(self, other: PySide6.QtWidgets.QStyleOptionTab) -> None:
        """
        https://doc.qt.io/qt-6/qstyleoptiontab.html#QStyleOptionTab-1

        **QStyleOptionTab::QStyleOptionTab(const QStyleOptionTab & other )**

        Constructs a copy of the **other** style option.
        """
        ...

    @overload
    def __init__(self, version: int) -> None:
        """
        https://doc.qt.io/qt-6/qstyleoptiontab.html#QStyleOptionTab

        **QStyleOptionTab::QStyleOptionTab()**

        Constructs a QStyleOptionTab object, initializing the members variables
        to their default values.
        """
        ...
