"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtWidgets, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import overload
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets

bytes = str


class QStyleOptionMenuItem(PySide6.QtWidgets.QStyleOption):
    """
    https://doc.qt.io/qt-6/qstyleoptionmenuitem.html

    **Detailed Description**

    QStyleOptionMenuItem contains all the information that **QStyle**  functions
    need to draw the menu items from **QMenu** . It is also used for drawing
    other menu-related widgets.

    For performance reasons, there are few member functions and the access to
    the member variables is direct (i.e., using the `.` or `->` operator). This
    makes the structures straightforward to use and emphasizes that these are
    simply parameters used by the style functions.

    For an example demonstrating how style options can be used, see the
    **Styles**  example.

    **See also** **QStyleOption** .
    """

    NotCheckable: QStyleOptionMenuItem.CheckType = ...
    Exclusive: QStyleOptionMenuItem.CheckType = ...
    NonExclusive: QStyleOptionMenuItem.CheckType = ...
    Normal: QStyleOptionMenuItem.MenuItemType = ...
    DefaultItem: QStyleOptionMenuItem.MenuItemType = ...
    Separator: QStyleOptionMenuItem.MenuItemType = ...
    SubMenu: QStyleOptionMenuItem.MenuItemType = ...
    Scroller: QStyleOptionMenuItem.MenuItemType = ...
    TearOff: QStyleOptionMenuItem.MenuItemType = ...
    Margin: QStyleOptionMenuItem.MenuItemType = ...
    EmptyArea: QStyleOptionMenuItem.MenuItemType = ...
    Type: QStyleOptionMenuItem.StyleOptionType = ...
    Version: QStyleOptionMenuItem.StyleOptionVersion = ...

    class CheckType(Enum):
        NotCheckable: QStyleOptionMenuItem.CheckType = ...
        Exclusive: QStyleOptionMenuItem.CheckType = ...
        NonExclusive: QStyleOptionMenuItem.CheckType = ...

    class MenuItemType(Enum):
        Normal: QStyleOptionMenuItem.MenuItemType = ...
        DefaultItem: QStyleOptionMenuItem.MenuItemType = ...
        Separator: QStyleOptionMenuItem.MenuItemType = ...
        SubMenu: QStyleOptionMenuItem.MenuItemType = ...
        Scroller: QStyleOptionMenuItem.MenuItemType = ...
        TearOff: QStyleOptionMenuItem.MenuItemType = ...
        Margin: QStyleOptionMenuItem.MenuItemType = ...
        EmptyArea: QStyleOptionMenuItem.MenuItemType = ...

    class StyleOptionType(Enum):
        Type: QStyleOptionMenuItem.StyleOptionType = ...

    class StyleOptionVersion(Enum):
        Version: QStyleOptionMenuItem.StyleOptionVersion = ...

    @overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qstyleoptionmenuitem.html#QStyleOptionMenuItem

        **QStyleOptionMenuItem::QStyleOptionMenuItem()**

        Constructs a QStyleOptionMenuItem, initializing the members variables to
        their default values.
        """
        ...

    @overload
    def __init__(self, other: PySide6.QtWidgets.QStyleOptionMenuItem) -> None:
        """
        https://doc.qt.io/qt-6/qstyleoptionmenuitem.html#QStyleOptionMenuItem-1

        **QStyleOptionMenuItem::QStyleOptionMenuItem(const QStyleOptionMenuItem
        & other )**

        Constructs a copy of the **other** style option.
        """
        ...

    @overload
    def __init__(self, version: int) -> None:
        """
        https://doc.qt.io/qt-6/qstyleoptionmenuitem.html#QStyleOptionMenuItem

        **QStyleOptionMenuItem::QStyleOptionMenuItem()**

        Constructs a QStyleOptionMenuItem, initializing the members variables to
        their default values.
        """
        ...
