"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtWidgets, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import overload
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets

bytes = str


class QStyleOptionHeader(PySide6.QtWidgets.QStyleOption):
    """
    https://doc.qt.io/qt-6/qstyleoptionheader.html

    **Detailed Description**

    QStyleOptionHeader contains all the information that **QStyle**  functions
    need to draw the item views' header pane, header sort arrow, and header
    label.

    For performance reasons, there are few member functions and the access to
    the member variables is direct (i.e., using the `.` or `->` operator). This
    makes the structures straightforward to use and emphasizes that these are
    simply parameters used by the style functions.

    For an example demonstrating how style options can be used, see the
    **Styles**  example.

    **See also** **QStyleOption** .
    """

    Beginning: QStyleOptionHeader.SectionPosition = ...
    Middle: QStyleOptionHeader.SectionPosition = ...
    End: QStyleOptionHeader.SectionPosition = ...
    OnlyOneSection: QStyleOptionHeader.SectionPosition = ...
    NotAdjacent: QStyleOptionHeader.SelectedPosition = ...
    NextIsSelected: QStyleOptionHeader.SelectedPosition = ...
    PreviousIsSelected: QStyleOptionHeader.SelectedPosition = ...
    NextAndPreviousAreSelected: QStyleOptionHeader.SelectedPosition = ...
    None_: QStyleOptionHeader.SortIndicator = ...
    SortUp: QStyleOptionHeader.SortIndicator = ...
    SortDown: QStyleOptionHeader.SortIndicator = ...
    Type: QStyleOptionHeader.StyleOptionType = ...
    Version: QStyleOptionHeader.StyleOptionVersion = ...

    class SectionPosition(Enum):
        Beginning: QStyleOptionHeader.SectionPosition = ...
        Middle: QStyleOptionHeader.SectionPosition = ...
        End: QStyleOptionHeader.SectionPosition = ...
        OnlyOneSection: QStyleOptionHeader.SectionPosition = ...

    class SelectedPosition(Enum):
        NotAdjacent: QStyleOptionHeader.SelectedPosition = ...
        NextIsSelected: QStyleOptionHeader.SelectedPosition = ...
        PreviousIsSelected: QStyleOptionHeader.SelectedPosition = ...
        NextAndPreviousAreSelected: QStyleOptionHeader.SelectedPosition = ...

    class SortIndicator(Enum):
        None_: QStyleOptionHeader.SortIndicator = ...
        SortUp: QStyleOptionHeader.SortIndicator = ...
        SortDown: QStyleOptionHeader.SortIndicator = ...

    class StyleOptionType(Enum):
        Type: QStyleOptionHeader.StyleOptionType = ...

    class StyleOptionVersion(Enum):
        Version: QStyleOptionHeader.StyleOptionVersion = ...

    @overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qstyleoptionheader.html#QStyleOptionHeader

        **QStyleOptionHeader::QStyleOptionHeader()**

        Constructs a QStyleOptionHeader, initializing the members variables to
        their default values.
        """
        ...

    @overload
    def __init__(self, other: PySide6.QtWidgets.QStyleOptionHeader) -> None:
        """
        https://doc.qt.io/qt-6/qstyleoptionheader.html#QStyleOptionHeader-1

        **QStyleOptionHeader::QStyleOptionHeader(const QStyleOptionHeader &
        other )**

        Constructs a copy of the **other** style option.
        """
        ...

    @overload
    def __init__(self, version: int) -> None:
        """
        https://doc.qt.io/qt-6/qstyleoptionheader.html#QStyleOptionHeader

        **QStyleOptionHeader::QStyleOptionHeader()**

        Constructs a QStyleOptionHeader, initializing the members variables to
        their default values.
        """
        ...
