"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtWidgets, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import overload
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets

bytes = str


class QStyleOptionFrame(PySide6.QtWidgets.QStyleOption):
    """
    https://doc.qt.io/qt-6/qstyleoptionframe.html

    **Detailed Description**

    QStyleOptionFrame is used for drawing several built-in Qt widgets, including
    **QFrame** , **QGroupBox** , **QLineEdit** , and **QMenu** .

    For performance reasons, there are few member functions and the access to
    the member variables is direct (i.e., using the `.` or `->` operator). This
    makes the structures straightforward to use and emphasizes that these are
    simply parameters used by the style functions.

    An instance of the QStyleOptionFrame class has **type**  SO_Frame and
    **version**  3.

    The type is used internally by **QStyleOption** , its subclasses, and
    **qstyleoption_cast** () to determine the type of style option. In general
    you do not need to worry about this unless you want to create your own
    **QStyleOption**  subclass and your own styles. The version is used by
    **QStyleOption**  subclasses to implement extensions without breaking
    compatibility. If you use **qstyleoption_cast** (), you normally do not need
    to check it.

    For an example demonstrating how style options can be used, see the
    **Styles**  example.

    **See also** **QStyleOption** .
    """

    None_: QStyleOptionFrame.FrameFeature = ...
    Flat: QStyleOptionFrame.FrameFeature = ...
    Rounded: QStyleOptionFrame.FrameFeature = ...
    Type: QStyleOptionFrame.StyleOptionType = ...
    Version: QStyleOptionFrame.StyleOptionVersion = ...

    class FrameFeature(Enum):
        None_: QStyleOptionFrame.FrameFeature = ...
        Flat: QStyleOptionFrame.FrameFeature = ...
        Rounded: QStyleOptionFrame.FrameFeature = ...

    class FrameFeatures(object):
        ...

    class StyleOptionType(Enum):
        Type: QStyleOptionFrame.StyleOptionType = ...

    class StyleOptionVersion(Enum):
        Version: QStyleOptionFrame.StyleOptionVersion = ...

    @overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qstyleoptionframe.html#QStyleOptionFrame

        **QStyleOptionFrame::QStyleOptionFrame()**

        Constructs a QStyleOptionFrame, initializing the members variables to
        their default values.
        """
        ...

    @overload
    def __init__(self, other: PySide6.QtWidgets.QStyleOptionFrame) -> None:
        """
        https://doc.qt.io/qt-6/qstyleoptionframe.html#QStyleOptionFrame-1

        **QStyleOptionFrame::QStyleOptionFrame(const QStyleOptionFrame & other
        )**

        Constructs a copy of the **other** style option.
        """
        ...

    @overload
    def __init__(self, version: int) -> None:
        """
        https://doc.qt.io/qt-6/qstyleoptionframe.html#QStyleOptionFrame

        **QStyleOptionFrame::QStyleOptionFrame()**

        Constructs a QStyleOptionFrame, initializing the members variables to
        their default values.
        """
        ...
