"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtWidgets, except for defaults which are replaced by "...".
"""
from typing import Optional, Union, overload
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets

bytes = str


class QMenuBar(PySide6.QtWidgets.QWidget):
    """
    https://doc.qt.io/qt-6/qmenubar.html

    **Detailed Description**

    A menu bar consists of a list of pull-down menu items. You add menu items
    with **addMenu** (). For example, assuming that `menubar` is a pointer to a
    QMenuBar and `fileMenu` is a pointer to a **QMenu** , the following
    statement inserts the menu into the menu bar:

    menubar->addMenu(fileMenu);

    The ampersand in the menu item's text sets Alt+F as a shortcut for this
    menu. (You can use "&&" to get a real ampersand in the menu bar.)

    There is no need to lay out a menu bar. It automatically sets its own
    geometry to the top of the parent widget and changes it appropriately
    whenever the parent is resized.

    **Usage**

    In most main window style applications you would use the **menuBar** ()
    function provided in **QMainWindow** , adding **QMenu** s to the menu bar
    and adding **QAction** s to the pop-up menus.

    Example (from the **Menus**  example):

    fileMenu = menuBar()->addMenu(tr("&File"));
    fileMenu->addAction(newAct);

    Menu items may be removed with **removeAction** ().

    Widgets can be added to menus by using instances of the **QWidgetAction**
    class to hold them. These actions can then be inserted into menus in the
    usual way; see the **QMenu**  documentation for more details.

    **Platform Dependent Look and Feel**

    Different platforms have different requirements for the appearance of menu
    bars and their behavior when the user interacts with them. For example,
    Windows systems are often configured so that the underlined character
    mnemonics that indicate keyboard shortcuts for items in the menu bar are
    only shown when the **Alt** key is pressed.

    **QMenuBar as a Global Menu Bar**

    On macOS and on certain Linux desktop environments such as Ubuntu Unity,
    QMenuBar is a wrapper for using the system-wide menu bar. If you have
    multiple menu bars in one dialog the outermost menu bar (normally inside a
    widget with widget flag **Qt::Window** ) will be used for the system-wide
    menu bar.

    Qt for macOS also provides a menu bar merging feature to make QMenuBar
    conform more closely to accepted macOS menu bar layout. The merging
    functionality is based on string matching the title of a **QMenu**  entry.
    These strings are translated (using **QObject::tr** ()) in the "QMenuBar"
    context. If an entry is moved its slots will still fire as if it was in the
    original place. The table below outlines the strings looked for and where
    the entry is placed if matched:

    String matchesPlacementNotes
    about.*Application Menu | About <application
    name>The application name is fetched from the `Info.plist` file (see note
    below). If this entry is not found no About item will appear in the
    Application Menu.
    config, options, setup, settings or
    preferencesApplication Menu | PreferencesIf this entry is not found the
    Settings item will be disabled
    quit or exitApplication Menu | Quit
    <application name>If this entry is not found a default Quit item will be
    created to call **QCoreApplication::quit** ()

    You can override this behavior by using the **QAction::menuRole** ()
    property.

    If you want all windows in a Mac application to share one menu bar, you must
    create a menu bar that does not have a parent. Create a parent-less menu bar
    this way:

    **QMenuBar**  *menuBar = new **QMenuBar** (nullptr);

    **Note:** Do **not** call **QMainWindow::menuBar** () to create the shared
    menu bar, because that menu bar will have the **QMainWindow**  as its
    parent. That menu bar would only be displayed for the parent **QMainWindow**
    .

    **Note:** The text used for the application name in the macOS menu bar is
    obtained from the value set in the `Info.plist` file in the application's
    bundle. See **Qt for macOS - Deployment**  for more information.

    **Note:** On Linux, if the com.canonical.AppMenu.Registrar service is
    available on the D-Bus session bus, then Qt will communicate with it to
    install the application's menus into the global menu bar, as described.

    **Examples**

    The **Menus**  example shows how to use QMenuBar and **QMenu** . The other
    **main window application examples**  also provide menus using these
    classes.

    **See also** **QMenu** , **QShortcut** , **QAction** , **Introduction to
    Apple Human Interface Guidelines** , **GUI Design Handbook: Menu Bar** , and
    **Menus Example** .
    """

    def __init__(self, parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qmenubar.html#QMenuBar

        **QMenuBar::QMenuBar(QWidget * parent = nullptr)**

        Constructs a menu bar with parent **parent**.
        """
        ...

    def actionAt(self, arg__1: PySide6.QtCore.QPoint) -> PySide6.QtGui.QAction:
        """
        https://doc.qt.io/qt-6/qmenubar.html#actionAt

        **QAction *QMenuBar::actionAt(const QPoint & pt ) const**

        Returns the **QAction**  at **pt**. Returns `nullptr` if there is no
        action at **pt** or if the location has a separator.

        **See also** **addAction** () and **addSeparator** ().
        """
        ...

    def actionEvent(self, arg__1: PySide6.QtGui.QActionEvent) -> None:
        """
        https://doc.qt.io/qt-6/qmenubar.html#actionEvent

        **[override virtual protected] void QMenuBar::actionEvent(QActionEvent *
        e )**

        Reimplements: **QWidget::actionEvent** (QActionEvent *event).
        """
        ...

    def actionGeometry(self, arg__1: PySide6.QtGui.QAction) -> PySide6.QtCore.QRect:
        """
        https://doc.qt.io/qt-6/qmenubar.html#actionGeometry

        **QRect QMenuBar::actionGeometry(QAction * act ) const**

        Returns the geometry of action **act** as a **QRect** .

        **See also** **actionAt** ().
        """
        ...

    def activeAction(self) -> PySide6.QtGui.QAction:
        """
        https://doc.qt.io/qt-6/qmenubar.html#activeAction

        **QAction *QMenuBar::activeAction() const**

        Returns the **QAction**  that is currently highlighted, if any, else
        `nullptr`.

        **See also** **setActiveAction** ().
        """
        ...

    @overload
    def addAction(self, arg__1: PySide6.QtGui.QAction) -> None:
        """
        https://doc.qt.io/qt-6/qmenubar.html#addAction

        **QAction *QMenuBar::addAction(const QString & text )**

        This convenience function creates a new action with **text**. The
        function adds the newly created action to the menu's list of actions,
        and returns it.

        **See also** **QWidget::addAction** () and **QWidget::actions** ().
        """
        ...

    @overload
    def addAction(self, arg__1: str, arg__2: object) -> None:
        """
        https://doc.qt.io/qt-6/qmenubar.html#addAction-1

        **QAction *QMenuBar::addAction(const QString & text , const QObject *
        receiver , const char * member )**

        This is an overloaded function.

        This convenience function creates a new action with the given **text**.
        The action's **triggered** () signal is connected to the **receiver** 's
        **member** slot. The function adds the newly created action to the
        menu's list of actions and returns it.

        **See also** **QWidget::addAction** () and **QWidget::actions** ().
        """
        ...

    @overload
    def addAction(self, text: str) -> PySide6.QtGui.QAction:
        """
        https://doc.qt.io/qt-6/qmenubar.html#addAction-2

        **[since 5.11] template <typename Obj, typename
        PointerToMemberFunctionOrFunctor> QAction *QMenuBar::addAction(const
        QString & text , const Obj * receiver , PointerToMemberFunctionOrFunctor
        method )**

        This is an overloaded function.

        This convenience function creates a new action with the given **text**.
        The action's **triggered** () signal is connected to the **method** of
        the **receiver**. The function adds the newly created action to the
        menu's list of actions and returns it.

        **QMenuBar**  takes ownership of the returned **QAction** .

        This function was introduced in Qt 5.11.

        **See also** **QWidget::addAction** () and **QWidget::actions** ().
        """
        ...

    @overload
    def addAction(
        self, text: str, receiver: PySide6.QtCore.QObject, member: bytes
    ) -> PySide6.QtGui.QAction:
        """
        https://doc.qt.io/qt-6/qmenubar.html#addAction-3

        **[since 5.11] template <typename Functor> QAction
        *QMenuBar::addAction(const QString & text , Functor functor )**

        This is an overloaded function.

        This convenience function creates a new action with the given **text**.
        The action's **triggered** () signal is connected to the **functor**.
        The function adds the newly created action to the menu's list of actions
        and returns it.

        **QMenuBar**  takes ownership of the returned **QAction** .

        This function was introduced in Qt 5.11.

        **See also** **QWidget::addAction** () and **QWidget::actions** ().
        """
        ...

    @overload
    def addMenu(
        self, icon: Union[PySide6.QtGui.QIcon, PySide6.QtGui.QPixmap], title: str
    ) -> PySide6.QtWidgets.QMenu:
        """
        https://doc.qt.io/qt-6/qmenubar.html#addMenu

        **QAction *QMenuBar::addMenu(QMenu * menu )**

        Appends **menu** to the menu bar. Returns the menu's menuAction(). The
        menu bar does not take ownership of the menu.

        **Note:** The returned **QAction**  object can be used to hide the
        corresponding menu.

        **See also** **QWidget::addAction** () and **QMenu::menuAction** ().
        """
        ...

    @overload
    def addMenu(self, menu: PySide6.QtWidgets.QMenu) -> PySide6.QtGui.QAction:
        """
        https://doc.qt.io/qt-6/qmenubar.html#addMenu-1

        **QMenu *QMenuBar::addMenu(const QString & title )**

        Appends a new **QMenu**  with **title** to the menu bar. The menu bar
        takes ownership of the menu. Returns the new menu.

        **See also** **QWidget::addAction** () and **QMenu::menuAction** ().
        """
        ...

    @overload
    def addMenu(self, title: str) -> PySide6.QtWidgets.QMenu:
        """
        https://doc.qt.io/qt-6/qmenubar.html#addMenu-2

        **QMenu *QMenuBar::addMenu(const QIcon & icon , const QString & title
        )**

        Appends a new **QMenu**  with **icon** and **title** to the menu bar.
        The menu bar takes ownership of the menu. Returns the new menu.

        **See also** **QWidget::addAction** () and **QMenu::menuAction** ().
        """
        ...

    def addSeparator(self) -> PySide6.QtGui.QAction:
        """
        https://doc.qt.io/qt-6/qmenubar.html#addSeparator

        **QAction *QMenuBar::addSeparator()**

        Appends a separator to the menu.
        """
        ...

    def changeEvent(self, arg__1: PySide6.QtCore.QEvent) -> None:
        """
        https://doc.qt.io/qt-6/qmenubar.html#changeEvent

        **[override virtual protected] void QMenuBar::changeEvent(QEvent * e )**

        Reimplements: **QWidget::changeEvent** (QEvent *event).
        """
        ...

    def clear(self) -> None:
        """
        https://doc.qt.io/qt-6/qmenubar.html#clear

        **void QMenuBar::clear()**

        Removes all the actions from the menu bar.

        **Note:** On macOS, menu items that have been merged to the system menu
        bar are not removed by this function. One way to handle this would be to
        remove the extra actions yourself. You can set the **menu role**  on the
        different menus, so that you know ahead of time which menu items get
        merged and which do not. Then decide what to recreate or remove
        yourself.

        **See also** **removeAction** ().
        """
        ...

    def cornerWidget(
        self, corner: PySide6.QtCore.Qt.Corner = ...
    ) -> PySide6.QtWidgets.QWidget:
        """
        https://doc.qt.io/qt-6/qmenubar.html#cornerWidget

        **QWidget *QMenuBar::cornerWidget(Qt::Corner corner =
        Qt::TopRightCorner) const**

        Returns the widget on the left of the first or on the right of the last
        menu item, depending on **corner**.

        **Note:** Using a corner other than **Qt::TopRightCorner**  or
        **Qt::TopLeftCorner**  will result in a warning.

        **See also** **setCornerWidget** ().
        """
        ...

    def event(self, arg__1: PySide6.QtCore.QEvent) -> bool:
        """
        https://doc.qt.io/qt-6/qmenubar.html#event

        **[override virtual protected] bool QMenuBar::event(QEvent * e )**

        Reimplements: **QWidget::event** (QEvent *event).
        """
        ...

    def eventFilter(
        self, arg__1: PySide6.QtCore.QObject, arg__2: PySide6.QtCore.QEvent
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qmenubar.html#eventFilter

        **[override virtual protected] bool QMenuBar::eventFilter(QObject *
        object , QEvent * event )**

        Reimplements: **QObject::eventFilter** (QObject *watched, QEvent
        *event).
        """
        ...

    def focusInEvent(self, arg__1: PySide6.QtGui.QFocusEvent) -> None:
        """
        https://doc.qt.io/qt-6/qmenubar.html#focusInEvent

        **[override virtual protected] void QMenuBar::focusInEvent(QFocusEvent
        *)**

        Reimplements: **QWidget::focusInEvent** (QFocusEvent *event).
        """
        ...

    def focusOutEvent(self, arg__1: PySide6.QtGui.QFocusEvent) -> None:
        """
        https://doc.qt.io/qt-6/qmenubar.html#focusOutEvent

        **[override virtual protected] void QMenuBar::focusOutEvent(QFocusEvent
        *)**

        Reimplements: **QWidget::focusOutEvent** (QFocusEvent *event).
        """
        ...

    def heightForWidth(self, arg__1: int) -> int:
        """
        https://doc.qt.io/qt-6/qmenubar.html#heightForWidth

        **[override virtual] int QMenuBar::heightForWidth(int) const**

        Reimplements: **QWidget::heightForWidth(int w) const** .
        """
        ...

    def initStyleOption(
        self,
        option: PySide6.QtWidgets.QStyleOptionMenuItem,
        action: PySide6.QtGui.QAction,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qmenubar.html#initStyleOption

        **[virtual protected] void
        QMenuBar::initStyleOption(QStyleOptionMenuItem * option , const QAction
        * action ) const**

        Initialize **option** with the values from the menu bar and information
        from **action**. This method is useful for subclasses when they need a
        **QStyleOptionMenuItem** , but don't want to fill in all the information
        themselves.

        **See also** **QStyleOption::initFrom** () and
        **QMenu::initStyleOption** ().
        """
        ...

    def insertMenu(
        self, before: PySide6.QtGui.QAction, menu: PySide6.QtWidgets.QMenu
    ) -> PySide6.QtGui.QAction:
        """
        https://doc.qt.io/qt-6/qmenubar.html#insertMenu

        **QAction *QMenuBar::insertMenu(QAction * before , QMenu * menu )**

        This convenience function inserts **menu** before action **before** and
        returns the menus menuAction().

        **See also** **QWidget::insertAction** () and **addMenu** ().
        """
        ...

    def insertSeparator(self, before: PySide6.QtGui.QAction) -> PySide6.QtGui.QAction:
        """
        https://doc.qt.io/qt-6/qmenubar.html#insertSeparator

        **QAction *QMenuBar::insertSeparator(QAction * before )**

        This convenience function creates a new separator action, i.e. an action
        with **QAction::isSeparator** () returning true. The function inserts
        the newly created action into this menu bar's list of actions before
        action **before** and returns it.

        **See also** **QWidget::insertAction** () and **addSeparator** ().
        """
        ...

    def isDefaultUp(self) -> bool:
        ...

    def isNativeMenuBar(self) -> bool:
        ...

    def keyPressEvent(self, arg__1: PySide6.QtGui.QKeyEvent) -> None:
        """
        https://doc.qt.io/qt-6/qmenubar.html#keyPressEvent

        **[override virtual protected] void QMenuBar::keyPressEvent(QKeyEvent *
        e )**

        Reimplements: **QWidget::keyPressEvent** (QKeyEvent *event).
        """
        ...

    def leaveEvent(self, arg__1: PySide6.QtCore.QEvent) -> None:
        """
        https://doc.qt.io/qt-6/qmenubar.html#leaveEvent

        **[override virtual protected] void QMenuBar::leaveEvent(QEvent *)**

        Reimplements: **QWidget::leaveEvent** (QEvent *event).
        """
        ...

    def minimumSizeHint(self) -> PySide6.QtCore.QSize:
        """
        https://doc.qt.io/qt-6/qmenubar.html#minimumSizeHint

        **[override virtual] QSize QMenuBar::minimumSizeHint() const**

        Reimplements an access function for property:
        **QWidget::minimumSizeHint** .
        """
        ...

    def mouseMoveEvent(self, arg__1: PySide6.QtGui.QMouseEvent) -> None:
        """
        https://doc.qt.io/qt-6/qmenubar.html#mouseMoveEvent

        **[override virtual protected] void QMenuBar::mouseMoveEvent(QMouseEvent
        * e )**

        Reimplements: **QWidget::mouseMoveEvent** (QMouseEvent *event).
        """
        ...

    def mousePressEvent(self, arg__1: PySide6.QtGui.QMouseEvent) -> None:
        """
        https://doc.qt.io/qt-6/qmenubar.html#mousePressEvent

        **[override virtual protected] void
        QMenuBar::mousePressEvent(QMouseEvent * e )**

        Reimplements: **QWidget::mousePressEvent** (QMouseEvent *event).
        """
        ...

    def mouseReleaseEvent(self, arg__1: PySide6.QtGui.QMouseEvent) -> None:
        """
        https://doc.qt.io/qt-6/qmenubar.html#mouseReleaseEvent

        **[override virtual protected] void
        QMenuBar::mouseReleaseEvent(QMouseEvent * e )**

        Reimplements: **QWidget::mouseReleaseEvent** (QMouseEvent *event).
        """
        ...

    def paintEvent(self, arg__1: PySide6.QtGui.QPaintEvent) -> None:
        """
        https://doc.qt.io/qt-6/qmenubar.html#paintEvent

        **[override virtual protected] void QMenuBar::paintEvent(QPaintEvent * e
        )**

        Reimplements: **QWidget::paintEvent** (QPaintEvent *event).
        """
        ...

    def resizeEvent(self, arg__1: PySide6.QtGui.QResizeEvent) -> None:
        """
        https://doc.qt.io/qt-6/qmenubar.html#resizeEvent

        **[override virtual protected] void QMenuBar::resizeEvent(QResizeEvent
        *)**

        Reimplements: **QWidget::resizeEvent** (QResizeEvent *event).
        """
        ...

    def setActiveAction(self, action: PySide6.QtGui.QAction) -> None:
        """
        https://doc.qt.io/qt-6/qmenubar.html#setActiveAction

        **void QMenuBar::setActiveAction(QAction * act )**

        Sets the currently highlighted action to **act**.

        **See also** **activeAction** ().
        """
        ...

    def setCornerWidget(
        self, w: PySide6.QtWidgets.QWidget, corner: PySide6.QtCore.Qt.Corner = ...
    ) -> None:
        """
        https://doc.qt.io/qt-6/qmenubar.html#setCornerWidget

        **void QMenuBar::setCornerWidget(QWidget * widget , Qt::Corner corner =
        Qt::TopRightCorner)**

        This sets the given **widget** to be shown directly on the left of the
        first menu item, or on the right of the last menu item, depending on
        **corner**.

        The menu bar takes ownership of **widget** , reparenting it into the
        menu bar. However, if the **corner** already contains a widget, this
        previous widget will no longer be managed and will still be a visible
        child of the menu bar.

        **Note:** Using a corner other than **Qt::TopRightCorner**  or
        **Qt::TopLeftCorner**  will result in a warning.

        **See also** **cornerWidget** ().
        """
        ...

    def setDefaultUp(self, arg__1: bool) -> None:
        """
        https://doc.qt.io/qt-6/qmenubar.html#defaultUp-prop

        **defaultUp : bool**

        This property holds the popup orientation

        The default popup orientation. By default, menus pop "down" the screen.
        By setting the property to true, the menu will pop "up". You might call
        this for menus that are **below** the document to which they refer.

        If the menu would not fit on the screen, the other direction is used
        automatically.

        **Access functions:**

        bool **isDefaultUp** () const
        void **setDefaultUp** (bool)
        """
        ...

    def setNativeMenuBar(self, nativeMenuBar: bool) -> None:
        """
        https://doc.qt.io/qt-6/qmenubar.html#nativeMenuBar-prop

        **nativeMenuBar : bool**

        This property holds whether or not a menubar will be used as a native
        menubar on platforms that support it

        This property specifies whether or not the menubar should be used as a
        native menubar on platforms that support it. The currently supported
        platforms are macOS, and Linux desktops which use the
        com.canonical.dbusmenu D-Bus interface (such as Ubuntu Unity). If this
        property is `true`, the menubar is used in the native menubar and is not
        in the window of its parent; if `false` the menubar remains in the
        window. On other platforms, setting this attribute has no effect, and
        reading this attribute will always return `false`.

        The default is to follow whether the **Qt::AA_DontUseNativeMenuBar**
        attribute is set for the application. Explicitly setting this property
        overrides the presence (or absence) of the attribute.

        **Access functions:**

        bool **isNativeMenuBar** () const
        void **setNativeMenuBar** (bool
        **nativeMenuBar** )

        **Member Function Documentation**
        """
        ...

    def setVisible(self, visible: bool) -> None:
        """
        https://doc.qt.io/qt-6/qmenubar.html#setVisible

        **[override virtual slot] void QMenuBar::setVisible(bool visible )**

        Reimplements an access function for property: **QWidget::visible** .
        """
        ...

    def sizeHint(self) -> PySide6.QtCore.QSize:
        """
        https://doc.qt.io/qt-6/qmenubar.html#sizeHint

        **[override virtual] QSize QMenuBar::sizeHint() const**

        Reimplements an access function for property: **QWidget::sizeHint** .
        """
        ...

    def timerEvent(self, arg__1: PySide6.QtCore.QTimerEvent) -> None:
        """
        https://doc.qt.io/qt-6/qmenubar.html#timerEvent

        **[override virtual protected] void QMenuBar::timerEvent(QTimerEvent * e
        )**

        Reimplements: **QObject::timerEvent** (QTimerEvent *event).
        """
        ...

    @property
    def hovered(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qmenubar.html#hovered

        **[signal] void QMenuBar::hovered(QAction * action )**

        This signal is emitted when a menu action is highlighted; **action** is
        the action that caused the event to be sent.

        Often this is used to update status information.

        **See also** **triggered** () and **QAction::hovered** ().
        """
        ...

    @property
    def triggered(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qmenubar.html#triggered

        **[signal] void QMenuBar::triggered(QAction * action )**

        This signal is emitted when an action in a menu belonging to this
        menubar is triggered as a result of a mouse click; **action** is the
        action that caused the signal to be emitted.

        **Note:****QMenuBar**  has to have ownership of the **QMenu**  in order
        this signal to work.

        Normally, you connect each menu action to a single slot using
        **QAction::triggered** (), but sometimes you will want to connect
        several items to a single slot (most often if the user selects from an
        array). This signal is useful in such cases.

        **See also** **hovered** () and **QAction::triggered** ().
        """
        ...
