"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtWidgets, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import List, Optional, Sequence, Union, overload
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets

bytes = str


class QMainWindow(PySide6.QtWidgets.QWidget):
    """
    https://doc.qt.io/qt-6/qmainwindow.html

    **Detailed Description**

    **Qt Main Window Framework**

    A main window provides a framework for building an application's user
    interface. Qt has QMainWindow and its **related classes**  for main window
    management. QMainWindow has its own layout to which you can add **QToolBar**
    s, **QDockWidget** s, a **QMenuBar** , and a **QStatusBar** . The layout has
    a center area that can be occupied by any kind of widget. You can see an
    image of the layout below.

    ![](images/mainwindowlayout.png)

    **Note:** Creating a main window without a central widget is not supported.
    You must have a central widget even if it is just a placeholder.

    **Creating Main Window Components**

    A central widget will typically be a standard Qt widget such as a
    **QTextEdit**  or a **QGraphicsView** . Custom widgets can also be used for
    advanced applications. You set the central widget with `setCentralWidget()`.

    Main windows have either a single (SDI) or multiple (MDI) document
    interface. You create MDI applications in Qt by using a **QMdiArea**  as the
    central widget.

    We will now examine each of the other widgets that can be added to a main
    window. We give examples on how to create and add them.

    **Creating Menus**

    Qt implements menus in **QMenu**  and QMainWindow keeps them in a
    **QMenuBar** . **QAction** s are added to the menus, which display them as
    menu items.

    You can add new menus to the main window's menu bar by calling `menuBar()`,
    which returns the **QMenuBar**  for the window, and then add a menu with
    **QMenuBar::addMenu** ().

    QMainWindow comes with a default menu bar, but you can also set one yourself
    with `setMenuBar()`. If you wish to implement a custom menu bar (i.e., not
    use the **QMenuBar**  widget), you can set it with `setMenuWidget()`.

    An example of how to create menus follows:

    void MainWindow::createMenus()
            {
                fileMenu =
    menuBar()->addMenu(tr("&File"));
                fileMenu->addAction(newAct);
    fileMenu->addAction(openAct);
                fileMenu->addAction(saveAct);

    The `createPopupMenu()` function creates popup menus when the main window
    receives context menu events. The default implementation generates a menu
    with the checkable actions from the dock widgets and toolbars. You can
    reimplement `createPopupMenu()` for a custom menu.

    **Creating Toolbars**

    Toolbars are implemented in the **QToolBar**  class. You add a toolbar to a
    main window with `addToolBar()`.

    You control the initial position of toolbars by assigning them to a specific
    **Qt::ToolBarArea** . You can split an area by inserting a toolbar break -
    think of this as a line break in text editing - with `addToolBarBreak()` or
    `insertToolBarBreak()`. You can also restrict placement by the user with
    **QToolBar::setAllowedAreas** () and **QToolBar::setMovable** ().

    The size of toolbar icons can be retrieved with `iconSize()`. The sizes are
    platform dependent; you can set a fixed size with `setIconSize()`. You can
    alter the appearance of all tool buttons in the toolbars with
    `setToolButtonStyle()`.

    An example of toolbar creation follows:

    void MainWindow::createToolBars()
            {
                fileToolBar =
    addToolBar(tr("File"));
                fileToolBar->addAction(newAct);

    **Creating Dock Widgets**

    Dock widgets are implemented in the **QDockWidget**  class. A dock widget is
    a window that can be docked into the main window. You add dock widgets to a
    main window with `addDockWidget()`.

    There are four dock widget areas as given by the **Qt::DockWidgetArea**
    enum: left, right, top, and bottom. You can specify which dock widget area
    that should occupy the corners where the areas overlap with `setCorner()`.
    By default each area can only contain one row (vertical or horizontal) of
    dock widgets, but if you enable nesting with `setDockNestingEnabled()`, dock
    widgets can be added in either direction.

    Two dock widgets may also be stacked on top of each other. A **QTabBar**  is
    then used to select which of the widgets should be displayed.

    We give an example of how to create and add dock widgets to a main window:

    **QDockWidget**  *dockWidget = new **QDockWidget** (tr("Dock Widget"),
    this);
            dockWidget->setAllowedAreas(Qt::LeftDockWidgetArea |
    Qt::RightDockWidgetArea);
            dockWidget->setWidget(dockWidgetContents);
    addDockWidget(Qt::LeftDockWidgetArea, dockWidget);

    **The Status Bar**

    You can set a status bar with `setStatusBar()`, but one is created the first
    time `statusBar()` (which returns the main window's status bar) is called.
    See **QStatusBar**  for information on how to use it.

    **Storing State**

    QMainWindow can store the state of its layout with `saveState()`; it can
    later be retrieved with `restoreState()`. It is the position and size
    (relative to the size of the main window) of the toolbars and dock widgets
    that are stored.

    **See also** **QMenuBar** , **QToolBar** , **QStatusBar** , **QDockWidget**
    , **Qt Widgets - Application Example** , **Dock Widgets Example** , **MDI
    Example** , **SDI Example** , and **Menus Example** .
    """

    AnimatedDocks: QMainWindow.DockOption = ...
    AllowNestedDocks: QMainWindow.DockOption = ...
    AllowTabbedDocks: QMainWindow.DockOption = ...
    ForceTabbedDocks: QMainWindow.DockOption = ...
    VerticalTabs: QMainWindow.DockOption = ...
    GroupedDragging: QMainWindow.DockOption = ...

    class DockOption(Enum):
        AnimatedDocks: QMainWindow.DockOption = ...
        AllowNestedDocks: QMainWindow.DockOption = ...
        AllowTabbedDocks: QMainWindow.DockOption = ...
        ForceTabbedDocks: QMainWindow.DockOption = ...
        VerticalTabs: QMainWindow.DockOption = ...
        GroupedDragging: QMainWindow.DockOption = ...

    class DockOptions(object):
        ...

    def __init__(
        self,
        parent: Optional[PySide6.QtWidgets.QWidget] = ...,
        flags: PySide6.QtCore.Qt.WindowFlags = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qmainwindow.html#QMainWindow

        **QMainWindow::QMainWindow(QWidget * parent = nullptr, Qt::WindowFlags
        flags = Qt::WindowFlags())**

        Constructs a QMainWindow with the given **parent** and the specified
        widget **flags**.

        QMainWindow sets the **Qt::Window**  flag itself, and will hence always
        be created as a top-level widget.
        """
        ...

    @overload
    def addDockWidget(
        self,
        area: PySide6.QtCore.Qt.DockWidgetArea,
        dockwidget: PySide6.QtWidgets.QDockWidget,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qmainwindow.html#addDockWidget

        **void QMainWindow::addDockWidget(Qt::DockWidgetArea area , QDockWidget
        * dockwidget )**

        Adds the given **dockwidget** to the specified **area**.
        """
        ...

    @overload
    def addDockWidget(
        self,
        area: PySide6.QtCore.Qt.DockWidgetArea,
        dockwidget: PySide6.QtWidgets.QDockWidget,
        orientation: PySide6.QtCore.Qt.Orientation,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qmainwindow.html#addDockWidget-1

        **void QMainWindow::addDockWidget(Qt::DockWidgetArea area , QDockWidget
        * dockwidget , Qt::Orientation orientation )**

        Adds **dockwidget** into the given **area** in the direction specified
        by the **orientation**.
        """
        ...

    @overload
    def addToolBar(
        self, area: PySide6.QtCore.Qt.ToolBarArea, toolbar: PySide6.QtWidgets.QToolBar
    ) -> None:
        """
        https://doc.qt.io/qt-6/qmainwindow.html#addToolBar

        **void QMainWindow::addToolBar(Qt::ToolBarArea area , QToolBar * toolbar
        )**

        Adds the **toolbar** into the specified **area** in this main window.
        The **toolbar** is placed at the end of the current tool bar block (i.e.
        line). If the main window already manages **toolbar** then it will only
        move the toolbar to **area**.

        **See also** **insertToolBar** (), **addToolBarBreak** (), and
        **insertToolBarBreak** ().
        """
        ...

    @overload
    def addToolBar(self, title: str) -> PySide6.QtWidgets.QToolBar:
        """
        https://doc.qt.io/qt-6/qmainwindow.html#addToolBar-1

        **void QMainWindow::addToolBar(QToolBar * toolbar )**

        This is an overloaded function.

        Equivalent of calling addToolBar(**Qt::TopToolBarArea** , **toolbar** )
        """
        ...

    @overload
    def addToolBar(self, toolbar: PySide6.QtWidgets.QToolBar) -> None:
        """
        https://doc.qt.io/qt-6/qmainwindow.html#addToolBar-2

        **QToolBar *QMainWindow::addToolBar(const QString & title )**

        This is an overloaded function.

        Creates a **QToolBar**  object, setting its window title to **title** ,
        and inserts it into the top toolbar area.

        **See also** **setWindowTitle** ().
        """
        ...

    def addToolBarBreak(self, area: PySide6.QtCore.Qt.ToolBarArea = ...) -> None:
        """
        https://doc.qt.io/qt-6/qmainwindow.html#addToolBarBreak

        **void QMainWindow::addToolBarBreak(Qt::ToolBarArea area =
        Qt::TopToolBarArea)**

        Adds a toolbar break to the given **area** after all the other objects
        that are present.
        """
        ...

    def centralWidget(self) -> PySide6.QtWidgets.QWidget:
        """
        https://doc.qt.io/qt-6/qmainwindow.html#centralWidget

        **QWidget *QMainWindow::centralWidget() const**

        Returns the central widget for the main window. This function returns
        zero if the central widget has not been set.

        **See also** **setCentralWidget** ().
        """
        ...

    def contextMenuEvent(self, event: PySide6.QtGui.QContextMenuEvent) -> None:
        """
        https://doc.qt.io/qt-6/qmainwindow.html#contextMenuEvent

        **[override virtual protected] void
        QMainWindow::contextMenuEvent(QContextMenuEvent * event )**

        Reimplements: **QWidget::contextMenuEvent** (QContextMenuEvent *event).
        """
        ...

    def corner(
        self, corner: PySide6.QtCore.Qt.Corner
    ) -> PySide6.QtCore.Qt.DockWidgetArea:
        """
        https://doc.qt.io/qt-6/qmainwindow.html#corner

        **Qt::DockWidgetArea QMainWindow::corner(Qt::Corner corner ) const**

        Returns the dock widget area that occupies the specified **corner**.

        **See also** **setCorner** ().
        """
        ...

    def createPopupMenu(self) -> PySide6.QtWidgets.QMenu:
        """
        https://doc.qt.io/qt-6/qmainwindow.html#createPopupMenu

        **[virtual] QMenu *QMainWindow::createPopupMenu()**

        Returns a popup menu containing checkable entries for the toolbars and
        dock widgets present in the main window. If there are no toolbars and
        dock widgets present, this function returns `nullptr`.

        By default, this function is called by the main window when the user
        activates a context menu, typically by right-clicking on a toolbar or a
        dock widget.

        If you want to create a custom popup menu, reimplement this function and
        return a newly-created popup menu. Ownership of the popup menu is
        transferred to the caller.

        **See also** **addDockWidget** (), **addToolBar** (), and **menuBar**
        ().
        """
        ...

    def dockOptions(self) -> PySide6.QtWidgets.QMainWindow.DockOptions:
        """
        https://doc.qt.io/qt-6/qmainwindow.html#dockOptions-prop

        **dockOptions : DockOptions**

        This property holds the docking behavior of **QMainWindow**

        The default value is **AnimatedDocks**  | **AllowTabbedDocks** .

        **Access functions:**

        QMainWindow::DockOptions **dockOptions** () const
        void
        **setDockOptions** (QMainWindow::DockOptions **options** )
        """
        ...

    def dockWidgetArea(
        self, dockwidget: PySide6.QtWidgets.QDockWidget
    ) -> PySide6.QtCore.Qt.DockWidgetArea:
        """
        https://doc.qt.io/qt-6/qmainwindow.html#dockWidgetArea

        **Qt::DockWidgetArea QMainWindow::dockWidgetArea(QDockWidget *
        dockwidget ) const**

        Returns the **Qt::DockWidgetArea**  for **dockwidget**. If
        **dockwidget** has not been added to the main window, this function
        returns `Qt::NoDockWidgetArea`.

        **See also** **addDockWidget** (), **splitDockWidget** (), and
        **Qt::DockWidgetArea** .
        """
        ...

    def documentMode(self) -> bool:
        """
        https://doc.qt.io/qt-6/qmainwindow.html#documentMode-prop

        **documentMode : bool**

        This property holds whether the tab bar for tabbed dockwidgets is set to
        document mode.

        The default is false.

        **Access functions:**

        bool **documentMode** () const
        void **setDocumentMode** (bool
        **enabled** )

        **See also** **QTabBar::documentMode** .
        """
        ...

    def event(self, event: PySide6.QtCore.QEvent) -> bool:
        """
        https://doc.qt.io/qt-6/qmainwindow.html#event

        **[override virtual protected] bool QMainWindow::event(QEvent * event
        )**

        Reimplements: **QWidget::event** (QEvent *event).
        """
        ...

    def iconSize(self) -> PySide6.QtCore.QSize:
        """
        https://doc.qt.io/qt-6/qmainwindow.html#iconSize-prop

        **iconSize : QSize**

        size of toolbar icons in this mainwindow.

        The default is the default tool bar icon size of the GUI style. Note
        that the icons used must be at least of this size as the icons are only
        scaled down.

        **Access functions:**

        QSize **iconSize** () const
        void **setIconSize** (const QSize &
        **iconSize** )
        """
        ...

    def insertToolBar(
        self, before: PySide6.QtWidgets.QToolBar, toolbar: PySide6.QtWidgets.QToolBar
    ) -> None:
        """
        https://doc.qt.io/qt-6/qmainwindow.html#insertToolBar

        **void QMainWindow::insertToolBar(QToolBar * before , QToolBar * toolbar
        )**

        Inserts the **toolbar** into the area occupied by the **before** toolbar
        so that it appears before it. For example, in normal left-to-right
        layout operation, this means that **toolbar** will appear to the left of
        the toolbar specified by **before** in a horizontal toolbar area.

        **See also** **insertToolBarBreak** (), **addToolBar** (), and
        **addToolBarBreak** ().
        """
        ...

    def insertToolBarBreak(self, before: PySide6.QtWidgets.QToolBar) -> None:
        """
        https://doc.qt.io/qt-6/qmainwindow.html#insertToolBarBreak

        **void QMainWindow::insertToolBarBreak(QToolBar * before )**

        Inserts a toolbar break before the toolbar specified by **before**.
        """
        ...

    def isAnimated(self) -> bool:
        ...

    def isDockNestingEnabled(self) -> bool:
        ...

    def isSeparator(self, pos: PySide6.QtCore.QPoint) -> bool:
        ...

    def menuBar(self) -> PySide6.QtWidgets.QMenuBar:
        """
        https://doc.qt.io/qt-6/qmainwindow.html#menuBar

        **QMenuBar *QMainWindow::menuBar() const**

        Returns the menu bar for the main window. This function creates and
        returns an empty menu bar if the menu bar does not exist.

        If you want all windows in a Mac application to share one menu bar,
        don't use this function to create it, because the menu bar created here
        will have this **QMainWindow**  as its parent. Instead, you must create
        a menu bar that does not have a parent, which you can then share among
        all the Mac windows. Create a parent-less menu bar this way:

        **QMenuBar**  *menuBar = new **QMenuBar** (nullptr);

        **See also** **setMenuBar** ().
        """
        ...

    def menuWidget(self) -> PySide6.QtWidgets.QWidget:
        """
        https://doc.qt.io/qt-6/qmainwindow.html#menuWidget

        **QWidget *QMainWindow::menuWidget() const**

        Returns the menu bar for the main window. This function returns null if
        a menu bar hasn't been constructed yet.

        **See also** **setMenuWidget** ().
        """
        ...

    def removeDockWidget(self, dockwidget: PySide6.QtWidgets.QDockWidget) -> None:
        """
        https://doc.qt.io/qt-6/qmainwindow.html#removeDockWidget

        **void QMainWindow::removeDockWidget(QDockWidget * dockwidget )**

        Removes the **dockwidget** from the main window layout and hides it.
        Note that the **dockwidget** is **not** deleted.
        """
        ...

    def removeToolBar(self, toolbar: PySide6.QtWidgets.QToolBar) -> None:
        """
        https://doc.qt.io/qt-6/qmainwindow.html#removeToolBar

        **void QMainWindow::removeToolBar(QToolBar * toolbar )**

        Removes the **toolbar** from the main window layout and hides it. Note
        that the **toolbar** is **not** deleted.
        """
        ...

    def removeToolBarBreak(self, before: PySide6.QtWidgets.QToolBar) -> None:
        """
        https://doc.qt.io/qt-6/qmainwindow.html#removeToolBarBreak

        **void QMainWindow::removeToolBarBreak(QToolBar * before )**

        Removes a toolbar break previously inserted before the toolbar specified
        by **before**.
        """
        ...

    def resizeDocks(
        self,
        docks: Sequence[PySide6.QtWidgets.QDockWidget],
        sizes: Sequence[int],
        orientation: PySide6.QtCore.Qt.Orientation,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qmainwindow.html#resizeDocks

        **[since 5.6] void QMainWindow::resizeDocks(const QList<QDockWidget *> &
        docks , const QList<int> & sizes , Qt::Orientation orientation )**

        Resizes the dock widgets in the list **docks** to the corresponding size
        in pixels from the list **sizes**. If **orientation** is
        **Qt::Horizontal** , adjusts the width, otherwise adjusts the height of
        the dock widgets. The sizes will be adjusted such that the maximum and
        the minimum sizes are respected and the **QMainWindow**  itself will not
        be resized. Any additional/missing space is distributed amongst the
        widgets according to the relative weight of the sizes.

        Example:

        resizeDocks({blueWidget, yellowWidget}, {20 , 40}, Qt::Horizontal);

        If the blue and the yellow widget are nested on the same level they will
        be resized such that the yellowWidget is twice as big as the blueWidget

        If some widgets are grouped in tabs, only one widget per group should be
        specified. Widgets not in the list might be changed to respect the
        constraints.

        This function was introduced in Qt 5.6.
        """
        ...

    def restoreDockWidget(self, dockwidget: PySide6.QtWidgets.QDockWidget) -> bool:
        """
        https://doc.qt.io/qt-6/qmainwindow.html#restoreDockWidget

        **bool QMainWindow::restoreDockWidget(QDockWidget * dockwidget )**

        Restores the state of **dockwidget** if it is created after the call to
        **restoreState** (). Returns `true` if the state was restored; otherwise
        returns `false`.

        **See also** **restoreState** () and **saveState** ().
        """
        ...

    def restoreState(
        self, state: Union[PySide6.QtCore.QByteArray, bytes], version: int = ...
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qmainwindow.html#restoreState

        **bool QMainWindow::restoreState(const QByteArray & state , int version
        = 0)**

        Restores the **state** of this mainwindow's toolbars and dockwidgets.
        Also restores the corner settings too. The **version** number is
        compared with that stored in **state**. If they do not match, the
        mainwindow's state is left unchanged, and this function returns `false`;
        otherwise, the state is restored, and this function returns `true`.

        To restore geometry saved using **QSettings** , you can use code like
        this:

        void MainWindow::readSettings()
            {
                **QSettings**
        settings("MyCompany", "MyApp");
        restoreGeometry(settings.value("myWidget/geometry").toByteArray());
        restoreState(settings.value("myWidget/windowState").toByteArray());
        }

        **See also** **saveState** (), **QWidget::saveGeometry** (),
        **QWidget::restoreGeometry** (), and **restoreDockWidget** ().
        """
        ...

    def saveState(self, version: int = ...) -> PySide6.QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qmainwindow.html#saveState

        **QByteArray QMainWindow::saveState(int version = 0) const**

        Saves the current state of this mainwindow's toolbars and dockwidgets.
        This includes the corner settings which can be set with **setCorner**
        (). The **version** number is stored as part of the data.

        The **objectName**  property is used to identify each **QToolBar**  and
        **QDockWidget** . You should make sure that this property is unique for
        each **QToolBar**  and **QDockWidget**  you add to the **QMainWindow**

        To restore the saved state, pass the return value and **version** number
        to **restoreState** ().

        To save the geometry when the window closes, you can implement a close
        event like this:

        void MyMainWindow::closeEvent(**QCloseEvent**  *event)
            {
        **QSettings**  settings("MyCompany", "MyApp");
        settings.setValue("geometry", saveGeometry());
        settings.setValue("windowState", saveState());
                **QMainWindow**
        ::closeEvent(event);
            }

        **See also** **restoreState** (), **QWidget::saveGeometry** (), and
        **QWidget::restoreGeometry** ().
        """
        ...

    def setAnimated(self, enabled: bool) -> None:
        """
        https://doc.qt.io/qt-6/qmainwindow.html#animated-prop

        **animated : bool**

        This property holds whether manipulating dock widgets and tool bars is
        animated

        When a dock widget or tool bar is dragged over the main window, the main
        window adjusts its contents to indicate where the dock widget or tool
        bar will be docked if it is dropped. Setting this property causes
        **QMainWindow**  to move its contents in a smooth animation. Clearing
        this property causes the contents to snap into their new positions.

        By default, this property is set. It may be cleared if the main window
        contains widgets which are slow at resizing or repainting themselves.

        Setting this property is identical to setting the **AnimatedDocks**
        option using **setDockOptions** ().

        **Access functions:**

        bool **isAnimated** () const
        void **setAnimated** (bool **enabled** )
        """
        ...

    def setCentralWidget(self, widget: PySide6.QtWidgets.QWidget) -> None:
        """
        https://doc.qt.io/qt-6/qmainwindow.html#setCentralWidget

        **void QMainWindow::setCentralWidget(QWidget * widget )**

        Sets the given **widget** to be the main window's central widget.

        Note: **QMainWindow**  takes ownership of the **widget** pointer and
        deletes it at the appropriate time.

        **See also** **centralWidget** ().
        """
        ...

    def setCorner(
        self, corner: PySide6.QtCore.Qt.Corner, area: PySide6.QtCore.Qt.DockWidgetArea
    ) -> None:
        """
        https://doc.qt.io/qt-6/qmainwindow.html#setCorner

        **void QMainWindow::setCorner(Qt::Corner corner , Qt::DockWidgetArea
        area )**

        Sets the given dock widget **area** to occupy the specified **corner**.

        **See also** **corner** ().
        """
        ...

    def setDockNestingEnabled(self, enabled: bool) -> None:
        """
        https://doc.qt.io/qt-6/qmainwindow.html#dockNestingEnabled-prop

        **dockNestingEnabled : bool**

        This property holds whether docks can be nested

        If this property is `false`, dock areas can only contain a single row
        (horizontal or vertical) of dock widgets. If this property is `true`,
        the area occupied by a dock widget can be split in either direction to
        contain more dock widgets.

        Dock nesting is only necessary in applications that contain a lot of
        dock widgets. It gives the user greater freedom in organizing their main
        window. However, dock nesting leads to more complex (and less intuitive)
        behavior when a dock widget is dragged over the main window, since there
        are more ways in which a dropped dock widget may be placed in the dock
        area.

        Setting this property is identical to setting the **AllowNestedDocks**
        option using **setDockOptions** ().

        **Access functions:**

        bool **isDockNestingEnabled** () const
        void **setDockNestingEnabled**
        (bool **enabled** )
        """
        ...

    def setDockOptions(
        self, options: PySide6.QtWidgets.QMainWindow.DockOptions
    ) -> None:
        """
        https://doc.qt.io/qt-6/qmainwindow.html#dockOptions-prop

        **dockOptions : DockOptions**

        This property holds the docking behavior of **QMainWindow**

        The default value is **AnimatedDocks**  | **AllowTabbedDocks** .

        **Access functions:**

        QMainWindow::DockOptions **dockOptions** () const
        void
        **setDockOptions** (QMainWindow::DockOptions **options** )
        """
        ...

    def setDocumentMode(self, enabled: bool) -> None:
        """
        https://doc.qt.io/qt-6/qmainwindow.html#documentMode-prop

        **documentMode : bool**

        This property holds whether the tab bar for tabbed dockwidgets is set to
        document mode.

        The default is false.

        **Access functions:**

        bool **documentMode** () const
        void **setDocumentMode** (bool
        **enabled** )

        **See also** **QTabBar::documentMode** .
        """
        ...

    def setIconSize(self, iconSize: PySide6.QtCore.QSize) -> None:
        """
        https://doc.qt.io/qt-6/qmainwindow.html#iconSize-prop

        **iconSize : QSize**

        size of toolbar icons in this mainwindow.

        The default is the default tool bar icon size of the GUI style. Note
        that the icons used must be at least of this size as the icons are only
        scaled down.

        **Access functions:**

        QSize **iconSize** () const
        void **setIconSize** (const QSize &
        **iconSize** )
        """
        ...

    def setMenuBar(self, menubar: PySide6.QtWidgets.QMenuBar) -> None:
        """
        https://doc.qt.io/qt-6/qmainwindow.html#setMenuBar

        **void QMainWindow::setMenuBar(QMenuBar * menuBar )**

        Sets the menu bar for the main window to **menuBar**.

        Note: **QMainWindow**  takes ownership of the **menuBar** pointer and
        deletes it at the appropriate time.

        **See also** **menuBar** ().
        """
        ...

    def setMenuWidget(self, menubar: PySide6.QtWidgets.QWidget) -> None:
        """
        https://doc.qt.io/qt-6/qmainwindow.html#setMenuWidget

        **void QMainWindow::setMenuWidget(QWidget * menuBar )**

        Sets the menu bar for the main window to **menuBar**.

        **QMainWindow**  takes ownership of the **menuBar** pointer and deletes
        it at the appropriate time.

        **See also** **menuWidget** ().
        """
        ...

    def setStatusBar(self, statusbar: PySide6.QtWidgets.QStatusBar) -> None:
        """
        https://doc.qt.io/qt-6/qmainwindow.html#setStatusBar

        **void QMainWindow::setStatusBar(QStatusBar * statusbar )**

        Sets the status bar for the main window to **statusbar**.

        Setting the status bar to `nullptr` will remove it from the main window.
        Note that **QMainWindow**  takes ownership of the **statusbar** pointer
        and deletes it at the appropriate time.

        **See also** **statusBar** ().
        """
        ...

    def setTabPosition(
        self,
        areas: PySide6.QtCore.Qt.DockWidgetAreas,
        tabPosition: PySide6.QtWidgets.QTabWidget.TabPosition,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qmainwindow.html#setTabPosition

        **void QMainWindow::setTabPosition(Qt::DockWidgetAreas areas ,
        QTabWidget::TabPosition tabPosition )**

        Sets the tab position for the given dock widget **areas** to the
        specified **tabPosition**. By default, all dock areas show their tabs at
        the bottom.

        **Note:** The **VerticalTabs**  dock option overrides the tab positions
        set by this method.

        **See also** **tabPosition** () and **setTabShape** ().
        """
        ...

    def setTabShape(self, tabShape: PySide6.QtWidgets.QTabWidget.TabShape) -> None:
        """
        https://doc.qt.io/qt-6/qmainwindow.html#tabShape-prop

        **tabShape : QTabWidget::TabShape**

        This property holds the tab shape used for tabbed dock widgets.

        The default is **QTabWidget::Rounded** .

        **Access functions:**

        QTabWidget::TabShape **tabShape** () const
        void **setTabShape**
        (QTabWidget::TabShape **tabShape** )

        **See also** **setTabPosition** ().
        """
        ...

    def setToolButtonStyle(
        self, toolButtonStyle: PySide6.QtCore.Qt.ToolButtonStyle
    ) -> None:
        """
        https://doc.qt.io/qt-6/qmainwindow.html#toolButtonStyle-prop

        **toolButtonStyle : Qt::ToolButtonStyle**

        style of toolbar buttons in this mainwindow.

        To have the style of toolbuttons follow the system settings, set this
        property to **Qt::ToolButtonFollowStyle** . On Unix, the user settings
        from the desktop environment will be used. On other platforms,
        **Qt::ToolButtonFollowStyle**  means icon only.

        The default is **Qt::ToolButtonIconOnly** .

        **Access functions:**

        Qt::ToolButtonStyle **toolButtonStyle** () const
        void
        **setToolButtonStyle** (Qt::ToolButtonStyle **toolButtonStyle** )
        """
        ...

    def setUnifiedTitleAndToolBarOnMac(self, set: bool) -> None:
        """
        https://doc.qt.io/qt-6/qmainwindow.html#unifiedTitleAndToolBarOnMac-prop

        **[since 5.2] unifiedTitleAndToolBarOnMac : bool**

        This property holds whether the window uses the unified title and
        toolbar look on macOS

        Note that the Qt 5 implementation has several limitations compared to Qt
        4:

        * Use in windows with OpenGL content is not supported. This includes
        QOpenGLWidget.
          * Using dockable or movable toolbars may result in
        painting errors and is not recommended

        This property was introduced in Qt 5.2.

        **Access functions:**

        bool **unifiedTitleAndToolBarOnMac** () const
        void
        **setUnifiedTitleAndToolBarOnMac** (bool **set** )

        **Member Function Documentation**
        """
        ...

    def splitDockWidget(
        self,
        after: PySide6.QtWidgets.QDockWidget,
        dockwidget: PySide6.QtWidgets.QDockWidget,
        orientation: PySide6.QtCore.Qt.Orientation,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qmainwindow.html#splitDockWidget

        **void QMainWindow::splitDockWidget(QDockWidget * first , QDockWidget *
        second , Qt::Orientation orientation )**

        Splits the space covered by the **first** dock widget into two parts,
        moves the **first** dock widget into the first part, and moves the
        **second** dock widget into the second part.

        The **orientation** specifies how the space is divided: A
        **Qt::Horizontal**  split places the second dock widget to the right of
        the first; a **Qt::Vertical**  split places the second dock widget below
        the first.

        **Note** : if **first** is currently in a tabbed docked area, **second**
        will be added as a new tab, not as a neighbor of **first**. This is
        because a single tab can contain only one dock widget.

        **Note** : The **Qt::LayoutDirection**  influences the order of the dock
        widgets in the two parts of the divided area. When right-to-left layout
        direction is enabled, the placing of the dock widgets will be reversed.

        **See also** **tabifyDockWidget** (), **addDockWidget** (), and
        **removeDockWidget** ().
        """
        ...

    def statusBar(self) -> PySide6.QtWidgets.QStatusBar:
        """
        https://doc.qt.io/qt-6/qmainwindow.html#statusBar

        **QStatusBar *QMainWindow::statusBar() const**

        Returns the status bar for the main window. This function creates and
        returns an empty status bar if the status bar does not exist.

        **See also** **setStatusBar** ().
        """
        ...

    def tabPosition(
        self, area: PySide6.QtCore.Qt.DockWidgetArea
    ) -> PySide6.QtWidgets.QTabWidget.TabPosition:
        """
        https://doc.qt.io/qt-6/qmainwindow.html#tabPosition

        **QTabWidget::TabPosition QMainWindow::tabPosition(Qt::DockWidgetArea
        area ) const**

        Returns the tab position for **area**.

        **Note:** The **VerticalTabs**  dock option overrides the tab positions
        returned by this function.

        **See also** **setTabPosition** () and **tabShape** ().
        """
        ...

    def tabShape(self) -> PySide6.QtWidgets.QTabWidget.TabShape:
        """
        https://doc.qt.io/qt-6/qmainwindow.html#tabShape-prop

        **tabShape : QTabWidget::TabShape**

        This property holds the tab shape used for tabbed dock widgets.

        The default is **QTabWidget::Rounded** .

        **Access functions:**

        QTabWidget::TabShape **tabShape** () const
        void **setTabShape**
        (QTabWidget::TabShape **tabShape** )

        **See also** **setTabPosition** ().
        """
        ...

    def tabifiedDockWidgets(
        self, dockwidget: PySide6.QtWidgets.QDockWidget
    ) -> List[PySide6.QtWidgets.QDockWidget]:
        """
        https://doc.qt.io/qt-6/qmainwindow.html#tabifiedDockWidgets

        **QList<QDockWidget *> QMainWindow::tabifiedDockWidgets(QDockWidget *
        dockwidget ) const**

        Returns the dock widgets that are tabified together with **dockwidget**.

        **See also** **tabifyDockWidget** ().
        """
        ...

    def tabifyDockWidget(
        self,
        first: PySide6.QtWidgets.QDockWidget,
        second: PySide6.QtWidgets.QDockWidget,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qmainwindow.html#tabifyDockWidget

        **void QMainWindow::tabifyDockWidget(QDockWidget * first , QDockWidget *
        second )**

        Moves **second** dock widget on top of **first** dock widget, creating a
        tabbed docked area in the main window.

        **See also** **tabifiedDockWidgets** ().
        """
        ...

    def takeCentralWidget(self) -> PySide6.QtWidgets.QWidget:
        """
        https://doc.qt.io/qt-6/qmainwindow.html#takeCentralWidget

        **[since 5.2] QWidget *QMainWindow::takeCentralWidget()**

        Removes the central widget from this main window.

        The ownership of the removed widget is passed to the caller.

        This function was introduced in Qt 5.2.
        """
        ...

    def toolBarArea(
        self, toolbar: PySide6.QtWidgets.QToolBar
    ) -> PySide6.QtCore.Qt.ToolBarArea:
        """
        https://doc.qt.io/qt-6/qmainwindow.html#toolBarArea

        **Qt::ToolBarArea QMainWindow::toolBarArea(const QToolBar * toolbar )
        const**

        Returns the **Qt::ToolBarArea**  for **toolbar**. If **toolbar** has not
        been added to the main window, this function returns
        `Qt::NoToolBarArea`.

        **See also** **addToolBar** (), **addToolBarBreak** (), and
        **Qt::ToolBarArea** .
        """
        ...

    def toolBarBreak(self, toolbar: PySide6.QtWidgets.QToolBar) -> bool:
        """
        https://doc.qt.io/qt-6/qmainwindow.html#toolBarBreak

        **bool QMainWindow::toolBarBreak(QToolBar * toolbar ) const**

        Returns whether there is a toolbar break before the **toolbar**.

        **See also** **addToolBarBreak** () and **insertToolBarBreak** ().
        """
        ...

    def toolButtonStyle(self) -> PySide6.QtCore.Qt.ToolButtonStyle:
        """
        https://doc.qt.io/qt-6/qmainwindow.html#toolButtonStyle-prop

        **toolButtonStyle : Qt::ToolButtonStyle**

        style of toolbar buttons in this mainwindow.

        To have the style of toolbuttons follow the system settings, set this
        property to **Qt::ToolButtonFollowStyle** . On Unix, the user settings
        from the desktop environment will be used. On other platforms,
        **Qt::ToolButtonFollowStyle**  means icon only.

        The default is **Qt::ToolButtonIconOnly** .

        **Access functions:**

        Qt::ToolButtonStyle **toolButtonStyle** () const
        void
        **setToolButtonStyle** (Qt::ToolButtonStyle **toolButtonStyle** )
        """
        ...

    def unifiedTitleAndToolBarOnMac(self) -> bool:
        """
        https://doc.qt.io/qt-6/qmainwindow.html#unifiedTitleAndToolBarOnMac-prop

        **[since 5.2] unifiedTitleAndToolBarOnMac : bool**

        This property holds whether the window uses the unified title and
        toolbar look on macOS

        Note that the Qt 5 implementation has several limitations compared to Qt
        4:

        * Use in windows with OpenGL content is not supported. This includes
        QOpenGLWidget.
          * Using dockable or movable toolbars may result in
        painting errors and is not recommended

        This property was introduced in Qt 5.2.

        **Access functions:**

        bool **unifiedTitleAndToolBarOnMac** () const
        void
        **setUnifiedTitleAndToolBarOnMac** (bool **set** )

        **Member Function Documentation**
        """
        ...

    @property
    def iconSizeChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qmainwindow.html#iconSizeChanged

        **[signal] void QMainWindow::iconSizeChanged(const QSize & iconSize )**

        This signal is emitted when the size of the icons used in the window is
        changed. The new icon size is passed in **iconSize**.

        You can connect this signal to other components to help maintain a
        consistent appearance for your application.

        **See also** **setIconSize** ().
        """
        ...

    @property
    def tabifiedDockWidgetActivated(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qmainwindow.html#tabifiedDockWidgetActivated

        **[signal, since 5.8] void
        QMainWindow::tabifiedDockWidgetActivated(QDockWidget * dockWidget )**

        This signal is emitted when the tabified dock widget is activated by
        selecting the tab. The activated dock widget is passed in
        **dockWidget**.

        This function was introduced in Qt 5.8.

        **See also** **tabifyDockWidget** () and **tabifiedDockWidgets** ().
        """
        ...

    @property
    def toolButtonStyleChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qmainwindow.html#toolButtonStyleChanged

        **[signal] void QMainWindow::toolButtonStyleChanged(Qt::ToolButtonStyle
        toolButtonStyle )**

        This signal is emitted when the style used for tool buttons in the
        window is changed. The new style is passed in **toolButtonStyle**.

        You can connect this signal to other components to help maintain a
        consistent appearance for your application.

        **See also** **setToolButtonStyle** ().
        """
        ...
