"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtWidgets, except for defaults which are replaced by "...".
"""
from typing import Optional, Union, overload
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets

bytes = str


class QKeySequenceEdit(PySide6.QtWidgets.QWidget):
    """
    https://doc.qt.io/qt-6/qkeysequenceedit.html

    **Detailed Description**

    This widget lets the user choose a **QKeySequence** , which is usually used
    as a shortcut. The recording is initiated when the widget receives the focus
    and ends one second after the user releases the last key.

    **See also** **QKeySequenceEdit::keySequence** .
    """

    @overload
    def __init__(
        self,
        keySequence: Union[
            PySide6.QtGui.QKeySequence,
            PySide6.QtCore.QKeyCombination,
            PySide6.QtGui.QKeySequence.StandardKey,
            str,
            int,
        ],
        parent: Optional[PySide6.QtWidgets.QWidget] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qkeysequenceedit.html#QKeySequenceEdit

        **QKeySequenceEdit::QKeySequenceEdit(QWidget * parent = nullptr)**

        Constructs a QKeySequenceEdit widget with the given **parent**.
        """
        ...

    @overload
    def __init__(self, parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qkeysequenceedit.html#QKeySequenceEdit-1

        **QKeySequenceEdit::QKeySequenceEdit(const QKeySequence & keySequence ,
        QWidget * parent = nullptr)**

        Constructs a QKeySequenceEdit widget with the given **keySequence** and
        **parent**.
        """
        ...

    def clear(self) -> None:
        """
        https://doc.qt.io/qt-6/qkeysequenceedit.html#clear

        **[slot] void QKeySequenceEdit::clear()**

        Clears the current key sequence.
        """
        ...

    def event(self, arg__1: PySide6.QtCore.QEvent) -> bool:
        """
        https://doc.qt.io/qt-6/qkeysequenceedit.html#event

        **[override virtual protected] bool QKeySequenceEdit::event(QEvent * e
        )**

        Reimplements: **QWidget::event** (QEvent *event).
        """
        ...

    def keyPressEvent(self, arg__1: PySide6.QtGui.QKeyEvent) -> None:
        """
        https://doc.qt.io/qt-6/qkeysequenceedit.html#keyPressEvent

        **[override virtual protected] void
        QKeySequenceEdit::keyPressEvent(QKeyEvent * e )**

        Reimplements: **QWidget::keyPressEvent** (QKeyEvent *event).
        """
        ...

    def keyReleaseEvent(self, arg__1: PySide6.QtGui.QKeyEvent) -> None:
        """
        https://doc.qt.io/qt-6/qkeysequenceedit.html#keyReleaseEvent

        **[override virtual protected] void
        QKeySequenceEdit::keyReleaseEvent(QKeyEvent * e )**

        Reimplements: **QWidget::keyReleaseEvent** (QKeyEvent *event).
        """
        ...

    def keySequence(self) -> PySide6.QtGui.QKeySequence:
        """
        https://doc.qt.io/qt-6/qkeysequenceedit.html#keySequence-prop

        **keySequence : QKeySequence**

        This property contains the currently chosen key sequence.

        The shortcut can be changed by the user or via setter function.

        **Access functions:**

        QKeySequence **keySequence** () const
        void **setKeySequence** (const
        QKeySequence & **keySequence** )

        **Notifier signal:**

        void **keySequenceChanged** (const QKeySequence & **keySequence** )

        **Member Function Documentation**
        """
        ...

    def setKeySequence(
        self,
        keySequence: Union[
            PySide6.QtGui.QKeySequence,
            PySide6.QtCore.QKeyCombination,
            PySide6.QtGui.QKeySequence.StandardKey,
            str,
            int,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qkeysequenceedit.html#keySequence-prop

        **keySequence : QKeySequence**

        This property contains the currently chosen key sequence.

        The shortcut can be changed by the user or via setter function.

        **Access functions:**

        QKeySequence **keySequence** () const
        void **setKeySequence** (const
        QKeySequence & **keySequence** )

        **Notifier signal:**

        void **keySequenceChanged** (const QKeySequence & **keySequence** )

        **Member Function Documentation**
        """
        ...

    def timerEvent(self, arg__1: PySide6.QtCore.QTimerEvent) -> None:
        """
        https://doc.qt.io/qt-6/qkeysequenceedit.html#timerEvent

        **[override virtual protected] void
        QKeySequenceEdit::timerEvent(QTimerEvent * e )**

        Reimplements: **QObject::timerEvent** (QTimerEvent *event).
        """
        ...

    @property
    def editingFinished(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qkeysequenceedit.html#editingFinished

        **[signal] void QKeySequenceEdit::editingFinished()**

        This signal is emitted when the user finishes entering the shortcut.

        **Note:** there is a one second delay before releasing the last key and
        emitting this signal.
        """
        ...

    @property
    def keySequenceChanged(self) -> PySide6.QtCore.SignalInstance:
        ...
