"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtWidgets, except for defaults which are replaced by "...".
"""
from typing import Any, List, Optional, Sequence, Tuple, Union, overload
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets

bytes = str


class QGraphicsWidget(
    PySide6.QtWidgets.QGraphicsObject, PySide6.QtWidgets.QGraphicsLayoutItem
):
    """
    https://doc.qt.io/qt-6/qgraphicswidget.html

    **Detailed Description**

    QGraphicsWidget is an extended base item that provides extra functionality
    over **QGraphicsItem** . It is similar to **QWidget**  in many ways:

    * Provides a **palette** , a **font**  and a **style** ().
      * Has a defined
    **geometry** ().
      * Supports layouts with **setLayout** () and **layout**
    ().
      * Supports shortcuts and actions with **grabShortcut** () and
    **insertAction** ()

    Unlike **QGraphicsItem** , QGraphicsWidget is not an abstract class; you can
    create instances of a QGraphicsWidget without having to subclass it. This
    approach is useful for widgets that only serve the purpose of organizing
    child widgets into a layout.

    QGraphicsWidget can be used as a base item for your own custom item if you
    require advanced input focus handling, e.g., tab focus and activation, or
    layouts.

    Since QGraphicsWidget resembles **QWidget**  and has similar API, it is
    easier to port a widget from **QWidget**  to QGraphicsWidget, instead of
    **QGraphicsItem** .

    **Note:****QWidget** -based widgets can be directly embedded into a
    **QGraphicsScene**  using **QGraphicsProxyWidget** .

    Noticeable differences between QGraphicsWidget and **QWidget**  are:

    QGraphicsWidget**QWidget**
    Coordinates and geometry are defined with
    qreals (doubles or floats, depending on the platform).**QWidget**  uses
    integer geometry (**QPoint** , **QRect** ).
    The widget is already visible
    by default; you do not have to call **show** () to display the
    widget.**QWidget**  is hidden by default until you call **show** ().
    A
    subset of widget attributes are supported.All widget attributes are
    supported.
    A top-level item's style defaults to **QGraphicsScene::style**
    A top-level widget's style defaults to **QApplication::style**
    Graphics
    View provides a custom drag and drop framework, different from **QWidget**
    .Standard drag and drop framework.
    Widget items do not support
    modality.Full modality support.

    QGraphicsWidget supports a subset of Qt's widget attributes,
    (**Qt::WidgetAttribute** ), as shown in the table below. Any attributes not
    listed in this table are unsupported, or otherwise unused.

    Widget AttributeUsage
    **Qt::WA_SetLayoutDirection** Set by
    **setLayoutDirection** (), cleared by **unsetLayoutDirection** (). You can
    test this attribute to check if the widget has been explicitly assigned a
    **layoutDirection** . If the attribute is not set, the **layoutDirection**
    () is inherited.
    **Qt::WA_RightToLeft** Toggled by **setLayoutDirection**
    (). Inherited from the parent/scene. If set, the widget's layout will order
    horizontally arranged widgets from right to left.
    **Qt::WA_SetStyle** Set
    and cleared by **setStyle** (). If this attribute is set, the widget has
    been explicitly assigned a style. If it is unset, the widget will use the
    scene's or the application's style.
    **Qt::WA_Resized** Set by
    **setGeometry** () and **resize** ().
    **Qt::WA_SetPalette** Set by
    **setPalette** ().
    **Qt::WA_SetFont** Set by **setFont** ().
    **Qt::WA_WindowPropagation** Enables propagation to window widgets.

    Although QGraphicsWidget inherits from both **QObject**  and
    **QGraphicsItem** , you should use the functions provided by
    **QGraphicsItem** , **not** **QObject** , to manage the relationships
    between parent and child items. These functions control the stacking order
    of items as well as their ownership.

    **Note:** The **QObject::parent** () should always return `nullptr` for
    QGraphicsWidgets, but this policy is not strictly defined.

    **See also** **QGraphicsProxyWidget** , **QGraphicsItem** , and **Widgets
    and Layouts** .
    """

    def __init__(
        self,
        parent: Optional[PySide6.QtWidgets.QGraphicsItem] = ...,
        wFlags: PySide6.QtCore.Qt.WindowFlags = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicswidget.html#QGraphicsWidget

        **QGraphicsWidget::QGraphicsWidget(QGraphicsItem * parent = nullptr,
        Qt::WindowFlags wFlags = Qt::WindowFlags())**

        Constructs a QGraphicsWidget instance. The optional **parent** argument
        is passed to **QGraphicsItem** 's constructor. The optional **wFlags**
        argument specifies the widget's window flags (e.g., whether the widget
        should be a window, a tool, a popup, etc).
        """
        ...

    def actions(self) -> List[PySide6.QtGui.QAction]:
        """
        https://doc.qt.io/qt-6/qgraphicswidget.html#actions

        **QList<QAction *> QGraphicsWidget::actions() const**

        Returns the (possibly empty) list of this widget's actions.

        **See also** **insertAction** (), **removeAction** (),
        **QWidget::actions** (), **QAction::associatedWidgets** (), and
        **QAction::associatedGraphicsWidgets** ().
        """
        ...

    def addAction(self, action: PySide6.QtGui.QAction) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicswidget.html#addAction

        **void QGraphicsWidget::addAction(QAction * action )**

        Appends the action **action** to this widget's list of actions.

        All QGraphicsWidgets have a list of **QAction** s, however they can be
        represented graphically in many different ways. The default use of the
        **QAction**  list (as returned by **actions** ()) is to create a context
        **QMenu** .

        A **QGraphicsWidget**  should only have one of each action and adding an
        action it already has will not cause the same action to be in the widget
        twice.

        **See also** **removeAction** (), **insertAction** (), **actions** (),
        and **QWidget::addAction** ().
        """
        ...

    def addActions(self, actions: Sequence[PySide6.QtGui.QAction]) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicswidget.html#addActions

        **void QGraphicsWidget::addActions(const QList<QAction *> & actions )**

        Appends the actions **actions** to this widget's list of actions.

        **See also** **removeAction** (), **QMenu** , **addAction** (), and
        **QWidget::addActions** ().
        """
        ...

    def adjustSize(self) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicswidget.html#adjustSize

        **void QGraphicsWidget::adjustSize()**

        Adjusts the size of the widget to its effective preferred size hint.

        This function is called implicitly when the item is shown for the first
        time.

        **See also** **effectiveSizeHint** () and **Qt::MinimumSize** .
        """
        ...

    def autoFillBackground(self) -> bool:
        """
        https://doc.qt.io/qt-6/qgraphicswidget.html#autoFillBackground-prop

        **autoFillBackground : bool**

        This property holds whether the widget background is filled
        automatically

        If enabled, this property will cause Qt to fill the background of the
        widget before invoking the **paint** () method. The color used is
        defined by the **QPalette::Window**  color role from the widget's
        **palette** .

        In addition, Windows are always filled with **QPalette::Window** ,
        unless the WA_OpaquePaintEvent or WA_NoSystemBackground attributes are
        set.

        By default, this property is `false`.

        **Access functions:**

        bool **autoFillBackground** () const
        void **setAutoFillBackground**
        (bool **enabled** )

        **See also** **Qt::WA_OpaquePaintEvent**  and
        **Qt::WA_NoSystemBackground** .
        """
        ...

    def boundingRect(self) -> PySide6.QtCore.QRectF:
        """
        https://doc.qt.io/qt-6/qgraphicswidget.html#boundingRect

        **[override virtual] QRectF QGraphicsWidget::boundingRect() const**

        Reimplements: **QGraphicsItem::boundingRect() const** .
        """
        ...

    def changeEvent(self, event: PySide6.QtCore.QEvent) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicswidget.html#changeEvent

        **[virtual protected] void QGraphicsWidget::changeEvent(QEvent * event
        )**

        This event handler can be reimplemented to handle state changes.

        The state being changed in this event can be retrieved through
        **event**.

        Change events include: **QEvent::ActivationChange** ,
        **QEvent::EnabledChange** , **QEvent::FontChange** ,
        **QEvent::StyleChange** , **QEvent::PaletteChange** ,
        **QEvent::ParentChange** , **QEvent::LayoutDirectionChange** , and
        **QEvent::ContentsRectChange** .
        """
        ...

    def close(self) -> bool:
        """
        https://doc.qt.io/qt-6/qgraphicswidget.html#close

        **[slot] bool QGraphicsWidget::close()**

        Call this function to close the widget.

        Returns `true` if the widget was closed; otherwise returns `false`. This
        slot will first send a **QCloseEvent**  to the widget, which may or may
        not accept the event. If the event was ignored, nothing happens. If the
        event was accepted, it will **hide** () the widget.

        If the widget has the **Qt::WA_DeleteOnClose**  attribute set it will be
        deleted.
        """
        ...

    def closeEvent(self, event: PySide6.QtGui.QCloseEvent) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicswidget.html#closeEvent

        **[virtual protected] void QGraphicsWidget::closeEvent(QCloseEvent *
        event )**

        This event handler, for **event** , can be reimplemented in a subclass
        to receive widget close events. The default implementation accepts the
        event.

        **See also** **close** () and **QCloseEvent** .
        """
        ...

    def event(self, event: PySide6.QtCore.QEvent) -> bool:
        """
        https://doc.qt.io/qt-6/qgraphicswidget.html#event

        **[override virtual protected] bool QGraphicsWidget::event(QEvent *
        event )**

        Reimplements: **QGraphicsObject::event** (QEvent *ev).

        Handles the **event**. **QGraphicsWidget**  handles the following
        events:

        EventUsage
        PolishDelivered to the widget some time after it has been
        shown.
        GraphicsSceneMoveDelivered to the widget after its local
        position has changed.
        GraphicsSceneResizeDelivered to the widget after
        its size has changed.
        ShowDelivered to the widget before it has been
        shown.
        HideDelivered to the widget after it has been hidden.
        PaletteChangeDelivered to the widget after its palette has changed.
        FontChangeDelivered to the widget after its font has changed.
        EnabledChangeDelivered to the widget after its enabled state has
        changed.
        StyleChangeDelivered to the widget after its style has
        changed.
        LayoutDirectionChangeDelivered to the widget after its layout
        direction has changed.
        ContentsRectChangeDelivered to the widget after
        its contents margins/ contents rect has changed.
        """
        ...

    def focusInEvent(self, event: PySide6.QtGui.QFocusEvent) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicswidget.html#focusInEvent

        **[override virtual protected] void
        QGraphicsWidget::focusInEvent(QFocusEvent * event )**

        Reimplements: **QGraphicsItem::focusInEvent** (QFocusEvent *event).
        """
        ...

    def focusNextPrevChild(self, next: bool) -> bool:
        """
        https://doc.qt.io/qt-6/qgraphicswidget.html#focusNextPrevChild

        **[virtual protected] bool QGraphicsWidget::focusNextPrevChild(bool next
        )**

        Finds a new widget to give the keyboard focus to, as appropriate for Tab
        and Shift+Tab, and returns `true` if it can find a new widget; returns
        `false` otherwise. If **next** is true, this function searches forward;
        if **next** is false, it searches backward.

        Sometimes, you will want to reimplement this function to provide special
        focus handling for your widget and its subwidgets. For example, a web
        browser might reimplement it to move its current active link forward or
        backward, and call the base implementation only when it reaches the last
        or first link on the page.

        Child widgets call focusNextPrevChild() on their parent widgets, but
        only the window that contains the child widgets decides where to
        redirect focus. By reimplementing this function for an object, you gain
        control of focus traversal for all child widgets.

        **See also** **focusPolicy** ().
        """
        ...

    def focusOutEvent(self, event: PySide6.QtGui.QFocusEvent) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicswidget.html#focusOutEvent

        **[override virtual protected] void
        QGraphicsWidget::focusOutEvent(QFocusEvent * event )**

        Reimplements: **QGraphicsItem::focusOutEvent** (QFocusEvent *event).
        """
        ...

    def focusPolicy(self) -> PySide6.QtCore.Qt.FocusPolicy:
        """
        https://doc.qt.io/qt-6/qgraphicswidget.html#focusPolicy-prop

        **focusPolicy : Qt::FocusPolicy**

        This property holds the way the widget accepts keyboard focus

        The focus policy is **Qt::TabFocus**  if the widget accepts keyboard
        focus by tabbing, **Qt::ClickFocus**  if the widget accepts focus by
        clicking, **Qt::StrongFocus**  if it accepts both, and **Qt::NoFocus**
        (the default) if it does not accept focus at all.

        You must enable keyboard focus for a widget if it processes keyboard
        events. This is normally done from the widget's constructor. For
        instance, the **QLineEdit**  constructor calls
        setFocusPolicy(**Qt::StrongFocus** ).

        If you enable a focus policy (i.e., not **Qt::NoFocus** ),
        **QGraphicsWidget**  will automatically enable the ItemIsFocusable flag.
        Setting **Qt::NoFocus**  on a widget will clear the ItemIsFocusable
        flag. If the widget currently has keyboard focus, the widget will
        automatically lose focus.

        **Access functions:**

        Qt::FocusPolicy **focusPolicy** () const
        void **setFocusPolicy**
        (Qt::FocusPolicy **policy** )

        **See also** **focusInEvent** (), **focusOutEvent** (),
        **keyPressEvent** (), **keyReleaseEvent** (), and **enabled** .
        """
        ...

    def focusWidget(self) -> PySide6.QtWidgets.QGraphicsWidget:
        """
        https://doc.qt.io/qt-6/qgraphicswidget.html#focusWidget

        **QGraphicsWidget *QGraphicsWidget::focusWidget() const**

        If this widget, a child or descendant of this widget currently has input
        focus, this function will return a pointer to that widget. If no
        descendant widget has input focus, `nullptr` is returned.

        **See also** **QGraphicsItem::focusItem** () and
        **QWidget::focusWidget** ().
        """
        ...

    def font(self) -> PySide6.QtGui.QFont:
        """
        https://doc.qt.io/qt-6/qgraphicswidget.html#font-prop

        **font : QFont**

        This property holds the widgets' font

        This property provides the widget's font.

        **QFont**  consists of font properties that have been explicitly defined
        and properties implicitly inherited from the widget's parent. Hence,
        font() can return a different font compared to the one set with
        setFont(). This scheme allows you to define single entries in a font
        without affecting the font's inherited entries.

        When a widget's font changes, it resolves its entries against its parent
        widget. If the widget does not have a parent widget, it resolves its
        entries against the scene. The widget then sends itself a **FontChange**
        event and notifies all its descendants so that they can resolve their
        fonts as well.

        By default, this property contains the application's default font.

        **Access functions:**

        QFont **font** () const
        void **setFont** (const QFont & **font** )

        **See also** **QApplication::font** (), **QGraphicsScene::font** , and
        **QFont::resolve** ().
        """
        ...

    def getContentsMargins(self) -> Tuple[float, float, float, float]:
        """
        https://doc.qt.io/qt-6/qgraphicswidget.html#getContentsMargins

        **[override virtual] void QGraphicsWidget::getContentsMargins(qreal *
        left , qreal * top , qreal * right , qreal * bottom ) const**

        Reimplements: **QGraphicsLayoutItem::getContentsMargins(qreal *left,
        qreal *top, qreal *right, qreal *bottom) const** .

        Gets the widget's contents margins. The margins are stored in **left** ,
        **top** , **right** and **bottom** , as pointers to qreals. Each
        argument can be **omitted** by passing `nullptr`.

        **See also** **setContentsMargins** ().
        """
        ...

    def getWindowFrameMargins(self) -> Tuple[float, float, float, float]:
        """
        https://doc.qt.io/qt-6/qgraphicswidget.html#getWindowFrameMargins

        **void QGraphicsWidget::getWindowFrameMargins(qreal * left , qreal * top
        , qreal * right , qreal * bottom ) const**

        Gets the widget's window frame margins. The margins are stored in
        **left** , **top** , **right** and **bottom** as pointers to qreals.
        Each argument can be **omitted** by passing `nullptr`.

        **See also** **setWindowFrameMargins** () and **windowFrameRect** ().
        """
        ...

    def grabKeyboardEvent(self, event: PySide6.QtCore.QEvent) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicswidget.html#grabKeyboardEvent

        **[virtual protected] void QGraphicsWidget::grabKeyboardEvent(QEvent *
        event )**

        This event handler, for **event** , can be reimplemented in a subclass
        to receive notifications for **QEvent::GrabKeyboard**  events.

        **See also** **grabKeyboard** () and **grabMouse** ().
        """
        ...

    def grabMouseEvent(self, event: PySide6.QtCore.QEvent) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicswidget.html#grabMouseEvent

        **[virtual protected] void QGraphicsWidget::grabMouseEvent(QEvent *
        event )**

        This event handler, for **event** , can be reimplemented in a subclass
        to receive notifications for **QEvent::GrabMouse**  events.

        **See also** **grabMouse** () and **grabKeyboard** ().
        """
        ...

    def grabShortcut(
        self,
        sequence: Union[
            PySide6.QtGui.QKeySequence,
            PySide6.QtCore.QKeyCombination,
            PySide6.QtGui.QKeySequence.StandardKey,
            str,
            int,
        ],
        context: PySide6.QtCore.Qt.ShortcutContext = ...,
    ) -> int:
        """
        https://doc.qt.io/qt-6/qgraphicswidget.html#grabShortcut

        **int QGraphicsWidget::grabShortcut(const QKeySequence & sequence ,
        Qt::ShortcutContext context = Qt::WindowShortcut)**

        Adds a shortcut to Qt's shortcut system that watches for the given key
        **sequence** in the given **context**. If the **context** is
        **Qt::ApplicationShortcut** , the shortcut applies to the application as
        a whole. Otherwise, it is either local to this widget,
        **Qt::WidgetShortcut** , or to the window itself, **Qt::WindowShortcut**
        . For widgets that are not part of a window (i.e., top-level widgets and
        their children), **Qt::WindowShortcut**  shortcuts apply to the scene.

        If the same key **sequence** has been grabbed by several widgets, when
        the key **sequence** occurs a **QEvent::Shortcut**  event is sent to all
        the widgets to which it applies in a non-deterministic order, but with
        the ``ambiguous'' flag set to true.

        **Warning:** You should not normally need to use this function; instead
        create **QAction** s with the shortcut key sequences you require (if you
        also want equivalent menu options and toolbar buttons), or create
        **QShortcut** s if you just need key sequences. Both **QAction**  and
        **QShortcut**  handle all the event filtering for you, and provide
        signals which are triggered when the user triggers the key sequence, so
        are much easier to use than this low-level function.

        **See also** **releaseShortcut** (), **setShortcutEnabled** (), and
        **QWidget::grabShortcut** ().
        """
        ...

    def hideEvent(self, event: PySide6.QtGui.QHideEvent) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicswidget.html#hideEvent

        **[virtual protected] void QGraphicsWidget::hideEvent(QHideEvent * event
        )**

        This event handler, for **Hide**  events, is delivered after the widget
        has been hidden, for example, setVisible(false) has been called for the
        widget or one of its ancestors when the widget was previously shown.

        You can reimplement this event handler to detect when your widget is
        hidden. Calling **QEvent::accept** () or **QEvent::ignore** () on
        **event** has no effect.

        **See also** **showEvent** (), **QWidget::hideEvent** (), and
        **ItemVisibleChange** .
        """
        ...

    def hoverLeaveEvent(
        self, event: PySide6.QtWidgets.QGraphicsSceneHoverEvent
    ) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicswidget.html#hoverLeaveEvent

        **[override virtual protected] void
        QGraphicsWidget::hoverLeaveEvent(QGraphicsSceneHoverEvent * event )**

        Reimplements: **QGraphicsItem::hoverLeaveEvent**
        (QGraphicsSceneHoverEvent *event).
        """
        ...

    def hoverMoveEvent(self, event: PySide6.QtWidgets.QGraphicsSceneHoverEvent) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicswidget.html#hoverMoveEvent

        **[override virtual protected] void
        QGraphicsWidget::hoverMoveEvent(QGraphicsSceneHoverEvent * event )**

        Reimplements: **QGraphicsItem::hoverMoveEvent**
        (QGraphicsSceneHoverEvent *event).
        """
        ...

    def initStyleOption(self, option: PySide6.QtWidgets.QStyleOption) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicswidget.html#initStyleOption

        **[virtual protected] void QGraphicsWidget::initStyleOption(QStyleOption
        * option ) const**

        Populates a style option object for this widget based on its current
        state, and stores the output in **option**. The default implementation
        populates **option** with the following properties.

        Style Option PropertyValue
        state & **QStyle::State_Enabled**
        Corresponds to **QGraphicsItem::isEnabled** ().
        state &
        **QStyle::State_HasFocus** Corresponds to **QGraphicsItem::hasFocus**
        ().
        state & **QStyle::State_MouseOver** Corresponds to
        **QGraphicsItem::isUnderMouse** ().
        directionCorresponds to
        **QGraphicsWidget::layoutDirection** ().
        rectCorresponds to
        **QGraphicsWidget::rect** ().toRect().
        paletteCorresponds to
        **QGraphicsWidget::palette** ().
        fontMetricsCorresponds to
        **QFontMetrics** (**QGraphicsWidget::font** ()).

        Subclasses of **QGraphicsWidget**  should call the base implementation,
        and then test the type of **option** using **qstyleoption_cast** <>() or
        test **QStyleOption::Type**  before storing widget-specific options.

        For example:

        void MyGroupBoxWidget::initStyleOption(**QStyleOption**  *option) const
        {
                **QGraphicsWidget** ::initStyleOption(option);
                if
        (**QStyleOptionGroupBox**  *box =
        qstyleoption_cast<**QStyleOptionGroupBox**  \\*>(option)) {
        // Add group box specific state.
                    box->flat = isFlat();
        ...
                }
            }

        **See also** **QStyleOption::initFrom** ().
        """
        ...

    def insertAction(
        self, before: PySide6.QtGui.QAction, action: PySide6.QtGui.QAction
    ) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicswidget.html#insertAction

        **void QGraphicsWidget::insertAction(QAction * before , QAction * action
        )**

        Inserts the action **action** to this widget's list of actions, before
        the action **before**. It appends the action if **before** is `nullptr`
        or **before** is not a valid action for this widget.

        A **QGraphicsWidget**  should only have one of each action.

        **See also** **removeAction** (), **addAction** (), **QMenu** ,
        **actions** (), and **QWidget::insertActions** ().
        """
        ...

    def insertActions(
        self, before: PySide6.QtGui.QAction, actions: Sequence[PySide6.QtGui.QAction]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicswidget.html#insertActions

        **void QGraphicsWidget::insertActions(QAction * before , const
        QList<QAction *> & actions )**

        Inserts the actions **actions** to this widget's list of actions, before
        the action **before**. It appends the action if **before** is `nullptr`
        or **before** is not a valid action for this widget.

        A **QGraphicsWidget**  can have at most one of each action.

        **See also** **removeAction** (), **QMenu** , **insertAction** (), and
        **QWidget::insertActions** ().
        """
        ...

    def isActiveWindow(self) -> bool:
        """
        https://doc.qt.io/qt-6/qgraphicswidget.html#isActiveWindow

        **bool QGraphicsWidget::isActiveWindow() const**

        Returns `true` if this widget's window is in the active window, or if
        the widget does not have a window but is in an active scene (i.e., a
        scene that currently has focus).

        The active window is the window that either contains a child widget that
        currently has input focus, or that itself has input focus.

        **See also** **QGraphicsScene::activeWindow** (),
        **QGraphicsScene::setActiveWindow** (), and **isActive** ().
        """
        ...

    def itemChange(
        self, change: PySide6.QtWidgets.QGraphicsItem.GraphicsItemChange, value: Any
    ) -> Any:
        """
        https://doc.qt.io/qt-6/qgraphicswidget.html#itemChange

        **[override virtual protected] QVariant
        QGraphicsWidget::itemChange(QGraphicsItem::GraphicsItemChange change ,
        const QVariant & value )**

        Reimplements: **QGraphicsItem::itemChange**
        (QGraphicsItem::GraphicsItemChange change, const QVariant &value).

        **QGraphicsWidget**  uses the base implementation of this function to
        catch and deliver events related to state changes in the item. Because
        of this, it is very important that subclasses call the base
        implementation.

        **change** specifies the type of change, and **value** is the new value.

        For example, **QGraphicsWidget**  uses ItemVisibleChange to deliver
        **Show**  and **Hide**  events, ItemPositionHasChanged to deliver
        **Move**  events, and ItemParentChange both to deliver **ParentChange**
        events, and for managing the focus chain.

        **QGraphicsWidget**  enables the ItemSendsGeometryChanges flag by
        default in order to track position changes.

        **See also** **QGraphicsItem::itemChange** ().
        """
        ...

    def layout(self) -> PySide6.QtWidgets.QGraphicsLayout:
        """
        https://doc.qt.io/qt-6/qgraphicswidget.html#layout

        **QGraphicsLayout *QGraphicsWidget::layout() const**

        Returns this widget's layout, or `nullptr` if no layout is currently
        managing this widget.

        **Note:** Getter function for property layout.

        **See also** **setLayout** ().
        """
        ...

    def layoutDirection(self) -> PySide6.QtCore.Qt.LayoutDirection:
        """
        https://doc.qt.io/qt-6/qgraphicswidget.html#layoutDirection-prop

        **layoutDirection : Qt::LayoutDirection**

        This property holds the layout direction for this widget.

        This property modifies this widget's and all of its descendants'
        **Qt::WA_RightToLeft**  attribute. It also sets this widget's
        **Qt::WA_SetLayoutDirection**  attribute.

        The widget's layout direction determines the order in which the layout
        manager horizontally arranges subwidgets of this widget. The default
        value depends on the language and locale of the application, and is
        typically in the same direction as words are read and written. With
        **Qt::LeftToRight** , the layout starts placing subwidgets from the left
        side of this widget towards the right. **Qt::RightToLeft**  does the
        opposite - the layout will place widgets starting from the right edge
        moving towards the left.

        Subwidgets inherit their layout direction from the parent. Top-level
        widget items inherit their layout direction from
        QGraphicsScene::layoutDirection. If you change a widget's layout
        direction by calling setLayoutDirection(), the widget will send itself a
        **LayoutDirectionChange**  event, and then propagate the new layout
        direction to all its descendants.

        **Access functions:**

        Qt::LayoutDirection **layoutDirection** () const
        void
        **setLayoutDirection** (Qt::LayoutDirection **direction** )
        void
        **unsetLayoutDirection** ()

        **See also** **QWidget::layoutDirection**  and
        **QApplication::layoutDirection** .
        """
        ...

    def moveEvent(self, event: PySide6.QtWidgets.QGraphicsSceneMoveEvent) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicswidget.html#moveEvent

        **[virtual protected] void
        QGraphicsWidget::moveEvent(QGraphicsSceneMoveEvent * event )**

        This event handler, for **GraphicsSceneMove**  events, is delivered
        after the widget has moved (e.g., its local position has changed).

        This event is only delivered when the item is moved locally. Calling
        **setTransform** () or moving any of the item's ancestors does not
        affect the item's local position.

        You can reimplement this event handler to detect when your widget has
        moved. Calling **QEvent::accept** () or **QEvent::ignore** () on
        **event** has no effect.

        **See also** **ItemPositionChange**  and **ItemPositionHasChanged** .
        """
        ...

    def paint(
        self,
        painter: PySide6.QtGui.QPainter,
        option: PySide6.QtWidgets.QStyleOptionGraphicsItem,
        widget: Optional[PySide6.QtWidgets.QWidget] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicswidget.html#paint

        **[override virtual] void QGraphicsWidget::paint(QPainter * painter ,
        const QStyleOptionGraphicsItem * option , QWidget * widget = nullptr)**

        Reimplements: **QGraphicsItem::paint** (QPainter *painter, const
        QStyleOptionGraphicsItem *option, QWidget *widget).
        """
        ...

    def paintWindowFrame(
        self,
        painter: PySide6.QtGui.QPainter,
        option: PySide6.QtWidgets.QStyleOptionGraphicsItem,
        widget: Optional[PySide6.QtWidgets.QWidget] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicswidget.html#paintWindowFrame

        **[virtual] void QGraphicsWidget::paintWindowFrame(QPainter * painter ,
        const QStyleOptionGraphicsItem * option , QWidget * widget = nullptr)**

        This virtual function is called by **QGraphicsScene**  to draw the
        window frame for windows using **painter** , **option** , and **widget**
        , in local coordinates. The base implementation uses the current style
        to render the frame and title bar.

        You can reimplement this function in a subclass of **QGraphicsWidget**
        to provide custom rendering of the widget's window frame.

        **See also** **QGraphicsItem::paint** ().
        """
        ...

    def palette(self) -> PySide6.QtGui.QPalette:
        """
        https://doc.qt.io/qt-6/qgraphicswidget.html#palette-prop

        **palette : QPalette**

        This property holds the widget's palette

        This property provides the widget's palette. The palette provides colors
        and brushes for color groups (e.g., **QPalette::Button** ) and states
        (e.g., **QPalette::Inactive** ), loosely defining the general look of
        the widget and its children.

        **QPalette**  consists of color groups that have been explicitly
        defined, and groups that are implicitly inherited from the widget's
        parent. Because of this, palette() can return a different palette than
        what has been set with setPalette(). This scheme allows you to define
        single entries in a palette without affecting the palette's inherited
        entries.

        When a widget's palette changes, it resolves its entries against its
        parent widget, or if it doesn't have a parent widget, it resolves
        against the scene. It then sends itself a **PaletteChange**  event, and
        notifies all its descendants so they can resolve their palettes as well.

        By default, this property contains the application's default palette.

        **Access functions:**

        QPalette **palette** () const
        void **setPalette** (const QPalette &
        **palette** )

        **See also** **QGuiApplication::palette** (),
        **QGraphicsScene::palette** , and **QPalette::resolve** ().
        """
        ...

    def polishEvent(self) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicswidget.html#polishEvent

        **[virtual protected] void QGraphicsWidget::polishEvent()**

        This event is delivered to the item by the scene at some point after it
        has been constructed, but before it is shown or otherwise accessed
        through the scene. You can use this event handler to do last-minute
        initializations of the widget which require the item to be fully
        constructed.

        The base implementation does nothing.
        """
        ...

    def propertyChange(self, propertyName: str, value: Any) -> Any:
        ...

    def rect(self) -> PySide6.QtCore.QRectF:
        """
        https://doc.qt.io/qt-6/qgraphicswidget.html#rect

        **QRectF QGraphicsWidget::rect() const**

        Returns the item's local rect as a **QRectF** . This function is
        equivalent to **QRectF** (QPointF(), **size** ()).

        **See also** **setGeometry** () and **resize** ().
        """
        ...

    def releaseShortcut(self, id: int) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicswidget.html#releaseShortcut

        **void QGraphicsWidget::releaseShortcut(int id )**

        Removes the shortcut with the given **id** from Qt's shortcut system.
        The widget will no longer receive **QEvent::Shortcut**  events for the
        shortcut's key sequence (unless it has other shortcuts with the same key
        sequence).

        **Warning:** You should not normally need to use this function since
        Qt's shortcut system removes shortcuts automatically when their parent
        widget is destroyed. It is best to use **QAction**  or **QShortcut**  to
        handle shortcuts, since they are easier to use than this low-level
        function. Note also that this is an expensive operation.

        **See also** **grabShortcut** (), **setShortcutEnabled** (), and
        **QWidget::releaseShortcut** ().
        """
        ...

    def removeAction(self, action: PySide6.QtGui.QAction) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicswidget.html#removeAction

        **void QGraphicsWidget::removeAction(QAction * action )**

        Removes the action **action** from this widget's list of actions.

        **See also** **insertAction** (), **actions** (), **insertAction** (),
        and **QWidget::removeAction** ().
        """
        ...

    @overload
    def resize(self, size: Union[PySide6.QtCore.QSizeF, PySide6.QtCore.QSize]) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicswidget.html#resize-1

        **void QGraphicsWidget::resize(qreal w , qreal h )**

        This is an overloaded function.

        Constructs a resize with the given `width` ( **w** ) and `height` (
        **h** ). This convenience function is equivalent to calling
        resize(**QSizeF** (w, h)).

        **Note:** Setter function for property **size** .

        **See also** **setGeometry** () and **setTransform** ().
        """
        ...

    @overload
    def resize(self, w: float, h: float) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicswidget.html#resize-1

        **void QGraphicsWidget::resize(qreal w , qreal h )**

        This is an overloaded function.

        Constructs a resize with the given `width` ( **w** ) and `height` (
        **h** ). This convenience function is equivalent to calling
        resize(**QSizeF** (w, h)).

        **Note:** Setter function for property **size** .

        **See also** **setGeometry** () and **setTransform** ().
        """
        ...

    def resizeEvent(self, event: PySide6.QtWidgets.QGraphicsSceneResizeEvent) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicswidget.html#resizeEvent

        **[virtual protected] void
        QGraphicsWidget::resizeEvent(QGraphicsSceneResizeEvent * event )**

        This event handler, for **GraphicsSceneResize**  events, is delivered
        after the widget has been resized (i.e., its local size has changed).
        **event** contains both the old and the new size.

        This event is only delivered when the widget is resized locally; calling
        **setTransform** () on the widget or any of its ancestors or view, does
        not affect the widget's local size.

        You can reimplement this event handler to detect when your widget has
        been resized. Calling **QEvent::accept** () or **QEvent::ignore** () on
        **event** has no effect.

        **See also** **geometry** () and **setGeometry** ().
        """
        ...

    def sceneEvent(self, event: PySide6.QtCore.QEvent) -> bool:
        """
        https://doc.qt.io/qt-6/qgraphicswidget.html#sceneEvent

        **[override virtual protected] bool QGraphicsWidget::sceneEvent(QEvent *
        event )**

        Reimplements: **QGraphicsItem::sceneEvent** (QEvent *event).

        **QGraphicsWidget** 's implementation of sceneEvent() simply passes
        **event** to **QGraphicsWidget::event** (). You can handle all events
        for your widget in **event** () or in any of the convenience functions;
        you should not have to reimplement this function in a subclass of
        **QGraphicsWidget** .

        Returns `true` if **event** has been recognized and processed;
        otherwise, returns `false`.

        **See also** **QGraphicsItem::sceneEvent** ().
        """
        ...

    def setAttribute(
        self, attribute: PySide6.QtCore.Qt.WidgetAttribute, on: bool = ...
    ) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicswidget.html#setAttribute

        **void QGraphicsWidget::setAttribute(Qt::WidgetAttribute attribute ,
        bool on = true)**

        If **on** is true, this function enables **attribute** ; otherwise
        **attribute** is disabled.

        See the class documentation for **QGraphicsWidget**  for a complete list
        of which attributes are supported, and what they are for.

        **See also** **testAttribute** () and **QWidget::setAttribute** ().
        """
        ...

    def setAutoFillBackground(self, enabled: bool) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicswidget.html#autoFillBackground-prop

        **autoFillBackground : bool**

        This property holds whether the widget background is filled
        automatically

        If enabled, this property will cause Qt to fill the background of the
        widget before invoking the **paint** () method. The color used is
        defined by the **QPalette::Window**  color role from the widget's
        **palette** .

        In addition, Windows are always filled with **QPalette::Window** ,
        unless the WA_OpaquePaintEvent or WA_NoSystemBackground attributes are
        set.

        By default, this property is `false`.

        **Access functions:**

        bool **autoFillBackground** () const
        void **setAutoFillBackground**
        (bool **enabled** )

        **See also** **Qt::WA_OpaquePaintEvent**  and
        **Qt::WA_NoSystemBackground** .
        """
        ...

    @overload
    def setContentsMargins(
        self, left: float, top: float, right: float, bottom: float
    ) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicswidget.html#setContentsMargins

        **[since 5.14] void QGraphicsWidget::setContentsMargins(QMarginsF
        margins )**

        Sets the widget's contents margins to **margins**.

        Contents margins are used by the assigned layout to define the placement
        of subwidgets and layouts. Margins are particularly useful for widgets
        that constrain subwidgets to only a section of its own geometry. For
        example, a group box with a layout will place subwidgets inside its
        frame, but below the title.

        Changing a widget's contents margins will always trigger an **update**
        (), and any assigned layout will be activated automatically. The widget
        will then receive a **ContentsRectChange**  event.

        This function was introduced in Qt 5.14.

        **See also** **getContentsMargins** () and **setGeometry** ().
        """
        ...

    @overload
    def setContentsMargins(
        self, margins: Union[PySide6.QtCore.QMarginsF, PySide6.QtCore.QMargins]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicswidget.html#setContentsMargins-1

        **void QGraphicsWidget::setContentsMargins(qreal left , qreal top ,
        qreal right , qreal bottom )**

        This is an overloaded function.

        Sets the widget's contents margins to **left** , **top** , **right** and
        **bottom**.
        """
        ...

    def setFocusPolicy(self, policy: PySide6.QtCore.Qt.FocusPolicy) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicswidget.html#focusPolicy-prop

        **focusPolicy : Qt::FocusPolicy**

        This property holds the way the widget accepts keyboard focus

        The focus policy is **Qt::TabFocus**  if the widget accepts keyboard
        focus by tabbing, **Qt::ClickFocus**  if the widget accepts focus by
        clicking, **Qt::StrongFocus**  if it accepts both, and **Qt::NoFocus**
        (the default) if it does not accept focus at all.

        You must enable keyboard focus for a widget if it processes keyboard
        events. This is normally done from the widget's constructor. For
        instance, the **QLineEdit**  constructor calls
        setFocusPolicy(**Qt::StrongFocus** ).

        If you enable a focus policy (i.e., not **Qt::NoFocus** ),
        **QGraphicsWidget**  will automatically enable the ItemIsFocusable flag.
        Setting **Qt::NoFocus**  on a widget will clear the ItemIsFocusable
        flag. If the widget currently has keyboard focus, the widget will
        automatically lose focus.

        **Access functions:**

        Qt::FocusPolicy **focusPolicy** () const
        void **setFocusPolicy**
        (Qt::FocusPolicy **policy** )

        **See also** **focusInEvent** (), **focusOutEvent** (),
        **keyPressEvent** (), **keyReleaseEvent** (), and **enabled** .
        """
        ...

    def setFont(self, font: Union[PySide6.QtGui.QFont, str, Sequence[str]]) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicswidget.html#font-prop

        **font : QFont**

        This property holds the widgets' font

        This property provides the widget's font.

        **QFont**  consists of font properties that have been explicitly defined
        and properties implicitly inherited from the widget's parent. Hence,
        font() can return a different font compared to the one set with
        setFont(). This scheme allows you to define single entries in a font
        without affecting the font's inherited entries.

        When a widget's font changes, it resolves its entries against its parent
        widget. If the widget does not have a parent widget, it resolves its
        entries against the scene. The widget then sends itself a **FontChange**
        event and notifies all its descendants so that they can resolve their
        fonts as well.

        By default, this property contains the application's default font.

        **Access functions:**

        QFont **font** () const
        void **setFont** (const QFont & **font** )

        **See also** **QApplication::font** (), **QGraphicsScene::font** , and
        **QFont::resolve** ().
        """
        ...

    @overload
    def setGeometry(
        self, rect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicswidget.html#setGeometry-1

        **void QGraphicsWidget::setGeometry(qreal x , qreal y , qreal w , qreal
        h )**

        This convenience function is equivalent to calling
        setGeometry(**QRectF** ( **x** , **y** , **w** , **h** )).

        **Note:** Setter function for property **geometry** .

        **See also** **geometry** () and **resize** ().
        """
        ...

    @overload
    def setGeometry(self, x: float, y: float, w: float, h: float) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicswidget.html#geometry-prop

        **geometry : QRectF**

        This property holds the geometry of the widget

        Sets the item's geometry to **rect**. The item's position and size are
        modified as a result of calling this function. The item is first moved,
        then resized.

        A side effect of calling this function is that the widget will receive a
        move event and a resize event. Also, if the widget has a layout
        assigned, the layout will activate.

        **Access functions:**

        virtual void **setGeometry** (const QRectF & **rect** ) override
        void
        ****setGeometry** ** (qreal **x** , qreal **y** , qreal **w** , qreal
        **h** )

        **Notifier signal:**

        void ****geometryChanged** ** ()

        **See also** **geometry** () and **resize** ().
        """
        ...

    def setLayout(self, layout: PySide6.QtWidgets.QGraphicsLayout) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicswidget.html#setLayout

        **void QGraphicsWidget::setLayout(QGraphicsLayout * layout )**

        Sets the layout for this widget to **layout**. Any existing layout
        manager is deleted before the new layout is assigned. If **layout** is
        `nullptr`, the widget is left without a layout. Existing subwidgets'
        geometries will remain unaffected.

        All widgets that are currently managed by **layout** or all of its
        sublayouts, are automatically reparented to this item. The layout is
        then invalidated, and the child widget geometries are adjusted according
        to this item's **geometry** () and contentsMargins(). Children who are
        not explicitly managed by **layout** remain unaffected by the layout
        after it has been assigned to this widget.

        **QGraphicsWidget**  takes ownership of **layout**.

        **Note:** Setter function for property **layout** .

        **See also** **layout** (), **QGraphicsLinearLayout::addItem** (), and
        **QGraphicsLayout::invalidate** ().
        """
        ...

    def setLayoutDirection(self, direction: PySide6.QtCore.Qt.LayoutDirection) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicswidget.html#layoutDirection-prop

        **layoutDirection : Qt::LayoutDirection**

        This property holds the layout direction for this widget.

        This property modifies this widget's and all of its descendants'
        **Qt::WA_RightToLeft**  attribute. It also sets this widget's
        **Qt::WA_SetLayoutDirection**  attribute.

        The widget's layout direction determines the order in which the layout
        manager horizontally arranges subwidgets of this widget. The default
        value depends on the language and locale of the application, and is
        typically in the same direction as words are read and written. With
        **Qt::LeftToRight** , the layout starts placing subwidgets from the left
        side of this widget towards the right. **Qt::RightToLeft**  does the
        opposite - the layout will place widgets starting from the right edge
        moving towards the left.

        Subwidgets inherit their layout direction from the parent. Top-level
        widget items inherit their layout direction from
        QGraphicsScene::layoutDirection. If you change a widget's layout
        direction by calling setLayoutDirection(), the widget will send itself a
        **LayoutDirectionChange**  event, and then propagate the new layout
        direction to all its descendants.

        **Access functions:**

        Qt::LayoutDirection **layoutDirection** () const
        void
        **setLayoutDirection** (Qt::LayoutDirection **direction** )
        void
        **unsetLayoutDirection** ()

        **See also** **QWidget::layoutDirection**  and
        **QApplication::layoutDirection** .
        """
        ...

    def setPalette(
        self,
        palette: Union[
            PySide6.QtGui.QPalette, PySide6.QtCore.Qt.GlobalColor, PySide6.QtGui.QColor
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicswidget.html#palette-prop

        **palette : QPalette**

        This property holds the widget's palette

        This property provides the widget's palette. The palette provides colors
        and brushes for color groups (e.g., **QPalette::Button** ) and states
        (e.g., **QPalette::Inactive** ), loosely defining the general look of
        the widget and its children.

        **QPalette**  consists of color groups that have been explicitly
        defined, and groups that are implicitly inherited from the widget's
        parent. Because of this, palette() can return a different palette than
        what has been set with setPalette(). This scheme allows you to define
        single entries in a palette without affecting the palette's inherited
        entries.

        When a widget's palette changes, it resolves its entries against its
        parent widget, or if it doesn't have a parent widget, it resolves
        against the scene. It then sends itself a **PaletteChange**  event, and
        notifies all its descendants so they can resolve their palettes as well.

        By default, this property contains the application's default palette.

        **Access functions:**

        QPalette **palette** () const
        void **setPalette** (const QPalette &
        **palette** )

        **See also** **QGuiApplication::palette** (),
        **QGraphicsScene::palette** , and **QPalette::resolve** ().
        """
        ...

    def setShortcutAutoRepeat(self, id: int, enabled: bool = ...) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicswidget.html#setShortcutAutoRepeat

        **void QGraphicsWidget::setShortcutAutoRepeat(int id , bool enabled =
        true)**

        If **enabled** is true, auto repeat of the shortcut with the given
        **id** is enabled; otherwise it is disabled.

        **See also** **grabShortcut** (), **releaseShortcut** (), and
        **QWidget::setShortcutAutoRepeat** ().
        """
        ...

    def setShortcutEnabled(self, id: int, enabled: bool = ...) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicswidget.html#setShortcutEnabled

        **void QGraphicsWidget::setShortcutEnabled(int id , bool enabled =
        true)**

        If **enabled** is true, the shortcut with the given **id** is enabled;
        otherwise the shortcut is disabled.

        **Warning:** You should not normally need to use this function since
        Qt's shortcut system enables/disables shortcuts automatically as widgets
        become hidden/visible and gain or lose focus. It is best to use
        **QAction**  or **QShortcut**  to handle shortcuts, since they are
        easier to use than this low-level function.

        **See also** **grabShortcut** (), **releaseShortcut** (), and
        **QWidget::setShortcutEnabled** ().
        """
        ...

    def setStyle(self, style: PySide6.QtWidgets.QStyle) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicswidget.html#setStyle

        **void QGraphicsWidget::setStyle(QStyle * style )**

        Sets the widget's style to **style**. **QGraphicsWidget**  does **not**
        take ownership of **style**.

        If no style is assigned, or **style** is `nullptr`, the widget will use
        **QGraphicsScene::style** () (if this has been set). Otherwise the
        widget will use **QApplication::style** ().

        This function sets the **Qt::WA_SetStyle**  attribute if **style** is
        not `nullptr`; otherwise it clears the attribute.

        **See also** **style** ().
        """
        ...

    @staticmethod
    def setTabOrder(
        first: PySide6.QtWidgets.QGraphicsWidget,
        second: PySide6.QtWidgets.QGraphicsWidget,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicswidget.html#setTabOrder

        **[static] void QGraphicsWidget::setTabOrder(QGraphicsWidget * first ,
        QGraphicsWidget * second )**

        Moves the **second** widget around the ring of focus widgets so that
        keyboard focus moves from the **first** widget to the **second** widget
        when the Tab key is pressed.

        Note that since the tab order of the **second** widget is changed, you
        should order a chain like this:

        setTabOrder(a, b); // a to b
            setTabOrder(b, c); // a to b to c
        setTabOrder(c, d); // a to b to c to d

        **not** like this:

        // WRONG
            setTabOrder(c, d); // c to d
            setTabOrder(a, b); // a to
        b AND c to d
            setTabOrder(b, c); // a to b to c, but not c to d

        If **first** is `nullptr`, this indicates that **second** should be the
        first widget to receive input focus should the scene gain Tab focus
        (i.e., the user hits Tab so that focus passes into the scene). If
        **second** is `nullptr`, this indicates that **first** should be the
        first widget to gain focus if the scene gained BackTab focus.

        By default, tab order is defined implicitly using widget creation order.

        **See also** **focusPolicy**  and **Keyboard Focus in Widgets** .
        """
        ...

    def setWindowFlags(self, wFlags: PySide6.QtCore.Qt.WindowFlags) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicswidget.html#windowFlags-prop

        **windowFlags : Qt::WindowFlags**

        This property holds the widget's window flags

        Window flags are a combination of a window type (e.g., **Qt::Dialog** )
        and several flags giving hints on the behavior of the window. The
        behavior is platform-dependent.

        By default, this property contains no window flags.

        Windows are panels. If you set the **Qt::Window**  flag, the ItemIsPanel
        flag will be set automatically. If you clear the **Qt::Window**  flag,
        the ItemIsPanel flag is also cleared. Note that the ItemIsPanel flag can
        be set independently of **Qt::Window** .

        **Access functions:**

        Qt::WindowFlags **windowFlags** () const
        void **setWindowFlags**
        (Qt::WindowFlags **wFlags** )

        **See also** **isWindow** () and **isPanel** ().
        """
        ...

    @overload
    def setWindowFrameMargins(
        self, left: float, top: float, right: float, bottom: float
    ) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicswidget.html#setWindowFrameMargins

        **[since 5.14] void QGraphicsWidget::setWindowFrameMargins(QMarginsF
        margins )**

        Sets the widget's window frame margins to **margins**. The default frame
        margins are provided by the style, and they depend on the current window
        flags.

        If you would like to draw your own window decoration, you can set your
        own frame margins to override the default margins.

        This function was introduced in Qt 5.14.

        **See also** **unsetWindowFrameMargins** (), **getWindowFrameMargins**
        (), and **windowFrameRect** ().
        """
        ...

    @overload
    def setWindowFrameMargins(
        self, margins: Union[PySide6.QtCore.QMarginsF, PySide6.QtCore.QMargins]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicswidget.html#setWindowFrameMargins-1

        **void QGraphicsWidget::setWindowFrameMargins(qreal left , qreal top ,
        qreal right , qreal bottom )**

        This is an overloaded function.

        Sets the widget's window frame margins to **left** , **top** , **right**
        and **bottom**.
        """
        ...

    def setWindowTitle(self, title: str) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicswidget.html#windowTitle-prop

        **windowTitle : QString**

        This property holds the window title (caption).

        This property is only used for windows.

        By default, if no title has been set, this property contains an empty
        string.

        **Access functions:**

        QString **windowTitle** () const
        void **setWindowTitle** (const
        QString & **title** )

        **Member Function Documentation**
        """
        ...

    def shape(self) -> PySide6.QtGui.QPainterPath:
        """
        https://doc.qt.io/qt-6/qgraphicswidget.html#shape

        **[override virtual] QPainterPath QGraphicsWidget::shape() const**

        Reimplements: **QGraphicsItem::shape() const** .
        """
        ...

    def showEvent(self, event: PySide6.QtGui.QShowEvent) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicswidget.html#showEvent

        **[virtual protected] void QGraphicsWidget::showEvent(QShowEvent * event
        )**

        This event handler, for **Show**  events, is delivered before the widget
        has been shown, for example, setVisible(true) has been called for the
        widget or one of its ancestors when the widget was previously hidden.

        You can reimplement this event handler to detect when your widget is
        shown. Calling **QEvent::accept** () or **QEvent::ignore** () on
        **event** has no effect.

        **See also** **hideEvent** (), **QWidget::showEvent** (), and
        **ItemVisibleChange** .
        """
        ...

    def size(self) -> PySide6.QtCore.QSizeF:
        """
        https://doc.qt.io/qt-6/qgraphicswidget.html#size-prop

        **size : QSizeF**

        This property holds the size of the widget

        Calling resize() resizes the widget to a **size** bounded by
        **minimumSize** () and **maximumSize** (). This property only affects
        the widget's width and height (e.g., its right and bottom edges); the
        widget's position and top-left corner remains unaffected.

        Resizing a widget triggers the widget to immediately receive a
        **GraphicsSceneResize**  event with the widget's old and new size. If
        the widget has a layout assigned when this event arrives, the layout
        will be activated and it will automatically update any child widgets's
        geometry.

        This property does not affect any layout of the parent widget. If the
        widget itself is managed by a parent layout; e.g., it has a parent
        widget with a layout assigned, that layout will not activate.

        By default, this property contains a size with zero width and height.

        **Access functions:**

        QSizeF **size** () const
        void **resize** (const QSizeF & **size** )
        void ****resize** ** (qreal **w** , qreal **h** )

        **Notifier signal:**

        void ****geometryChanged** ** ()

        **See also** **setGeometry** (), **QGraphicsSceneResizeEvent** , and
        **QGraphicsLayout** .
        """
        ...

    def sizeHint(
        self,
        which: PySide6.QtCore.Qt.SizeHint,
        constraint: Union[PySide6.QtCore.QSizeF, PySide6.QtCore.QSize] = ...,
    ) -> PySide6.QtCore.QSizeF:
        """
        https://doc.qt.io/qt-6/qgraphicswidget.html#sizeHint

        **[override virtual protected] QSizeF
        QGraphicsWidget::sizeHint(Qt::SizeHint which , const QSizeF & constraint
        = QSizeF()) const**

        Reimplements: **QGraphicsLayoutItem::sizeHint(Qt::SizeHint which, const
        QSizeF &constraint) const** .
        """
        ...

    def style(self) -> PySide6.QtWidgets.QStyle:
        """
        https://doc.qt.io/qt-6/qgraphicswidget.html#style

        **QStyle *QGraphicsWidget::style() const**

        Returns a pointer to the widget's style. If this widget does not have
        any explicitly assigned style, the scene's style is returned instead. In
        turn, if the scene does not have any assigned style, this function
        returns **QApplication::style** ().

        **See also** **setStyle** ().
        """
        ...

    def testAttribute(self, attribute: PySide6.QtCore.Qt.WidgetAttribute) -> bool:
        """
        https://doc.qt.io/qt-6/qgraphicswidget.html#testAttribute

        **bool QGraphicsWidget::testAttribute(Qt::WidgetAttribute attribute )
        const**

        Returns `true` if **attribute** is enabled for this widget; otherwise,
        returns `false`.

        **See also** **setAttribute** ().
        """
        ...

    def type(self) -> int:
        """
        https://doc.qt.io/qt-6/qgraphicswidget.html#type

        **[override virtual] int QGraphicsWidget::type() const**

        Reimplements: **QGraphicsItem::type() const** .
        """
        ...

    def ungrabKeyboardEvent(self, event: PySide6.QtCore.QEvent) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicswidget.html#ungrabKeyboardEvent

        **[virtual protected] void QGraphicsWidget::ungrabKeyboardEvent(QEvent *
        event )**

        This event handler, for **event** , can be reimplemented in a subclass
        to receive notifications for **QEvent::UngrabKeyboard**  events.

        **See also** **ungrabKeyboard** () and **ungrabMouse** ().
        """
        ...

    def ungrabMouseEvent(self, event: PySide6.QtCore.QEvent) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicswidget.html#ungrabMouseEvent

        **[virtual protected] void QGraphicsWidget::ungrabMouseEvent(QEvent *
        event )**

        This event handler, for **event** , can be reimplemented in a subclass
        to receive notifications for **QEvent::UngrabMouse**  events.

        **See also** **ungrabMouse** () and **ungrabKeyboard** ().
        """
        ...

    def unsetLayoutDirection(self) -> None:
        ...

    def unsetWindowFrameMargins(self) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicswidget.html#unsetWindowFrameMargins

        **void QGraphicsWidget::unsetWindowFrameMargins()**

        Resets the window frame margins to the default value, provided by the
        style.

        **See also** **setWindowFrameMargins** (), **getWindowFrameMargins** (),
        and **windowFrameRect** ().
        """
        ...

    def updateGeometry(self) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicswidget.html#updateGeometry

        **[override virtual protected] void QGraphicsWidget::updateGeometry()**

        Reimplements: **QGraphicsLayoutItem::updateGeometry** ().

        If this widget is currently managed by a layout, this function notifies
        the layout that the widget's size hints have changed and the layout may
        need to resize and reposition the widget accordingly.

        Call this function if the widget's **sizeHint** () has changed.

        **See also** **QGraphicsLayout::invalidate** ().
        """
        ...

    def windowFlags(self) -> PySide6.QtCore.Qt.WindowFlags:
        """
        https://doc.qt.io/qt-6/qgraphicswidget.html#windowFlags-prop

        **windowFlags : Qt::WindowFlags**

        This property holds the widget's window flags

        Window flags are a combination of a window type (e.g., **Qt::Dialog** )
        and several flags giving hints on the behavior of the window. The
        behavior is platform-dependent.

        By default, this property contains no window flags.

        Windows are panels. If you set the **Qt::Window**  flag, the ItemIsPanel
        flag will be set automatically. If you clear the **Qt::Window**  flag,
        the ItemIsPanel flag is also cleared. Note that the ItemIsPanel flag can
        be set independently of **Qt::Window** .

        **Access functions:**

        Qt::WindowFlags **windowFlags** () const
        void **setWindowFlags**
        (Qt::WindowFlags **wFlags** )

        **See also** **isWindow** () and **isPanel** ().
        """
        ...

    def windowFrameEvent(self, e: PySide6.QtCore.QEvent) -> bool:
        """
        https://doc.qt.io/qt-6/qgraphicswidget.html#windowFrameEvent

        **[virtual protected] bool QGraphicsWidget::windowFrameEvent(QEvent *
        event )**

        This event handler, for **event** , receives events for the window frame
        if this widget is a window. Its base implementation provides support for
        default window frame interaction such as moving, resizing, etc.

        You can reimplement this handler in a subclass of **QGraphicsWidget**
        to provide your own custom window frame interaction support.

        Returns `true` if **event** has been recognized and processed;
        otherwise, returns `false`.

        **See also** **event** ().
        """
        ...

    def windowFrameGeometry(self) -> PySide6.QtCore.QRectF:
        """
        https://doc.qt.io/qt-6/qgraphicswidget.html#windowFrameGeometry

        **QRectF QGraphicsWidget::windowFrameGeometry() const**

        Returns the widget's geometry in parent coordinates including any window
        frame.

        **See also** **windowFrameRect** (), **getWindowFrameMargins** (), and
        **setWindowFrameMargins** ().
        """
        ...

    def windowFrameRect(self) -> PySide6.QtCore.QRectF:
        """
        https://doc.qt.io/qt-6/qgraphicswidget.html#windowFrameRect

        **QRectF QGraphicsWidget::windowFrameRect() const**

        Returns the widget's local rect including any window frame.

        **See also** **windowFrameGeometry** (), **getWindowFrameMargins** (),
        and **setWindowFrameMargins** ().
        """
        ...

    def windowFrameSectionAt(
        self,
        pos: Union[
            PySide6.QtCore.QPointF,
            PySide6.QtCore.QPoint,
            PySide6.QtGui.QPainterPath.Element,
        ],
    ) -> PySide6.QtCore.Qt.WindowFrameSection:
        """
        https://doc.qt.io/qt-6/qgraphicswidget.html#windowFrameSectionAt

        **[virtual protected] Qt::WindowFrameSection
        QGraphicsWidget::windowFrameSectionAt(const QPointF & pos ) const**

        Returns the window frame section at position **pos** , or
        **Qt::NoSection**  if there is no window frame section at this position.

        This function is used in **QGraphicsWidget** 's base implementation for
        window frame interaction.

        You can reimplement this function if you want to customize how a window
        can be interactively moved or resized. For instance, if you only want to
        allow a window to be resized by the bottom right corner, you can
        reimplement this function to return **Qt::NoSection**  for all sections
        except **Qt::BottomRightSection** .

        **See also** **windowFrameEvent** (), **paintWindowFrame** (), and
        **windowFrameGeometry** ().
        """
        ...

    def windowTitle(self) -> str:
        """
        https://doc.qt.io/qt-6/qgraphicswidget.html#windowTitle-prop

        **windowTitle : QString**

        This property holds the window title (caption).

        This property is only used for windows.

        By default, if no title has been set, this property contains an empty
        string.

        **Access functions:**

        QString **windowTitle** () const
        void **setWindowTitle** (const
        QString & **title** )

        **Member Function Documentation**
        """
        ...

    def windowType(self) -> PySide6.QtCore.Qt.WindowType:
        """
        https://doc.qt.io/qt-6/qgraphicswidget.html#windowType

        **Qt::WindowType QGraphicsWidget::windowType() const**

        Returns the widgets window type.

        **See also** **windowFlags** (), **isWindow** (), and **isPanel** ().
        """
        ...

    @property
    def geometryChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qgraphicswidget.html#geometryChanged

        **[signal] void QGraphicsWidget::geometryChanged()**

        This signal gets emitted whenever the geometry is changed in
        **setGeometry** ().

        **Note:** Notifier signal for property **geometry** . Notifier signal
        for property **size** .
        """
        ...

    @property
    def layoutChanged(self) -> PySide6.QtCore.SignalInstance:
        ...
