"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtWidgets, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import Any, Optional, Union, overload
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets

bytes = str


class QGraphicsPixmapItem(PySide6.QtWidgets.QGraphicsItem):
    """
    https://doc.qt.io/qt-6/qgraphicspixmapitem.html

    **Detailed Description**

    To set the item's pixmap, pass a **QPixmap**  to QGraphicsPixmapItem's
    constructor, or call the **setPixmap** () function. The **pixmap** ()
    function returns the current pixmap.

    QGraphicsPixmapItem uses pixmap's optional alpha mask to provide a
    reasonable implementation of **boundingRect** (), **shape** (), and
    **contains** ().

    ![](images/graphicsview-pixmapitem.png)

    The pixmap is drawn at the item's (0, 0) coordinate, as returned by
    **offset** (). You can change the drawing offset by calling **setOffset**
    ().

    You can set the pixmap's transformation mode by calling
    **setTransformationMode** (). By default, **Qt::FastTransformation**  is
    used, which provides fast, non-smooth scaling. **Qt::SmoothTransformation**
    enables **QPainter::SmoothPixmapTransform**  on the painter, and the quality
    depends on the platform and viewport. The result is usually not as good as
    calling QPixmap::scale() directly. Call **transformationMode** () to get the
    current transformation mode for the item.

    **See also** **QGraphicsPathItem** , **QGraphicsRectItem** ,
    **QGraphicsEllipseItem** , **QGraphicsTextItem** , **QGraphicsPolygonItem**
    , **QGraphicsLineItem** , and **Graphics View Framework** .
    """

    MaskShape: QGraphicsPixmapItem.ShapeMode = ...
    BoundingRectShape: QGraphicsPixmapItem.ShapeMode = ...
    HeuristicMaskShape: QGraphicsPixmapItem.ShapeMode = ...

    class ShapeMode(Enum):
        MaskShape: QGraphicsPixmapItem.ShapeMode = ...
        BoundingRectShape: QGraphicsPixmapItem.ShapeMode = ...
        HeuristicMaskShape: QGraphicsPixmapItem.ShapeMode = ...

    @overload
    def __init__(self, parent: Optional[PySide6.QtWidgets.QGraphicsItem] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicspixmapitem.html#QGraphicsPixmapItem

        **QGraphicsPixmapItem::QGraphicsPixmapItem(QGraphicsItem * parent =
        nullptr)**

        Constructs a QGraphicsPixmapItem. **parent** is passed to
        **QGraphicsItem** 's constructor.

        **See also** **QGraphicsScene::addItem** ().
        """
        ...

    @overload
    def __init__(
        self,
        pixmap: Union[PySide6.QtGui.QPixmap, PySide6.QtGui.QImage, str],
        parent: Optional[PySide6.QtWidgets.QGraphicsItem] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicspixmapitem.html#QGraphicsPixmapItem-1

        **QGraphicsPixmapItem::QGraphicsPixmapItem(const QPixmap & pixmap ,
        QGraphicsItem * parent = nullptr)**

        Constructs a QGraphicsPixmapItem, using **pixmap** as the default
        pixmap. **parent** is passed to **QGraphicsItem** 's constructor.

        **See also** **QGraphicsScene::addItem** ().
        """
        ...

    def boundingRect(self) -> PySide6.QtCore.QRectF:
        """
        https://doc.qt.io/qt-6/qgraphicspixmapitem.html#boundingRect

        **[override virtual] QRectF QGraphicsPixmapItem::boundingRect() const**

        Reimplements: **QGraphicsItem::boundingRect() const** .
        """
        ...

    def contains(
        self,
        point: Union[
            PySide6.QtCore.QPointF,
            PySide6.QtCore.QPoint,
            PySide6.QtGui.QPainterPath.Element,
        ],
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qgraphicspixmapitem.html#contains

        **[override virtual] bool QGraphicsPixmapItem::contains(const QPointF &
        point ) const**

        Reimplements: **QGraphicsItem::contains(const QPointF &point) const** .
        """
        ...

    def extension(self, variant: Any) -> Any:
        ...

    def isObscuredBy(self, item: PySide6.QtWidgets.QGraphicsItem) -> bool:
        """
        https://doc.qt.io/qt-6/qgraphicspixmapitem.html#isObscuredBy

        **[override virtual] bool QGraphicsPixmapItem::isObscuredBy(const
        QGraphicsItem * item ) const**

        Reimplements: **QGraphicsItem::isObscuredBy(const QGraphicsItem *item)
        const** .
        """
        ...

    def offset(self) -> PySide6.QtCore.QPointF:
        """
        https://doc.qt.io/qt-6/qgraphicspixmapitem.html#offset

        **QPointF QGraphicsPixmapItem::offset() const**

        Returns the pixmap item's **offset** , which defines the point of the
        top-left corner of the pixmap, in local coordinates.

        **See also** **setOffset** ().
        """
        ...

    def opaqueArea(self) -> PySide6.QtGui.QPainterPath:
        """
        https://doc.qt.io/qt-6/qgraphicspixmapitem.html#opaqueArea

        **[override virtual] QPainterPath QGraphicsPixmapItem::opaqueArea()
        const**

        Reimplements: **QGraphicsItem::opaqueArea() const** .
        """
        ...

    def paint(
        self,
        painter: PySide6.QtGui.QPainter,
        option: PySide6.QtWidgets.QStyleOptionGraphicsItem,
        widget: PySide6.QtWidgets.QWidget,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicspixmapitem.html#paint

        **[override virtual] void QGraphicsPixmapItem::paint(QPainter * painter
        , const QStyleOptionGraphicsItem * option , QWidget * widget )**

        Reimplements: **QGraphicsItem::paint** (QPainter *painter, const
        QStyleOptionGraphicsItem *option, QWidget *widget).
        """
        ...

    def pixmap(self) -> PySide6.QtGui.QPixmap:
        """
        https://doc.qt.io/qt-6/qgraphicspixmapitem.html#pixmap

        **QPixmap QGraphicsPixmapItem::pixmap() const**

        Returns the item's pixmap, or an invalid **QPixmap**  if no pixmap has
        been set.

        **See also** **setPixmap** ().
        """
        ...

    @overload
    def setOffset(
        self,
        offset: Union[
            PySide6.QtCore.QPointF,
            PySide6.QtCore.QPoint,
            PySide6.QtGui.QPainterPath.Element,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicspixmapitem.html#setOffset

        **void QGraphicsPixmapItem::setOffset(const QPointF & offset )**

        Sets the pixmap item's offset to **offset**. **QGraphicsPixmapItem**
        will draw its pixmap using **offset** for its top-left corner.

        **See also** **offset** ().
        """
        ...

    @overload
    def setOffset(self, x: float, y: float) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicspixmapitem.html#setOffset-1

        **void QGraphicsPixmapItem::setOffset(qreal x , qreal y )**

        This convenience function is equivalent to calling setOffset(**QPointF**
        ( **x** , **y** )).
        """
        ...

    def setPixmap(
        self, pixmap: Union[PySide6.QtGui.QPixmap, PySide6.QtGui.QImage, str]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicspixmapitem.html#setPixmap

        **void QGraphicsPixmapItem::setPixmap(const QPixmap & pixmap )**

        Sets the item's pixmap to **pixmap**.

        **See also** **pixmap** ().
        """
        ...

    def setShapeMode(
        self, mode: PySide6.QtWidgets.QGraphicsPixmapItem.ShapeMode
    ) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicspixmapitem.html#setShapeMode

        **void QGraphicsPixmapItem::setShapeMode(QGraphicsPixmapItem::ShapeMode
        mode )**

        Sets the item's shape mode to **mode**. The shape mode describes how
        **QGraphicsPixmapItem**  calculates its shape. The default mode is
        **MaskShape** .

        **See also** **shapeMode** () and **ShapeMode** .
        """
        ...

    def setTransformationMode(self, mode: PySide6.QtCore.Qt.TransformationMode) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicspixmapitem.html#setTransformationMode

        **void QGraphicsPixmapItem::setTransformationMode(Qt::TransformationMode
        mode )**

        Sets the pixmap item's transformation mode to **mode** , and toggles an
        update of the item. The default mode is **Qt::FastTransformation** ,
        which provides quick transformation with no smoothing.

        **Qt::SmoothTransformation**  enables
        **QPainter::SmoothPixmapTransform**  on the painter, and the quality
        depends on the platform and viewport. The result is usually not as good
        as calling QPixmap::scale() directly.

        **See also** **transformationMode** ().
        """
        ...

    def shape(self) -> PySide6.QtGui.QPainterPath:
        """
        https://doc.qt.io/qt-6/qgraphicspixmapitem.html#shape

        **[override virtual] QPainterPath QGraphicsPixmapItem::shape() const**

        Reimplements: **QGraphicsItem::shape() const** .
        """
        ...

    def shapeMode(self) -> PySide6.QtWidgets.QGraphicsPixmapItem.ShapeMode:
        """
        https://doc.qt.io/qt-6/qgraphicspixmapitem.html#shapeMode

        **QGraphicsPixmapItem::ShapeMode QGraphicsPixmapItem::shapeMode()
        const**

        Returns the item's shape mode. The shape mode describes how
        **QGraphicsPixmapItem**  calculates its shape. The default mode is
        **MaskShape** .

        **See also** **setShapeMode** () and **ShapeMode** .
        """
        ...

    def transformationMode(self) -> PySide6.QtCore.Qt.TransformationMode:
        """
        https://doc.qt.io/qt-6/qgraphicspixmapitem.html#transformationMode

        **Qt::TransformationMode QGraphicsPixmapItem::transformationMode()
        const**

        Returns the transformation mode of the pixmap. The default mode is
        **Qt::FastTransformation** , which provides quick transformation with no
        smoothing.

        **See also** **setTransformationMode** ().
        """
        ...

    def type(self) -> int:
        """
        https://doc.qt.io/qt-6/qgraphicspixmapitem.html#type

        **[override virtual] int QGraphicsPixmapItem::type() const**

        Reimplements: **QGraphicsItem::type() const** .
        """
        ...
