"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtWidgets, except for defaults which are replaced by "...".
"""
from typing import Optional, Union, overload
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets

bytes = str


class QGraphicsLinearLayout(PySide6.QtWidgets.QGraphicsLayout):
    """
    https://doc.qt.io/qt-6/qgraphicslinearlayout.html

    **Detailed Description**

    The default orientation for a linear layout is **Qt::Horizontal** . You can
    choose a vertical orientation either by calling **setOrientation** (), or by
    passing **Qt::Vertical**  to QGraphicsLinearLayout's constructor.

    The most common way to use QGraphicsLinearLayout is to construct an object
    on the heap with no parent, add widgets and layouts by calling **addItem**
    (), and finally assign the layout to a widget by calling
    **QGraphicsWidget::setLayout** ().

    **QGraphicsScene**  scene;
        **QGraphicsWidget**  *textEdit =
    scene.addWidget(new **QTextEdit** );
        **QGraphicsWidget**  *pushButton =
    scene.addWidget(new **QPushButton** );

        **QGraphicsLinearLayout**
    *layout = new **QGraphicsLinearLayout** ;
        layout->addItem(textEdit);
    layout->addItem(pushButton);

        **QGraphicsWidget**  *form = new
    **QGraphicsWidget** ;
        form->setLayout(layout);
        scene.addItem(form);

    You can add widgets, layouts, stretches (**addStretch** (),
    **insertStretch** () or **setStretchFactor** ()), and spacings
    (**setItemSpacing** ()) to a linear layout. The layout takes ownership of
    the items. In some cases when the layout item also inherits from
    **QGraphicsItem**  (such as **QGraphicsWidget** ) there will be a ambiguity
    in ownership because the layout item belongs to two ownership hierarchies.
    See the documentation of **QGraphicsLayoutItem::setOwnedByLayout** () how to
    handle this. You can access each item in the layout by calling **count** ()
    and **itemAt** (). Calling **removeAt** () or **removeItem** () will remove
    an item from the layout, without destroying it.

    **Size Hints and Size Policies in QGraphicsLinearLayout**

    QGraphicsLinearLayout respects each item's size hints and size policies, and
    when the layout contains more space than the items can fill, each item is
    arranged according to the layout's alignment for that item. You can set an
    alignment for each item by calling **setAlignment** (), and check the
    alignment for any item by calling **alignment** (). By default, items are
    aligned to the top left.

    **Spacing within QGraphicsLinearLayout**

    Between the items, the layout distributes some space. The actual amount of
    space depends on the managed widget's current style, but the common spacing
    is 4. You can also set your own spacing by calling **setSpacing** (), and
    get the current spacing value by calling **spacing** (). If you want to
    configure individual spacing for your items, you can call **setItemSpacing**
    ().

    **Stretch Factor in QGraphicsLinearLayout**

    You can assign a stretch factor to each item to control how much space it
    will get compared to the other items. By default, two identical widgets
    arranged in a linear layout will have the same size, but if the first widget
    has a stretch factor of 1 and the second widget has a stretch factor of 2,
    the first widget will get 1/3 of the available space, and the second will
    get 2/3.

    QGraphicsLinearLayout calculates the distribution of sizes by adding up the
    stretch factors of all items, and then dividing the available space
    accordingly. The default stretch factor is 0 for all items; a factor of 0
    means the item does not have any defined stretch factor; effectively this is
    the same as setting the stretch factor to 1. The stretch factor only applies
    to the available space in the lengthwise direction of the layout (following
    its orientation). If you want to control both the item's horizontal and
    vertical stretch, you can use **QGraphicsGridLayout**  instead.

    **QGraphicsLinearLayout Compared to Other Layouts**

    QGraphicsLinearLayout is very similar to **QVBoxLayout**  and
    **QHBoxLayout** , but in contrast to these classes, it is used to manage
    **QGraphicsWidget**  and **QGraphicsLayout**  instead of **QWidget**  and
    **QLayout** .

    **See also** **QGraphicsGridLayout**  and **QGraphicsWidget** .
    """

    @overload
    def __init__(
        self,
        orientation: PySide6.QtCore.Qt.Orientation,
        parent: Optional[PySide6.QtWidgets.QGraphicsLayoutItem] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicslinearlayout.html#QGraphicsLinearLayout

        **QGraphicsLinearLayout::QGraphicsLinearLayout(QGraphicsLayoutItem *
        parent = nullptr)**

        Constructs a QGraphicsLinearLayout instance using **Qt::Horizontal**
        orientation. **parent** is passed to **QGraphicsLayout** 's constructor.
        """
        ...

    @overload
    def __init__(
        self, parent: Optional[PySide6.QtWidgets.QGraphicsLayoutItem] = ...
    ) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicslinearlayout.html#QGraphicsLinearLayout-
        1

        **QGraphicsLinearLayout::QGraphicsLinearLayout(Qt::Orientation
        orientation , QGraphicsLayoutItem * parent = nullptr)**

        Constructs a QGraphicsLinearLayout instance. You can pass the
        **orientation** for the layout, either horizontal or vertical, and
        **parent** is passed to **QGraphicsLayout** 's constructor.
        """
        ...

    def addItem(self, item: PySide6.QtWidgets.QGraphicsLayoutItem) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicslinearlayout.html#addItem

        **void QGraphicsLinearLayout::addItem(QGraphicsLayoutItem * item )**

        This convenience function is equivalent to calling **insertItem** (-1,
        **item** ).
        """
        ...

    def addStretch(self, stretch: int = ...) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicslinearlayout.html#addStretch

        **void QGraphicsLinearLayout::addStretch(int stretch = 1)**

        This convenience function is equivalent to calling **insertStretch**
        (-1, **stretch** ).
        """
        ...

    def alignment(
        self, item: PySide6.QtWidgets.QGraphicsLayoutItem
    ) -> PySide6.QtCore.Qt.Alignment:
        """
        https://doc.qt.io/qt-6/qgraphicslinearlayout.html#alignment

        **Qt::Alignment QGraphicsLinearLayout::alignment(QGraphicsLayoutItem *
        item ) const**

        Returns the alignment for **item**. The default alignment is
        **Qt::AlignTop**  | **Qt::AlignLeft** .

        The alignment decides how the item is positioned within its assigned
        space in the case where there's more space available in the layout than
        the widgets can occupy.

        **See also** **setAlignment** ().
        """
        ...

    def count(self) -> int:
        """
        https://doc.qt.io/qt-6/qgraphicslinearlayout.html#count

        **[override virtual] int QGraphicsLinearLayout::count() const**

        Reimplements: **QGraphicsLayout::count() const** .
        """
        ...

    def dump(self, indent: int = ...) -> None:
        ...

    def insertItem(
        self, index: int, item: PySide6.QtWidgets.QGraphicsLayoutItem
    ) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicslinearlayout.html#insertItem

        **void QGraphicsLinearLayout::insertItem(int index , QGraphicsLayoutItem
        * item )**

        Inserts **item** into the layout at **index** , or before any item that
        is currently at **index**.

        **See also** **addItem** (), **itemAt** (), **insertStretch** (), and
        **setItemSpacing** ().
        """
        ...

    def insertStretch(self, index: int, stretch: int = ...) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicslinearlayout.html#insertStretch

        **void QGraphicsLinearLayout::insertStretch(int index , int stretch =
        1)**

        Inserts a stretch of **stretch** at **index** , or before any item that
        is currently at **index**.

        **See also** **addStretch** (), **setStretchFactor** (),
        **setItemSpacing** (), and **insertItem** ().
        """
        ...

    def invalidate(self) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicslinearlayout.html#invalidate

        **[override virtual] void QGraphicsLinearLayout::invalidate()**

        Reimplements: **QGraphicsLayout::invalidate** ().
        """
        ...

    def itemAt(self, index: int) -> PySide6.QtWidgets.QGraphicsLayoutItem:
        """
        https://doc.qt.io/qt-6/qgraphicslinearlayout.html#itemAt

        **[override virtual] QGraphicsLayoutItem
        *QGraphicsLinearLayout::itemAt(int index ) const**

        Reimplements: **QGraphicsLayout::itemAt(int i) const** .

        When iterating from 0 and up, it will return the items in the visual
        arranged order.
        """
        ...

    def itemSpacing(self, index: int) -> float:
        """
        https://doc.qt.io/qt-6/qgraphicslinearlayout.html#itemSpacing

        **qreal QGraphicsLinearLayout::itemSpacing(int index ) const**

        Returns the spacing after item at **index**.

        **See also** **setItemSpacing** ().
        """
        ...

    def orientation(self) -> PySide6.QtCore.Qt.Orientation:
        """
        https://doc.qt.io/qt-6/qgraphicslinearlayout.html#orientation

        **Qt::Orientation QGraphicsLinearLayout::orientation() const**

        Returns the layout orientation.

        **See also** **setOrientation** ().
        """
        ...

    def removeAt(self, index: int) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicslinearlayout.html#removeAt

        **[override virtual] void QGraphicsLinearLayout::removeAt(int index )**

        Reimplements: **QGraphicsLayout::removeAt** (int index).

        Removes the item at **index** without destroying it. Ownership of the
        item is transferred to the caller.

        **See also** **removeItem** () and **insertItem** ().
        """
        ...

    def removeItem(self, item: PySide6.QtWidgets.QGraphicsLayoutItem) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicslinearlayout.html#removeItem

        **void QGraphicsLinearLayout::removeItem(QGraphicsLayoutItem * item )**

        Removes **item** from the layout without destroying it. Ownership of
        **item** is transferred to the caller.

        **See also** **removeAt** () and **insertItem** ().
        """
        ...

    def setAlignment(
        self,
        item: PySide6.QtWidgets.QGraphicsLayoutItem,
        alignment: PySide6.QtCore.Qt.Alignment,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicslinearlayout.html#setAlignment

        **void QGraphicsLinearLayout::setAlignment(QGraphicsLayoutItem * item ,
        Qt::Alignment alignment )**

        Sets the alignment of **item** to **alignment**. If **item** 's
        alignment changes, the layout is automatically invalidated.

        **See also** **alignment** () and **invalidate** ().
        """
        ...

    def setGeometry(
        self, rect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicslinearlayout.html#setGeometry

        **[override virtual] void QGraphicsLinearLayout::setGeometry(const
        QRectF & rect )**

        Reimplements: **QGraphicsLayoutItem::setGeometry** (const QRectF &rect).
        """
        ...

    def setItemSpacing(self, index: int, spacing: float) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicslinearlayout.html#setItemSpacing

        **void QGraphicsLinearLayout::setItemSpacing(int index , qreal spacing
        )**

        Sets the spacing after item at **index** to **spacing**.

        **See also** **itemSpacing** ().
        """
        ...

    def setOrientation(self, orientation: PySide6.QtCore.Qt.Orientation) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicslinearlayout.html#setOrientation

        **void QGraphicsLinearLayout::setOrientation(Qt::Orientation orientation
        )**

        Change the layout orientation to **orientation**. Changing the layout
        orientation will automatically invalidate the layout.

        **See also** **orientation** ().
        """
        ...

    def setSpacing(self, spacing: float) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicslinearlayout.html#setSpacing

        **void QGraphicsLinearLayout::setSpacing(qreal spacing )**

        Sets the layout's spacing to **spacing**. Spacing refers to the vertical
        and horizontal distances between items.

        **See also** **spacing** (), **setItemSpacing** (), **setStretchFactor**
        (), and **QGraphicsGridLayout::setSpacing** ().
        """
        ...

    def setStretchFactor(
        self, item: PySide6.QtWidgets.QGraphicsLayoutItem, stretch: int
    ) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicslinearlayout.html#setStretchFactor

        **void QGraphicsLinearLayout::setStretchFactor(QGraphicsLayoutItem *
        item , int stretch )**

        Sets the stretch factor for **item** to **stretch**. If an item's
        stretch factor changes, this function will invalidate the layout.

        Setting **stretch** to 0 removes the stretch factor from the item, and
        is effectively equivalent to setting **stretch** to 1.

        **See also** **stretchFactor** ().
        """
        ...

    def sizeHint(
        self,
        which: PySide6.QtCore.Qt.SizeHint,
        constraint: Union[PySide6.QtCore.QSizeF, PySide6.QtCore.QSize] = ...,
    ) -> PySide6.QtCore.QSizeF:
        """
        https://doc.qt.io/qt-6/qgraphicslinearlayout.html#sizeHint

        **[override virtual] QSizeF QGraphicsLinearLayout::sizeHint(Qt::SizeHint
        which , const QSizeF & constraint = QSizeF()) const**

        Reimplements: **QGraphicsLayoutItem::sizeHint(Qt::SizeHint which, const
        QSizeF &constraint) const** .
        """
        ...

    def spacing(self) -> float:
        """
        https://doc.qt.io/qt-6/qgraphicslinearlayout.html#spacing

        **qreal QGraphicsLinearLayout::spacing() const**

        Returns the layout's spacing. Spacing refers to the vertical and
        horizontal distances between items.

        **See also** **setSpacing** ().
        """
        ...

    def stretchFactor(self, item: PySide6.QtWidgets.QGraphicsLayoutItem) -> int:
        """
        https://doc.qt.io/qt-6/qgraphicslinearlayout.html#stretchFactor

        **int QGraphicsLinearLayout::stretchFactor(QGraphicsLayoutItem * item )
        const**

        Returns the stretch factor for **item**. The default stretch factor is
        0, meaning that the item has no assigned stretch factor.

        **See also** **setStretchFactor** ().
        """
        ...
