"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtWidgets, except for defaults which are replaced by "...".
"""
from typing import List, Optional, Tuple, Union
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets

bytes = str


class QGraphicsItemAnimation(PySide6.QtCore.QObject):
    """
    https://doc.qt.io/qt-6/qgraphicsitemanimation.html

    **Detailed Description**

    The QGraphicsItemAnimation class animates a **QGraphicsItem** . You can
    schedule changes to the item's transformation matrix at specified steps. The
    QGraphicsItemAnimation class has a current step value. When this value
    changes the transformations scheduled at that step are performed. The
    current step of the animation is set with the `setStep()` function.

    QGraphicsItemAnimation will do a simple linear interpolation between the
    nearest adjacent scheduled changes to calculate the matrix. For instance, if
    you set the position of an item at values 0.0 and 1.0, the animation will
    show the item moving in a straight line between these positions. The same is
    true for scaling and rotation.

    It is usual to use the class with a **QTimeLine** . The timeline's
    **valueChanged** () signal is then connected to the `setStep()` slot. For
    example, you can set up an item for rotation by calling `setRotationAt()`
    for different step values. The animations timeline is set with the
    **setTimeLine** () function.

    An example animation with a timeline follows:

    **QGraphicsItem**  *ball = new **QGraphicsEllipseItem** (0, 0, 20, 20);
    **QTimeLine**  *timer = new **QTimeLine** (5000);
    timer->setFrameRange(0, 100);

            **QGraphicsItemAnimation**
    *animation = new **QGraphicsItemAnimation** ;
    animation->setItem(ball);
            animation->setTimeLine(timer);
    for (int i = 0; i < 200; ++i)
                animation->setPosAt(i / 200.0,
    **QPointF** (i, i));

            **QGraphicsScene**  *scene = new
    **QGraphicsScene** ;
            scene->setSceneRect(0, 0, 250, 250);
    scene->addItem(ball);

            **QGraphicsView**  *view = new
    **QGraphicsView** (scene);
            view->show();
    timer->start();

    Note that steps lie between 0.0 and 1.0. It may be necessary to use
    **setUpdateInterval** (). The default update interval is 40 ms. A scheduled
    transformation cannot be removed when set, so scheduling several
    transformations of the same kind (e.g., rotations) at the same step is not
    recommended.

    **See also** **QTimeLine**  and **Graphics View Framework** .
    """

    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicsitemanimation.html#QGraphicsItemAnimatio
        n

        **QGraphicsItemAnimation::QGraphicsItemAnimation(QObject * parent =
        nullptr)**

        Constructs an animation object with the given **parent**.
        """
        ...

    def afterAnimationStep(self, step: float) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicsitemanimation.html#afterAnimationStep

        **[virtual protected] void
        QGraphicsItemAnimation::afterAnimationStep(qreal step )**

        This method is meant to be overridden in subclasses that need to execute
        additional code after a new step has taken place. The animation **step**
        is provided for use in cases where the action depends on its value.
        """
        ...

    def beforeAnimationStep(self, step: float) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicsitemanimation.html#beforeAnimationStep

        **[virtual protected] void
        QGraphicsItemAnimation::beforeAnimationStep(qreal step )**

        This method is meant to be overridden by subclassed that needs to
        execute additional code before a new step takes place. The animation
        **step** is provided for use in cases where the action depends on its
        value.
        """
        ...

    def clear(self) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicsitemanimation.html#clear

        **void QGraphicsItemAnimation::clear()**

        Clears the scheduled transformations used for the animation, but retains
        the item and timeline.
        """
        ...

    def horizontalScaleAt(self, step: float) -> float:
        """
        https://doc.qt.io/qt-6/qgraphicsitemanimation.html#horizontalScaleAt

        **qreal QGraphicsItemAnimation::horizontalScaleAt(qreal step ) const**

        Returns the horizontal scale for the item at the specified **step**
        value.

        **See also** **setScaleAt** ().
        """
        ...

    def horizontalShearAt(self, step: float) -> float:
        """
        https://doc.qt.io/qt-6/qgraphicsitemanimation.html#horizontalShearAt

        **qreal QGraphicsItemAnimation::horizontalShearAt(qreal step ) const**

        Returns the horizontal shear for the item at the specified **step**
        value.

        **See also** **setShearAt** ().
        """
        ...

    def item(self) -> PySide6.QtWidgets.QGraphicsItem:
        """
        https://doc.qt.io/qt-6/qgraphicsitemanimation.html#item

        **QGraphicsItem *QGraphicsItemAnimation::item() const**

        Returns the item on which the animation object operates.

        **See also** **setItem** ().
        """
        ...

    def posAt(self, step: float) -> PySide6.QtCore.QPointF:
        """
        https://doc.qt.io/qt-6/qgraphicsitemanimation.html#posAt

        **QPointF QGraphicsItemAnimation::posAt(qreal step ) const**

        Returns the position of the item at the given **step** value.

        **See also** **setPosAt** ().
        """
        ...

    def posList(self) -> List[Tuple[float, PySide6.QtCore.QPointF]]:
        """
        https://doc.qt.io/qt-6/qgraphicsitemanimation.html#posList

        **QList<QPair<qreal, QPointF> > QGraphicsItemAnimation::posList()
        const**

        Returns all explicitly inserted positions.

        **See also** **posAt** () and **setPosAt** ().
        """
        ...

    def rotationAt(self, step: float) -> float:
        """
        https://doc.qt.io/qt-6/qgraphicsitemanimation.html#rotationAt

        **qreal QGraphicsItemAnimation::rotationAt(qreal step ) const**

        Returns the angle at which the item is rotated at the specified **step**
        value.

        **See also** **setRotationAt** ().
        """
        ...

    def rotationList(self) -> List[Tuple[float, float]]:
        """
        https://doc.qt.io/qt-6/qgraphicsitemanimation.html#rotationList

        **QList<QPair<qreal, qreal> > QGraphicsItemAnimation::rotationList()
        const**

        Returns all explicitly inserted rotations.

        **See also** **rotationAt** () and **setRotationAt** ().
        """
        ...

    def scaleList(self) -> List[Tuple[float, PySide6.QtCore.QPointF]]:
        """
        https://doc.qt.io/qt-6/qgraphicsitemanimation.html#scaleList

        **QList<QPair<qreal, QPointF> > QGraphicsItemAnimation::scaleList()
        const**

        Returns all explicitly inserted scales.

        **See also** **verticalScaleAt** (), **horizontalScaleAt** (), and
        **setScaleAt** ().
        """
        ...

    def setItem(self, item: PySide6.QtWidgets.QGraphicsItem) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicsitemanimation.html#setItem

        **void QGraphicsItemAnimation::setItem(QGraphicsItem * item )**

        Sets the specified **item** to be used in the animation.

        **See also** **item** ().
        """
        ...

    def setPosAt(
        self,
        step: float,
        pos: Union[
            PySide6.QtCore.QPointF,
            PySide6.QtCore.QPoint,
            PySide6.QtGui.QPainterPath.Element,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicsitemanimation.html#setPosAt

        **void QGraphicsItemAnimation::setPosAt(qreal step , const QPointF &
        point )**

        Sets the position of the item at the given **step** value to the
        **point** specified.

        **See also** **posAt** ().
        """
        ...

    def setRotationAt(self, step: float, angle: float) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicsitemanimation.html#setRotationAt

        **void QGraphicsItemAnimation::setRotationAt(qreal step , qreal angle
        )**

        Sets the rotation of the item at the given **step** value to the
        **angle** specified.

        **See also** **rotationAt** ().
        """
        ...

    def setScaleAt(self, step: float, sx: float, sy: float) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicsitemanimation.html#setScaleAt

        **void QGraphicsItemAnimation::setScaleAt(qreal step , qreal sx , qreal
        sy )**

        Sets the scale of the item at the given **step** value using the
        horizontal and vertical scale factors specified by **sx** and **sy**.

        **See also** **verticalScaleAt** () and **horizontalScaleAt** ().
        """
        ...

    def setShearAt(self, step: float, sh: float, sv: float) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicsitemanimation.html#setShearAt

        **void QGraphicsItemAnimation::setShearAt(qreal step , qreal sh , qreal
        sv )**

        Sets the shear of the item at the given **step** value using the
        horizontal and vertical shear factors specified by **sh** and **sv**.

        **See also** **verticalShearAt** () and **horizontalShearAt** ().
        """
        ...

    def setStep(self, x: float) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicsitemanimation.html#setStep

        **[slot] void QGraphicsItemAnimation::setStep(qreal step )**

        Sets the current **step** value for the animation, causing the
        transformations scheduled at this step to be performed.
        """
        ...

    def setTimeLine(self, timeLine: PySide6.QtCore.QTimeLine) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicsitemanimation.html#setTimeLine

        **void QGraphicsItemAnimation::setTimeLine(QTimeLine * timeLine )**

        Sets the timeline object used to control the rate of animation to the
        **timeLine** specified.

        **See also** **timeLine** ().
        """
        ...

    def setTranslationAt(self, step: float, dx: float, dy: float) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicsitemanimation.html#setTranslationAt

        **void QGraphicsItemAnimation::setTranslationAt(qreal step , qreal dx ,
        qreal dy )**

        Sets the translation of the item at the given **step** value using the
        horizontal and vertical coordinates specified by **dx** and **dy**.

        **See also** **xTranslationAt** () and **yTranslationAt** ().
        """
        ...

    def shearList(self) -> List[Tuple[float, PySide6.QtCore.QPointF]]:
        """
        https://doc.qt.io/qt-6/qgraphicsitemanimation.html#shearList

        **QList<QPair<qreal, QPointF> > QGraphicsItemAnimation::shearList()
        const**

        Returns all explicitly inserted shears.

        **See also** **verticalShearAt** (), **horizontalShearAt** (), and
        **setShearAt** ().
        """
        ...

    def timeLine(self) -> PySide6.QtCore.QTimeLine:
        """
        https://doc.qt.io/qt-6/qgraphicsitemanimation.html#timeLine

        **QTimeLine *QGraphicsItemAnimation::timeLine() const**

        Returns the timeline object used to control the rate at which the
        animation occurs.

        **See also** **setTimeLine** ().
        """
        ...

    def transformAt(self, step: float) -> PySide6.QtGui.QTransform:
        """
        https://doc.qt.io/qt-6/qgraphicsitemanimation.html#transformAt

        **[since 5.14] QTransform QGraphicsItemAnimation::transformAt(qreal step
        ) const**

        Returns the transform used for the item at the specified **step** value.

        This function was introduced in Qt 5.14.
        """
        ...

    def translationList(self) -> List[Tuple[float, PySide6.QtCore.QPointF]]:
        """
        https://doc.qt.io/qt-6/qgraphicsitemanimation.html#translationList

        **QList<QPair<qreal, QPointF> >
        QGraphicsItemAnimation::translationList() const**

        Returns all explicitly inserted translations.

        **See also** **xTranslationAt** (), **yTranslationAt** (), and
        **setTranslationAt** ().
        """
        ...

    def verticalScaleAt(self, step: float) -> float:
        """
        https://doc.qt.io/qt-6/qgraphicsitemanimation.html#verticalScaleAt

        **qreal QGraphicsItemAnimation::verticalScaleAt(qreal step ) const**

        Returns the vertical scale for the item at the specified **step** value.

        **See also** **setScaleAt** ().
        """
        ...

    def verticalShearAt(self, step: float) -> float:
        """
        https://doc.qt.io/qt-6/qgraphicsitemanimation.html#verticalShearAt

        **qreal QGraphicsItemAnimation::verticalShearAt(qreal step ) const**

        Returns the vertical shear for the item at the specified **step** value.

        **See also** **setShearAt** ().
        """
        ...

    def xTranslationAt(self, step: float) -> float:
        """
        https://doc.qt.io/qt-6/qgraphicsitemanimation.html#xTranslationAt

        **qreal QGraphicsItemAnimation::xTranslationAt(qreal step ) const**

        Returns the horizontal translation of the item at the specified **step**
        value.

        **See also** **setTranslationAt** ().
        """
        ...

    def yTranslationAt(self, step: float) -> float:
        """
        https://doc.qt.io/qt-6/qgraphicsitemanimation.html#yTranslationAt

        **qreal QGraphicsItemAnimation::yTranslationAt(qreal step ) const**

        Returns the vertical translation of the item at the specified **step**
        value.

        **See also** **setTranslationAt** ().
        """
        ...
