"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtWidgets, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import Optional, Union
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets

bytes = str


class QGraphicsEffect(PySide6.QtCore.QObject):
    """
    https://doc.qt.io/qt-6/qgraphicseffect.html

    **Detailed Description**

    Effects alter the appearance of elements by hooking into the rendering
    pipeline and operating between the source (e.g., a **QGraphicsPixmapItem** )
    and the destination device (e.g., **QGraphicsView** 's viewport). Effects
    can be disabled by calling **setEnabled** (false). If effects are disabled,
    the source is rendered directly.

    To add a visual effect to a **QGraphicsItem** , for example, you can use one
    of the standard effects, or alternately, create your own effect by creating
    a subclass of QGraphicsEffect. The effect can then be installed on the item
    using **QGraphicsItem::setGraphicsEffect** ().

    Qt provides the following standard effects:

    * **QGraphicsBlurEffect**  \\- blurs the item by a given radius
      *
    **QGraphicsDropShadowEffect**  \\- renders a dropshadow behind the item
      *
    **QGraphicsColorizeEffect**  \\- renders the item in shades of any given
    color
      * **QGraphicsOpacityEffect**  \\- renders the item with an opacity

    ![](images/graphicseffect-plain.png)

    ![](images/graphicseffect-
    blur.png)

    ![](images/graphicseffect-colorize.png)
    ![](images/graphicseffect-opacity.png)

    ![](images/graphicseffect-drop-
    shadow.png)

    ![](images/graphicseffect-widget.png)

    For more information on how to use each effect, refer to the specific
    effect's documentation.

    To create your own custom effect, create a subclass of QGraphicsEffect (or
    any other existing effects) and reimplement the virtual function **draw**
    (). This function is called whenever the effect needs to redraw. The
    **draw** () function takes the painter with which to draw as an argument.
    For more information, refer to the documentation for **draw** (). In the
    **draw** () function you can call **sourcePixmap** () to get a pixmap of the
    graphics effect source which you can then process.

    If your effect changes, use **update** () to request for a redraw. If your
    custom effect changes the bounding rectangle of the source, e.g., a radial
    glow effect may need to apply an extra margin, you can reimplement the
    virtual **boundingRectFor** () function, and call **updateBoundingRect** ()
    to notify the framework whenever this rectangle changes. The virtual
    **sourceChanged** () function is called to notify the effects that the
    source has changed in some way - e.g., if the source is a
    **QGraphicsRectItem**  and its rectangle parameters have changed.

    **See also** **QGraphicsItem::setGraphicsEffect** () and
    **QWidget::setGraphicsEffect** ().
    """

    SourceAttached: QGraphicsEffect.ChangeFlag = ...
    SourceDetached: QGraphicsEffect.ChangeFlag = ...
    SourceBoundingRectChanged: QGraphicsEffect.ChangeFlag = ...
    SourceInvalidated: QGraphicsEffect.ChangeFlag = ...
    NoPad: QGraphicsEffect.PixmapPadMode = ...
    PadToTransparentBorder: QGraphicsEffect.PixmapPadMode = ...
    PadToEffectiveBoundingRect: QGraphicsEffect.PixmapPadMode = ...

    class ChangeFlag(Enum):
        SourceAttached: QGraphicsEffect.ChangeFlag = ...
        SourceDetached: QGraphicsEffect.ChangeFlag = ...
        SourceBoundingRectChanged: QGraphicsEffect.ChangeFlag = ...
        SourceInvalidated: QGraphicsEffect.ChangeFlag = ...

    class ChangeFlags(object):
        ...

    class PixmapPadMode(Enum):
        NoPad: QGraphicsEffect.PixmapPadMode = ...
        PadToTransparentBorder: QGraphicsEffect.PixmapPadMode = ...
        PadToEffectiveBoundingRect: QGraphicsEffect.PixmapPadMode = ...

    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicseffect.html#QGraphicsEffect

        **QGraphicsEffect::QGraphicsEffect(QObject * parent = nullptr)**

        Constructs a new QGraphicsEffect instance having the specified
        **parent**.
        """
        ...

    def boundingRect(self) -> PySide6.QtCore.QRectF:
        """
        https://doc.qt.io/qt-6/qgraphicseffect.html#boundingRect

        **QRectF QGraphicsEffect::boundingRect() const**

        Returns the effective bounding rectangle for this effect, i.e., the
        bounding rectangle of the source in device coordinates, adjusted by any
        margins applied by the effect itself.

        **See also** **boundingRectFor** () and **updateBoundingRect** ().
        """
        ...

    def boundingRectFor(
        self, sourceRect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect]
    ) -> PySide6.QtCore.QRectF:
        """
        https://doc.qt.io/qt-6/qgraphicseffect.html#boundingRectFor

        **[virtual] QRectF QGraphicsEffect::boundingRectFor(const QRectF & rect
        ) const**

        Returns the effective bounding rectangle for this effect, given the
        provided **rect** in the device coordinates. When writing you own custom
        effect, you must call **updateBoundingRect** () whenever any parameters
        are changed that may cause this this function to return a different
        value.

        **See also** **sourceBoundingRect** ().
        """
        ...

    def draw(self, painter: PySide6.QtGui.QPainter) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicseffect.html#draw

        **[pure virtual protected] void QGraphicsEffect::draw(QPainter * painter
        )**

        This pure virtual function draws the effect and is called whenever the
        source needs to be drawn.

        Reimplement this function in a **QGraphicsEffect**  subclass to provide
        the effect's drawing implementation, using **painter**.

        For example:

        MyGraphicsEffect::draw(**QPainter**  *painter)
            {
                ...
        **QPoint**  offset;
                if (sourceIsPixmap()) {
                    // No
        point in drawing in device coordinates (pixmap will be scaled anyways).
        const **QPixmap**  pixmap = sourcePixmap(Qt::LogicalCoordinates,
        &offset);
                    ...
                    painter->drawPixmap(offset,
        pixmap);
                } else {
                    // Draw pixmap in device
        coordinates to avoid pixmap scaling;
                    const **QPixmap**
        pixmap = sourcePixmap(Qt::DeviceCoordinates, &offset);
        painter->setWorldTransform(**QTransform** ());
                    ...
        painter->drawPixmap(offset, pixmap);
                }
                ...
            }

        This function should not be called explicitly by the user, since it is
        meant for reimplementation purposes only.
        """
        ...

    def drawSource(self, painter: PySide6.QtGui.QPainter) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicseffect.html#drawSource

        **[protected] void QGraphicsEffect::drawSource(QPainter * painter )**

        Draws the source directly using the given **painter**.

        This function should only be called from **QGraphicsEffect::draw** ().

        For example:

        MyGraphicsOpacityEffect::draw(**QPainter**  *painter)
            {
                //
        Fully opaque; draw directly without going through a pixmap.
                if
        (**qFuzzyCompare** (m_opacity, 1)) {
                    drawSource(painter);
        return;
                }
                ...
            }

        **See also** **QGraphicsEffect::draw** ().
        """
        ...

    def isEnabled(self) -> bool:
        ...

    def setEnabled(self, enable: bool) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicseffect.html#enabled-prop

        **enabled : bool**

        This property holds whether the effect is enabled or not.

        If an effect is disabled, the source will be rendered with as normal,
        with no interference from the effect. If the effect is enabled, the
        source will be rendered with the effect applied.

        This property is enabled by default.

        Using this property, you can disable certain effects on slow platforms,
        in order to ensure that the user interface is responsive.

        **Access functions:**

        bool **isEnabled** () const
        void **setEnabled** (bool **enable** )

        **Notifier signal:**

        void ****enabledChanged** ** (bool **enabled** )

        **Member Function Documentation**
        """
        ...

    def sourceBoundingRect(
        self, system: PySide6.QtCore.Qt.CoordinateSystem = ...
    ) -> PySide6.QtCore.QRectF:
        """
        https://doc.qt.io/qt-6/qgraphicseffect.html#sourceBoundingRect

        **[protected] QRectF
        QGraphicsEffect::sourceBoundingRect(Qt::CoordinateSystem system =
        Qt::LogicalCoordinates) const**

        Returns the bounding rectangle of the source mapped to the given
        **system**.

        Calling this function with **Qt::DeviceCoordinates**  outside of
        **QGraphicsEffect::draw** () will give undefined results, as there is no
        device context available.

        **See also** **draw** ().
        """
        ...

    def sourceChanged(
        self, flags: PySide6.QtWidgets.QGraphicsEffect.ChangeFlags
    ) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicseffect.html#sourceChanged

        **[virtual protected] void
        QGraphicsEffect::sourceChanged(QGraphicsEffect::ChangeFlags flags )**

        This virtual function is called by **QGraphicsEffect**  to notify the
        effect that the source has changed. If the effect applies any cache,
        then this cache must be purged in order to reflect the new appearance of
        the source.

        The **flags** describes what has changed.
        """
        ...

    def sourceIsPixmap(self) -> bool:
        """
        https://doc.qt.io/qt-6/qgraphicseffect.html#sourceIsPixmap

        **[protected] bool QGraphicsEffect::sourceIsPixmap() const**

        Returns `true` if the source effectively is a pixmap, e.g., a
        **QGraphicsPixmapItem** .

        This function is useful for optimization purposes. For instance, there's
        no point in drawing the source in device coordinates to avoid pixmap
        scaling if this function returns `true` \\- the source pixmap will be
        scaled anyways.
        """
        ...

    def sourcePixmap(
        self,
        system: PySide6.QtCore.Qt.CoordinateSystem = ...,
        offset: Optional[PySide6.QtCore.QPoint] = ...,
        mode: PySide6.QtWidgets.QGraphicsEffect.PixmapPadMode = ...,
    ) -> PySide6.QtGui.QPixmap:
        """
        https://doc.qt.io/qt-6/qgraphicseffect.html#sourcePixmap

        **[protected] QPixmap QGraphicsEffect::sourcePixmap(Qt::CoordinateSystem
        system = Qt::LogicalCoordinates, QPoint * offset = nullptr,
        QGraphicsEffect::PixmapPadMode mode = PadToEffectiveBoundingRect)
        const**

        Returns a pixmap with the source painted into it.

        The **system** specifies which coordinate system to be used for the
        source. The optional **offset** parameter returns the offset where the
        pixmap should be painted at using the current painter. For control on
        how the pixmap is padded use the **mode** parameter.

        The returned pixmap is clipped to the current painter's device rectangle
        when **system** is **Qt::DeviceCoordinates** .

        Calling this function with **Qt::DeviceCoordinates**  outside of
        **QGraphicsEffect::draw** () will give undefined results, as there is no
        device context available.

        **See also** **draw** () and **boundingRect** ().
        """
        ...

    def update(self) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicseffect.html#update

        **[slot] void QGraphicsEffect::update()**

        Schedules a redraw of the effect. Call this function whenever the effect
        needs to be redrawn. This function does not trigger a redraw of the
        source.

        **See also** **updateBoundingRect** ().
        """
        ...

    def updateBoundingRect(self) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicseffect.html#updateBoundingRect

        **[protected] void QGraphicsEffect::updateBoundingRect()**

        This function notifies the effect framework when the effect's bounding
        rectangle has changed. As a custom effect author, you must call this
        function whenever you change any parameters that will cause the virtual
        **boundingRectFor** () function to return a different value.

        This function will call **update** () if this is necessary.

        **See also** **boundingRectFor** (), **boundingRect** (), and
        **sourceBoundingRect** ().
        """
        ...

    @property
    def enabledChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qgraphicseffect.html#enabledChanged

        **[signal] void QGraphicsEffect::enabledChanged(bool enabled )**

        This signal is emitted whenever the effect is enabled or disabled. The
        **enabled** parameter holds the effects's new enabled state.

        **Note:** Notifier signal for property **enabled** .

        **See also** **isEnabled** ().
        """
        ...
