"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtWidgets, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import Optional, Union
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets

bytes = str


class QGraphicsBlurEffect(PySide6.QtWidgets.QGraphicsEffect):
    """
    https://doc.qt.io/qt-6/qgraphicsblureffect.html

    **Detailed Description**

    A blur effect blurs the source. This effect is useful for reducing details,
    such as when the source loses focus and you want to draw attention to other
    elements. The level of detail can be modified using the **setBlurRadius** ()
    function. Use **setBlurHints** () to choose the blur hints.

    By default, the blur radius is 5 pixels. The blur radius is specified in
    device coordinates.

    ![](images/graphicseffect-blur.png)

    **See also** **QGraphicsDropShadowEffect** , **QGraphicsColorizeEffect** ,
    and **QGraphicsOpacityEffect** .
    """

    PerformanceHint: QGraphicsBlurEffect.BlurHint = ...
    QualityHint: QGraphicsBlurEffect.BlurHint = ...
    AnimationHint: QGraphicsBlurEffect.BlurHint = ...

    class BlurHint(Enum):
        PerformanceHint: QGraphicsBlurEffect.BlurHint = ...
        QualityHint: QGraphicsBlurEffect.BlurHint = ...
        AnimationHint: QGraphicsBlurEffect.BlurHint = ...

    class BlurHints(object):
        ...

    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicsblureffect.html#QGraphicsBlurEffect

        **QGraphicsBlurEffect::QGraphicsBlurEffect(QObject * parent = nullptr)**

        Constructs a new QGraphicsBlurEffect instance. The **parent** parameter
        is passed to **QGraphicsEffect** 's constructor.
        """
        ...

    def blurHints(self) -> PySide6.QtWidgets.QGraphicsBlurEffect.BlurHints:
        """
        https://doc.qt.io/qt-6/qgraphicsblureffect.html#blurHints-prop

        **blurHints : BlurHints**

        This property holds the blur hint of the effect.

        Use the **PerformanceHint**  hint to say that you want a faster blur,
        the **QualityHint**  hint to say that you prefer a higher quality blur,
        or the **AnimationHint**  when you want to animate the blur radius.

        By default, the blur hint is **PerformanceHint** .

        **Access functions:**

        QGraphicsBlurEffect::BlurHints **blurHints** () const
        void
        **setBlurHints** (QGraphicsBlurEffect::BlurHints **hints** )

        **Notifier signal:**

        void ****blurHintsChanged** ** (QGraphicsBlurEffect::BlurHints **hints**
        )
        """
        ...

    def blurRadius(self) -> float:
        """
        https://doc.qt.io/qt-6/qgraphicsblureffect.html#blurRadius-prop

        **blurRadius : qreal**

        This property holds the blur radius of the effect.

        Using a smaller radius results in a sharper appearance, whereas a bigger
        radius results in a more blurred appearance.

        By default, the blur radius is 5 pixels.

        The radius is given in device coordinates, meaning it is unaffected by
        scale.

        **Access functions:**

        qreal **blurRadius** () const
        void **setBlurRadius** (qreal
        **blurRadius** )

        **Notifier signal:**

        void ****blurRadiusChanged** ** (qreal **radius** )

        **Member Function Documentation**
        """
        ...

    def boundingRectFor(
        self, rect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect]
    ) -> PySide6.QtCore.QRectF:
        """
        https://doc.qt.io/qt-6/qgraphicsblureffect.html#boundingRectFor

        **[override virtual] QRectF QGraphicsBlurEffect::boundingRectFor(const
        QRectF & rect ) const**

        Reimplements: **QGraphicsEffect::boundingRectFor(const QRectF &rect)
        const** .
        """
        ...

    def draw(self, painter: PySide6.QtGui.QPainter) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicsblureffect.html#draw

        **[override virtual protected] void QGraphicsBlurEffect::draw(QPainter *
        painter )**

        Reimplements: **QGraphicsEffect::draw** (QPainter *painter).
        """
        ...

    def setBlurHints(
        self, hints: PySide6.QtWidgets.QGraphicsBlurEffect.BlurHints
    ) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicsblureffect.html#blurHints-prop

        **blurHints : BlurHints**

        This property holds the blur hint of the effect.

        Use the **PerformanceHint**  hint to say that you want a faster blur,
        the **QualityHint**  hint to say that you prefer a higher quality blur,
        or the **AnimationHint**  when you want to animate the blur radius.

        By default, the blur hint is **PerformanceHint** .

        **Access functions:**

        QGraphicsBlurEffect::BlurHints **blurHints** () const
        void
        **setBlurHints** (QGraphicsBlurEffect::BlurHints **hints** )

        **Notifier signal:**

        void ****blurHintsChanged** ** (QGraphicsBlurEffect::BlurHints **hints**
        )
        """
        ...

    def setBlurRadius(self, blurRadius: float) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicsblureffect.html#blurRadius-prop

        **blurRadius : qreal**

        This property holds the blur radius of the effect.

        Using a smaller radius results in a sharper appearance, whereas a bigger
        radius results in a more blurred appearance.

        By default, the blur radius is 5 pixels.

        The radius is given in device coordinates, meaning it is unaffected by
        scale.

        **Access functions:**

        qreal **blurRadius** () const
        void **setBlurRadius** (qreal
        **blurRadius** )

        **Notifier signal:**

        void ****blurRadiusChanged** ** (qreal **radius** )

        **Member Function Documentation**
        """
        ...

    @property
    def blurHintsChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qgraphicsblureffect.html#blurHintsChanged

        **[signal] void
        QGraphicsBlurEffect::blurHintsChanged(QGraphicsBlurEffect::BlurHints
        hints )**

        This signal is emitted whenever the effect's blur hints changes. The
        **hints** parameter holds the effect's new blur hints.

        **Note:** Notifier signal for property **blurHints** .
        """
        ...

    @property
    def blurRadiusChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qgraphicsblureffect.html#blurRadiusChanged

        **[signal] void QGraphicsBlurEffect::blurRadiusChanged(qreal radius )**

        This signal is emitted whenever the effect's blur radius changes. The
        **radius** parameter holds the effect's new blur radius.

        **Note:** Notifier signal for property **blurRadius** .
        """
        ...
