"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtWidgets, except for defaults which are replaced by "...".
"""
from enum import Enum
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets

bytes = str


class QGestureRecognizer(object):
    """
    https://doc.qt.io/qt-6/qgesturerecognizer.html

    **Detailed Description**

    Gesture recognizers are responsible for creating and managing **QGesture**
    objects and monitoring input events sent to **QWidget**  and
    **QGraphicsObject**  subclasses. QGestureRecognizer is the base class for
    implementing custom gestures.

    Developers that only need to provide gesture recognition for standard
    gestures do not need to use this class directly. Instances will be created
    behind the scenes by the framework.

    For an overview of gesture handling in Qt and information on using gestures
    in your applications, see the **Gestures in Widgets and Graphics View**
    document.

    **Recognizing Gestures**

    The process of recognizing gestures involves filtering input events sent to
    specific objects, and modifying the associated **QGesture**  objects to
    include relevant information about the user's input.

    Gestures are created when the framework calls **create** () to handle user
    input for a particular instance of a **QWidget**  or **QGraphicsObject**
    subclass. A **QGesture**  object is created for each widget or item that is
    configured to use gestures.

    Once a **QGesture**  has been created for a target object, the gesture
    recognizer will receive events for it in its **recognize** () handler
    function.

    When a gesture is canceled, the **reset** () function is called, giving the
    recognizer the chance to update the appropriate properties in the
    corresponding **QGesture**  object.

    **Supporting New Gestures**

    To add support for new gestures, you need to derive from QGestureRecognizer
    to create a custom recognizer class, construct an instance of this class,
    and register it with the application by calling
    **QGestureRecognizer::registerRecognizer** (). You can also subclass
    **QGesture**  to create a custom gesture class, or rely on dynamic
    properties to express specific details of the gesture you want to handle.

    Your custom QGestureRecognizer subclass needs to reimplement the
    **recognize** () function to handle and filter the incoming input events for
    **QWidget**  and **QGraphicsObject**  subclasses. Although the logic for
    gesture recognition is implemented in this function, you can store
    persistent information about the state of the recognition process in the
    **QGesture**  object supplied. The **recognize** () function must return a
    value of **QGestureRecognizer::Result**  that indicates the state of
    recognition for a given gesture and target object. This determines whether
    or not a gesture event will be delivered to a target object.

    If you choose to represent a gesture by a custom **QGesture**  subclass, you
    will need to reimplement the **create** () function to construct instances
    of your gesture class. Similarly, you may need to reimplement the **reset**
    () function if your custom gesture objects need to be specially handled when
    a gesture is canceled.

    **See also** **QGesture** .
    """

    Ignore: QGestureRecognizer.ResultFlag = ...
    MayBeGesture: QGestureRecognizer.ResultFlag = ...
    TriggerGesture: QGestureRecognizer.ResultFlag = ...
    FinishGesture: QGestureRecognizer.ResultFlag = ...
    CancelGesture: QGestureRecognizer.ResultFlag = ...
    ResultState_Mask: QGestureRecognizer.ResultFlag = ...
    ConsumeEventHint: QGestureRecognizer.ResultFlag = ...
    ResultHint_Mask: QGestureRecognizer.ResultFlag = ...

    class Result(object):
        ...

    class ResultFlag(Enum):
        Ignore: QGestureRecognizer.ResultFlag = ...
        MayBeGesture: QGestureRecognizer.ResultFlag = ...
        TriggerGesture: QGestureRecognizer.ResultFlag = ...
        FinishGesture: QGestureRecognizer.ResultFlag = ...
        CancelGesture: QGestureRecognizer.ResultFlag = ...
        ResultState_Mask: QGestureRecognizer.ResultFlag = ...
        ConsumeEventHint: QGestureRecognizer.ResultFlag = ...
        ResultHint_Mask: QGestureRecognizer.ResultFlag = ...

    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qgesturerecognizer.html#QGestureRecognizer

        **QGestureRecognizer::QGestureRecognizer()**

        Constructs a new gesture recognizer object.
        """
        ...

    def create(self, target: PySide6.QtCore.QObject) -> PySide6.QtWidgets.QGesture:
        """
        https://doc.qt.io/qt-6/qgesturerecognizer.html#create

        **[virtual] QGesture *QGestureRecognizer::create(QObject * target )**

        This function is called by Qt to create a new **QGesture**  object for
        the given **target** (**QWidget**  or **QGraphicsObject** ).

        Reimplement this function to create a custom **QGesture** -derived
        gesture object if necessary.

        The application takes ownership of the created gesture object.
        """
        ...

    def recognize(
        self,
        state: PySide6.QtWidgets.QGesture,
        watched: PySide6.QtCore.QObject,
        event: PySide6.QtCore.QEvent,
    ) -> PySide6.QtWidgets.QGestureRecognizer.Result:
        """
        https://doc.qt.io/qt-6/qgesturerecognizer.html#recognize

        **[pure virtual] QGestureRecognizer::Result
        QGestureRecognizer::recognize(QGesture * gesture , QObject * watched ,
        QEvent * event )**

        Handles the given **event** for the **watched** object, updating the
        state of the **gesture** object as required, and returns a suitable
        result for the current recognition step.

        This function is called by the framework to allow the recognizer to
        filter input events dispatched to **QWidget**  or **QGraphicsObject**
        instances that it is monitoring.

        The result reflects how much of the gesture has been recognized. The
        state of the **gesture** object is set depending on the result.

        **See also** **QGestureRecognizer::Result** .
        """
        ...

    @staticmethod
    def registerRecognizer(
        recognizer: PySide6.QtWidgets.QGestureRecognizer,
    ) -> PySide6.QtCore.Qt.GestureType:
        """
        https://doc.qt.io/qt-6/qgesturerecognizer.html#registerRecognizer

        **[static] Qt::GestureType
        QGestureRecognizer::registerRecognizer(QGestureRecognizer * recognizer
        )**

        Registers the given **recognizer** in the gesture framework and returns
        a gesture ID for it.

        The application takes ownership of the **recognizer** and returns the
        gesture type ID associated with it. For gesture recognizers which handle
        custom **QGesture**  objects (i.e., those which return
        **Qt::CustomGesture**  in a **QGesture::gestureType** () function) the
        return value is a generated gesture ID with the **Qt::CustomGesture**
        flag set.

        **See also** **unregisterRecognizer** (), **QGestureRecognizer::create**
        (), and **QGesture** .
        """
        ...

    def reset(self, state: PySide6.QtWidgets.QGesture) -> None:
        """
        https://doc.qt.io/qt-6/qgesturerecognizer.html#reset

        **[virtual] void QGestureRecognizer::reset(QGesture * gesture )**

        This function is called by the framework to reset a given **gesture**.

        Reimplement this function to implement additional requirements for
        custom **QGesture**  objects. This may be necessary if you implement a
        custom **QGesture**  whose properties need special handling when the
        gesture is reset.
        """
        ...

    @staticmethod
    def unregisterRecognizer(type: PySide6.QtCore.Qt.GestureType) -> None:
        """
        https://doc.qt.io/qt-6/qgesturerecognizer.html#unregisterRecognizer

        **[static] void QGestureRecognizer::unregisterRecognizer(Qt::GestureType
        type )**

        Unregisters all gesture recognizers of the specified **type**.

        **See also** **registerRecognizer** ().
        """
        ...
