"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtWidgets, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import Optional, Union
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets

bytes = str


class QGesture(PySide6.QtCore.QObject):
    """
    https://doc.qt.io/qt-6/qgesture.html

    **Detailed Description**

    Gesture objects are not constructed directly by developers. They are created
    by the **QGestureRecognizer**  object that is registered with the
    application; see **QGestureRecognizer::registerRecognizer** ().

    For an overview of gesture handling in Qt and information on using gestures
    in your applications, see the **Gestures in Widgets and Graphics View**
    document.

    **Gesture Properties**

    The class has a list of properties that can be queried by the user to get
    some gesture-specific arguments. For example, the pinch gesture has a scale
    factor that is exposed as a property.

    Developers of custom gesture recognizers can add additional properties in
    order to provide additional information about a gesture. This can be done by
    adding new dynamic properties to a QGesture object, or by subclassing the
    QGesture class (or one of its subclasses).

    **Lifecycle of a Gesture Object**

    A QGesture instance is implicitly created when needed and is owned by Qt.
    Developers should never destroy them or store them for later use as Qt may
    destroy particular instances of them and create new ones to replace them.

    The registered gesture recognizer monitors the input events for the target
    object via its **recognize** () function, updating the properties of the
    gesture object as required.

    The gesture object may be delivered to the target object in a
    **QGestureEvent**  if the corresponding gesture is active or has just been
    canceled. Each event that is delivered contains a list of gesture objects,
    since support for more than one gesture may be enabled for the target
    object. Due to the way events are handled in Qt, gesture events may be
    filtered by other objects.

    **See also** **QGestureEvent**  and **QGestureRecognizer** .
    """

    CancelNone: QGesture.GestureCancelPolicy = ...
    CancelAllInContext: QGesture.GestureCancelPolicy = ...

    class GestureCancelPolicy(Enum):
        CancelNone: QGesture.GestureCancelPolicy = ...
        CancelAllInContext: QGesture.GestureCancelPolicy = ...

    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qgesture.html#QGesture

        **QGesture::QGesture(QObject * parent = nullptr)**

        Constructs a new gesture object with the given **parent**.

        QGesture objects are created by gesture recognizers in the
        **QGestureRecognizer::create** () function.
        """
        ...

    def gestureCancelPolicy(self) -> PySide6.QtWidgets.QGesture.GestureCancelPolicy:
        """
        https://doc.qt.io/qt-6/qgesture.html#gestureCancelPolicy-prop

        **gestureCancelPolicy : QGesture::GestureCancelPolicy**

        This property holds the policy for deciding what happens on accepting a
        gesture

        On accepting one gesture Qt can automatically cancel other gestures that
        belong to other targets. The policy is normally set to not cancel any
        other gestures and can be set to cancel all active gestures in the
        context. For example for all child widgets.

        **Access functions:**

        QGesture::GestureCancelPolicy **gestureCancelPolicy** () const
        void
        **setGestureCancelPolicy** (QGesture::GestureCancelPolicy **policy** )
        """
        ...

    def gestureType(self) -> PySide6.QtCore.Qt.GestureType:
        """
        https://doc.qt.io/qt-6/qgesture.html#gestureType-prop

        **[read-only] gestureType : const Qt::GestureType**

        This property holds the type of the gesture

        **Access functions:**

        Qt::GestureType **gestureType** () const
        """
        ...

    def hasHotSpot(self) -> bool:
        """
        https://doc.qt.io/qt-6/qgesture.html#hasHotSpot-prop

        **[read-only] hasHotSpot : const bool**

        This property holds whether the gesture has a hot-spot

        **Access functions:**

        bool **hasHotSpot** () const
        """
        ...

    def hotSpot(self) -> PySide6.QtCore.QPointF:
        """
        https://doc.qt.io/qt-6/qgesture.html#hotSpot-prop

        **hotSpot : QPointF**

        This property holds the point that is used to find the receiver for the
        gesture event.

        The hot-spot is a point in the global coordinate system, use
        **QWidget::mapFromGlobal** () or **QGestureEvent::mapToGraphicsScene**
        () to get a local hot-spot.

        The hot-spot should be set by the gesture recognizer to allow gesture
        event delivery to a **QGraphicsObject** .

        **Access functions:**

        QPointF **hotSpot** () const
        void **setHotSpot** (const QPointF &
        **value** )
        void **unsetHotSpot** ()
        """
        ...

    def setGestureCancelPolicy(
        self, policy: PySide6.QtWidgets.QGesture.GestureCancelPolicy
    ) -> None:
        """
        https://doc.qt.io/qt-6/qgesture.html#gestureCancelPolicy-prop

        **gestureCancelPolicy : QGesture::GestureCancelPolicy**

        This property holds the policy for deciding what happens on accepting a
        gesture

        On accepting one gesture Qt can automatically cancel other gestures that
        belong to other targets. The policy is normally set to not cancel any
        other gestures and can be set to cancel all active gestures in the
        context. For example for all child widgets.

        **Access functions:**

        QGesture::GestureCancelPolicy **gestureCancelPolicy** () const
        void
        **setGestureCancelPolicy** (QGesture::GestureCancelPolicy **policy** )
        """
        ...

    def setHotSpot(
        self,
        value: Union[
            PySide6.QtCore.QPointF,
            PySide6.QtCore.QPoint,
            PySide6.QtGui.QPainterPath.Element,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qgesture.html#hotSpot-prop

        **hotSpot : QPointF**

        This property holds the point that is used to find the receiver for the
        gesture event.

        The hot-spot is a point in the global coordinate system, use
        **QWidget::mapFromGlobal** () or **QGestureEvent::mapToGraphicsScene**
        () to get a local hot-spot.

        The hot-spot should be set by the gesture recognizer to allow gesture
        event delivery to a **QGraphicsObject** .

        **Access functions:**

        QPointF **hotSpot** () const
        void **setHotSpot** (const QPointF &
        **value** )
        void **unsetHotSpot** ()
        """
        ...

    def state(self) -> PySide6.QtCore.Qt.GestureState:
        """
        https://doc.qt.io/qt-6/qgesture.html#state-prop

        **[read-only] state : const Qt::GestureState**

        This property holds the current state of the gesture

        **Access functions:**

        Qt::GestureState **state** () const

        **Member Function Documentation**
        """
        ...

    def unsetHotSpot(self) -> None:
        ...
