"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtWidgets, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import Optional, Sequence, Union
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets

bytes = str


class QFontComboBox(PySide6.QtWidgets.QComboBox):
    """
    https://doc.qt.io/qt-6/qfontcombobox.html

    **Detailed Description**

    The combobox is populated with an alphabetized list of font family names,
    such as Arial, Helvetica, and Times New Roman. Family names are displayed
    using the actual font when possible. For fonts such as Symbol, where the
    name is not representable in the font itself, a sample of the font is
    displayed next to the family name.

    QFontComboBox is often used in toolbars, in conjunction with a **QComboBox**
    for controlling the font size and two **QToolButton** s for bold and italic.

    When the user selects a new font, the **currentFontChanged** () signal is
    emitted in addition to **currentIndexChanged** ().

    Call **setWritingSystem** () to tell QFontComboBox to show only fonts that
    support a given writing system, and **setFontFilters** () to filter out
    certain types of fonts as e.g. non scalable fonts or monospaced fonts.

    ![Screenshot of QFontComboBox on Windows Vista](images/windowsvista-
    fontcombobox.png)

    **See also** **QComboBox** , **QFont** , **QFontInfo** , **QFontMetrics** ,
    **QFontDatabase** , and **Character Map Example** .
    """

    AllFonts: QFontComboBox.FontFilter = ...
    ScalableFonts: QFontComboBox.FontFilter = ...
    NonScalableFonts: QFontComboBox.FontFilter = ...
    MonospacedFonts: QFontComboBox.FontFilter = ...
    ProportionalFonts: QFontComboBox.FontFilter = ...

    class FontFilter(Enum):
        AllFonts: QFontComboBox.FontFilter = ...
        ScalableFonts: QFontComboBox.FontFilter = ...
        NonScalableFonts: QFontComboBox.FontFilter = ...
        MonospacedFonts: QFontComboBox.FontFilter = ...
        ProportionalFonts: QFontComboBox.FontFilter = ...

    class FontFilters(object):
        ...

    def __init__(self, parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qfontcombobox.html#QFontComboBox

        **QFontComboBox::QFontComboBox(QWidget * parent = nullptr)**

        Constructs a font combobox with the given **parent**.
        """
        ...

    def currentFont(self) -> PySide6.QtGui.QFont:
        """
        https://doc.qt.io/qt-6/qfontcombobox.html#currentFont-prop

        **currentFont : QFont**

        This property holds the currently selected font

        **Access functions:**

        QFont **currentFont** () const
        void **setCurrentFont** (const QFont &
        **f** )

        **Notifier signal:**

        void ****currentFontChanged** ** (const QFont & **font** )

        **See also** **currentIndex**  and **currentText** .
        """
        ...

    def event(self, e: PySide6.QtCore.QEvent) -> bool:
        """
        https://doc.qt.io/qt-6/qfontcombobox.html#event

        **[override virtual protected] bool QFontComboBox::event(QEvent * e )**

        Reimplements: **QComboBox::event** (QEvent *event).
        """
        ...

    def fontFilters(self) -> PySide6.QtWidgets.QFontComboBox.FontFilters:
        """
        https://doc.qt.io/qt-6/qfontcombobox.html#fontFilters-prop

        **fontFilters : FontFilters**

        This property holds the filter for the combobox

        By default, all fonts are listed.

        **Access functions:**

        QFontComboBox::FontFilters **fontFilters** () const
        void
        **setFontFilters** (QFontComboBox::FontFilters **filters** )

        **See also** **writingSystem** .
        """
        ...

    def setCurrentFont(self, f: Union[PySide6.QtGui.QFont, str, Sequence[str]]) -> None:
        """
        https://doc.qt.io/qt-6/qfontcombobox.html#currentFont-prop

        **currentFont : QFont**

        This property holds the currently selected font

        **Access functions:**

        QFont **currentFont** () const
        void **setCurrentFont** (const QFont &
        **f** )

        **Notifier signal:**

        void ****currentFontChanged** ** (const QFont & **font** )

        **See also** **currentIndex**  and **currentText** .
        """
        ...

    def setFontFilters(
        self, filters: PySide6.QtWidgets.QFontComboBox.FontFilters
    ) -> None:
        """
        https://doc.qt.io/qt-6/qfontcombobox.html#fontFilters-prop

        **fontFilters : FontFilters**

        This property holds the filter for the combobox

        By default, all fonts are listed.

        **Access functions:**

        QFontComboBox::FontFilters **fontFilters** () const
        void
        **setFontFilters** (QFontComboBox::FontFilters **filters** )

        **See also** **writingSystem** .
        """
        ...

    def setWritingSystem(
        self, arg__1: PySide6.QtGui.QFontDatabase.WritingSystem
    ) -> None:
        """
        https://doc.qt.io/qt-6/qfontcombobox.html#writingSystem-prop

        **writingSystem : QFontDatabase::WritingSystem**

        This property holds the writing system that serves as a filter for the
        combobox

        If **script** is **QFontDatabase::Any**  (the default), all fonts are
        listed.

        **Access functions:**

        QFontDatabase::WritingSystem **writingSystem** () const
        void
        **setWritingSystem** (QFontDatabase::WritingSystem)

        **See also** **fontFilters** .

        **Member Function Documentation**
        """
        ...

    def sizeHint(self) -> PySide6.QtCore.QSize:
        """
        https://doc.qt.io/qt-6/qfontcombobox.html#sizeHint

        **[override virtual] QSize QFontComboBox::sizeHint() const**

        Reimplements: **QComboBox::sizeHint() const** .
        """
        ...

    def writingSystem(self) -> PySide6.QtGui.QFontDatabase.WritingSystem:
        """
        https://doc.qt.io/qt-6/qfontcombobox.html#writingSystem-prop

        **writingSystem : QFontDatabase::WritingSystem**

        This property holds the writing system that serves as a filter for the
        combobox

        If **script** is **QFontDatabase::Any**  (the default), all fonts are
        listed.

        **Access functions:**

        QFontDatabase::WritingSystem **writingSystem** () const
        void
        **setWritingSystem** (QFontDatabase::WritingSystem)

        **See also** **fontFilters** .

        **Member Function Documentation**
        """
        ...

    @property
    def currentFontChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qfontcombobox.html#currentFontChanged

        **[signal] void QFontComboBox::currentFontChanged(const QFont & font )**

        This signal is emitted whenever the current font changes, with the new
        **font**.

        **Note:** Notifier signal for property **currentFont** .

        **See also** **currentFont** .
        """
        ...
