"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtWidgets, except for defaults which are replaced by "...".
"""
from typing import Optional, overload
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets

bytes = str


class QErrorMessage(PySide6.QtWidgets.QDialog):
    """
    https://doc.qt.io/qt-6/qerrormessage.html

    **Detailed Description**

    An error message widget consists of a text label and a checkbox. The
    checkbox lets the user control whether the same error message will be
    displayed again in the future, typically displaying the text, "Show this
    message again" translated into the appropriate local language.

    For production applications, the class can be used to display messages which
    the user only needs to see once. To use QErrorMessage like this, you create
    the dialog in the usual way, and show it by calling the **showMessage** ()
    slot or connecting signals to it.

    The static **qtHandler** () function installs a message handler using
    **qInstallMessageHandler** () and creates a QErrorMessage that displays
    **qDebug** (), **qWarning** () and **qFatal** () messages. This is most
    useful in environments where no console is available to display warnings and
    error messages.

    In both cases QErrorMessage will queue pending messages and display them in
    order, with each new message being shown as soon as the user has accepted
    the previous message. Once the user has specified that a message is not to
    be shown again it is automatically skipped, and the dialog will show the
    next appropriate message in the queue.

    The **Standard Dialogs**  example shows how to use QErrorMessage as well as
    other built-in Qt dialogs.

    ![](images/qerrormessage.png)

    **See also** **QMessageBox** , **QStatusBar::showMessage** (), and
    **Standard Dialogs Example** .
    """

    def __init__(self, parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qerrormessage.html#QErrorMessage

        **QErrorMessage::QErrorMessage(QWidget * parent = nullptr)**

        Constructs and installs an error handler window with the given
        **parent**.
        """
        ...

    def changeEvent(self, e: PySide6.QtCore.QEvent) -> None:
        """
        https://doc.qt.io/qt-6/qerrormessage.html#changeEvent

        **[override virtual protected] void QErrorMessage::changeEvent(QEvent *
        e )**

        Reimplements: **QWidget::changeEvent** (QEvent *event).
        """
        ...

    def done(self, arg__1: int) -> None:
        """
        https://doc.qt.io/qt-6/qerrormessage.html#done

        **[override virtual protected] void QErrorMessage::done(int a )**

        Reimplements: **QDialog::done** (int r).
        """
        ...

    @staticmethod
    def qtHandler() -> PySide6.QtWidgets.QErrorMessage:
        """
        https://doc.qt.io/qt-6/qerrormessage.html#qtHandler

        **[static] QErrorMessage *QErrorMessage::qtHandler()**

        Returns a pointer to a **QErrorMessage**  object that outputs the
        default Qt messages. This function creates such an object, if there
        isn't one already.
        """
        ...

    @overload
    def showMessage(self, message: str) -> None:
        """
        https://doc.qt.io/qt-6/qerrormessage.html#showMessage

        **[slot] void QErrorMessage::showMessage(const QString & message )**

        Shows the given message, **message** , and returns immediately. If the
        user has requested for the message not to be shown again, this function
        does nothing.

        Normally, the message is displayed immediately. However, if there are
        pending messages, it will be queued to be displayed later.
        """
        ...

    @overload
    def showMessage(self, message: str, type: str) -> None:
        """
        https://doc.qt.io/qt-6/qerrormessage.html#showMessage-1

        **[slot] void QErrorMessage::showMessage(const QString & message , const
        QString & type )**

        This is an overloaded function.

        Shows the given message, **message** , and returns immediately. If the
        user has requested for messages of type, **type** , not to be shown
        again, this function does nothing.

        Normally, the message is displayed immediately. However, if there are
        pending messages, it will be queued to be displayed later.

        **See also** **showMessage** ().
        """
        ...
