"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtWidgets, except for defaults which are replaced by "...".
"""
from typing import Optional, overload
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets

bytes = str


class QCommandLinkButton(PySide6.QtWidgets.QPushButton):
    """
    https://doc.qt.io/qt-6/qcommandlinkbutton.html

    **Detailed Description**

    The command link is a new control that was introduced by Windows Vista. Its
    intended use is similar to that of a radio button in that it is used to
    choose between a set of mutually exclusive options. Command link buttons
    should not be used by themselves but rather as an alternative to radio
    buttons in Wizards and dialogs and makes pressing the "next" button
    redundant. The appearance is generally similar to that of a flat pushbutton,
    but it allows for a descriptive text in addition to the normal button text.
    By default it will also carry an arrow icon, indicating that pressing the
    control will open another window or page.

    **See also** **QPushButton**  and **QRadioButton** .
    """

    @overload
    def __init__(self, parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qcommandlinkbutton.html#QCommandLinkButton

        **QCommandLinkButton::QCommandLinkButton(QWidget * parent = nullptr)**

        Constructs a command link with no text and a **parent**.
        """
        ...

    @overload
    def __init__(
        self,
        text: str,
        description: str,
        parent: Optional[PySide6.QtWidgets.QWidget] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qcommandlinkbutton.html#QCommandLinkButton-1

        **QCommandLinkButton::QCommandLinkButton(const QString & text , QWidget
        * parent = nullptr)**

        Constructs a command link with the parent **parent** and the text
        **text**.
        """
        ...

    @overload
    def __init__(
        self, text: str, parent: Optional[PySide6.QtWidgets.QWidget] = ...
    ) -> None:
        """
        https://doc.qt.io/qt-6/qcommandlinkbutton.html#QCommandLinkButton-2

        **QCommandLinkButton::QCommandLinkButton(const QString & text , const
        QString & description , QWidget * parent = nullptr)**

        Constructs a command link with a **text** , a **description** , and a
        **parent**.
        """
        ...

    def description(self) -> str:
        """
        https://doc.qt.io/qt-6/qcommandlinkbutton.html#description-prop

        **description : QString**

        This property holds a descriptive label to complement the button text

        Setting this property will set a descriptive text on the button,
        complementing the text label. This will usually be displayed in a
        smaller font than the primary text.

        **Access functions:**

        QString **description** () const
        void **setDescription** (const
        QString & **description** )
        """
        ...

    def event(self, e: PySide6.QtCore.QEvent) -> bool:
        """
        https://doc.qt.io/qt-6/qcommandlinkbutton.html#event

        **[override virtual protected] bool QCommandLinkButton::event(QEvent * e
        )**

        Reimplements: **QPushButton::event** (QEvent *e).
        """
        ...

    def heightForWidth(self, arg__1: int) -> int:
        """
        https://doc.qt.io/qt-6/qcommandlinkbutton.html#heightForWidth

        **[override virtual] int QCommandLinkButton::heightForWidth(int width )
        const**

        Reimplements: **QWidget::heightForWidth(int w) const** .
        """
        ...

    def initStyleOption(self, option: PySide6.QtWidgets.QStyleOptionButton) -> None:
        ...

    def minimumSizeHint(self) -> PySide6.QtCore.QSize:
        """
        https://doc.qt.io/qt-6/qcommandlinkbutton.html#minimumSizeHint

        **[override virtual] QSize QCommandLinkButton::minimumSizeHint() const**

        Reimplements: **QPushButton::minimumSizeHint() const** .
        """
        ...

    def paintEvent(self, arg__1: PySide6.QtGui.QPaintEvent) -> None:
        """
        https://doc.qt.io/qt-6/qcommandlinkbutton.html#paintEvent

        **[override virtual protected] void
        QCommandLinkButton::paintEvent(QPaintEvent *)**

        Reimplements: **QPushButton::paintEvent** (QPaintEvent *).
        """
        ...

    def setDescription(self, description: str) -> None:
        """
        https://doc.qt.io/qt-6/qcommandlinkbutton.html#description-prop

        **description : QString**

        This property holds a descriptive label to complement the button text

        Setting this property will set a descriptive text on the button,
        complementing the text label. This will usually be displayed in a
        smaller font than the primary text.

        **Access functions:**

        QString **description** () const
        void **setDescription** (const
        QString & **description** )
        """
        ...

    def sizeHint(self) -> PySide6.QtCore.QSize:
        """
        https://doc.qt.io/qt-6/qcommandlinkbutton.html#sizeHint

        **[override virtual] QSize QCommandLinkButton::sizeHint() const**

        Reimplements: **QPushButton::sizeHint() const** .
        """
        ...
