"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtWidgets, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import Any, Optional, Sequence, Union, overload
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets

bytes = str


class QComboBox(PySide6.QtWidgets.QWidget):
    """
    https://doc.qt.io/qt-6/qcombobox.html

    **Detailed Description**

    ![](images/windows-combobox.png)

    A QComboBox provides a means of presenting a list of options to the user in
    a way that takes up the minimum amount of screen space.

    A combobox is a selection widget that displays the current item, and can pop
    up a list of selectable items. A combobox may be editable, allowing the user
    to modify each item in the list.

    Comboboxes can contain pixmaps as well as strings; the **insertItem** () and
    **setItemText** () functions are suitably overloaded. For editable
    comboboxes, the function **clearEditText** () is provided, to clear the
    displayed string without changing the combobox's contents.

    There are three signals emitted if the current item of a combobox changes,
    **currentIndexChanged** (), **currentTextChanged** () and **activated** ().
    **currentIndexChanged** () and **currentTextChanged** () are always emitted
    regardless if the change was done programmatically or by user interaction,
    while **activated** () is only emitted when the change is caused by user
    interaction. The **highlighted** () signal is emitted when the user
    highlights an item in the combobox popup list. All three signals exist in
    two versions, one with a **QString**  argument and one with an `int`
    argument. If the user selects or highlights a pixmap, only the `int` signals
    are emitted. Whenever the text of an editable combobox is changed the
    **editTextChanged** () signal is emitted.

    When the user enters a new string in an editable combobox, the widget may or
    may not insert it, and it can insert it in several locations. The default
    policy is **InsertAtBottom**  but you can change this using
    **setInsertPolicy** ().

    It is possible to constrain the input to an editable combobox using
    **QValidator** ; see **setValidator** (). By default, any input is accepted.

    A combobox can be populated using the insert functions, **insertItem** ()
    and **insertItems** () for example. Items can be changed with
    **setItemText** (). An item can be removed with **removeItem** () and all
    items can be removed with **clear** (). The text of the current item is
    returned by **currentText** (), and the text of a numbered item is returned
    with text(). The current item can be set with **setCurrentIndex** (). The
    number of items in the combobox is returned by **count** (); the maximum
    number of items can be set with **setMaxCount** (). You can allow editing
    using **setEditable** (). For editable comboboxes you can set auto-
    completion using **setCompleter** () and whether or not the user can add
    duplicates is set with **setDuplicatesEnabled** ().

    QComboBox uses the **model/view framework**  for its popup list and to store
    its items. By default a **QStandardItemModel**  stores the items and a
    **QListView**  subclass displays the popuplist. You can access the model and
    view directly (with **model** () and **view** ()), but QComboBox also
    provides functions to set and get item data (e.g., **setItemData** () and
    **itemText** ()). You can also set a new model and view (with **setModel**
    () and **setView** ()). For the text and icon in the combobox label, the
    data in the model that has the **Qt::DisplayRole**  and
    **Qt::DecorationRole**  is used. Note that you cannot alter the
    **SelectionMode**  of the **view** (), e.g., by using **setSelectionMode**
    ().

    **See also** **QLineEdit** , **QSpinBox** , **QRadioButton** ,
    **QButtonGroup** , and **GUI Design Handbook: Combo Box, Drop-Down List
    Box** .
    """

    NoInsert: QComboBox.InsertPolicy = ...
    InsertAtTop: QComboBox.InsertPolicy = ...
    InsertAtCurrent: QComboBox.InsertPolicy = ...
    InsertAtBottom: QComboBox.InsertPolicy = ...
    InsertAfterCurrent: QComboBox.InsertPolicy = ...
    InsertBeforeCurrent: QComboBox.InsertPolicy = ...
    InsertAlphabetically: QComboBox.InsertPolicy = ...
    AdjustToContents: QComboBox.SizeAdjustPolicy = ...
    AdjustToContentsOnFirstShow: QComboBox.SizeAdjustPolicy = ...
    AdjustToMinimumContentsLengthWithIcon: QComboBox.SizeAdjustPolicy = ...

    class InsertPolicy(Enum):
        NoInsert: QComboBox.InsertPolicy = ...
        InsertAtTop: QComboBox.InsertPolicy = ...
        InsertAtCurrent: QComboBox.InsertPolicy = ...
        InsertAtBottom: QComboBox.InsertPolicy = ...
        InsertAfterCurrent: QComboBox.InsertPolicy = ...
        InsertBeforeCurrent: QComboBox.InsertPolicy = ...
        InsertAlphabetically: QComboBox.InsertPolicy = ...

    class SizeAdjustPolicy(Enum):
        AdjustToContents: QComboBox.SizeAdjustPolicy = ...
        AdjustToContentsOnFirstShow: QComboBox.SizeAdjustPolicy = ...
        AdjustToMinimumContentsLengthWithIcon: QComboBox.SizeAdjustPolicy = ...

    def __init__(self, parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qcombobox.html#QComboBox

        **QComboBox::QComboBox(QWidget * parent = nullptr)**

        Constructs a combobox with the given **parent** , using the default
        model **QStandardItemModel** .
        """
        ...

    @overload
    def addItem(
        self,
        icon: Union[PySide6.QtGui.QIcon, PySide6.QtGui.QPixmap],
        text: str,
        userData: Any = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qcombobox.html#addItem

        **void QComboBox::addItem(const QString & text , const QVariant &
        userData = QVariant())**

        Adds an item to the combobox with the given **text** , and containing
        the specified **userData** (stored in the **Qt::UserRole** ). The item
        is appended to the list of existing items.
        """
        ...

    @overload
    def addItem(self, text: str, userData: Any = ...) -> None:
        """
        https://doc.qt.io/qt-6/qcombobox.html#addItem-1

        **void QComboBox::addItem(const QIcon & icon , const QString & text ,
        const QVariant & userData = QVariant())**

        Adds an item to the combobox with the given **icon** and **text** , and
        containing the specified **userData** (stored in the **Qt::UserRole** ).
        The item is appended to the list of existing items.
        """
        ...

    def addItems(self, texts: Sequence[str]) -> None:
        """
        https://doc.qt.io/qt-6/qcombobox.html#addItems

        **void QComboBox::addItems(const QStringList & texts )**

        Adds each of the strings in the given **texts** to the combobox. Each
        item is appended to the list of existing items in turn.
        """
        ...

    def changeEvent(self, e: PySide6.QtCore.QEvent) -> None:
        """
        https://doc.qt.io/qt-6/qcombobox.html#changeEvent

        **[override virtual protected] void QComboBox::changeEvent(QEvent * e
        )**

        Reimplements: **QWidget::changeEvent** (QEvent *event).
        """
        ...

    def clear(self) -> None:
        """
        https://doc.qt.io/qt-6/qcombobox.html#clear

        **[slot] void QComboBox::clear()**

        Clears the combobox, removing all items.

        Note: If you have set an external model on the combobox this model will
        still be cleared when calling this function.
        """
        ...

    def clearEditText(self) -> None:
        """
        https://doc.qt.io/qt-6/qcombobox.html#clearEditText

        **[slot] void QComboBox::clearEditText()**

        Clears the contents of the line edit used for editing in the combobox.
        """
        ...

    def completer(self) -> PySide6.QtWidgets.QCompleter:
        """
        https://doc.qt.io/qt-6/qcombobox.html#completer

        **QCompleter *QComboBox::completer() const**

        Returns the completer that is used to auto complete text input for the
        combobox.

        **See also** **setCompleter** () and **editable** .
        """
        ...

    def contextMenuEvent(self, e: PySide6.QtGui.QContextMenuEvent) -> None:
        """
        https://doc.qt.io/qt-6/qcombobox.html#contextMenuEvent

        **[override virtual protected] void
        QComboBox::contextMenuEvent(QContextMenuEvent * e )**

        Reimplements: **QWidget::contextMenuEvent** (QContextMenuEvent *event).
        """
        ...

    def count(self) -> int:
        """
        https://doc.qt.io/qt-6/qcombobox.html#count-prop

        **[read-only] count : const int**

        This property holds the number of items in the combobox

        By default, for an empty combo box, this property has a value of 0.

        **Access functions:**

        int **count** () const
        """
        ...

    def currentData(self, role: int = ...) -> Any:
        """
        https://doc.qt.io/qt-6/qcombobox.html#currentData-prop

        **[read-only, since 5.2] currentData : const QVariant**

        This property holds the data for the current item

        By default, for an empty combo box or a combo box in which no current
        item is set, this property contains an invalid **QVariant** .

        This property was introduced in Qt 5.2.

        **Access functions:**

        QVariant **currentData** (int **role** = Qt::UserRole) const
        """
        ...

    def currentIndex(self) -> int:
        """
        https://doc.qt.io/qt-6/qcombobox.html#currentIndex-prop

        **currentIndex : int**

        This property holds the index of the current item in the combobox.

        The current index can change when inserting or removing items.

        By default, for an empty combo box or a combo box in which no current
        item is set, this property has a value of -1.

        **Access functions:**

        int **currentIndex** () const
        void **setCurrentIndex** (int **index**
        )

        **Notifier signal:**

        void ****currentIndexChanged** ** (int **index** )
        """
        ...

    def currentText(self) -> str:
        """
        https://doc.qt.io/qt-6/qcombobox.html#currentText-prop

        **currentText : QString**

        This property holds the current text

        If the combo box is editable, the current text is the value displayed by
        the line edit. Otherwise, it is the value of the current item or an
        empty string if the combo box is empty or no current item is set.

        The setter setCurrentText() simply calls **setEditText** () if the combo
        box is editable. Otherwise, if there is a matching text in the list,
        **currentIndex**  is set to the corresponding index.

        **Access functions:**

        QString **currentText** () const
        void **setCurrentText** (const
        QString & **text** )

        **Notifier signal:**

        void ****currentTextChanged** ** (const QString & **text** )

        **See also** **editable**  and **setEditText** ().
        """
        ...

    def duplicatesEnabled(self) -> bool:
        """
        https://doc.qt.io/qt-6/qcombobox.html#duplicatesEnabled-prop

        **duplicatesEnabled : bool**

        This property holds whether the user can enter duplicate items into the
        combobox

        Note that it is always possible to programmatically insert duplicate
        items into the combobox.

        By default, this property is `false` (duplicates are not allowed).

        **Access functions:**

        bool **duplicatesEnabled** () const
        void **setDuplicatesEnabled**
        (bool **enable** )
        """
        ...

    def event(self, event: PySide6.QtCore.QEvent) -> bool:
        """
        https://doc.qt.io/qt-6/qcombobox.html#event

        **[override virtual] bool QComboBox::event(QEvent * event )**

        Reimplements: **QWidget::event** (QEvent *event).
        """
        ...

    def findData(
        self, data: Any, role: int = ..., flags: PySide6.QtCore.Qt.MatchFlags = ...
    ) -> int:
        """
        https://doc.qt.io/qt-6/qcombobox.html#findData

        **int QComboBox::findData(const QVariant & data , int role =
        Qt::UserRole, Qt::MatchFlags flags =
        static_cast<Qt::MatchFlags>(Qt::MatchExactly|Qt::MatchCaseSensitive))
        const**

        Returns the index of the item containing the given **data** for the
        given **role** ; otherwise returns -1.

        The **flags** specify how the items in the combobox are searched.
        """
        ...

    def findText(self, text: str, flags: PySide6.QtCore.Qt.MatchFlags = ...) -> int:
        """
        https://doc.qt.io/qt-6/qcombobox.html#findText

        **int QComboBox::findText(const QString & text , Qt::MatchFlags flags =
        Qt::MatchExactly|Qt::MatchCaseSensitive) const**

        Returns the index of the item containing the given **text** ; otherwise
        returns -1.

        The **flags** specify how the items in the combobox are searched.
        """
        ...

    def focusInEvent(self, e: PySide6.QtGui.QFocusEvent) -> None:
        """
        https://doc.qt.io/qt-6/qcombobox.html#focusInEvent

        **[override virtual protected] void QComboBox::focusInEvent(QFocusEvent
        * e )**

        Reimplements: **QWidget::focusInEvent** (QFocusEvent *event).
        """
        ...

    def focusOutEvent(self, e: PySide6.QtGui.QFocusEvent) -> None:
        """
        https://doc.qt.io/qt-6/qcombobox.html#focusOutEvent

        **[override virtual protected] void QComboBox::focusOutEvent(QFocusEvent
        * e )**

        Reimplements: **QWidget::focusOutEvent** (QFocusEvent *event).
        """
        ...

    def hasFrame(self) -> bool:
        ...

    def hideEvent(self, e: PySide6.QtGui.QHideEvent) -> None:
        """
        https://doc.qt.io/qt-6/qcombobox.html#hideEvent

        **[override virtual protected] void QComboBox::hideEvent(QHideEvent * e
        )**

        Reimplements: **QWidget::hideEvent** (QHideEvent *event).
        """
        ...

    def hidePopup(self) -> None:
        """
        https://doc.qt.io/qt-6/qcombobox.html#hidePopup

        **[virtual] void QComboBox::hidePopup()**

        Hides the list of items in the combobox if it is currently visible and
        resets the internal state, so that if the custom pop-up was shown inside
        the reimplemented **showPopup** (), then you also need to reimplement
        the hidePopup() function to hide your custom pop-up and call the base
        class implementation to reset the internal state whenever your custom
        pop-up widget is hidden.

        **See also** **showPopup** ().
        """
        ...

    def iconSize(self) -> PySide6.QtCore.QSize:
        """
        https://doc.qt.io/qt-6/qcombobox.html#iconSize-prop

        **iconSize : QSize**

        This property holds the size of the icons shown in the combobox.

        Unless explicitly set this returns the default value of the current
        style. This size is the maximum size that icons can have; icons of
        smaller size are not scaled up.

        **Access functions:**

        QSize **iconSize** () const
        void **setIconSize** (const QSize &
        **size** )
        """
        ...

    def initStyleOption(self, option: PySide6.QtWidgets.QStyleOptionComboBox) -> None:
        """
        https://doc.qt.io/qt-6/qcombobox.html#initStyleOption

        **[virtual protected] void
        QComboBox::initStyleOption(QStyleOptionComboBox * option ) const**

        Initialize **option** with the values from this **QComboBox** . This
        method is useful for subclasses when they need a
        **QStyleOptionComboBox** , but don't want to fill in all the information
        themselves.

        **See also** **QStyleOption::initFrom** ().
        """
        ...

    def inputMethodEvent(self, arg__1: PySide6.QtGui.QInputMethodEvent) -> None:
        """
        https://doc.qt.io/qt-6/qcombobox.html#inputMethodEvent

        **[override virtual protected] void
        QComboBox::inputMethodEvent(QInputMethodEvent * e )**

        Reimplements: **QWidget::inputMethodEvent** (QInputMethodEvent *event).
        """
        ...

    @overload
    def inputMethodQuery(self, arg__1: PySide6.QtCore.Qt.InputMethodQuery) -> Any:
        """
        https://doc.qt.io/qt-6/qcombobox.html#inputMethodQuery

        **[override virtual] QVariant
        QComboBox::inputMethodQuery(Qt::InputMethodQuery query ) const**

        Reimplements: **QWidget::inputMethodQuery(Qt::InputMethodQuery query)
        const** .
        """
        ...

    @overload
    def inputMethodQuery(
        self, query: PySide6.QtCore.Qt.InputMethodQuery, argument: Any
    ) -> Any:
        """
        https://doc.qt.io/qt-6/qcombobox.html#inputMethodQuery

        **[override virtual] QVariant
        QComboBox::inputMethodQuery(Qt::InputMethodQuery query ) const**

        Reimplements: **QWidget::inputMethodQuery(Qt::InputMethodQuery query)
        const** .
        """
        ...

    @overload
    def insertItem(
        self,
        index: int,
        icon: Union[PySide6.QtGui.QIcon, PySide6.QtGui.QPixmap],
        text: str,
        userData: Any = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qcombobox.html#insertItem

        **void QComboBox::insertItem(int index , const QString & text , const
        QVariant & userData = QVariant())**

        Inserts the **text** and **userData** (stored in the **Qt::UserRole** )
        into the combobox at the given **index**.

        If the index is equal to or higher than the total number of items, the
        new item is appended to the list of existing items. If the index is zero
        or negative, the new item is prepended to the list of existing items.

        **See also** **insertItems** ().
        """
        ...

    @overload
    def insertItem(self, index: int, text: str, userData: Any = ...) -> None:
        """
        https://doc.qt.io/qt-6/qcombobox.html#insertItem-1

        **void QComboBox::insertItem(int index , const QIcon & icon , const
        QString & text , const QVariant & userData = QVariant())**

        Inserts the **icon** , **text** and **userData** (stored in the
        **Qt::UserRole** ) into the combobox at the given **index**.

        If the index is equal to or higher than the total number of items, the
        new item is appended to the list of existing items. If the index is zero
        or negative, the new item is prepended to the list of existing items.

        **See also** **insertItems** ().
        """
        ...

    def insertItems(self, index: int, texts: Sequence[str]) -> None:
        """
        https://doc.qt.io/qt-6/qcombobox.html#insertItems

        **void QComboBox::insertItems(int index , const QStringList & list )**

        Inserts the strings from the **list** into the combobox as separate
        items, starting at the **index** specified.

        If the index is equal to or higher than the total number of items, the
        new items are appended to the list of existing items. If the index is
        zero or negative, the new items are prepended to the list of existing
        items.

        **See also** **insertItem** ().
        """
        ...

    def insertPolicy(self) -> PySide6.QtWidgets.QComboBox.InsertPolicy:
        """
        https://doc.qt.io/qt-6/qcombobox.html#insertPolicy-prop

        **insertPolicy : InsertPolicy**

        This property holds the policy used to determine where user-inserted
        items should appear in the combobox

        The default value is **InsertAtBottom** , indicating that new items will
        appear at the bottom of the list of items.

        **Access functions:**

        QComboBox::InsertPolicy **insertPolicy** () const
        void
        **setInsertPolicy** (QComboBox::InsertPolicy **policy** )

        **See also** **InsertPolicy** .
        """
        ...

    def insertSeparator(self, index: int) -> None:
        """
        https://doc.qt.io/qt-6/qcombobox.html#insertSeparator

        **void QComboBox::insertSeparator(int index )**

        Inserts a separator item into the combobox at the given **index**.

        If the index is equal to or higher than the total number of items, the
        new item is appended to the list of existing items. If the index is zero
        or negative, the new item is prepended to the list of existing items.

        **See also** **insertItem** ().
        """
        ...

    def isEditable(self) -> bool:
        ...

    def itemData(self, index: int, role: int = ...) -> Any:
        """
        https://doc.qt.io/qt-6/qcombobox.html#itemData

        **QVariant QComboBox::itemData(int index , int role = Qt::UserRole)
        const**

        Returns the data for the given **role** in the given **index** in the
        combobox, or an invalid **QVariant**  if there is no data for this role.

        **See also** **setItemData** ().
        """
        ...

    def itemDelegate(self) -> PySide6.QtWidgets.QAbstractItemDelegate:
        """
        https://doc.qt.io/qt-6/qcombobox.html#itemDelegate

        **QAbstractItemDelegate *QComboBox::itemDelegate() const**

        Returns the item delegate used by the popup list view.

        **See also** **setItemDelegate** ().
        """
        ...

    def itemIcon(self, index: int) -> PySide6.QtGui.QIcon:
        """
        https://doc.qt.io/qt-6/qcombobox.html#itemIcon

        **QIcon QComboBox::itemIcon(int index ) const**

        Returns the icon for the given **index** in the combobox.

        **See also** **setItemIcon** ().
        """
        ...

    def itemText(self, index: int) -> str:
        """
        https://doc.qt.io/qt-6/qcombobox.html#itemText

        **QString QComboBox::itemText(int index ) const**

        Returns the text for the given **index** in the combobox.

        **See also** **setItemText** ().
        """
        ...

    def keyPressEvent(self, e: PySide6.QtGui.QKeyEvent) -> None:
        """
        https://doc.qt.io/qt-6/qcombobox.html#keyPressEvent

        **[override virtual protected] void QComboBox::keyPressEvent(QKeyEvent *
        e )**

        Reimplements: **QWidget::keyPressEvent** (QKeyEvent *event).
        """
        ...

    def keyReleaseEvent(self, e: PySide6.QtGui.QKeyEvent) -> None:
        """
        https://doc.qt.io/qt-6/qcombobox.html#keyReleaseEvent

        **[override virtual protected] void QComboBox::keyReleaseEvent(QKeyEvent
        * e )**

        Reimplements: **QWidget::keyReleaseEvent** (QKeyEvent *event).
        """
        ...

    def lineEdit(self) -> PySide6.QtWidgets.QLineEdit:
        """
        https://doc.qt.io/qt-6/qcombobox.html#lineEdit

        **QLineEdit *QComboBox::lineEdit() const**

        Returns the line edit used to edit items in the combobox, or `nullptr`
        if there is no line edit.

        Only editable combo boxes have a line edit.

        **See also** **setLineEdit** ().
        """
        ...

    def maxCount(self) -> int:
        """
        https://doc.qt.io/qt-6/qcombobox.html#maxCount-prop

        **maxCount : int**

        This property holds the maximum number of items allowed in the combobox

        **Note:** If you set the maximum number to be less then the current
        amount of items in the combobox, the extra items will be truncated. This
        also applies if you have set an external model on the combobox.

        By default, this property's value is derived from the highest signed
        integer available (typically 2147483647).

        **Access functions:**

        int **maxCount** () const
        void **setMaxCount** (int **max** )
        """
        ...

    def maxVisibleItems(self) -> int:
        """
        https://doc.qt.io/qt-6/qcombobox.html#maxVisibleItems-prop

        **maxVisibleItems : int**

        This property holds the maximum allowed size on screen of the combo box,
        measured in items

        By default, this property has a value of 10.

        **Note:** This property is ignored for non-editable comboboxes in styles
        that returns true for **QStyle::SH_ComboBox_Popup**  such as the Mac
        style or the Gtk+ Style.

        **Access functions:**

        int **maxVisibleItems** () const
        void **setMaxVisibleItems** (int
        **maxItems** )
        """
        ...

    def minimumContentsLength(self) -> int:
        """
        https://doc.qt.io/qt-6/qcombobox.html#minimumContentsLength-prop

        **minimumContentsLength : int**

        This property holds the minimum number of characters that should fit
        into the combobox.

        The default value is 0.

        If this property is set to a positive value, the **minimumSizeHint** ()
        and **sizeHint** () take it into account.

        **Access functions:**

        int **minimumContentsLength** () const
        void
        **setMinimumContentsLength** (int **characters** )

        **See also** **sizeAdjustPolicy** .
        """
        ...

    def minimumSizeHint(self) -> PySide6.QtCore.QSize:
        """
        https://doc.qt.io/qt-6/qcombobox.html#minimumSizeHint

        **[override virtual] QSize QComboBox::minimumSizeHint() const**

        Reimplements an access function for property:
        **QWidget::minimumSizeHint** .
        """
        ...

    def model(self) -> PySide6.QtCore.QAbstractItemModel:
        """
        https://doc.qt.io/qt-6/qcombobox.html#model

        **QAbstractItemModel *QComboBox::model() const**

        Returns the model used by the combobox.

        **See also** **setModel** ().
        """
        ...

    def modelColumn(self) -> int:
        """
        https://doc.qt.io/qt-6/qcombobox.html#modelColumn-prop

        **modelColumn : int**

        This property holds the column in the model that is visible.

        If set prior to populating the combo box, the pop-up view will not be
        affected and will show the first column (using this property's default
        value).

        By default, this property has a value of 0.

        **Note:** In an editable combobox, the visible column will also become
        the **completion column** .

        **Access functions:**

        int **modelColumn** () const
        void **setModelColumn** (int
        **visibleColumn** )
        """
        ...

    def mousePressEvent(self, e: PySide6.QtGui.QMouseEvent) -> None:
        """
        https://doc.qt.io/qt-6/qcombobox.html#mousePressEvent

        **[override virtual protected] void
        QComboBox::mousePressEvent(QMouseEvent * e )**

        Reimplements: **QWidget::mousePressEvent** (QMouseEvent *event).
        """
        ...

    def mouseReleaseEvent(self, e: PySide6.QtGui.QMouseEvent) -> None:
        """
        https://doc.qt.io/qt-6/qcombobox.html#mouseReleaseEvent

        **[override virtual protected] void
        QComboBox::mouseReleaseEvent(QMouseEvent * e )**

        Reimplements: **QWidget::mouseReleaseEvent** (QMouseEvent *event).
        """
        ...

    def paintEvent(self, e: PySide6.QtGui.QPaintEvent) -> None:
        """
        https://doc.qt.io/qt-6/qcombobox.html#paintEvent

        **[override virtual protected] void QComboBox::paintEvent(QPaintEvent *
        e )**

        Reimplements: **QWidget::paintEvent** (QPaintEvent *event).
        """
        ...

    def placeholderText(self) -> str:
        """
        https://doc.qt.io/qt-6/qcombobox.html#placeholderText-prop

        **[since 5.15] placeholderText : QString**

        Sets a **placeholderText** text shown when no valid index is set

        The **placeholderText** will be shown when an invalid index is set. The
        text is not accessible in the dropdown list. When this function is
        called before items are added the placeholder text will be shown,
        otherwise you have to call **setCurrentIndex** (-1) programmatically if
        you want to show the placeholder text. Set an empty placeholder text to
        reset the setting.

        When the **QComboBox**  is editable, use
        **QLineEdit::setPlaceholderText** () instead.

        This property was introduced in Qt 5.15.

        **Access functions:**

        QString **placeholderText** () const
        void **setPlaceholderText**
        (const QString & **placeholderText** )
        """
        ...

    def removeItem(self, index: int) -> None:
        """
        https://doc.qt.io/qt-6/qcombobox.html#removeItem

        **void QComboBox::removeItem(int index )**

        Removes the item at the given **index** from the combobox. This will
        update the current index if the index is removed.

        This function does nothing if **index** is out of range.
        """
        ...

    def resizeEvent(self, e: PySide6.QtGui.QResizeEvent) -> None:
        """
        https://doc.qt.io/qt-6/qcombobox.html#resizeEvent

        **[override virtual protected] void QComboBox::resizeEvent(QResizeEvent
        * e )**

        Reimplements: **QWidget::resizeEvent** (QResizeEvent *event).
        """
        ...

    def rootModelIndex(self) -> PySide6.QtCore.QModelIndex:
        """
        https://doc.qt.io/qt-6/qcombobox.html#rootModelIndex

        **QModelIndex QComboBox::rootModelIndex() const**

        Returns the root model item index for the items in the combobox.

        **See also** **setRootModelIndex** ().
        """
        ...

    def setCompleter(self, c: PySide6.QtWidgets.QCompleter) -> None:
        """
        https://doc.qt.io/qt-6/qcombobox.html#setCompleter

        **void QComboBox::setCompleter(QCompleter * completer )**

        Sets the **completer** to use instead of the current completer. If
        **completer** is `nullptr`, auto completion is disabled.

        By default, for an editable combo box, a **QCompleter**  that performs
        case insensitive inline completion is automatically created.

        **Note:** The completer is removed when the **editable**  property
        becomes `false`, or when the line edit is replaced by a call to
        **setLineEdit** (). Setting a completer on a **QComboBox**  that is not
        editable will be ignored.

        **See also** **completer** ().
        """
        ...

    def setCurrentIndex(self, index: int) -> None:
        """
        https://doc.qt.io/qt-6/qcombobox.html#currentIndex-prop

        **currentIndex : int**

        This property holds the index of the current item in the combobox.

        The current index can change when inserting or removing items.

        By default, for an empty combo box or a combo box in which no current
        item is set, this property has a value of -1.

        **Access functions:**

        int **currentIndex** () const
        void **setCurrentIndex** (int **index**
        )

        **Notifier signal:**

        void ****currentIndexChanged** ** (int **index** )
        """
        ...

    def setCurrentText(self, text: str) -> None:
        """
        https://doc.qt.io/qt-6/qcombobox.html#currentText-prop

        **currentText : QString**

        This property holds the current text

        If the combo box is editable, the current text is the value displayed by
        the line edit. Otherwise, it is the value of the current item or an
        empty string if the combo box is empty or no current item is set.

        The setter setCurrentText() simply calls **setEditText** () if the combo
        box is editable. Otherwise, if there is a matching text in the list,
        **currentIndex**  is set to the corresponding index.

        **Access functions:**

        QString **currentText** () const
        void **setCurrentText** (const
        QString & **text** )

        **Notifier signal:**

        void ****currentTextChanged** ** (const QString & **text** )

        **See also** **editable**  and **setEditText** ().
        """
        ...

    def setDuplicatesEnabled(self, enable: bool) -> None:
        """
        https://doc.qt.io/qt-6/qcombobox.html#duplicatesEnabled-prop

        **duplicatesEnabled : bool**

        This property holds whether the user can enter duplicate items into the
        combobox

        Note that it is always possible to programmatically insert duplicate
        items into the combobox.

        By default, this property is `false` (duplicates are not allowed).

        **Access functions:**

        bool **duplicatesEnabled** () const
        void **setDuplicatesEnabled**
        (bool **enable** )
        """
        ...

    def setEditText(self, text: str) -> None:
        """
        https://doc.qt.io/qt-6/qcombobox.html#setEditText

        **[slot] void QComboBox::setEditText(const QString & text )**

        Sets the **text** in the combobox's text edit.
        """
        ...

    def setEditable(self, editable: bool) -> None:
        """
        https://doc.qt.io/qt-6/qcombobox.html#editable-prop

        **editable : bool**

        This property holds whether the combo box can be edited by the user

        By default, this property is `false`. The effect of editing depends on
        the insert policy.

        **Note:** When disabling the **editable** state, the validator and
        completer are removed.

        **Access functions:**

        bool **isEditable** () const
        void **setEditable** (bool **editable** )

        **See also** **InsertPolicy** .
        """
        ...

    def setFrame(self, arg__1: bool) -> None:
        """
        https://doc.qt.io/qt-6/qcombobox.html#frame-prop

        **frame : bool**

        This property holds whether the combo box draws itself with a frame

        If enabled (the default) the combo box draws itself inside a frame,
        otherwise the combo box draws itself without any frame.

        **Access functions:**

        bool **hasFrame** () const
        void **setFrame** (bool)
        """
        ...

    def setIconSize(self, size: PySide6.QtCore.QSize) -> None:
        """
        https://doc.qt.io/qt-6/qcombobox.html#iconSize-prop

        **iconSize : QSize**

        This property holds the size of the icons shown in the combobox.

        Unless explicitly set this returns the default value of the current
        style. This size is the maximum size that icons can have; icons of
        smaller size are not scaled up.

        **Access functions:**

        QSize **iconSize** () const
        void **setIconSize** (const QSize &
        **size** )
        """
        ...

    def setInsertPolicy(self, policy: PySide6.QtWidgets.QComboBox.InsertPolicy) -> None:
        """
        https://doc.qt.io/qt-6/qcombobox.html#insertPolicy-prop

        **insertPolicy : InsertPolicy**

        This property holds the policy used to determine where user-inserted
        items should appear in the combobox

        The default value is **InsertAtBottom** , indicating that new items will
        appear at the bottom of the list of items.

        **Access functions:**

        QComboBox::InsertPolicy **insertPolicy** () const
        void
        **setInsertPolicy** (QComboBox::InsertPolicy **policy** )

        **See also** **InsertPolicy** .
        """
        ...

    def setItemData(self, index: int, value: Any, role: int = ...) -> None:
        """
        https://doc.qt.io/qt-6/qcombobox.html#setItemData

        **void QComboBox::setItemData(int index , const QVariant & value , int
        role = Qt::UserRole)**

        Sets the data **role** for the item on the given **index** in the
        combobox to the specified **value**.

        **See also** **itemData** ().
        """
        ...

    def setItemDelegate(
        self, delegate: PySide6.QtWidgets.QAbstractItemDelegate
    ) -> None:
        """
        https://doc.qt.io/qt-6/qcombobox.html#setItemDelegate

        **void QComboBox::setItemDelegate(QAbstractItemDelegate * delegate )**

        Sets the item **delegate** for the popup list view. The combobox takes
        ownership of the delegate.

        Any existing delegate will be removed, but not deleted. **QComboBox**
        does not take ownership of **delegate**.

        **Warning:** You should not share the same instance of a delegate
        between comboboxes, widget mappers or views. Doing so can cause
        incorrect or unintuitive editing behavior since each view connected to a
        given delegate may receive the **closeEditor** () signal, and attempt to
        access, modify or close an editor that has already been closed.

        **See also** **itemDelegate** ().
        """
        ...

    def setItemIcon(
        self, index: int, icon: Union[PySide6.QtGui.QIcon, PySide6.QtGui.QPixmap]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qcombobox.html#setItemIcon

        **void QComboBox::setItemIcon(int index , const QIcon & icon )**

        Sets the **icon** for the item on the given **index** in the combobox.

        **See also** **itemIcon** ().
        """
        ...

    def setItemText(self, index: int, text: str) -> None:
        """
        https://doc.qt.io/qt-6/qcombobox.html#setItemText

        **void QComboBox::setItemText(int index , const QString & text )**

        Sets the **text** for the item on the given **index** in the combobox.

        **See also** **itemText** ().
        """
        ...

    def setLineEdit(self, edit: PySide6.QtWidgets.QLineEdit) -> None:
        """
        https://doc.qt.io/qt-6/qcombobox.html#setLineEdit

        **void QComboBox::setLineEdit(QLineEdit * edit )**

        Sets the line **edit** to use instead of the current line edit widget.

        The combo box takes ownership of the line edit.

        **Note:** Since the combobox's line edit owns the **QCompleter** , any
        previous call to **setCompleter** () will no longer have any effect.

        **See also** **lineEdit** ().
        """
        ...

    def setMaxCount(self, max: int) -> None:
        """
        https://doc.qt.io/qt-6/qcombobox.html#maxCount-prop

        **maxCount : int**

        This property holds the maximum number of items allowed in the combobox

        **Note:** If you set the maximum number to be less then the current
        amount of items in the combobox, the extra items will be truncated. This
        also applies if you have set an external model on the combobox.

        By default, this property's value is derived from the highest signed
        integer available (typically 2147483647).

        **Access functions:**

        int **maxCount** () const
        void **setMaxCount** (int **max** )
        """
        ...

    def setMaxVisibleItems(self, maxItems: int) -> None:
        """
        https://doc.qt.io/qt-6/qcombobox.html#maxVisibleItems-prop

        **maxVisibleItems : int**

        This property holds the maximum allowed size on screen of the combo box,
        measured in items

        By default, this property has a value of 10.

        **Note:** This property is ignored for non-editable comboboxes in styles
        that returns true for **QStyle::SH_ComboBox_Popup**  such as the Mac
        style or the Gtk+ Style.

        **Access functions:**

        int **maxVisibleItems** () const
        void **setMaxVisibleItems** (int
        **maxItems** )
        """
        ...

    def setMinimumContentsLength(self, characters: int) -> None:
        """
        https://doc.qt.io/qt-6/qcombobox.html#minimumContentsLength-prop

        **minimumContentsLength : int**

        This property holds the minimum number of characters that should fit
        into the combobox.

        The default value is 0.

        If this property is set to a positive value, the **minimumSizeHint** ()
        and **sizeHint** () take it into account.

        **Access functions:**

        int **minimumContentsLength** () const
        void
        **setMinimumContentsLength** (int **characters** )

        **See also** **sizeAdjustPolicy** .
        """
        ...

    def setModel(self, model: PySide6.QtCore.QAbstractItemModel) -> None:
        """
        https://doc.qt.io/qt-6/qcombobox.html#setModel

        **[virtual] void QComboBox::setModel(QAbstractItemModel * model )**

        Sets the model to be **model**. **model** must not be `nullptr`. If you
        want to clear the contents of a model, call **clear** ().

        **Note:** If the combobox is editable, then the **model** will also be
        set on the completer of the line edit.

        **See also** **model** (), **clear** (), and **setCompleter** ().
        """
        ...

    def setModelColumn(self, visibleColumn: int) -> None:
        """
        https://doc.qt.io/qt-6/qcombobox.html#modelColumn-prop

        **modelColumn : int**

        This property holds the column in the model that is visible.

        If set prior to populating the combo box, the pop-up view will not be
        affected and will show the first column (using this property's default
        value).

        By default, this property has a value of 0.

        **Note:** In an editable combobox, the visible column will also become
        the **completion column** .

        **Access functions:**

        int **modelColumn** () const
        void **setModelColumn** (int
        **visibleColumn** )
        """
        ...

    def setPlaceholderText(self, placeholderText: str) -> None:
        """
        https://doc.qt.io/qt-6/qcombobox.html#placeholderText-prop

        **[since 5.15] placeholderText : QString**

        Sets a **placeholderText** text shown when no valid index is set

        The **placeholderText** will be shown when an invalid index is set. The
        text is not accessible in the dropdown list. When this function is
        called before items are added the placeholder text will be shown,
        otherwise you have to call **setCurrentIndex** (-1) programmatically if
        you want to show the placeholder text. Set an empty placeholder text to
        reset the setting.

        When the **QComboBox**  is editable, use
        **QLineEdit::setPlaceholderText** () instead.

        This property was introduced in Qt 5.15.

        **Access functions:**

        QString **placeholderText** () const
        void **setPlaceholderText**
        (const QString & **placeholderText** )
        """
        ...

    def setRootModelIndex(
        self,
        index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qcombobox.html#setRootModelIndex

        **void QComboBox::setRootModelIndex(const QModelIndex & index )**

        Sets the root model item **index** for the items in the combobox.

        **See also** **rootModelIndex** ().
        """
        ...

    def setSizeAdjustPolicy(
        self, policy: PySide6.QtWidgets.QComboBox.SizeAdjustPolicy
    ) -> None:
        """
        https://doc.qt.io/qt-6/qcombobox.html#sizeAdjustPolicy-prop

        **sizeAdjustPolicy : SizeAdjustPolicy**

        This property holds the policy describing how the size of the combobox
        changes when the content changes

        The default value is **AdjustToContentsOnFirstShow** .

        **Access functions:**

        QComboBox::SizeAdjustPolicy **sizeAdjustPolicy** () const
        void
        **setSizeAdjustPolicy** (QComboBox::SizeAdjustPolicy **policy** )

        **See also** **SizeAdjustPolicy** .

        **Member Function Documentation**
        """
        ...

    def setValidator(self, v: PySide6.QtGui.QValidator) -> None:
        """
        https://doc.qt.io/qt-6/qcombobox.html#setValidator

        **void QComboBox::setValidator(const QValidator * validator )**

        Sets the **validator** to use instead of the current validator.

        **Note:** The validator is removed when the **editable**  property
        becomes `false`.

        **See also** **validator** ().
        """
        ...

    def setView(self, itemView: PySide6.QtWidgets.QAbstractItemView) -> None:
        """
        https://doc.qt.io/qt-6/qcombobox.html#setView

        **void QComboBox::setView(QAbstractItemView * itemView )**

        Sets the view to be used in the combobox popup to the given
        **itemView**. The combobox takes ownership of the view.

        Note: If you want to use the convenience views (like **QListWidget** ,
        **QTableWidget**  or **QTreeWidget** ), make sure to call **setModel**
        () on the combobox with the convenience widgets model before calling
        this function.

        **See also** **view** ().
        """
        ...

    def showEvent(self, e: PySide6.QtGui.QShowEvent) -> None:
        """
        https://doc.qt.io/qt-6/qcombobox.html#showEvent

        **[override virtual protected] void QComboBox::showEvent(QShowEvent * e
        )**

        Reimplements: **QWidget::showEvent** (QShowEvent *event).
        """
        ...

    def showPopup(self) -> None:
        """
        https://doc.qt.io/qt-6/qcombobox.html#showPopup

        **[virtual] void QComboBox::showPopup()**

        Displays the list of items in the combobox. If the list is empty then no
        items will be shown.

        If you reimplement this function to show a custom pop-up, make sure you
        call **hidePopup** () to reset the internal state.

        **See also** **hidePopup** ().
        """
        ...

    def sizeAdjustPolicy(self) -> PySide6.QtWidgets.QComboBox.SizeAdjustPolicy:
        """
        https://doc.qt.io/qt-6/qcombobox.html#sizeAdjustPolicy-prop

        **sizeAdjustPolicy : SizeAdjustPolicy**

        This property holds the policy describing how the size of the combobox
        changes when the content changes

        The default value is **AdjustToContentsOnFirstShow** .

        **Access functions:**

        QComboBox::SizeAdjustPolicy **sizeAdjustPolicy** () const
        void
        **setSizeAdjustPolicy** (QComboBox::SizeAdjustPolicy **policy** )

        **See also** **SizeAdjustPolicy** .

        **Member Function Documentation**
        """
        ...

    def sizeHint(self) -> PySide6.QtCore.QSize:
        """
        https://doc.qt.io/qt-6/qcombobox.html#sizeHint

        **[override virtual] QSize QComboBox::sizeHint() const**

        Reimplements an access function for property: **QWidget::sizeHint** .

        This implementation caches the size hint to avoid resizing when the
        contents change dynamically. To invalidate the cached value change the
        **sizeAdjustPolicy** .
        """
        ...

    def validator(self) -> PySide6.QtGui.QValidator:
        """
        https://doc.qt.io/qt-6/qcombobox.html#validator

        **const QValidator *QComboBox::validator() const**

        Returns the validator that is used to constrain text input for the
        combobox.

        **See also** **setValidator** () and **editable** .
        """
        ...

    def view(self) -> PySide6.QtWidgets.QAbstractItemView:
        """
        https://doc.qt.io/qt-6/qcombobox.html#view

        **QAbstractItemView *QComboBox::view() const**

        Returns the list view used for the combobox popup.

        **See also** **setView** ().
        """
        ...

    def wheelEvent(self, e: PySide6.QtGui.QWheelEvent) -> None:
        """
        https://doc.qt.io/qt-6/qcombobox.html#wheelEvent

        **[override virtual protected] void QComboBox::wheelEvent(QWheelEvent *
        e )**

        Reimplements: **QWidget::wheelEvent** (QWheelEvent *event).
        """
        ...

    @property
    def activated(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qcombobox.html#activated

        **[signal] void QComboBox::activated(int index )**

        This signal is sent when the user chooses an item in the combobox. The
        item's **index** is passed. Note that this signal is sent even when the
        choice is not changed. If you need to know when the choice actually
        changes, use signal **currentIndexChanged** () or **currentTextChanged**
        ().
        """
        ...

    @property
    def currentIndexChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qcombobox.html#currentIndexChanged

        **[signal] void QComboBox::currentIndexChanged(int index )**

        This signal is sent whenever the **currentIndex**  in the combobox
        changes either through user interaction or programmatically. The item's
        **index** is passed or -1 if the combobox becomes empty or the
        **currentIndex**  was reset.

        **Note:** Notifier signal for property **currentIndex** .
        """
        ...

    @property
    def currentTextChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qcombobox.html#currentTextChanged

        **[signal, since 5.0] void QComboBox::currentTextChanged(const QString &
        text )**

        This signal is sent whenever **currentText**  changes. The new value is
        passed as **text**.

        **Note:** Notifier signal for property **currentText** .

        This function was introduced in Qt 5.0.
        """
        ...

    @property
    def editTextChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qcombobox.html#editTextChanged

        **[signal] void QComboBox::editTextChanged(const QString & text )**

        This signal is emitted when the text in the combobox's line edit widget
        is changed. The new text is specified by **text**.
        """
        ...

    @property
    def highlighted(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qcombobox.html#highlighted

        **[signal] void QComboBox::highlighted(int index )**

        This signal is sent when an item in the combobox popup list is
        highlighted by the user. The item's **index** is passed.
        """
        ...

    @property
    def textActivated(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qcombobox.html#textActivated

        **[signal, since 5.14] void QComboBox::textActivated(const QString &
        text )**

        This signal is sent when the user chooses an item in the combobox. The
        item's **text** is passed. Note that this signal is sent even when the
        choice is not changed. If you need to know when the choice actually
        changes, use signal **currentIndexChanged** () or **currentTextChanged**
        ().

        This function was introduced in Qt 5.14.
        """
        ...

    @property
    def textHighlighted(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qcombobox.html#textHighlighted

        **[signal, since 5.14] void QComboBox::textHighlighted(const QString &
        text )**

        This signal is sent when an item in the combobox popup list is
        highlighted by the user. The item's **text** is passed.

        This function was introduced in Qt 5.14.
        """
        ...
