"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtWidgets, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import Optional, overload
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets

bytes = str


class QBoxLayout(PySide6.QtWidgets.QLayout):
    """
    https://doc.qt.io/qt-6/qboxlayout.html

    **Detailed Description**

    QBoxLayout takes the space it gets (from its parent layout or from the
    **parentWidget** ()), divides it up into a row of boxes, and makes each
    managed widget fill one box.

    ![Horizontal box layout with five child widgets](images/qhboxlayout-
    with-5-children.png)

    If the QBoxLayout's orientation is **Qt::Horizontal**  the boxes are placed
    in a row, with suitable sizes. Each widget (or other box) will get at least
    its minimum size and at most its maximum size. Any excess space is shared
    according to the stretch factors (more about that below).

    ![Vertical box layout with five child widgets](images/qvboxlayout-
    with-5-children.png)

    If the QBoxLayout's orientation is **Qt::Vertical** , the boxes are placed
    in a column, again with suitable sizes.

    The easiest way to create a QBoxLayout is to use one of the convenience
    classes, e.g. **QHBoxLayout**  (for **Qt::Horizontal**  boxes) or
    **QVBoxLayout**  (for **Qt::Vertical**  boxes). You can also use the
    QBoxLayout constructor directly, specifying its direction as **LeftToRight**
    , **RightToLeft** , **TopToBottom** , or **BottomToTop** .

    If the QBoxLayout is not the top-level layout (i.e. it is not managing all
    of the widget's area and children), you must add it to its parent layout
    before you can do anything with it. The normal way to add a layout is by
    calling parentLayout->**addLayout** ().

    Once you have done this, you can add boxes to the QBoxLayout using one of
    four functions:

    * **addWidget** () to add a widget to the QBoxLayout and set the widget's
    stretch factor. (The stretch factor is along the row of boxes.)
      *
    **addSpacing** () to create an empty box; this is one of the functions you
    use to create nice and spacious dialogs. See below for ways to set margins.
    * **addStretch** () to create an empty, stretchable box.
      * **addLayout**
    () to add a box containing another **QLayout**  to the row and set that
    layout's stretch factor.

    Use **insertWidget** (), **insertSpacing** (), **insertStretch** () or
    **insertLayout** () to insert a box at a specified position in the layout.

    QBoxLayout also includes two margin widths:

    * **setContentsMargins** () sets the width of the outer border on each side
    of the widget. This is the width of the reserved space along each of the
    QBoxLayout's four sides.
      * **setSpacing** () sets the width between
    neighboring boxes. (You can use **addSpacing** () to get more space at a
    particular spot.)

    The margin default is provided by the style. The default margin most Qt
    styles specify is 9 for child widgets and 11 for windows. The spacing
    defaults to the same as the margin width for a top-level layout, or to the
    same as the parent layout.

    To remove a widget from a layout, call **removeWidget** (). Calling
    **QWidget::hide** () on a widget also effectively removes the widget from
    the layout until **QWidget::show** () is called.

    You will almost always want to use **QVBoxLayout**  and **QHBoxLayout**
    rather than QBoxLayout because of their convenient constructors.

    **See also** **QGridLayout** , **QStackedLayout** , and **Layout
    Management** .
    """

    LeftToRight: QBoxLayout.Direction = ...
    RightToLeft: QBoxLayout.Direction = ...
    Down: QBoxLayout.Direction = ...
    TopToBottom: QBoxLayout.Direction = ...
    BottomToTop: QBoxLayout.Direction = ...
    Up: QBoxLayout.Direction = ...

    class Direction(Enum):
        LeftToRight: QBoxLayout.Direction = ...
        RightToLeft: QBoxLayout.Direction = ...
        Down: QBoxLayout.Direction = ...
        TopToBottom: QBoxLayout.Direction = ...
        BottomToTop: QBoxLayout.Direction = ...
        Up: QBoxLayout.Direction = ...

    def __init__(
        self,
        arg__1: PySide6.QtWidgets.QBoxLayout.Direction,
        parent: Optional[PySide6.QtWidgets.QWidget] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qboxlayout.html#QBoxLayout

        **QBoxLayout::QBoxLayout(QBoxLayout::Direction dir , QWidget * parent =
        nullptr)**

        Constructs a new QBoxLayout with direction **dir** and parent widget
        **parent**.

        The layout is set directly as the top-level layout for **parent**. There
        can be only one top-level layout for a widget. It is returned by
        **QWidget::layout** ().

        **See also** **direction** () and **QWidget::setLayout** ().
        """
        ...

    def addItem(self, arg__1: PySide6.QtWidgets.QLayoutItem) -> None:
        """
        https://doc.qt.io/qt-6/qboxlayout.html#addItem

        **[override virtual] void QBoxLayout::addItem(QLayoutItem * item )**

        Reimplements: **QLayout::addItem** (QLayoutItem *item).
        """
        ...

    def addLayout(self, layout: PySide6.QtWidgets.QLayout, stretch: int = ...) -> None:
        """
        https://doc.qt.io/qt-6/qboxlayout.html#addLayout

        **void QBoxLayout::addLayout(QLayout * layout , int stretch = 0)**

        Adds **layout** to the end of the box, with serial stretch factor
        **stretch**.

        **See also** **insertLayout** (), **addItem** (), and **addWidget** ().
        """
        ...

    def addSpacerItem(self, spacerItem: PySide6.QtWidgets.QSpacerItem) -> None:
        """
        https://doc.qt.io/qt-6/qboxlayout.html#addSpacerItem

        **void QBoxLayout::addSpacerItem(QSpacerItem * spacerItem )**

        Adds **spacerItem** to the end of this box layout.

        **See also** **addSpacing** () and **addStretch** ().
        """
        ...

    def addSpacing(self, size: int) -> None:
        """
        https://doc.qt.io/qt-6/qboxlayout.html#addSpacing

        **void QBoxLayout::addSpacing(int size )**

        Adds a non-stretchable space (a **QSpacerItem** ) with size **size** to
        the end of this box layout. **QBoxLayout**  provides default margin and
        spacing. This function adds additional space.

        **See also** **insertSpacing** (), **addItem** (), and **QSpacerItem** .
        """
        ...

    def addStretch(self, stretch: int = ...) -> None:
        """
        https://doc.qt.io/qt-6/qboxlayout.html#addStretch

        **void QBoxLayout::addStretch(int stretch = 0)**

        Adds a stretchable space (a **QSpacerItem** ) with zero minimum size and
        stretch factor **stretch** to the end of this box layout.

        **See also** **insertStretch** (), **addItem** (), and **QSpacerItem** .
        """
        ...

    def addStrut(self, arg__1: int) -> None:
        """
        https://doc.qt.io/qt-6/qboxlayout.html#addStrut

        **void QBoxLayout::addStrut(int size )**

        Limits the perpendicular dimension of the box (e.g. height if the box is
        **LeftToRight** ) to a minimum of **size**. Other constraints may
        increase the limit.

        **See also** **addItem** ().
        """
        ...

    def addWidget(
        self,
        arg__1: PySide6.QtWidgets.QWidget,
        stretch: int = ...,
        alignment: PySide6.QtCore.Qt.Alignment = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qboxlayout.html#addWidget

        **void QBoxLayout::addWidget(QWidget * widget , int stretch = 0,
        Qt::Alignment alignment = Qt::Alignment())**

        Adds **widget** to the end of this box layout, with a stretch factor of
        **stretch** and alignment **alignment**.

        The stretch factor applies only in the **direction**  of the
        **QBoxLayout** , and is relative to the other boxes and widgets in this
        **QBoxLayout** . Widgets and boxes with higher stretch factors grow
        more.

        If the stretch factor is 0 and nothing else in the **QBoxLayout**  has a
        stretch factor greater than zero, the space is distributed according to
        the **QWidget** :sizePolicy() of each widget that's involved.

        The alignment is specified by **alignment**. The default alignment is 0,
        which means that the widget fills the entire cell.

        **See also** **insertWidget** (), **addItem** (), **addLayout** (),
        **addStretch** (), **addSpacing** (), and **addStrut** ().
        """
        ...

    def count(self) -> int:
        """
        https://doc.qt.io/qt-6/qboxlayout.html#count

        **[override virtual] int QBoxLayout::count() const**

        Reimplements: **QLayout::count() const** .
        """
        ...

    def direction(self) -> PySide6.QtWidgets.QBoxLayout.Direction:
        """
        https://doc.qt.io/qt-6/qboxlayout.html#direction

        **QBoxLayout::Direction QBoxLayout::direction() const**

        Returns the direction of the box. **addWidget** () and **addSpacing** ()
        work in this direction; the stretch stretches in this direction.

        **See also** **setDirection** (), **QBoxLayout::Direction** ,
        **addWidget** (), and **addSpacing** ().
        """
        ...

    def expandingDirections(self) -> PySide6.QtCore.Qt.Orientations:
        """
        https://doc.qt.io/qt-6/qboxlayout.html#expandingDirections

        **[override virtual] Qt::Orientations QBoxLayout::expandingDirections()
        const**

        Reimplements: **QLayout::expandingDirections() const** .
        """
        ...

    def hasHeightForWidth(self) -> bool:
        """
        https://doc.qt.io/qt-6/qboxlayout.html#hasHeightForWidth

        **[override virtual] bool QBoxLayout::hasHeightForWidth() const**

        Reimplements: **QLayoutItem::hasHeightForWidth() const** .
        """
        ...

    def heightForWidth(self, arg__1: int) -> int:
        """
        https://doc.qt.io/qt-6/qboxlayout.html#heightForWidth

        **[override virtual] int QBoxLayout::heightForWidth(int w ) const**

        Reimplements: **QLayoutItem::heightForWidth(int) const** .
        """
        ...

    def insertItem(self, index: int, arg__2: PySide6.QtWidgets.QLayoutItem) -> None:
        """
        https://doc.qt.io/qt-6/qboxlayout.html#insertItem

        **void QBoxLayout::insertItem(int index , QLayoutItem * item )**

        Inserts **item** into this box layout at position **index**. If
        **index** is negative, the item is added at the end.

        **See also** **addItem** (), **insertWidget** (), **insertLayout** (),
        **insertStretch** (), and **insertSpacing** ().
        """
        ...

    def insertLayout(
        self, index: int, layout: PySide6.QtWidgets.QLayout, stretch: int = ...
    ) -> None:
        """
        https://doc.qt.io/qt-6/qboxlayout.html#insertLayout

        **void QBoxLayout::insertLayout(int index , QLayout * layout , int
        stretch = 0)**

        Inserts **layout** at position **index** , with stretch factor
        **stretch**. If **index** is negative, the layout is added at the end.

        **layout** becomes a child of the box layout.

        **See also** **addLayout** () and **insertItem** ().
        """
        ...

    def insertSpacerItem(
        self, index: int, spacerItem: PySide6.QtWidgets.QSpacerItem
    ) -> None:
        """
        https://doc.qt.io/qt-6/qboxlayout.html#insertSpacerItem

        **void QBoxLayout::insertSpacerItem(int index , QSpacerItem * spacerItem
        )**

        Inserts **spacerItem** at position **index** , with zero minimum size
        and stretch factor. If **index** is negative the space is added at the
        end.

        **See also** **addSpacerItem** (), **insertStretch** (), and
        **insertSpacing** ().
        """
        ...

    def insertSpacing(self, index: int, size: int) -> None:
        """
        https://doc.qt.io/qt-6/qboxlayout.html#insertSpacing

        **void QBoxLayout::insertSpacing(int index , int size )**

        Inserts a non-stretchable space (a **QSpacerItem** ) at position
        **index** , with size **size**. If **index** is negative the space is
        added at the end.

        The box layout has default margin and spacing. This function adds
        additional space.

        **See also** **addSpacing** (), **insertItem** (), and **QSpacerItem** .
        """
        ...

    def insertStretch(self, index: int, stretch: int = ...) -> None:
        """
        https://doc.qt.io/qt-6/qboxlayout.html#insertStretch

        **void QBoxLayout::insertStretch(int index , int stretch = 0)**

        Inserts a stretchable space (a **QSpacerItem** ) at position **index** ,
        with zero minimum size and stretch factor **stretch**. If **index** is
        negative the space is added at the end.

        **See also** **addStretch** (), **insertItem** (), and **QSpacerItem** .
        """
        ...

    def insertWidget(
        self,
        index: int,
        widget: PySide6.QtWidgets.QWidget,
        stretch: int = ...,
        alignment: PySide6.QtCore.Qt.Alignment = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qboxlayout.html#insertWidget

        **void QBoxLayout::insertWidget(int index , QWidget * widget , int
        stretch = 0, Qt::Alignment alignment = Qt::Alignment())**

        Inserts **widget** at position **index** , with stretch factor
        **stretch** and alignment **alignment**. If **index** is negative, the
        widget is added at the end.

        The stretch factor applies only in the **direction**  of the
        **QBoxLayout** , and is relative to the other boxes and widgets in this
        **QBoxLayout** . Widgets and boxes with higher stretch factors grow
        more.

        If the stretch factor is 0 and nothing else in the **QBoxLayout**  has a
        stretch factor greater than zero, the space is distributed according to
        the **QWidget** :sizePolicy() of each widget that's involved.

        The alignment is specified by **alignment**. The default alignment is 0,
        which means that the widget fills the entire cell.

        **See also** **addWidget** () and **insertItem** ().
        """
        ...

    def invalidate(self) -> None:
        """
        https://doc.qt.io/qt-6/qboxlayout.html#invalidate

        **[override virtual] void QBoxLayout::invalidate()**

        Reimplements: **QLayout::invalidate** ().

        Resets cached information.
        """
        ...

    def itemAt(self, arg__1: int) -> PySide6.QtWidgets.QLayoutItem:
        """
        https://doc.qt.io/qt-6/qboxlayout.html#itemAt

        **[override virtual] QLayoutItem *QBoxLayout::itemAt(int index ) const**

        Reimplements: **QLayout::itemAt(int index) const** .
        """
        ...

    def maximumSize(self) -> PySide6.QtCore.QSize:
        """
        https://doc.qt.io/qt-6/qboxlayout.html#maximumSize

        **[override virtual] QSize QBoxLayout::maximumSize() const**

        Reimplements: **QLayout::maximumSize() const** .
        """
        ...

    def minimumHeightForWidth(self, arg__1: int) -> int:
        """
        https://doc.qt.io/qt-6/qboxlayout.html#minimumHeightForWidth

        **[override virtual] int QBoxLayout::minimumHeightForWidth(int w )
        const**

        Reimplements: **QLayoutItem::minimumHeightForWidth(int w) const** .
        """
        ...

    def minimumSize(self) -> PySide6.QtCore.QSize:
        """
        https://doc.qt.io/qt-6/qboxlayout.html#minimumSize

        **[override virtual] QSize QBoxLayout::minimumSize() const**

        Reimplements: **QLayout::minimumSize() const** .
        """
        ...

    def setDirection(self, arg__1: PySide6.QtWidgets.QBoxLayout.Direction) -> None:
        """
        https://doc.qt.io/qt-6/qboxlayout.html#setDirection

        **void QBoxLayout::setDirection(QBoxLayout::Direction direction )**

        Sets the direction of this layout to **direction**.

        **See also** **direction** ().
        """
        ...

    def setGeometry(self, arg__1: PySide6.QtCore.QRect) -> None:
        """
        https://doc.qt.io/qt-6/qboxlayout.html#setGeometry

        **[override virtual] void QBoxLayout::setGeometry(const QRect & r )**

        Reimplements: **QLayout::setGeometry** (const QRect &r).
        """
        ...

    def setSpacing(self, spacing: int) -> None:
        """
        https://doc.qt.io/qt-6/qboxlayout.html#setSpacing

        **[override virtual] void QBoxLayout::setSpacing(int spacing )**

        Reimplements an access function for property: **QLayout::spacing** .

        Reimplements **QLayout::setSpacing** (). Sets the spacing property to
        **spacing**.

        **See also** **QLayout::setSpacing** () and **spacing** ().
        """
        ...

    def setStretch(self, index: int, stretch: int) -> None:
        """
        https://doc.qt.io/qt-6/qboxlayout.html#setStretch

        **void QBoxLayout::setStretch(int index , int stretch )**

        Sets the stretch factor at position **index**. to **stretch**.

        **See also** **stretch** ().
        """
        ...

    @overload
    def setStretchFactor(self, l: PySide6.QtWidgets.QLayout, stretch: int) -> bool:
        """
        https://doc.qt.io/qt-6/qboxlayout.html#setStretchFactor

        **bool QBoxLayout::setStretchFactor(QWidget * widget , int stretch )**

        Sets the stretch factor for **widget** to **stretch** and returns true
        if **widget** is found in this layout (not including child layouts);
        otherwise returns `false`.

        **See also** **setAlignment** ().
        """
        ...

    @overload
    def setStretchFactor(self, w: PySide6.QtWidgets.QWidget, stretch: int) -> bool:
        """
        https://doc.qt.io/qt-6/qboxlayout.html#setStretchFactor-1

        **bool QBoxLayout::setStretchFactor(QLayout * layout , int stretch )**

        This is an overloaded function.

        Sets the stretch factor for the layout **layout** to **stretch** and
        returns `true` if **layout** is found in this layout (not including
        child layouts); otherwise returns `false`.
        """
        ...

    def sizeHint(self) -> PySide6.QtCore.QSize:
        """
        https://doc.qt.io/qt-6/qboxlayout.html#sizeHint

        **[override virtual] QSize QBoxLayout::sizeHint() const**

        Reimplements: **QLayoutItem::sizeHint() const** .
        """
        ...

    def spacing(self) -> int:
        """
        https://doc.qt.io/qt-6/qboxlayout.html#spacing

        **[override virtual] int QBoxLayout::spacing() const**

        Reimplements an access function for property: **QLayout::spacing** .

        Reimplements **QLayout::spacing** (). If the spacing property is valid,
        that value is returned. Otherwise, a value for the spacing property is
        computed and returned. Since layout spacing in a widget is style
        dependent, if the parent is a widget, it queries the style for the
        (horizontal or vertical) spacing of the layout. Otherwise, the parent is
        a layout, and it queries the parent layout for the spacing().

        **See also** **QLayout::spacing** () and **setSpacing** ().
        """
        ...

    def stretch(self, index: int) -> int:
        """
        https://doc.qt.io/qt-6/qboxlayout.html#stretch

        **int QBoxLayout::stretch(int index ) const**

        Returns the stretch factor at position **index**.

        **See also** **setStretch** ().
        """
        ...

    def takeAt(self, arg__1: int) -> PySide6.QtWidgets.QLayoutItem:
        """
        https://doc.qt.io/qt-6/qboxlayout.html#takeAt

        **[override virtual] QLayoutItem *QBoxLayout::takeAt(int index )**

        Reimplements: **QLayout::takeAt** (int index).
        """
        ...
