"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtWebSockets, except for defaults which are replaced by "...".
"""
from typing import Optional
import PySide6.QtCore
import PySide6.QtNetwork
import PySide6.QtWebSockets

bytes = str


class QMaskGenerator(PySide6.QtCore.QObject):
    """
    https://doc.qt.io/qt-6/qmaskgenerator.html

    **Detailed Description**

    The WebSockets specification as outlined in **RFC 6455**  requires that all
    communication from client to server be masked. This is to prevent malicious
    scripts from attacking badly behaving proxies. For more information about
    the importance of good masking, see **"Talking to Yourself for Fun and
    Profit" by Lin-Shung Huang et al** . By default **QWebSocket**  uses the
    reasonably secure **QRandomGenerator::global** ()->generate() function. The
    best measure against attacks mentioned in the document above, is to use
    **QWebSocket**  over a secure connection ( **wss://** ). In general, always
    be careful to not have 3rd party script access to a **QWebSocket**  in your
    application.
    """

    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qmaskgenerator.html#QMaskGenerator-1

        **QMaskGenerator::QMaskGenerator(QObject * parent = nullptr)**

        Creates a new QMaskGenerator object with the given optional **QObject**
        **parent**.
        """
        ...

    def nextMask(self) -> int:
        """
        https://doc.qt.io/qt-6/qmaskgenerator.html#nextMask

        **[pure virtual] quint32 QMaskGenerator::nextMask()**

        Returns a new random 32-bit mask. The randomness depends on the RNG used
        to created the mask.
        """
        ...

    def seed(self) -> bool:
        """
        https://doc.qt.io/qt-6/qmaskgenerator.html#seed

        **[pure virtual] bool QMaskGenerator::seed()**

        Initializes the **QMaskGenerator**  by seeding the randomizer. When
        seed() is not called, it depends on the specific implementation of a
        subclass if a default seed is used or no seed is used at all. Returns
        **true** if seeding succeeds, otherwise false.
        """
        ...
