"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtWebEngineWidgets, except for defaults which are replaced by "...".
"""
from typing import Optional, Union, overload
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets
import PySide6.QtPrintSupport
import PySide6.QtWebEngineCore
import PySide6.QtWebEngineWidgets

bytes = str


class QWebEngineView(PySide6.QtWidgets.QWidget):
    """
    https://doc.qt.io/qt-6/qwebengineview.html

    **Detailed Description**

    A **web view** is the main widget component of the Qt WebEngine web browsing
    module. It can be used in various applications to display web content live
    from the Internet.

    A **web site** can be loaded to a web view with the **load** () function.
    The GET method is always used to load URLs.

    Like all Qt widgets, the **show** () function must be invoked in order to
    display the web view. The snippet below illustrates this:

    **QWebEngineView**  *view = new **QWebEngineView** (parent);
    view->load(**QUrl** ("http://qt-project.org/"));
            view->show();

    Alternatively, **setUrl** () can be used to load a web site. If you have the
    HTML content readily available, you can use **setHtml** () instead.

    The **loadStarted** () signal is emitted when the view begins loading and
    the **loadProgress** () signal is emitted whenever an element of the web
    view completes loading, such as an embedded image or a script. The
    **loadFinished** () signal is emitted when the view has been loaded
    completely. Its argument, either `true` or `false`, indicates whether
    loading was successful or failed.

    The **page** () function returns a pointer to a **web page** object. A
    QWebEngineView contains a **QWebEnginePage** , which in turn allows access
    to the **QWebEngineHistory**  in the page's context.

    The title of an HTML document can be accessed with the **title** ()
    property. Additionally, a web site may specify an icon, which can be
    accessed using the **icon** () or its URL using the **iconUrl** () property.
    If the title or the icon changes, the corresponding **titleChanged** (),
    **iconChanged** () and **iconUrlChanged** () signals will be emitted. The
    **zoomFactor** () property enables zooming the contents of the web page by a
    scale factor.

    The widget features a context menu that is tailored to the element at hand,
    and includes actions useful in a browser. For a custom context menu, or for
    embedding actions in a menu or toolbar, the individual actions are available
    via **pageAction** (). The web view maintains the state of the returned
    actions, but allows modification of action properties such as **text**  or
    **icon** . The action semantics can also be triggered directly through
    **triggerPageAction** ().

    If you want to provide support for web sites that allow the user to open new
    windows, such as pop-up windows, you can subclass QWebEngineView and
    reimplement the **createWindow** () function.

    **See also** **WebEngine Widgets Simple Browser Example** , **WebEngine
    Content Manipulation Example** , and **WebEngine Markdown Editor Example** .
    """

    def __init__(self, parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qwebengineview.html#QWebEngineView

        **QWebEngineView::QWebEngineView(QWidget * parent = nullptr)**

        Constructs an empty web view with the parent **parent**.

        **See also** **load** ().
        """
        ...

    def back(self) -> None:
        """
        https://doc.qt.io/qt-6/qwebengineview.html#back

        **[slot] void QWebEngineView::back()**

        Convenience slot that loads the previous document in the list of
        documents built by navigating links. Does nothing if there is no
        previous document.

        It is equivalent to:

        view->page()->triggerAction(**QWebEnginePage** ::Back);

        **See also** **forward** () and **pageAction** ().
        """
        ...

    def closeEvent(self, arg__1: PySide6.QtGui.QCloseEvent) -> None:
        """
        https://doc.qt.io/qt-6/qwebengineview.html#closeEvent

        **[override virtual protected] void
        QWebEngineView::closeEvent(QCloseEvent * event )**

        Reimplements: **QWidget::closeEvent** (QCloseEvent *event).
        """
        ...

    def contextMenuEvent(self, arg__1: PySide6.QtGui.QContextMenuEvent) -> None:
        """
        https://doc.qt.io/qt-6/qwebengineview.html#contextMenuEvent

        **[override virtual protected] void
        QWebEngineView::contextMenuEvent(QContextMenuEvent * event )**

        Reimplements: **QWidget::contextMenuEvent** (QContextMenuEvent *event).
        """
        ...

    def createStandardContextMenu(self) -> PySide6.QtWidgets.QMenu:
        """
        https://doc.qt.io/qt-6/qwebengineview.html#createStandardContextMenu

        **QMenu *QWebEngineView::createStandardContextMenu()**

        Creates a standard context menu and returns a pointer to it.
        """
        ...

    def createWindow(
        self, type: PySide6.QtWebEngineCore.QWebEnginePage.WebWindowType
    ) -> PySide6.QtWebEngineWidgets.QWebEngineView:
        """
        https://doc.qt.io/qt-6/qwebengineview.html#createWindow

        **[virtual protected] QWebEngineView
        *QWebEngineView::createWindow(QWebEnginePage::WebWindowType type )**

        This function is called from the **createWindow** () method of the
        associated **QWebEnginePage**  each time the page wants to create a new
        window of the given **type**. For example, when a JavaScript request to
        open a document in a new window is issued.

        **Note:** If the `createWindow()` method of the associated page is
        reimplemented, this method is not called, unless explicitly done so in
        the reimplementation.

        **See also** **QWebEnginePage::createWindow** ().
        """
        ...

    def dragEnterEvent(self, e: PySide6.QtGui.QDragEnterEvent) -> None:
        """
        https://doc.qt.io/qt-6/qwebengineview.html#dragEnterEvent

        **[override virtual protected] void
        QWebEngineView::dragEnterEvent(QDragEnterEvent * e )**

        Reimplements: **QWidget::dragEnterEvent** (QDragEnterEvent *event).
        """
        ...

    def dragLeaveEvent(self, e: PySide6.QtGui.QDragLeaveEvent) -> None:
        """
        https://doc.qt.io/qt-6/qwebengineview.html#dragLeaveEvent

        **[override virtual protected] void
        QWebEngineView::dragLeaveEvent(QDragLeaveEvent * e )**

        Reimplements: **QWidget::dragLeaveEvent** (QDragLeaveEvent *event).
        """
        ...

    def dragMoveEvent(self, e: PySide6.QtGui.QDragMoveEvent) -> None:
        """
        https://doc.qt.io/qt-6/qwebengineview.html#dragMoveEvent

        **[override virtual protected] void
        QWebEngineView::dragMoveEvent(QDragMoveEvent * e )**

        Reimplements: **QWidget::dragMoveEvent** (QDragMoveEvent *event).
        """
        ...

    def dropEvent(self, e: PySide6.QtGui.QDropEvent) -> None:
        """
        https://doc.qt.io/qt-6/qwebengineview.html#dropEvent

        **[override virtual protected] void QWebEngineView::dropEvent(QDropEvent
        * e )**

        Reimplements: **QWidget::dropEvent** (QDropEvent *event).
        """
        ...

    def event(self, arg__1: PySide6.QtCore.QEvent) -> bool:
        """
        https://doc.qt.io/qt-6/qwebengineview.html#event

        **[override virtual protected] bool QWebEngineView::event(QEvent * ev
        )**

        Reimplements: **QWidget::event** (QEvent *event).
        """
        ...

    @overload
    def findText(
        self,
        arg__1: str,
        arg__2: PySide6.QtWebEngineCore.QWebEnginePage.FindFlags,
        arg__3: object,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qwebengineview.html#findText

        **void QWebEngineView::findText(const QString & subString ,
        QWebEnginePage::FindFlags options = {}, const std::function<void (const
        QWebEngineFindTextResult &)> & resultCallback = ...)**

        Finds the specified string, **subString** , in the page, using the given
        **options**.

        To clear the selection, just pass an empty string.

        The **resultCallback** must take a **QWebEngineFindTextResult**
        parameter.

        **Warning:** We guarantee that the callback ( **resultCallback** ) is
        always called, but it might be done during page destruction. When
        **QWebEnginePage**  is deleted, the callback is triggered with an
        invalid value and it is not safe to use the corresponding
        **QWebEnginePage**  or **QWebEngineView**  instance inside it.

        **See also** **selectedText** () and **selectionChanged** ().
        """
        ...

    @overload
    def findText(
        self,
        subString: str,
        options: PySide6.QtWebEngineCore.QWebEnginePage.FindFlags = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qwebengineview.html#findText

        **void QWebEngineView::findText(const QString & subString ,
        QWebEnginePage::FindFlags options = {}, const std::function<void (const
        QWebEngineFindTextResult &)> & resultCallback = ...)**

        Finds the specified string, **subString** , in the page, using the given
        **options**.

        To clear the selection, just pass an empty string.

        The **resultCallback** must take a **QWebEngineFindTextResult**
        parameter.

        **Warning:** We guarantee that the callback ( **resultCallback** ) is
        always called, but it might be done during page destruction. When
        **QWebEnginePage**  is deleted, the callback is triggered with an
        invalid value and it is not safe to use the corresponding
        **QWebEnginePage**  or **QWebEngineView**  instance inside it.

        **See also** **selectedText** () and **selectionChanged** ().
        """
        ...

    @staticmethod
    def forPage(
        page: PySide6.QtWebEngineCore.QWebEnginePage,
    ) -> PySide6.QtWebEngineWidgets.QWebEngineView:
        """
        https://doc.qt.io/qt-6/qwebengineview.html#forPage

        **[static, since 6.2] QWebEngineView *QWebEngineView::forPage(const
        QWebEnginePage * page )**

        Returns the view if any, associated with the **page**.

        This function was introduced in Qt 6.2.

        **See also** **page** () and **setPage** ().
        """
        ...

    def forward(self) -> None:
        """
        https://doc.qt.io/qt-6/qwebengineview.html#forward

        **[slot] void QWebEngineView::forward()**

        Convenience slot that loads the next document in the list of documents
        built by navigating links. Does nothing if there is no next document.

        It is equivalent to:

        view->page()->triggerAction(**QWebEnginePage** ::Forward);

        **See also** **back** () and **pageAction** ().
        """
        ...

    def hasSelection(self) -> bool:
        """
        https://doc.qt.io/qt-6/qwebengineview.html#hasSelection-prop

        **[read-only] hasSelection : const bool**

        This property holds whether this page contains selected content or not.

        By default, this property is `false`.

        **Access functions:**

        bool **hasSelection** () const

        **See also** **selectionChanged** ().
        """
        ...

    def hideEvent(self, arg__1: PySide6.QtGui.QHideEvent) -> None:
        """
        https://doc.qt.io/qt-6/qwebengineview.html#hideEvent

        **[override virtual protected] void QWebEngineView::hideEvent(QHideEvent
        * event )**

        Reimplements: **QWidget::hideEvent** (QHideEvent *event).
        """
        ...

    def history(self) -> PySide6.QtWebEngineCore.QWebEngineHistory:
        """
        https://doc.qt.io/qt-6/qwebengineview.html#history

        **QWebEngineHistory *QWebEngineView::history() const**

        Returns a pointer to the view's history of navigated web pages.

        It is equivalent to:

        view->page()->history();
        """
        ...

    def icon(self) -> PySide6.QtGui.QIcon:
        """
        https://doc.qt.io/qt-6/qwebengineview.html#icon-prop

        **[read-only, since 5.7] icon : const QIcon**

        This property holds the icon associated with the page currently viewed.

        By default, this property contains a null icon.

        This property was introduced in Qt 5.7.

        **Access functions:**

        QIcon **icon** () const

        **Notifier signal:**

        void ****iconChanged** ** (const QIcon & **icon** )

        **See also** **iconChanged** (), **iconUrl** (), and **iconUrlChanged**
        ().
        """
        ...

    def iconUrl(self) -> PySide6.QtCore.QUrl:
        """
        https://doc.qt.io/qt-6/qwebengineview.html#iconUrl-prop

        **[read-only] iconUrl : const QUrl**

        This property holds the URL of the icon associated with the page
        currently viewed.

        By default, this property contains an empty URL.

        **Access functions:**

        QUrl **iconUrl** () const

        **Notifier signal:**

        void ****iconUrlChanged** ** (const QUrl & **url** )

        **See also** **iconUrlChanged** (), **icon** (), and **iconChanged** ().
        """
        ...

    def lastContextMenuRequest(
        self,
    ) -> PySide6.QtWebEngineCore.QWebEngineContextMenuRequest:
        """
        https://doc.qt.io/qt-6/qwebengineview.html#lastContextMenuRequest

        **[since 6.2] QWebEngineContextMenuRequest
        *QWebEngineView::lastContextMenuRequest() const**

        Returns additional data about the current context menu. It is only
        guaranteed to be valid during the call to the **contextMenuEvent** ().

        This function was introduced in Qt 6.2.

        **See also** **createStandardContextMenu** ().
        """
        ...

    @overload
    def load(self, request: PySide6.QtWebEngineCore.QWebEngineHttpRequest) -> None:
        """
        https://doc.qt.io/qt-6/qwebengineview.html#load

        **void QWebEngineView::load(const QUrl & url )**

        Loads the specified **url** and displays it.

        **Note:** The view remains the same until enough data has arrived to
        display the new URL.

        **See also**  load(), **setUrl** (), **url** (), **urlChanged** (), and
        **QUrl::fromUserInput** ().
        """
        ...

    @overload
    def load(self, url: Union[PySide6.QtCore.QUrl, str]) -> None:
        """
        https://doc.qt.io/qt-6/qwebengineview.html#load-1

        **[since 5.9] void QWebEngineView::load(const QWebEngineHttpRequest &
        request )**

        Issues the specified **request** and loads the response.

        This function was introduced in Qt 5.9.

        **See also** **load** (), **setUrl** (), **url** (), **urlChanged** (),
        and **QUrl::fromUserInput** ().
        """
        ...

    def page(self) -> PySide6.QtWebEngineCore.QWebEnginePage:
        """
        https://doc.qt.io/qt-6/qwebengineview.html#page

        **QWebEnginePage *QWebEngineView::page() const**

        Returns a pointer to the underlying web page.

        **See also** **setPage** ().
        """
        ...

    def pageAction(
        self, action: PySide6.QtWebEngineCore.QWebEnginePage.WebAction
    ) -> PySide6.QtGui.QAction:
        """
        https://doc.qt.io/qt-6/qwebengineview.html#pageAction

        **QAction *QWebEngineView::pageAction(QWebEnginePage::WebAction action )
        const**

        Returns a pointer to a **QAction**  that encapsulates the specified web
        action **action**.
        """
        ...

    def print(self, printer: PySide6.QtPrintSupport.QPrinter) -> None:
        """
        https://doc.qt.io/qt-6/qwebengineview.html#print

        **[since 6.2] void QWebEngineView::print(QPrinter * printer )**

        Renders the current content of the page into a temporary PDF document,
        then prints it using **printer**.

        The settings for creating and printing the PDF document will be
        retrieved from the **printer** object.

        When finished the signal **printFinished** () is emitted with the `true`
        for success or `false` for failure.

        It is the users responsibility to ensure the **printer** remains valid
        until **printFinished** () has been emitted.

        **Note:** Printing runs on the browser process, which is by default not
        sandboxed.

        **Note:** This function rasterizes the result when rendering onto
        **printer**. Please consider raising the default resolution of
        **printer** to at least 300 DPI or using **printToPdf** () to produce
        PDF file output more effectively.

        This function was introduced in Qt 6.2.
        """
        ...

    def printToPdf(
        self,
        filePath: str,
        layout: PySide6.QtGui.QPageLayout = ...,
        ranges: PySide6.QtGui.QPageRanges = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qwebengineview.html#printToPdf

        **[since 6.2] void QWebEngineView::printToPdf(const QString & filePath ,
        const QPageLayout & layout = QPageLayout(QPageSize(QPageSize::A4),
        QPageLayout::Portrait, QMarginsF()), const QPageRanges & ranges = {})**

        Renders the current content of the page into a PDF document and saves it
        in the location specified in **filePath**. The page size and orientation
        of the produced PDF document are taken from the values specified in
        **layout** , while the range of pages printed is taken from **ranges**
        with the default being printing all pages.

        This method issues an asynchronous request for printing the web page
        into a PDF and returns immediately. To be informed about the result of
        the request, connect to the signal **pdfPrintingFinished** ().

        If a file already exists at the provided file path, it will be
        overwritten.

        This function was introduced in Qt 6.2.

        **See also** **pdfPrintingFinished** ().
        """
        ...

    def reload(self) -> None:
        """
        https://doc.qt.io/qt-6/qwebengineview.html#reload

        **[slot] void QWebEngineView::reload()**

        Reloads the current document.

        **See also** **stop** (), **pageAction** (), and **loadStarted** ().
        """
        ...

    def selectedText(self) -> str:
        """
        https://doc.qt.io/qt-6/qwebengineview.html#selectedText-prop

        **[read-only] selectedText : const QString**

        This property holds the text currently selected.

        By default, this property contains an empty string.

        **Access functions:**

        QString **selectedText** () const

        **See also** **findText** () and **selectionChanged** ().
        """
        ...

    def setContent(
        self,
        data: Union[PySide6.QtCore.QByteArray, bytes],
        mimeType: str = ...,
        baseUrl: Union[PySide6.QtCore.QUrl, str] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qwebengineview.html#setContent

        **void QWebEngineView::setContent(const QByteArray & data , const
        QString & mimeType = QString(), const QUrl & baseUrl = QUrl())**

        Sets the content of the web view to **data**. If the **mimeType**
        argument is empty, it is assumed that the content is
        `text/plain,charset=US-ASCII`.

        External objects referenced in the content are located relative to
        **baseUrl**. For external objects to be loaded, `baseUrl` cannot be
        empty.

        The data is loaded immediately; external objects are loaded
        asynchronously.

        **See also** **load** (), **setHtml** (), and **QWebEnginePage::toHtml**
        ().
        """
        ...

    def setHtml(
        self, html: str, baseUrl: Union[PySide6.QtCore.QUrl, str] = ...
    ) -> None:
        """
        https://doc.qt.io/qt-6/qwebengineview.html#setHtml

        **void QWebEngineView::setHtml(const QString & html , const QUrl &
        baseUrl = QUrl())**

        Sets the content of the web view to the specified **html** content.

        External objects, such as stylesheets or images referenced in the HTML
        document, are located relative to **baseUrl**. For external objects to
        be loaded, `baseUrl` cannot be empty. For example, if **html** is
        retrieved from `http://www.example.com/documents/overview.html`, which
        is the base URL, then an image referenced with the relative URL,
        `diagram.png`, should be at
        `http://www.example.com/documents/diagram.png`.

        The HTML document is loaded immediately, whereas external objects are
        loaded asynchronously.

        When using this method, Qt WebEngine assumes that external resources,
        such as JavaScript programs or style sheets, are encoded in UTF-8 unless
        otherwise specified. For example, the encoding of an external script can
        be specified through the `charset` attribute of the HTML script tag.
        Alternatively, the encoding can be specified by the web server.

        This is a convenience function equivalent to `setContent(html,
        "text/html;charset=UTF-8", baseUrl)`.

        **Warning:** This function works only for HTML. For other MIME types
        (such as XHTML or SVG), **setContent** () should be used instead.

        **Note:** Content larger than 2 MB cannot be displayed, because
        setHtml() converts the provided HTML to percent-encoding and places
        `data`: in front of it to create the URL that it navigates to. Thereby,
        the provided code becomes a URL that exceeds the 2 MB limit set by
        Chromium. If the content is too large, the **loadFinished** () signal is
        triggered with `success=false`.

        **See also** **load** (), **setContent** (), **QWebEnginePage::toHtml**
        (), and **QWebEnginePage::setContent** ().
        """
        ...

    def setPage(self, page: PySide6.QtWebEngineCore.QWebEnginePage) -> None:
        """
        https://doc.qt.io/qt-6/qwebengineview.html#setPage

        **void QWebEngineView::setPage(QWebEnginePage * page )**

        Makes **page** the new web page of the web view.

        The parent **QObject**  of the provided page remains the owner of the
        object. If the current page is a child of the web view, it will be
        deleted.

        **See also** **page** ().
        """
        ...

    def setUrl(self, url: Union[PySide6.QtCore.QUrl, str]) -> None:
        """
        https://doc.qt.io/qt-6/qwebengineview.html#url-prop

        **url : QUrl**

        This property holds the URL of the web page currently viewed.

        Setting this property clears the view and loads the URL.

        By default, this property contains an empty, invalid URL.

        **Access functions:**

        QUrl **url** () const
        void **setUrl** (const QUrl & **url** )

        **See also** **load** () and **urlChanged** ().
        """
        ...

    def setZoomFactor(self, factor: float) -> None:
        """
        https://doc.qt.io/qt-6/qwebengineview.html#zoomFactor-prop

        **zoomFactor : qreal**

        This property holds the zoom factor for the view.

        Valid values are within the range from `0.25` to `5.0`. The default
        factor is `1.0`.

        **Access functions:**

        qreal **zoomFactor** () const
        void **setZoomFactor** (qreal **factor**
        )

        **Member Function Documentation**
        """
        ...

    def settings(self) -> PySide6.QtWebEngineCore.QWebEngineSettings:
        """
        https://doc.qt.io/qt-6/qwebengineview.html#settings

        **QWebEngineSettings *QWebEngineView::settings() const**

        Returns a pointer to the view or page specific settings object.

        It is equivalent to:

        view->page()->settings();
        """
        ...

    def showEvent(self, arg__1: PySide6.QtGui.QShowEvent) -> None:
        """
        https://doc.qt.io/qt-6/qwebengineview.html#showEvent

        **[override virtual protected] void QWebEngineView::showEvent(QShowEvent
        * event )**

        Reimplements: **QWidget::showEvent** (QShowEvent *event).
        """
        ...

    def sizeHint(self) -> PySide6.QtCore.QSize:
        """
        https://doc.qt.io/qt-6/qwebengineview.html#sizeHint

        **[override virtual] QSize QWebEngineView::sizeHint() const**

        Reimplements an access function for property: **QWidget::sizeHint** .
        """
        ...

    def stop(self) -> None:
        """
        https://doc.qt.io/qt-6/qwebengineview.html#stop

        **[slot] void QWebEngineView::stop()**

        Convenience slot that stops loading the document.

        It is equivalent to:

        view->page()->triggerAction(**QWebEnginePage** ::Stop);

        **See also** **reload** (), **pageAction** (), and **loadFinished** ().
        """
        ...

    def title(self) -> str:
        """
        https://doc.qt.io/qt-6/qwebengineview.html#title-prop

        **[read-only] title : const QString**

        This property holds the title of the page as defined by the HTML
        `<title>` element.

        Equivalent to **QWebEnginePage::title** ().

        **Access functions:**

        QString **title** () const

        **See also** **titleChanged** ().
        """
        ...

    def triggerPageAction(
        self,
        action: PySide6.QtWebEngineCore.QWebEnginePage.WebAction,
        checked: bool = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qwebengineview.html#triggerPageAction

        **void QWebEngineView::triggerPageAction(QWebEnginePage::WebAction
        action , bool checked = false)**

        Triggers the specified **action**. If it is a checkable action, the
        specified **checked** state is assumed.

        The following example triggers the copy action and therefore copies any
        selected text to the clipboard.

        view->triggerPageAction(**QWebEnginePage** ::Copy);

        **See also** **pageAction** ().
        """
        ...

    def url(self) -> PySide6.QtCore.QUrl:
        """
        https://doc.qt.io/qt-6/qwebengineview.html#url-prop

        **url : QUrl**

        This property holds the URL of the web page currently viewed.

        Setting this property clears the view and loads the URL.

        By default, this property contains an empty, invalid URL.

        **Access functions:**

        QUrl **url** () const
        void **setUrl** (const QUrl & **url** )

        **See also** **load** () and **urlChanged** ().
        """
        ...

    def zoomFactor(self) -> float:
        """
        https://doc.qt.io/qt-6/qwebengineview.html#zoomFactor-prop

        **zoomFactor : qreal**

        This property holds the zoom factor for the view.

        Valid values are within the range from `0.25` to `5.0`. The default
        factor is `1.0`.

        **Access functions:**

        qreal **zoomFactor** () const
        void **setZoomFactor** (qreal **factor**
        )

        **Member Function Documentation**
        """
        ...

    @property
    def iconChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qwebengineview.html#iconChanged

        **[signal, since 5.7] void QWebEngineView::iconChanged(const QIcon &
        icon )**

        This signal is emitted when the icon ("favicon") associated with the
        view is changed. The new icon is specified by **icon**.

        **Note:** Notifier signal for property **icon** .

        This function was introduced in Qt 5.7.

        **See also** **icon** (), **iconUrl** (), and **iconUrlChanged** ().
        """
        ...

    @property
    def iconUrlChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qwebengineview.html#iconUrlChanged

        **[signal] void QWebEngineView::iconUrlChanged(const QUrl & url )**

        This signal is emitted when the URL of the icon ("favicon") associated
        with the view is changed. The new URL is specified by **url**.

        **Note:** Notifier signal for property **iconUrl** .

        **See also** **iconUrl** (), **icon** (), and **iconChanged** ().
        """
        ...

    @property
    def loadFinished(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qwebengineview.html#loadFinished

        **[signal] void QWebEngineView::loadFinished(bool ok )**

        This signal is emitted when a load of the page has finished. **ok** will
        indicate whether the load was successful or an error occurred.

        **See also** **loadStarted** ().
        """
        ...

    @property
    def loadProgress(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qwebengineview.html#loadProgress

        **[signal] void QWebEngineView::loadProgress(int progress )**

        This signal is emitted every time an element in the web view completes
        loading, such as an embedded image or a script. Therefore, it tracks the
        collective progress of loading the web view.

        The current value is provided by **progress** and scales from 0 to 100,
        which is the default range of **QProgressBar** .

        **See also** **loadStarted** () and **loadFinished** ().
        """
        ...

    @property
    def loadStarted(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qwebengineview.html#loadStarted

        **[signal] void QWebEngineView::loadStarted()**

        This signal is emitted when a new load of the page is started.

        **See also** **loadProgress** () and **loadFinished** ().
        """
        ...

    @property
    def pdfPrintingFinished(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qwebengineview.html#pdfPrintingFinished

        **[signal, since 6.2] void QWebEngineView::pdfPrintingFinished(const
        QString & filePath , bool success )**

        This signal is emitted when printing the web page into a PDF file has
        finished. **filePath** will contain the path the file was requested to
        be created at, and **success** will be `true` if the file was
        successfully created and `false` otherwise.

        This function was introduced in Qt 6.2.

        **See also** **printToPdf** ().
        """
        ...

    @property
    def printFinished(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qwebengineview.html#printFinished

        **[signal, since 6.2] void QWebEngineView::printFinished(bool success
        )**

        This signal is emitted when printing requested with **print** () has
        finished. The parameter **success** is `true` for success or `false` for
        failure.

        This function was introduced in Qt 6.2.

        **See also** **print** ().
        """
        ...

    @property
    def printRequested(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qwebengineview.html#printRequested

        **[signal, since 6.2] void QWebEngineView::printRequested()**

        This signal is emitted when the JavaScript `window.print()` method is
        called. Typically, the signal handler can simply call **print** ().

        This function was introduced in Qt 6.2.

        **See also** **print** ().
        """
        ...

    @property
    def renderProcessTerminated(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qwebengineview.html#renderProcessTerminated

        **[signal, since 5.6] void QWebEngineView::renderProcessTerminated(QWebE
        nginePage::RenderProcessTerminationStatus terminationStatus , int
        exitCode )**

        This signal is emitted when the render process is terminated with a non-
        zero exit status. **terminationStatus** is the termination status of the
        process and **exitCode** is the status code with which the process
        terminated.

        This function was introduced in Qt 5.6.
        """
        ...

    @property
    def selectionChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qwebengineview.html#selectionChanged

        **[signal] void QWebEngineView::selectionChanged()**

        This signal is emitted whenever the selection changes.

        **Note:** When using the mouse to select text by left-clicking and
        dragging, the signal will be emitted for each new character selected,
        and not upon releasing the left mouse button.

        **See also** **selectedText** ().
        """
        ...

    @property
    def titleChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qwebengineview.html#titleChanged

        **[signal] void QWebEngineView::titleChanged(const QString & title )**

        This signal is emitted whenever the **title** of the view changes.

        **See also** **title** ().
        """
        ...

    @property
    def urlChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qwebengineview.html#urlChanged

        **[signal] void QWebEngineView::urlChanged(const QUrl & url )**

        This signal is emitted when the **url** of the view changes.

        **See also** **url** () and **load** ().
        """
        ...
