"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtWebEngineCore, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import Union, overload
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtNetwork
import PySide6.QtWebChannel
import PySide6.QtWebEngineCore

bytes = str


class QWebEngineUrlScheme(object):
    """
    https://doc.qt.io/qt-6/qwebengineurlscheme.html

    **Detailed Description**

    A web engine URL scheme describes a URL scheme from the web engine's
    perspective, specifying how URLs of this scheme should be parsed, and which
    security restrictions should be placed on resources originating from such
    URLs.

    Custom URL schemes must be configured early at application startup, before
    creating any Qt WebEngine classes. In general this means the schemes need to
    be configured before a **QGuiApplication**  or **QApplication**  instance is
    created.

    Every registered scheme configuration applies globally to all profiles.

    int main(int argc, char **argv)
        {
            **QWebEngineUrlScheme**
    scheme("myscheme");
            scheme.setSyntax(**QWebEngineUrlScheme**
    ::Syntax::HostAndPort);
            scheme.setDefaultPort(2345);
    scheme.setFlags(**QWebEngineUrlScheme** ::SecureScheme);
    **QWebEngineUrlScheme** ::registerScheme(scheme);
            ...
        }

    To actually make use of the custom URL scheme, a
    **QWebEngineUrlSchemeHandler**  must be created and registered in a profile.

    **See also** **QWebEngineUrlSchemeHandler** .
    """

    SecureScheme: QWebEngineUrlScheme.Flag = ...
    LocalScheme: QWebEngineUrlScheme.Flag = ...
    LocalAccessAllowed: QWebEngineUrlScheme.Flag = ...
    NoAccessAllowed: QWebEngineUrlScheme.Flag = ...
    ServiceWorkersAllowed: QWebEngineUrlScheme.Flag = ...
    ViewSourceAllowed: QWebEngineUrlScheme.Flag = ...
    ContentSecurityPolicyIgnored: QWebEngineUrlScheme.Flag = ...
    CorsEnabled: QWebEngineUrlScheme.Flag = ...
    PortUnspecified: QWebEngineUrlScheme.SpecialPort = ...

    class Flag(Enum):
        SecureScheme: QWebEngineUrlScheme.Flag = ...
        LocalScheme: QWebEngineUrlScheme.Flag = ...
        LocalAccessAllowed: QWebEngineUrlScheme.Flag = ...
        NoAccessAllowed: QWebEngineUrlScheme.Flag = ...
        ServiceWorkersAllowed: QWebEngineUrlScheme.Flag = ...
        ViewSourceAllowed: QWebEngineUrlScheme.Flag = ...
        ContentSecurityPolicyIgnored: QWebEngineUrlScheme.Flag = ...
        CorsEnabled: QWebEngineUrlScheme.Flag = ...

    class Flags(object):
        ...

    class SpecialPort(Enum):
        PortUnspecified: QWebEngineUrlScheme.SpecialPort = ...

    class Syntax(Enum):
        HostPortAndUserInformation: QWebEngineUrlScheme.Syntax = ...
        HostAndPort: QWebEngineUrlScheme.Syntax = ...
        Host: QWebEngineUrlScheme.Syntax = ...
        Path: QWebEngineUrlScheme.Syntax = ...

    @overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qwebengineurlscheme.html#QWebEngineUrlScheme

        **QWebEngineUrlScheme::QWebEngineUrlScheme()**

        Constructs a web engine URL scheme with default values.
        """
        ...

    @overload
    def __init__(self, name: Union[PySide6.QtCore.QByteArray, bytes]) -> None:
        """
        https://doc.qt.io/qt-6/qwebengineurlscheme.html#QWebEngineUrlScheme-1

        **QWebEngineUrlScheme::QWebEngineUrlScheme(const QByteArray & name )**

        Constructs a web engine URL scheme with given **name**.
        """
        ...

    @overload
    def __init__(self, that: PySide6.QtWebEngineCore.QWebEngineUrlScheme) -> None:
        """
        https://doc.qt.io/qt-6/qwebengineurlscheme.html#QWebEngineUrlScheme-2

        **QWebEngineUrlScheme::QWebEngineUrlScheme(const QWebEngineUrlScheme &
        that )**

        Copies **that**.
        """
        ...

    @staticmethod
    def __copy__() -> None:
        ...

    def defaultPort(self) -> int:
        """
        https://doc.qt.io/qt-6/qwebengineurlscheme.html#defaultPort

        **int QWebEngineUrlScheme::defaultPort() const**

        Returns the default port of this URL scheme.

        The default value is `PortUnspecified`.

        **See also** **setDefaultPort** ().
        """
        ...

    def flags(self) -> PySide6.QtWebEngineCore.QWebEngineUrlScheme.Flags:
        """
        https://doc.qt.io/qt-6/qwebengineurlscheme.html#flags

        **QWebEngineUrlScheme::Flags QWebEngineUrlScheme::flags() const**

        Returns the flags for this URL scheme.

        The default value is an empty set of flags.

        **See also** **Flags**  and **setFlags** ().
        """
        ...

    def name(self) -> PySide6.QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qwebengineurlscheme.html#name

        **QByteArray QWebEngineUrlScheme::name() const**

        Returns the name of this URL scheme.

        The default value is an empty string.

        **See also** **setName** ().
        """
        ...

    @staticmethod
    def registerScheme(scheme: PySide6.QtWebEngineCore.QWebEngineUrlScheme) -> None:
        """
        https://doc.qt.io/qt-6/qwebengineurlscheme.html#registerScheme

        **[static] void QWebEngineUrlScheme::registerScheme(const
        QWebEngineUrlScheme & scheme )**

        Registers **scheme** with the web engine's URL parser and security
        model.

        It is recommended that all custom URL schemes are first registered with
        this function at application startup, even if the default options are to
        be used.

        **Warning:** This function must be called early at application startup,
        before creating any **WebEngine**  classes. Late calls will be ignored.

        **See also** **schemeByName** ().
        """
        ...

    @staticmethod
    def schemeByName(
        name: Union[PySide6.QtCore.QByteArray, bytes]
    ) -> PySide6.QtWebEngineCore.QWebEngineUrlScheme:
        """
        https://doc.qt.io/qt-6/qwebengineurlscheme.html#schemeByName

        **[static] QWebEngineUrlScheme QWebEngineUrlScheme::schemeByName(const
        QByteArray & name )**

        Returns the web engine URL scheme with the given **name** or the
        default-constructed scheme.

        **See also** **registerScheme** ().
        """
        ...

    def setDefaultPort(self, newValue: int) -> None:
        """
        https://doc.qt.io/qt-6/qwebengineurlscheme.html#setDefaultPort

        **void QWebEngineUrlScheme::setDefaultPort(int newValue )**

        Sets the default port of this URL scheme to **newValue**.

        **See also** **defaultPort** ().
        """
        ...

    def setFlags(
        self, newValue: PySide6.QtWebEngineCore.QWebEngineUrlScheme.Flags
    ) -> None:
        """
        https://doc.qt.io/qt-6/qwebengineurlscheme.html#setFlags

        **void QWebEngineUrlScheme::setFlags(QWebEngineUrlScheme::Flags newValue
        )**

        Sets the flags for this URL scheme to **newValue**.

        **See also** **Flags**  and **flags** ().
        """
        ...

    def setName(self, newValue: Union[PySide6.QtCore.QByteArray, bytes]) -> None:
        """
        https://doc.qt.io/qt-6/qwebengineurlscheme.html#setName

        **void QWebEngineUrlScheme::setName(const QByteArray & newValue )**

        Sets the name of this URL scheme to **newValue**.

        **Note:** The name is automatically converted to lower case.

        **See also** **name** ().
        """
        ...

    def setSyntax(
        self, newValue: PySide6.QtWebEngineCore.QWebEngineUrlScheme.Syntax
    ) -> None:
        """
        https://doc.qt.io/qt-6/qwebengineurlscheme.html#setSyntax

        **void QWebEngineUrlScheme::setSyntax(QWebEngineUrlScheme::Syntax
        newValue )**

        Sets the syntax type of this URL scheme to **newValue**.

        **See also** **Syntax**  and **syntax** ().
        """
        ...

    def syntax(self) -> PySide6.QtWebEngineCore.QWebEngineUrlScheme.Syntax:
        """
        https://doc.qt.io/qt-6/qwebengineurlscheme.html#syntax

        **QWebEngineUrlScheme::Syntax QWebEngineUrlScheme::syntax() const**

        Returns the syntax type of this URL scheme.

        The default value is `Path`.

        **See also** **Syntax**  and **setSyntax** ().
        """
        ...
