"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtWebEngineCore, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import Dict, Union
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtNetwork
import PySide6.QtWebChannel
import PySide6.QtWebEngineCore

bytes = str


class QWebEngineUrlRequestJob(PySide6.QtCore.QObject):
    """
    https://doc.qt.io/qt-6/qwebengineurlrequestjob.html

    **Detailed Description**

    A QWebEngineUrlRequestJob is given to
    **QWebEngineUrlSchemeHandler::requestStarted** () and must be handled by the
    derived implementations of the class. The job can be handled by calling
    either **reply** (), **redirect** (), or **fail** ().

    The class is owned by the web engine and does not need to be deleted.
    However, the web engine may delete the job when it is no longer needed, and
    therefore the signal **QObject::destroyed** () must be monitored if a
    pointer to the object is stored.
    """

    NoError: QWebEngineUrlRequestJob.Error = ...
    UrlNotFound: QWebEngineUrlRequestJob.Error = ...
    UrlInvalid: QWebEngineUrlRequestJob.Error = ...
    RequestAborted: QWebEngineUrlRequestJob.Error = ...
    RequestDenied: QWebEngineUrlRequestJob.Error = ...
    RequestFailed: QWebEngineUrlRequestJob.Error = ...

    class Error(Enum):
        NoError: QWebEngineUrlRequestJob.Error = ...
        UrlNotFound: QWebEngineUrlRequestJob.Error = ...
        UrlInvalid: QWebEngineUrlRequestJob.Error = ...
        RequestAborted: QWebEngineUrlRequestJob.Error = ...
        RequestDenied: QWebEngineUrlRequestJob.Error = ...
        RequestFailed: QWebEngineUrlRequestJob.Error = ...

    def fail(
        self, error: PySide6.QtWebEngineCore.QWebEngineUrlRequestJob.Error
    ) -> None:
        """
        https://doc.qt.io/qt-6/qwebengineurlrequestjob.html#fail

        **void QWebEngineUrlRequestJob::fail(QWebEngineUrlRequestJob::Error r
        )**

        Fails the request with the error **r**.

        **See also** **Error** .
        """
        ...

    def initiator(self) -> PySide6.QtCore.QUrl:
        """
        https://doc.qt.io/qt-6/qwebengineurlrequestjob.html#initiator

        **[since 5.11] QUrl QWebEngineUrlRequestJob::initiator() const**

        Returns the serialized origin of the content that initiated the request.

        Generally, the origin consists of a scheme, hostname, and port. For
        example, `"http://localhost:8080"` would be a valid origin. The port is
        omitted if it is the scheme's default port (80 for `http`, 443 for
        `https`). The hostname is omitted for non-network schemes such as `file`
        and `qrc`.

        However, there is also the special value `"null"` representing a unique
        origin. It is, for example, the origin of a sandboxed iframe. The
        purpose of this special origin is to be always different from all other
        origins in the same-origin check. In other words, content with a unique
        origin should never have privileged access to any other content.

        Finally, if the request was not initiated by web content, the function
        will return an empty **QUrl** . This happens, for example, when you call
        **QWebEnginePage::setUrl** ().

        This value can be used for implementing secure cross-origin checks.

        This function was introduced in Qt 5.11.
        """
        ...

    def redirect(self, url: Union[PySide6.QtCore.QUrl, str]) -> None:
        """
        https://doc.qt.io/qt-6/qwebengineurlrequestjob.html#redirect

        **void QWebEngineUrlRequestJob::redirect(const QUrl & url )**

        Redirects the request to **url**.
        """
        ...

    def reply(
        self,
        contentType: Union[PySide6.QtCore.QByteArray, bytes],
        device: PySide6.QtCore.QIODevice,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qwebengineurlrequestjob.html#reply

        **void QWebEngineUrlRequestJob::reply(const QByteArray & contentType ,
        QIODevice * device )**

        Replies to the request with **device** and the MIME type
        **contentType**.

        The user has to be aware that **device** will be used on another thread
        until the job is deleted. In case simultaneous access from the main
        thread is desired, the user is reponsible for making access to
        **device** thread-safe for example by using **QMutex** . Note that the
        **device** object is not owned by the web engine. Therefore, the signal
        **QObject::destroyed** () of **QWebEngineUrlRequestJob**  must be
        monitored.

        The device should remain available at least as long as the job exists.
        When calling this method with a newly constructed device, one solution
        is to make the device as a child of the job or delete itself when job is
        deleted, like this:

        connect(job, &**QObject** ::destroyed, device, &**QObject**
        ::deleteLater);
        """
        ...

    def requestHeaders(
        self,
    ) -> Dict[PySide6.QtCore.QByteArray, PySide6.QtCore.QByteArray]:
        """
        https://doc.qt.io/qt-6/qwebengineurlrequestjob.html#requestHeaders

        **[since 5.13] QMap<QByteArray, QByteArray>
        QWebEngineUrlRequestJob::requestHeaders() const**

        Returns any HTTP headers added to the request.

        This function was introduced in Qt 5.13.
        """
        ...

    def requestMethod(self) -> PySide6.QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qwebengineurlrequestjob.html#requestMethod

        **QByteArray QWebEngineUrlRequestJob::requestMethod() const**

        Returns the HTTP method of the request (for example, GET or POST).
        """
        ...

    def requestUrl(self) -> PySide6.QtCore.QUrl:
        """
        https://doc.qt.io/qt-6/qwebengineurlrequestjob.html#requestUrl

        **QUrl QWebEngineUrlRequestJob::requestUrl() const**

        Returns the requested URL.
        """
        ...
