"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtWebEngineCore, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import Union
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtNetwork
import PySide6.QtWebChannel
import PySide6.QtWebEngineCore

bytes = str


class QWebEngineUrlRequestInfo(object):
    """
    https://doc.qt.io/qt-6/qwebengineurlrequestinfo.html

    **Detailed Description**

    The QWebEngineUrlRequestInfo is useful for setting extra header fields for
    requests or for redirecting certain requests without payload data to another
    URL. This class cannot be instantiated or copied by the user, instead it
    will be created by Qt WebEngine and sent through the virtual function
    **QWebEngineUrlRequestInterceptor::interceptRequest** () if an interceptor
    has been set.
    """

    NavigationTypeLink: QWebEngineUrlRequestInfo.NavigationType = ...
    NavigationTypeTyped: QWebEngineUrlRequestInfo.NavigationType = ...
    NavigationTypeFormSubmitted: QWebEngineUrlRequestInfo.NavigationType = ...
    NavigationTypeBackForward: QWebEngineUrlRequestInfo.NavigationType = ...
    NavigationTypeReload: QWebEngineUrlRequestInfo.NavigationType = ...
    NavigationTypeOther: QWebEngineUrlRequestInfo.NavigationType = ...
    NavigationTypeRedirect: QWebEngineUrlRequestInfo.NavigationType = ...
    ResourceTypeMainFrame: QWebEngineUrlRequestInfo.ResourceType = ...
    ResourceTypeSubFrame: QWebEngineUrlRequestInfo.ResourceType = ...
    ResourceTypeStylesheet: QWebEngineUrlRequestInfo.ResourceType = ...
    ResourceTypeScript: QWebEngineUrlRequestInfo.ResourceType = ...
    ResourceTypeImage: QWebEngineUrlRequestInfo.ResourceType = ...
    ResourceTypeFontResource: QWebEngineUrlRequestInfo.ResourceType = ...
    ResourceTypeSubResource: QWebEngineUrlRequestInfo.ResourceType = ...
    ResourceTypeObject: QWebEngineUrlRequestInfo.ResourceType = ...
    ResourceTypeMedia: QWebEngineUrlRequestInfo.ResourceType = ...
    ResourceTypeWorker: QWebEngineUrlRequestInfo.ResourceType = ...
    ResourceTypeSharedWorker: QWebEngineUrlRequestInfo.ResourceType = ...
    ResourceTypePrefetch: QWebEngineUrlRequestInfo.ResourceType = ...
    ResourceTypeFavicon: QWebEngineUrlRequestInfo.ResourceType = ...
    ResourceTypeXhr: QWebEngineUrlRequestInfo.ResourceType = ...
    ResourceTypePing: QWebEngineUrlRequestInfo.ResourceType = ...
    ResourceTypeServiceWorker: QWebEngineUrlRequestInfo.ResourceType = ...
    ResourceTypeCspReport: QWebEngineUrlRequestInfo.ResourceType = ...
    ResourceTypePluginResource: QWebEngineUrlRequestInfo.ResourceType = ...
    ResourceTypeNavigationPreloadMainFrame: QWebEngineUrlRequestInfo.ResourceType = ...
    ResourceTypeLast: QWebEngineUrlRequestInfo.ResourceType = ...
    ResourceTypeNavigationPreloadSubFrame: QWebEngineUrlRequestInfo.ResourceType = ...
    ResourceTypeUnknown: QWebEngineUrlRequestInfo.ResourceType = ...

    class NavigationType(Enum):
        NavigationTypeLink: QWebEngineUrlRequestInfo.NavigationType = ...
        NavigationTypeTyped: QWebEngineUrlRequestInfo.NavigationType = ...
        NavigationTypeFormSubmitted: QWebEngineUrlRequestInfo.NavigationType = ...
        NavigationTypeBackForward: QWebEngineUrlRequestInfo.NavigationType = ...
        NavigationTypeReload: QWebEngineUrlRequestInfo.NavigationType = ...
        NavigationTypeOther: QWebEngineUrlRequestInfo.NavigationType = ...
        NavigationTypeRedirect: QWebEngineUrlRequestInfo.NavigationType = ...

    class ResourceType(Enum):
        ResourceTypeMainFrame: QWebEngineUrlRequestInfo.ResourceType = ...
        ResourceTypeSubFrame: QWebEngineUrlRequestInfo.ResourceType = ...
        ResourceTypeStylesheet: QWebEngineUrlRequestInfo.ResourceType = ...
        ResourceTypeScript: QWebEngineUrlRequestInfo.ResourceType = ...
        ResourceTypeImage: QWebEngineUrlRequestInfo.ResourceType = ...
        ResourceTypeFontResource: QWebEngineUrlRequestInfo.ResourceType = ...
        ResourceTypeSubResource: QWebEngineUrlRequestInfo.ResourceType = ...
        ResourceTypeObject: QWebEngineUrlRequestInfo.ResourceType = ...
        ResourceTypeMedia: QWebEngineUrlRequestInfo.ResourceType = ...
        ResourceTypeWorker: QWebEngineUrlRequestInfo.ResourceType = ...
        ResourceTypeSharedWorker: QWebEngineUrlRequestInfo.ResourceType = ...
        ResourceTypePrefetch: QWebEngineUrlRequestInfo.ResourceType = ...
        ResourceTypeFavicon: QWebEngineUrlRequestInfo.ResourceType = ...
        ResourceTypeXhr: QWebEngineUrlRequestInfo.ResourceType = ...
        ResourceTypePing: QWebEngineUrlRequestInfo.ResourceType = ...
        ResourceTypeServiceWorker: QWebEngineUrlRequestInfo.ResourceType = ...
        ResourceTypeCspReport: QWebEngineUrlRequestInfo.ResourceType = ...
        ResourceTypePluginResource: QWebEngineUrlRequestInfo.ResourceType = ...
        ResourceTypeNavigationPreloadMainFrame: QWebEngineUrlRequestInfo.ResourceType = (
            ...
        )
        ResourceTypeLast: QWebEngineUrlRequestInfo.ResourceType = ...
        ResourceTypeNavigationPreloadSubFrame: QWebEngineUrlRequestInfo.ResourceType = (
            ...
        )
        ResourceTypeUnknown: QWebEngineUrlRequestInfo.ResourceType = ...

    def block(self, shouldBlock: bool) -> None:
        """
        https://doc.qt.io/qt-6/qwebengineurlrequestinfo.html#block

        **void QWebEngineUrlRequestInfo::block(bool shouldBlock )**

        Blocks this request if **shouldBlock** is true, so that it will not
        proceed.

        This function can be used to prevent navigating away from a given
        domain, for example.
        """
        ...

    def changed(self) -> bool:
        ...

    def firstPartyUrl(self) -> PySide6.QtCore.QUrl:
        """
        https://doc.qt.io/qt-6/qwebengineurlrequestinfo.html#firstPartyUrl

        **QUrl QWebEngineUrlRequestInfo::firstPartyUrl() const**

        Returns the first party URL of the request. The first party URL is the
        URL of the page that issued the request.
        """
        ...

    def initiator(self) -> PySide6.QtCore.QUrl:
        """
        https://doc.qt.io/qt-6/qwebengineurlrequestinfo.html#initiator

        **[since 5.14] QUrl QWebEngineUrlRequestInfo::initiator() const**

        Returns the origin URL of the document that initiated the navigation of
        a frame to another frame.

        This function was introduced in Qt 5.14.
        """
        ...

    def navigationType(
        self,
    ) -> PySide6.QtWebEngineCore.QWebEngineUrlRequestInfo.NavigationType:
        """
        https://doc.qt.io/qt-6/qwebengineurlrequestinfo.html#navigationType

        **QWebEngineUrlRequestInfo::NavigationType
        QWebEngineUrlRequestInfo::navigationType() const**

        Returns the navigation type of the request.

        **See also** **NavigationType** .
        """
        ...

    def redirect(self, url: Union[PySide6.QtCore.QUrl, str]) -> None:
        """
        https://doc.qt.io/qt-6/qwebengineurlrequestinfo.html#redirect

        **void QWebEngineUrlRequestInfo::redirect(const QUrl & url )**

        Redirects this request to **url**. It is only possible to redirect
        requests that do not have payload data, such as GET requests.
        """
        ...

    def requestMethod(self) -> PySide6.QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qwebengineurlrequestinfo.html#requestMethod

        **QByteArray QWebEngineUrlRequestInfo::requestMethod() const**

        Returns the HTTP method of the request (for example, GET or POST).
        """
        ...

    def requestUrl(self) -> PySide6.QtCore.QUrl:
        """
        https://doc.qt.io/qt-6/qwebengineurlrequestinfo.html#requestUrl

        **QUrl QWebEngineUrlRequestInfo::requestUrl() const**

        Returns the requested URL.
        """
        ...

    def resourceType(
        self,
    ) -> PySide6.QtWebEngineCore.QWebEngineUrlRequestInfo.ResourceType:
        """
        https://doc.qt.io/qt-6/qwebengineurlrequestinfo.html#resourceType

        **QWebEngineUrlRequestInfo::ResourceType
        QWebEngineUrlRequestInfo::resourceType() const**

        Returns the resource type of the request.

        **See also** **ResourceType** .
        """
        ...

    def setHttpHeader(
        self,
        name: Union[PySide6.QtCore.QByteArray, bytes],
        value: Union[PySide6.QtCore.QByteArray, bytes],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qwebengineurlrequestinfo.html#setHttpHeader

        **void QWebEngineUrlRequestInfo::setHttpHeader(const QByteArray & name ,
        const QByteArray & value )**

        Sets the request header **name** to **value** for this request.
        """
        ...
