"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtWebEngineCore, except for defaults which are replaced by "...".
"""
from typing import List, Sequence, overload
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtNetwork
import PySide6.QtWebChannel
import PySide6.QtWebEngineCore

bytes = str


class QWebEngineScriptCollection(object):
    """
    https://doc.qt.io/qt-6/qwebenginescriptcollection.html

    **Detailed Description**

    QWebEngineScriptCollection manages a set of user scripts.

    Use **QWebEnginePage::scripts** () and **QWebEngineProfile::scripts** () to
    access the collection of scripts associated with a single page or a number
    of pages sharing the same profile.

    **See also** **Script Injection** .
    """

    def clear(self) -> None:
        """
        https://doc.qt.io/qt-6/qwebenginescriptcollection.html#clear

        **void QWebEngineScriptCollection::clear()**

        Removes all scripts from this collection.
        """
        ...

    def contains(self, value: PySide6.QtWebEngineCore.QWebEngineScript) -> bool:
        """
        https://doc.qt.io/qt-6/qwebenginescriptcollection.html#contains

        **bool QWebEngineScriptCollection::contains(const QWebEngineScript &
        value ) const**

        Returns `true` if the collection contains an occurrence of **value** ;
        otherwise returns `false`.
        """
        ...

    def count(self) -> int:
        """
        https://doc.qt.io/qt-6/qwebenginescriptcollection.html#count

        **int QWebEngineScriptCollection::count() const**

        Returns the number of elements in the collection.
        """
        ...

    def find(self, name: str) -> List[PySide6.QtWebEngineCore.QWebEngineScript]:
        """
        https://doc.qt.io/qt-6/qwebenginescriptcollection.html#find

        **QList<QWebEngineScript> QWebEngineScriptCollection::find(const QString
        & name ) const**

        Returns the list of scripts in the collection with the name **name** ,
        or an empty list if none was found.
        """
        ...

    @overload
    def insert(self, arg__1: PySide6.QtWebEngineCore.QWebEngineScript) -> None:
        """
        https://doc.qt.io/qt-6/qwebenginescriptcollection.html#insert

        **void QWebEngineScriptCollection::insert(const QWebEngineScript & s )**

        Inserts the script **s** into the collection.
        """
        ...

    @overload
    def insert(self, list: Sequence[PySide6.QtWebEngineCore.QWebEngineScript]) -> None:
        """
        https://doc.qt.io/qt-6/qwebenginescriptcollection.html#insert-1

        **void QWebEngineScriptCollection::insert(const QList<QWebEngineScript>
        & list )**

        Inserts scripts from the list **list** into the collection.
        """
        ...

    def isEmpty(self) -> bool:
        """
        https://doc.qt.io/qt-6/qwebenginescriptcollection.html#isEmpty

        **bool QWebEngineScriptCollection::isEmpty() const**

        Returns `true` if the collection is empty; otherwise returns `false`.
        """
        ...

    def remove(self, arg__1: PySide6.QtWebEngineCore.QWebEngineScript) -> bool:
        """
        https://doc.qt.io/qt-6/qwebenginescriptcollection.html#remove

        **bool QWebEngineScriptCollection::remove(const QWebEngineScript &
        script )**

        Removes **script** from the collection.

        Returns `true` if the script was found and successfully removed from the
        collection; otherwise returns `false`.
        """
        ...

    def toList(self) -> List[PySide6.QtWebEngineCore.QWebEngineScript]:
        """
        https://doc.qt.io/qt-6/qwebenginescriptcollection.html#toList

        **QList<QWebEngineScript> QWebEngineScriptCollection::toList() const**

        Returns a list with the values of the scripts used in this collection.
        """
        ...
