"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtWebEngineCore, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import Union, overload
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtNetwork
import PySide6.QtWebChannel
import PySide6.QtWebEngineCore

bytes = str


class QWebEngineScript(object):
    """
    https://doc.qt.io/qt-6/qwebenginescript.html

    **Detailed Description**

    QWebEngineScript enables the programmatic injection of so called **user
    scripts** in the JavaScript engine at different points, determined by
    **injectionPoint** (), during the loading of web contents.

    Scripts can be executed either in the main JavaScript **world** , along with
    the rest of the JavaScript coming from the web contents, or in their own
    isolated world. While the DOM of the page can be accessed from any world,
    JavaScript variables of a function defined in one world are not accessible
    from a different one. **ScriptWorldId**  provides some predefined IDs for
    this purpose.

    The following **Greasemonkey**  attributes are supported since Qt 5.8:
    `@exclude`, `@include`, `@name`, `@match`, and `@run-at`.

    Use **QWebEnginePage::scripts** () and **QWebEngineProfile::scripts** () to
    access the collection of scripts associated with a single page or a number
    of pages sharing the same profile.

    **See also** **Script Injection** .
    """

    Deferred: QWebEngineScript.InjectionPoint = ...
    DocumentReady: QWebEngineScript.InjectionPoint = ...
    DocumentCreation: QWebEngineScript.InjectionPoint = ...
    MainWorld: QWebEngineScript.ScriptWorldId = ...
    ApplicationWorld: QWebEngineScript.ScriptWorldId = ...
    UserWorld: QWebEngineScript.ScriptWorldId = ...

    class InjectionPoint(Enum):
        Deferred: QWebEngineScript.InjectionPoint = ...
        DocumentReady: QWebEngineScript.InjectionPoint = ...
        DocumentCreation: QWebEngineScript.InjectionPoint = ...

    class ScriptWorldId(Enum):
        MainWorld: QWebEngineScript.ScriptWorldId = ...
        ApplicationWorld: QWebEngineScript.ScriptWorldId = ...
        UserWorld: QWebEngineScript.ScriptWorldId = ...

    @overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qwebenginescript.html#QWebEngineScript

        **QWebEngineScript::QWebEngineScript()**

        Constructs a null script.
        """
        ...

    @overload
    def __init__(self, other: PySide6.QtWebEngineCore.QWebEngineScript) -> None:
        """
        https://doc.qt.io/qt-6/qwebenginescript.html#QWebEngineScript-1

        **QWebEngineScript::QWebEngineScript(const QWebEngineScript & other )**

        Constructs a user script using the contents of **other**.
        """
        ...

    @staticmethod
    def __copy__() -> None:
        ...

    def injectionPoint(self) -> PySide6.QtWebEngineCore.QWebEngineScript.InjectionPoint:
        """
        https://doc.qt.io/qt-6/qwebenginescript.html#injectionPoint

        **QWebEngineScript::InjectionPoint QWebEngineScript::injectionPoint()
        const**

        Returns the point in the loading process at which the script will be
        executed. The default value is **QWebEngineScript::Deferred** .

        **Note:** Getter function for property injectionPoint.

        **See also** **setInjectionPoint** ().
        """
        ...

    def name(self) -> str:
        """
        https://doc.qt.io/qt-6/qwebenginescript.html#name

        **QString QWebEngineScript::name() const**

        Returns the name of the script. Can be useful to retrieve a particular
        script from a **QWebEngineScriptCollection** .

        **Note:** Getter function for property name.

        **See also** **setName** () and **QWebEngineScriptCollection::find** ().
        """
        ...

    def runsOnSubFrames(self) -> bool:
        """
        https://doc.qt.io/qt-6/qwebenginescript.html#runsOnSubFrames

        **bool QWebEngineScript::runsOnSubFrames() const**

        Returns `true` if the script is executed on every frame in the page, or
        `false` if it is only ran for the main frame.

        **Note:** Getter function for property runsOnSubFrames.

        **See also** **setRunsOnSubFrames** ().
        """
        ...

    def setInjectionPoint(
        self, arg__1: PySide6.QtWebEngineCore.QWebEngineScript.InjectionPoint
    ) -> None:
        """
        https://doc.qt.io/qt-6/qwebenginescript.html#setInjectionPoint

        **void
        QWebEngineScript::setInjectionPoint(QWebEngineScript::InjectionPoint p
        )**

        Sets the point at which to execute the script to be **p**.

        **Note:** Setter function for property **injectionPoint** .

        **See also** **injectionPoint** () and **InjectionPoint** .
        """
        ...

    def setName(self, arg__1: str) -> None:
        """
        https://doc.qt.io/qt-6/qwebenginescript.html#setName

        **void QWebEngineScript::setName(const QString & scriptName )**

        Sets the script name to **scriptName**.

        **Note:** Setter function for property **name** .

        **See also** **name** ().
        """
        ...

    def setRunsOnSubFrames(self, on: bool) -> None:
        """
        https://doc.qt.io/qt-6/qwebenginescript.html#setRunsOnSubFrames

        **void QWebEngineScript::setRunsOnSubFrames(bool on )**

        Executes the script on sub frames in addition to the main frame if
        **on** returns `true`.

        **Note:** Setter function for property **runsOnSubFrames** .

        **See also** **runsOnSubFrames** ().
        """
        ...

    def setSourceCode(self, arg__1: str) -> None:
        """
        https://doc.qt.io/qt-6/qwebenginescript.html#setSourceCode

        **void QWebEngineScript::setSourceCode(const QString & scriptSource )**

        Sets the script source to **scriptSource**.

        **Note:** Setter function for property **sourceCode** .

        **See also** **sourceCode** ().
        """
        ...

    def setSourceUrl(self, url: Union[PySide6.QtCore.QUrl, str]) -> None:
        ...

    def setWorldId(self, arg__1: int) -> None:
        """
        https://doc.qt.io/qt-6/qwebenginescript.html#setWorldId

        **void QWebEngineScript::setWorldId(quint32 id )**

        Sets the world ID of the isolated world to **id** when running this
        script.

        Must be between `0` and `256`.

        **Note:** Setter function for property **worldId** .

        **See also** **worldId** ().
        """
        ...

    def sourceCode(self) -> str:
        """
        https://doc.qt.io/qt-6/qwebenginescript.html#sourceCode

        **QString QWebEngineScript::sourceCode() const**

        Returns the source of the script.

        **Note:** Getter function for property sourceCode.

        **See also** **setSourceCode** ().
        """
        ...

    def sourceUrl(self) -> PySide6.QtCore.QUrl:
        ...

    def swap(self, other: PySide6.QtWebEngineCore.QWebEngineScript) -> None:
        """
        https://doc.qt.io/qt-6/qwebenginescript.html#swap

        **void QWebEngineScript::swap(QWebEngineScript & other )**

        Swaps the contents of the script with the contents of **other**.
        """
        ...

    def worldId(self) -> int:
        """
        https://doc.qt.io/qt-6/qwebenginescript.html#worldId

        **quint32 QWebEngineScript::worldId() const**

        Returns the world ID defining which world the script is executed in.

        **Note:** Getter function for property worldId.

        **See also** **setWorldId** ().
        """
        ...
