"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtWebEngineCore, except for defaults which are replaced by "...".
"""
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtNetwork
import PySide6.QtWebChannel
import PySide6.QtWebEngineCore

bytes = str


class QWebEngineQuotaRequest(object):
    """
    https://doc.qt.io/qt-6/qwebenginequotarequest.html

    **Detailed Description**

    This class is used by the **QWebEnginePage::quotaRequested** () signal to
    **accept** () or **reject** () a request for an increase in the persistent
    storage allocated to the application. The default quota is 0 bytes.
    """

    def __init__(self) -> None:
        ...

    def accept(self) -> None:
        """
        https://doc.qt.io/qt-6/qwebenginequotarequest.html#accept

        **[invokable] void QWebEngineQuotaRequest::accept()**

        Accepts a request for larger persistent storage.

        **Note:** This function can be invoked via the meta-object system and
        from QML. See **Q_INVOKABLE** .
        """
        ...

    def origin(self) -> PySide6.QtCore.QUrl:
        """
        https://doc.qt.io/qt-6/qwebenginequotarequest.html#origin-prop

        **[read-only] origin : const QUrl**

        This property holds the URL of the web page that issued the quota
        request.

        **Access functions:**

        QUrl **origin** () const
        """
        ...

    def reject(self) -> None:
        """
        https://doc.qt.io/qt-6/qwebenginequotarequest.html#reject

        **[invokable] void QWebEngineQuotaRequest::reject()**

        Rejects a request for larger persistent storage.

        **Note:** This function can be invoked via the meta-object system and
        from QML. See **Q_INVOKABLE** .
        """
        ...

    def requestedSize(self) -> int:
        """
        https://doc.qt.io/qt-6/qwebenginequotarequest.html#requestedSize-prop

        **[read-only] requestedSize : const qint64**

        Contains the size of the requested disk space in bytes.

        **Access functions:**

        qint64 **requestedSize** () const

        **Member Function Documentation**
        """
        ...
