"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtWebEngineCore, except for defaults which are replaced by "...".
"""
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtNetwork
import PySide6.QtWebChannel
import PySide6.QtWebEngineCore

bytes = str


class QWebEngineNotification(PySide6.QtCore.QObject):
    """
    https://doc.qt.io/qt-6/qwebenginenotification.html

    **Detailed Description**

    This class contains the information and API for HTML5 desktop and push
    notifications.

    Web engine notifications are passed to the user through the custom handler
    provided with the **QWebEngineProfile::setNotificationPresenter** () call.

    For more information about how to handle web notification, see the
    **Notification Example** .
    """

    def click(self) -> None:
        """
        https://doc.qt.io/qt-6/qwebenginenotification.html#click

        **[slot] void QWebEngineNotification::click() const**

        Creates and dispatches a JavaScript **click event** on notification.

        Should be called by the notification platform when the notification is
        activated by the user.
        """
        ...

    def close(self) -> None:
        """
        https://doc.qt.io/qt-6/qwebenginenotification.html#close

        **[slot] void QWebEngineNotification::close() const**

        Creates and dispatches a JavaScript **close event** on notification.

        Should be called by the notification platform when the notification is
        closed, either by the underlying platform or by the user.
        """
        ...

    def direction(self) -> PySide6.QtCore.Qt.LayoutDirection:
        """
        https://doc.qt.io/qt-6/qwebenginenotification.html#direction-prop

        **[read-only] direction : const Qt::LayoutDirection**

        This property holds the text direction for the notification's title and
        body.

        **Access functions:**

        Qt::LayoutDirection **direction** () const

        **See also** **title** () and **message** ().
        """
        ...

    def icon(self) -> PySide6.QtGui.QImage:
        """
        https://doc.qt.io/qt-6/qwebenginenotification.html#icon

        **QImage QWebEngineNotification::icon() const**

        Returns the icon to be shown with the notification.

        If no icon is set by the sender, a null **QImage**  is returned.
        """
        ...

    def language(self) -> str:
        """
        https://doc.qt.io/qt-6/qwebenginenotification.html#language-prop

        **[read-only] language : const QString**

        This property holds the primary language for the notification's title
        and body.

        Its value is a valid BCP 47 language tag, or the empty string.

        **Access functions:**

        QString **language** () const

        **See also** **title** () and **message** ().
        """
        ...

    def matches(self, other: PySide6.QtWebEngineCore.QWebEngineNotification) -> bool:
        """
        https://doc.qt.io/qt-6/qwebenginenotification.html#matches

        **bool QWebEngineNotification::matches(const QWebEngineNotification *
        other ) const**

        Returns `true` if the two notifications belong to the same message
        chain. That is, if their **tag** () and **origin** () are the same. This
        means one is a replacement or an update of the **other**.

        **See also** **tag** () and **origin** ().
        """
        ...

    def message(self) -> str:
        """
        https://doc.qt.io/qt-6/qwebenginenotification.html#message-prop

        **[read-only] message : const QString**

        This property holds the body of the notification message.

        **Access functions:**

        QString **message** () const

        **See also** **title** ().
        """
        ...

    def origin(self) -> PySide6.QtCore.QUrl:
        """
        https://doc.qt.io/qt-6/qwebenginenotification.html#origin-prop

        **[read-only] origin : const QUrl**

        This property holds the URL of the page sending the notification.

        **Access functions:**

        QUrl **origin** () const
        """
        ...

    def show(self) -> None:
        """
        https://doc.qt.io/qt-6/qwebenginenotification.html#show

        **[slot] void QWebEngineNotification::show() const**

        Creates and dispatches a JavaScript **show event** on notification.

        Should be called by the notification platform when the notification has
        been shown to user.
        """
        ...

    def tag(self) -> str:
        """
        https://doc.qt.io/qt-6/qwebenginenotification.html#tag-prop

        **[read-only] tag : const QString**

        This property holds the tag of the notification message.

        New notifications that have the same tag and origin URL as an existing
        one should replace or update the old notification with the same tag.

        **Access functions:**

        QString **tag** () const

        **See also** **matches** ().
        """
        ...

    def title(self) -> str:
        """
        https://doc.qt.io/qt-6/qwebenginenotification.html#title-prop

        **[read-only] title : const QString**

        This property holds the title of the notification.

        **Access functions:**

        QString **title** () const

        **See also** **message** ().

        **Member Function Documentation**
        """
        ...

    @property
    def closed(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qwebenginenotification.html#closed

        **[signal] void QWebEngineNotification::closed()**

        This signal is emitted when the web page calls close steps for the
        notification, and it no longer needs to be shown.
        """
        ...
