"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtWebEngineCore, except for defaults which are replaced by "...".
"""
from enum import Enum
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtNetwork
import PySide6.QtWebChannel
import PySide6.QtWebEngineCore

bytes = str


class QWebEngineNewWindowRequest(PySide6.QtCore.QObject):
    """
    https://doc.qt.io/qt-6/qwebenginenewwindowrequest.html

    **Detailed Description**

    Contains information about a request to load a page in a separate web engine
    view.

    **See also** **QWebEnginePage::newWindowRequested** ().
    """

    InNewWindow: QWebEngineNewWindowRequest.DestinationType = ...
    InNewTab: QWebEngineNewWindowRequest.DestinationType = ...
    InNewDialog: QWebEngineNewWindowRequest.DestinationType = ...
    InNewBackgroundTab: QWebEngineNewWindowRequest.DestinationType = ...

    class DestinationType(Enum):
        InNewWindow: QWebEngineNewWindowRequest.DestinationType = ...
        InNewTab: QWebEngineNewWindowRequest.DestinationType = ...
        InNewDialog: QWebEngineNewWindowRequest.DestinationType = ...
        InNewBackgroundTab: QWebEngineNewWindowRequest.DestinationType = ...

    def destination(
        self,
    ) -> PySide6.QtWebEngineCore.QWebEngineNewWindowRequest.DestinationType:
        """
        https://doc.qt.io/qt-6/qwebenginenewwindowrequest.html#destination-prop

        **[read-only] destination : const DestinationType**

        This property holds the type of window that is requested.

        **Access functions:**

        QWebEngineNewWindowRequest::DestinationType **destination** () const
        """
        ...

    def isUserInitiated(self) -> bool:
        ...

    def openIn(self, arg__1: PySide6.QtWebEngineCore.QWebEnginePage) -> None:
        """
        https://doc.qt.io/qt-6/qwebenginenewwindowrequest.html#openIn

        **void QWebEngineNewWindowRequest::openIn(QWebEnginePage * page )**

        Opens the requested window in the view represented by **page**.

        **See also** **QWebEnginePage::newWindowRequested** .
        """
        ...

    def requestedGeometry(self) -> PySide6.QtCore.QRect:
        """
        https://doc.qt.io/qt-6/qwebenginenewwindowrequest.html#requestedGeometry
        -prop

        **[read-only] requestedGeometry : const QRect**

        This property holds the size that is requested for the new page.

        **Access functions:**

        QRect **requestedGeometry** () const
        """
        ...

    def requestedUrl(self) -> PySide6.QtCore.QUrl:
        """
        https://doc.qt.io/qt-6/qwebenginenewwindowrequest.html#requestedUrl-prop

        **[read-only] requestedUrl : const QUrl**

        This property holds the URL that is requested for the new page.

        **Access functions:**

        QUrl **requestedUrl** () const
        """
        ...
