"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtWebEngineCore, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import Any, Dict, Union
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtNetwork
import PySide6.QtWebChannel
import PySide6.QtWebEngineCore

bytes = str


class QWebEngineHistoryModel(PySide6.QtCore.QAbstractListModel):
    """
    https://doc.qt.io/qt-6/qwebenginehistorymodel.html

    **Detailed Description**

    The QWebEngineHistoryModel type exposes the **title** , **url** , **icon** ,
    and **offset** roles. The **title** , **url** and **icon** specify the
    title, URL, and favicon of the visited page. The **offset** specifies the
    position of the page in respect to the current page (0). A positive number
    indicates that the page was visited after the current page, whereas a
    negative number indicates that the page was visited before the current page.

    This type is uncreatable, but it can be accessed by using the
    **QWebEngineHistory::itemsModel** , **QWebEngineHistory::backItemsModel** ,
    **QWebEngineHistory::forwardItemsModel**  methods.

    **See also** **QWebEngineHistory** .
    """

    UrlRole: QWebEngineHistoryModel.Roles = ...
    TitleRole: QWebEngineHistoryModel.Roles = ...
    OffsetRole: QWebEngineHistoryModel.Roles = ...
    IconUrlRole: QWebEngineHistoryModel.Roles = ...

    class Roles(Enum):
        UrlRole: QWebEngineHistoryModel.Roles = ...
        TitleRole: QWebEngineHistoryModel.Roles = ...
        OffsetRole: QWebEngineHistoryModel.Roles = ...
        IconUrlRole: QWebEngineHistoryModel.Roles = ...

    def data(
        self,
        index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex],
        role: int = ...,
    ) -> Any:
        ...

    def reset(self) -> None:
        ...

    def roleNames(self) -> Dict[int, PySide6.QtCore.QByteArray]:
        ...

    def rowCount(
        self,
        parent: Union[
            PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex
        ] = ...,
    ) -> int:
        ...
