"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtWebEngineCore, except for defaults which are replaced by "...".
"""
from typing import List
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtNetwork
import PySide6.QtWebChannel
import PySide6.QtWebEngineCore

bytes = str


class QWebEngineHistory(PySide6.QtCore.QObject):
    """
    https://doc.qt.io/qt-6/qwebenginehistory.html

    **Detailed Description**

    Each web engine page contains a history of visited pages that can be
    accessed by **QWebEnginePage::history** ().

    The history uses the concept of a **current item** , dividing the pages
    visited into those that can be visited by navigating **back** and
    **forward** using the **back** () and **forward** () functions. The current
    item can be obtained by calling **currentItem** (), and an arbitrary item in
    the history can be made the current item by passing it to **goToItem** ().

    A list of items describing the pages that can be visited by going back can
    be obtained by calling the **backItems** () function; similarly, items
    describing the pages ahead of the current page can be obtained with the
    **forwardItems** () function. The total list of items is obtained with the
    **items** () function.

    Also, the following **QWebEngineHistoryModel**  data model objects are
    provided:

    * `backItemsModel()`, which contains the URLs of visited pages.
      *
    `forwardItemsModel()`, which contains the URLs of the pages that were
    visited after visiting the current page.
      * `itemsModel()`, which contains
    the URLs of the back and forward items, as well as the URL of the current
    page.

    Just as with containers, functions are available to examine the history in
    terms of a list. Arbitrary items in the history can be obtained with
    **itemAt** (), the total number of items is given by **count** (), and the
    history can be cleared with the **clear** () function.

    QWebEngineHistory's state can be saved to a **QDataStream**  using the >>
    operator and loaded by using the << operator.

    **See also** **QWebEngineHistoryItem**  and **QWebEnginePage** .
    """

    def __lshift__(
        self, stream: PySide6.QtCore.QDataStream
    ) -> PySide6.QtCore.QDataStream:
        ...

    def __rshift__(
        self, stream: PySide6.QtCore.QDataStream
    ) -> PySide6.QtCore.QDataStream:
        ...

    def back(self) -> None:
        """
        https://doc.qt.io/qt-6/qwebenginehistory.html#back

        **void QWebEngineHistory::back()**

        Sets the current item to be the previous item in the history and goes to
        the corresponding page; that is, goes back one history item.

        **See also** **forward** () and **goToItem** ().
        """
        ...

    def backItem(self) -> PySide6.QtWebEngineCore.QWebEngineHistoryItem:
        """
        https://doc.qt.io/qt-6/qwebenginehistory.html#backItem

        **QWebEngineHistoryItem QWebEngineHistory::backItem() const**

        Returns the item before the current item in the history.
        """
        ...

    def backItems(
        self, maxItems: int
    ) -> List[PySide6.QtWebEngineCore.QWebEngineHistoryItem]:
        """
        https://doc.qt.io/qt-6/qwebenginehistory.html#backItems

        **QList<QWebEngineHistoryItem> QWebEngineHistory::backItems(int maxItems
        ) const**

        Returns the list of items in the backwards history list. At most
        **maxItems** entries are returned.

        **See also** **forwardItems** ().
        """
        ...

    def backItemsModel(self) -> PySide6.QtWebEngineCore.QWebEngineHistoryModel:
        """
        https://doc.qt.io/qt-6/qwebenginehistory.html#backItemsModel

        **QWebEngineHistoryModel *QWebEngineHistory::backItemsModel() const**

        Return the data model, which represents URLs of visited pages.

        **Note:** Getter function for property **backItems** .
        """
        ...

    def canGoBack(self) -> bool:
        """
        https://doc.qt.io/qt-6/qwebenginehistory.html#canGoBack

        **bool QWebEngineHistory::canGoBack() const**

        Returns `true` if there is an item preceding the current item in the
        history; otherwise returns `false`.

        **See also** **canGoForward** ().
        """
        ...

    def canGoForward(self) -> bool:
        """
        https://doc.qt.io/qt-6/qwebenginehistory.html#canGoForward

        **bool QWebEngineHistory::canGoForward() const**

        Returns `true` if we have an item to go forward to; otherwise returns
        `false`.

        **See also** **canGoBack** ().
        """
        ...

    def clear(self) -> None:
        """
        https://doc.qt.io/qt-6/qwebenginehistory.html#clear

        **[invokable] void QWebEngineHistory::clear()**

        Clears the history.

        **Note:** This function can be invoked via the meta-object system and
        from QML. See **Q_INVOKABLE** .

        **See also** **count** () and **items** ().
        """
        ...

    def count(self) -> int:
        """
        https://doc.qt.io/qt-6/qwebenginehistory.html#count

        **int QWebEngineHistory::count() const**

        Returns the total number of items in the history.
        """
        ...

    def currentItem(self) -> PySide6.QtWebEngineCore.QWebEngineHistoryItem:
        """
        https://doc.qt.io/qt-6/qwebenginehistory.html#currentItem

        **QWebEngineHistoryItem QWebEngineHistory::currentItem() const**

        Returns the current item in the history.
        """
        ...

    def currentItemIndex(self) -> int:
        """
        https://doc.qt.io/qt-6/qwebenginehistory.html#currentItemIndex

        **int QWebEngineHistory::currentItemIndex() const**

        Returns the index of the current item in history.
        """
        ...

    def forward(self) -> None:
        """
        https://doc.qt.io/qt-6/qwebenginehistory.html#forward

        **void QWebEngineHistory::forward()**

        Sets the current item to be the next item in the history and goes to the
        corresponding page; that is, goes forward one history item.

        **See also** **back** () and **goToItem** ().
        """
        ...

    def forwardItem(self) -> PySide6.QtWebEngineCore.QWebEngineHistoryItem:
        """
        https://doc.qt.io/qt-6/qwebenginehistory.html#forwardItem

        **QWebEngineHistoryItem QWebEngineHistory::forwardItem() const**

        Returns the item after the current item in the history.
        """
        ...

    def forwardItems(
        self, maxItems: int
    ) -> List[PySide6.QtWebEngineCore.QWebEngineHistoryItem]:
        """
        https://doc.qt.io/qt-6/qwebenginehistory.html#forwardItems

        **QList<QWebEngineHistoryItem> QWebEngineHistory::forwardItems(int
        maxItems ) const**

        Returns the list of items in the forward history list. At most
        **maxItems** entries are returned.

        **See also** **backItems** ().
        """
        ...

    def forwardItemsModel(self) -> PySide6.QtWebEngineCore.QWebEngineHistoryModel:
        """
        https://doc.qt.io/qt-6/qwebenginehistory.html#forwardItemsModel

        **QWebEngineHistoryModel *QWebEngineHistory::forwardItemsModel() const**

        Return the data model, which represents URLs of the pages that were
        visited after visiting the current page.

        **Note:** Getter function for property **forwardItems** .
        """
        ...

    def goToItem(self, item: PySide6.QtWebEngineCore.QWebEngineHistoryItem) -> None:
        """
        https://doc.qt.io/qt-6/qwebenginehistory.html#goToItem

        **void QWebEngineHistory::goToItem(const QWebEngineHistoryItem & item
        )**

        Sets the current item to be the specified **item** in the history and
        goes to the page.

        **See also** **back** () and **forward** ().
        """
        ...

    def itemAt(self, i: int) -> PySide6.QtWebEngineCore.QWebEngineHistoryItem:
        """
        https://doc.qt.io/qt-6/qwebenginehistory.html#itemAt

        **QWebEngineHistoryItem QWebEngineHistory::itemAt(int i ) const**

        Returns the item at index **i** in the history.
        """
        ...

    def items(self) -> List[PySide6.QtWebEngineCore.QWebEngineHistoryItem]:
        """
        https://doc.qt.io/qt-6/qwebenginehistory.html#items

        **QList<QWebEngineHistoryItem> QWebEngineHistory::items() const**

        Returns a list of all items currently in the history.

        **See also** **count** () and **clear** ().
        """
        ...

    def itemsModel(self) -> PySide6.QtWebEngineCore.QWebEngineHistoryModel:
        """
        https://doc.qt.io/qt-6/qwebenginehistory.html#itemsModel

        **QWebEngineHistoryModel *QWebEngineHistory::itemsModel() const**

        Returns the data model, which represents URLs of back items, forward
        items, and the current item in the history.

        **Note:** Getter function for property **items** .
        """
        ...
