"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtWebEngineCore, except for defaults which are replaced by "...".
"""
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtNetwork
import PySide6.QtWebChannel
import PySide6.QtWebEngineCore

bytes = str


class QWebEngineFullScreenRequest(object):
    """
    https://doc.qt.io/qt-6/qwebenginefullscreenrequest.html

    **Detailed Description**

    To allow elements such as videos to be shown in the fullscreen mode,
    applications must set **QWebEngineSettings::FullScreenSupportEnabled**  and
    connect to **QWebEnginePage::fullScreenRequested** , which takes a
    QWebEngineFullScreenRequest instance as an argument.

    If an element of a web page requests to be shown in the fullscreen mode,
    **QWebEnginePage::fullScreenRequested**  will be emitted with an
    QWebEngineFullScreenRequest instance as an argument where **toggleOn** ()
    returns `true`. The signal handler needs to then either call **accept** ()
    or **reject** ().

    If the request to enter the fullscreen mode is accepted, the element
    requesting fullscreen mode will fill the viewport, but it is up to the
    application to make the view fullscreen or to move the page to a view that
    is in the fullscreen mode.

    Likewise, a **QWebEnginePage::fullScreenRequested**  will be emitted when
    the user wants to leave the full screen mode (that is, through the
    **QWebEnginePage::ExitFullScreen**  context menu action). In this case,
    **toggleOn** () will return `false`, and the signal handler again needs to
    **accept** () or **reject** () the request. If it is accepted, the
    applicaton needs to make sure that the global window state is restored.
    """

    def __init__(
        self, other: PySide6.QtWebEngineCore.QWebEngineFullScreenRequest
    ) -> None:
        ...

    def accept(self) -> None:
        """
        https://doc.qt.io/qt-6/qwebenginefullscreenrequest.html#accept

        **[invokable] void QWebEngineFullScreenRequest::accept()**

        Accepts the request to enter or exit the fullscreen mode.

        **Note:** This function can be invoked via the meta-object system and
        from QML. See **Q_INVOKABLE** .
        """
        ...

    def origin(self) -> PySide6.QtCore.QUrl:
        """
        https://doc.qt.io/qt-6/qwebenginefullscreenrequest.html#origin

        **QUrl QWebEngineFullScreenRequest::origin() const**

        Returns the URL to be opened in the fullscreen mode.

        **Note:** Getter function for property origin.
        """
        ...

    def reject(self) -> None:
        """
        https://doc.qt.io/qt-6/qwebenginefullscreenrequest.html#reject

        **[invokable] void QWebEngineFullScreenRequest::reject()**

        Rejects a request to enter or exit the fullscreen mode.

        **Note:** This function can be invoked via the meta-object system and
        from QML. See **Q_INVOKABLE** .
        """
        ...

    def toggleOn(self) -> bool:
        """
        https://doc.qt.io/qt-6/qwebenginefullscreenrequest.html#toggleOn

        **bool QWebEngineFullScreenRequest::toggleOn() const**

        Returns `true` if the web page has issued a request to enter the
        fullscreen mode, otherwise returns `false`.

        **Note:** Getter function for property toggleOn.
        """
        ...
