"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtWebChannel, except for defaults which are replaced by "...".
"""
from typing import Dict, Optional
import PySide6.QtCore
import PySide6.QtWebChannel

bytes = str


class QWebChannel(PySide6.QtCore.QObject):
    """
    https://doc.qt.io/qt-6/qwebchannel.html

    **Detailed Description**

    The QWebChannel fills the gap between C++ applications and HTML/JavaScript
    applications. By publishing a **QObject**  derived object to a QWebChannel
    and using the **qwebchannel.js**  on the HTML side, one can transparently
    access properties and public slots and methods of the **QObject** . No
    manual message passing and serialization of data is required, property
    updates and signal emission on the C++ side get automatically transmitted to
    the potentially remotely running HTML clients. On the client side, a
    JavaScript object will be created for any published C++ **QObject** . It
    mirrors the C++ object's API and thus is intuitively useable.

    The C++ QWebChannel API makes it possible to talk to any HTML client, which
    could run on a local or even remote machine. The only limitation is that the
    HTML client supports the JavaScript features used by `qwebchannel.js`. As
    such, one can interact with basically any modern HTML browser or standalone
    JavaScript runtime, such as node.js.

    There also exists a declarative **WebChannel API** .

    **See also** **Qt WebChannel Standalone Example**  and **JavaScript API** .
    """

    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qwebchannel.html#QWebChannel-1

        **QWebChannel::QWebChannel(QObject * parent = nullptr)**

        Constructs the QWebChannel object with the given **parent**.

        Note that a QWebChannel is only fully operational once you connect it to
        a **QWebChannelAbstractTransport** . The HTML clients also need to be
        setup appropriately using [`qwebchannel.js`** .
        """
        ...

    def blockUpdates(self) -> bool:
        """
        https://doc.qt.io/qt-6/qwebchannel.html#blockUpdates-prop

        **[bindable] blockUpdates : bool**

        **Note:** This property supports **QProperty**  bindings.

        When set to true, updates are blocked and remote clients will not be
        notified about property changes.

        The changes are recorded and sent to the clients once updates become
        unblocked again by setting this property to false. By default, updates
        are not blocked.
        """
        ...

    def connectTo(
        self, transport: PySide6.QtWebChannel.QWebChannelAbstractTransport
    ) -> None:
        """
        https://doc.qt.io/qt-6/qwebchannel.html#connectTo

        **[slot] void QWebChannel::connectTo(QWebChannelAbstractTransport *
        transport )**

        Connects the **QWebChannel**  to the given **transport** object.

        The transport object then handles the communication between the C++
        application and a remote HTML client.

        **See also** **QWebChannelAbstractTransport**  and
        **QWebChannel::disconnectFrom** ().
        """
        ...

    def deregisterObject(self, object: PySide6.QtCore.QObject) -> None:
        """
        https://doc.qt.io/qt-6/qwebchannel.html#deregisterObject

        **[invokable] void QWebChannel::deregisterObject(QObject * object )**

        Deregisters the given **object** from the **QWebChannel** .

        Remote clients will receive a `destroyed` signal for the given object.

        **Note:** This function can be invoked via the meta-object system and
        from QML. See **Q_INVOKABLE** .

        **See also** **QWebChannel::registerObjects** (),
        **QWebChannel::registerObject** (), and
        **QWebChannel::registeredObjects** ().
        """
        ...

    def disconnectFrom(
        self, transport: PySide6.QtWebChannel.QWebChannelAbstractTransport
    ) -> None:
        """
        https://doc.qt.io/qt-6/qwebchannel.html#disconnectFrom

        **[slot] void QWebChannel::disconnectFrom(QWebChannelAbstractTransport *
        transport )**

        Disconnects the **QWebChannel**  from the **transport** object.

        **See also** **QWebChannel::connectTo** ().
        """
        ...

    def propertyUpdateInterval(self) -> int:
        """
        https://doc.qt.io/qt-6/qwebchannel.html#propertyUpdateInterval-prop

        **[bindable] propertyUpdateInterval : int**

        **Note:** This property supports **QProperty**  bindings.

        This property holds the property update interval.

        This interval can be changed to a different interval in milliseconds by
        setting it to a positive value. Property updates are batched and sent
        out after the interval expires. If set to zero, the updates occurring
        within a single event loop run are batched and sent out on the next run.
        If negative, updates will be sent immediately. Default value is 50
        milliseconds.

        **Member Function Documentation**
        """
        ...

    def registerObject(self, id: str, object: PySide6.QtCore.QObject) -> None:
        """
        https://doc.qt.io/qt-6/qwebchannel.html#registerObject

        **[invokable] void QWebChannel::registerObject(const QString & id ,
        QObject * object )**

        Registers a single object to the **QWebChannel** .

        The properties, signals and public methods of the **object** are
        published to the remote clients. There, an object with the identifier
        **id** is then constructed.

        **Note:** A property that is `BINDABLE` but does not have a `NOTIFY`
        signal will have working property updates on the client side, but no
        mechanism to register a callback for the change notifications.

        **Note:** A current limitation is that objects must be registered before
        any client is initialized.

        **Note:** This function can be invoked via the meta-object system and
        from QML. See **Q_INVOKABLE** .

        **See also** **QWebChannel::registerObjects** (),
        **QWebChannel::deregisterObject** (), and
        **QWebChannel::registeredObjects** ().
        """
        ...

    def registerObjects(self, objects: Dict[str, PySide6.QtCore.QObject]) -> None:
        """
        https://doc.qt.io/qt-6/qwebchannel.html#registerObjects

        **void QWebChannel::registerObjects(const QHash<QString, QObject *> &
        objects )**

        Registers a group of objects to the **QWebChannel** .

        The properties, signals and public invokable methods of the objects are
        published to the remote clients. There, an object with the identifier
        used as key in the **objects** map is then constructed.

        **Note:** A current limitation is that objects must be registered before
        any client is initialized.

        **See also** **QWebChannel::registerObject** (),
        **QWebChannel::deregisterObject** (), and
        **QWebChannel::registeredObjects** ().
        """
        ...

    def registeredObjects(self) -> Dict[str, PySide6.QtCore.QObject]:
        """
        https://doc.qt.io/qt-6/qwebchannel.html#registeredObjects

        **QHash<QString, QObject *> QWebChannel::registeredObjects() const**

        Returns the map of registered objects that are published to remote
        clients.

        **See also** **QWebChannel::registerObjects** (),
        **QWebChannel::registerObject** (), and
        **QWebChannel::deregisterObject** ().
        """
        ...

    def setBlockUpdates(self, block: bool) -> None:
        """
        https://doc.qt.io/qt-6/qwebchannel.html#blockUpdates-prop

        **[bindable] blockUpdates : bool**

        **Note:** This property supports **QProperty**  bindings.

        When set to true, updates are blocked and remote clients will not be
        notified about property changes.

        The changes are recorded and sent to the clients once updates become
        unblocked again by setting this property to false. By default, updates
        are not blocked.
        """
        ...

    def setPropertyUpdateInterval(self, ms: int) -> None:
        """
        https://doc.qt.io/qt-6/qwebchannel.html#propertyUpdateInterval-prop

        **[bindable] propertyUpdateInterval : int**

        **Note:** This property supports **QProperty**  bindings.

        This property holds the property update interval.

        This interval can be changed to a different interval in milliseconds by
        setting it to a positive value. Property updates are batched and sent
        out after the interval expires. If set to zero, the updates occurring
        within a single event loop run are batched and sent out on the next run.
        If negative, updates will be sent immediately. Default value is 50
        milliseconds.

        **Member Function Documentation**
        """
        ...

    @property
    def blockUpdatesChanged(self) -> PySide6.QtCore.SignalInstance:
        ...
