"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtUiTools, except for defaults which are replaced by "...".
"""
import os
from typing import List, Optional, Union, overload
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets
import PySide6.QtUiTools

bytes = str


class QUiLoader(PySide6.QtCore.QObject):
    """
    https://doc.qt.io/qt-6/quiloader.html

    **Detailed Description**

    In addition, you can customize or create your own user interface by deriving
    your own loader class.

    If you have a custom component or an application that embeds **Qt Designer**
    , you can also use the **QFormBuilder**  class provided by the
    **QtDesigner**  module to create user interfaces from UI files.

    The QUiLoader class provides a collection of functions allowing you to
    create widgets based on the information stored in UI files (created with
    **Qt Designer** ) or available in the specified plugin paths. The specified
    plugin paths can be retrieved using the **pluginPaths** () function.
    Similarly, the contents of a UI file can be retrieved using the **load** ()
    function. For example:

    MyWidget::MyWidget(**QWidget**  *parent)
            : **QWidget** (parent)
    {
            **QUiLoader**  loader;
            **QFile**
    file(":/forms/myform.ui");
            file.open(**QFile** ::ReadOnly);
    **QWidget**  *myWidget = loader.load(&file, this);
            file.close();
    **QVBoxLayout**  *layout = new **QVBoxLayout** ;
    layout->addWidget(myWidget);
            setLayout(layout);
        }

    By including the user interface in the form's resources (`myform.qrc`), we
    ensure that it will be present at run-time:

    <!DOCTYPE RCC><RCC version="1.0">
        <qresource prefix="/forms">
    <file>myform.ui</file>
        </qresource>
        </RCC>

    The **availableWidgets** () function returns a **QStringList**  with the
    class names of the widgets available in the specified plugin paths. To
    create these widgets, simply use the **createWidget** () function. For
    example:

    **QWidget**  *loadCustomWidget(**QWidget**  *parent)
        {
    **QUiLoader**  loader;
            **QWidget**  *myWidget;
    **QStringList**  availableWidgets = loader.availableWidgets();
    if (availableWidgets.contains("AnalogClock"))
                myWidget =
    loader.createWidget("AnalogClock", parent);

            return myWidget;
    }

    To make a custom widget available to the loader, you can use the
    **addPluginPath** () function; to remove all available widgets, you can call
    the **clearPluginPaths** () function.

    The **createAction** (), **createActionGroup** (), **createLayout** (), and
    **createWidget** () functions are used internally by the QUiLoader class
    whenever it has to create an action, action group, layout, or widget
    respectively. For that reason, you can subclass the QUiLoader class and
    reimplement these functions to intervene the process of constructing a user
    interface. For example, you might want to have a list of the actions created
    when loading a form or creating a custom widget.

    For a complete example using the QUiLoader class, see the **Calculator
    Builder Example** .

    **See also** **Qt UI Tools**  and **QFormBuilder** .
    """

    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-6/quiloader.html#QUiLoader

        **QUiLoader::QUiLoader(QObject * parent = nullptr)**

        Creates a form loader with the given **parent**.
        """
        ...

    def addPluginPath(self, path: str) -> None:
        """
        https://doc.qt.io/qt-6/quiloader.html#addPluginPath

        **void QUiLoader::addPluginPath(const QString & path )**

        Adds the given **path** to the list of paths in which the loader will
        search when locating plugins.

        **See also** **pluginPaths** () and **clearPluginPaths** ().
        """
        ...

    def availableLayouts(self) -> List[str]:
        """
        https://doc.qt.io/qt-6/quiloader.html#availableLayouts

        **QStringList QUiLoader::availableLayouts() const**

        Returns a list naming all available layouts that can be built using the
        **createLayout** () function

        **See also** **createLayout** ().
        """
        ...

    def availableWidgets(self) -> List[str]:
        """
        https://doc.qt.io/qt-6/quiloader.html#availableWidgets

        **QStringList QUiLoader::availableWidgets() const**

        Returns a list naming all available widgets that can be built using the
        **createWidget** () function, i.e all the widgets specified within the
        given plugin paths.

        **See also** **pluginPaths** () and **createWidget** ().
        """
        ...

    def clearPluginPaths(self) -> None:
        """
        https://doc.qt.io/qt-6/quiloader.html#clearPluginPaths

        **void QUiLoader::clearPluginPaths()**

        Clears the list of paths in which the loader will search when locating
        plugins.

        **See also** **addPluginPath** () and **pluginPaths** ().
        """
        ...

    def createAction(
        self, parent: Optional[PySide6.QtCore.QObject] = ..., name: str = ...
    ) -> PySide6.QtGui.QAction:
        """
        https://doc.qt.io/qt-6/quiloader.html#createAction

        **[virtual] QAction *QUiLoader::createAction(QObject * parent = nullptr,
        const QString & name = QString())**

        Creates a new action with the given **parent** and **name**.

        The function is also used internally by the **QUiLoader**  class
        whenever it creates a widget. Hence, you can subclass **QUiLoader**  and
        reimplement this function to intervene process of constructing a user
        interface or widget. However, in your implementation, ensure that you
        call **QUiLoader** 's version first.

        **See also** **createActionGroup** (), **createWidget** (), and **load**
        ().
        """
        ...

    def createActionGroup(
        self, parent: Optional[PySide6.QtCore.QObject] = ..., name: str = ...
    ) -> PySide6.QtGui.QActionGroup:
        """
        https://doc.qt.io/qt-6/quiloader.html#createActionGroup

        **[virtual] QActionGroup *QUiLoader::createActionGroup(QObject * parent
        = nullptr, const QString & name = QString())**

        Creates a new action group with the given **parent** and **name**.

        The function is also used internally by the **QUiLoader**  class
        whenever it creates a widget. Hence, you can subclass **QUiLoader**  and
        reimplement this function to intervene process of constructing a user
        interface or widget. However, in your implementation, ensure that you
        call **QUiLoader** 's version first.

        **See also** **createAction** (), **createWidget** (), and **load** ().
        """
        ...

    def createLayout(
        self,
        className: str,
        parent: Optional[PySide6.QtCore.QObject] = ...,
        name: str = ...,
    ) -> PySide6.QtWidgets.QLayout:
        """
        https://doc.qt.io/qt-6/quiloader.html#createLayout

        **[virtual] QLayout *QUiLoader::createLayout(const QString & className ,
        QObject * parent = nullptr, const QString & name = QString())**

        Creates a new layout with the given **parent** and **name** using the
        class specified by **className**.

        The function is also used internally by the **QUiLoader**  class
        whenever it creates a widget. Hence, you can subclass **QUiLoader**  and
        reimplement this function to intervene process of constructing a user
        interface or widget. However, in your implementation, ensure that you
        call **QUiLoader** 's version first.

        **See also** **createWidget** () and **load** ().
        """
        ...

    def createWidget(
        self,
        className: str,
        parent: Optional[PySide6.QtWidgets.QWidget] = ...,
        name: str = ...,
    ) -> PySide6.QtWidgets.QWidget:
        """
        https://doc.qt.io/qt-6/quiloader.html#createWidget

        **[virtual] QWidget *QUiLoader::createWidget(const QString & className ,
        QWidget * parent = nullptr, const QString & name = QString())**

        Creates a new widget with the given **parent** and **name** using the
        class specified by **className**. You can use this function to create
        any of the widgets returned by the **availableWidgets** () function.

        The function is also used internally by the **QUiLoader**  class
        whenever it creates a widget. Hence, you can subclass **QUiLoader**  and
        reimplement this function to intervene process of constructing a user
        interface or widget. However, in your implementation, ensure that you
        call **QUiLoader** 's version first.

        **See also** **availableWidgets** () and **load** ().
        """
        ...

    def errorString(self) -> str:
        """
        https://doc.qt.io/qt-6/quiloader.html#errorString

        **[since 5.0] QString QUiLoader::errorString() const**

        Returns a human-readable description of the last error occurred in
        **load** ().

        This function was introduced in Qt 5.0.

        **See also** **load** ().
        """
        ...

    def isLanguageChangeEnabled(self) -> bool:
        """
        https://doc.qt.io/qt-6/quiloader.html#isLanguageChangeEnabled

        **bool QUiLoader::isLanguageChangeEnabled() const**

        Returns true if dynamic retranslation on language change is enabled;
        returns false otherwise.

        **See also** **setLanguageChangeEnabled** ().
        """
        ...

    def isTranslationEnabled(self) -> bool:
        ...

    @overload
    def load(
        self,
        arg__1: Union[str, bytes, os.PathLike],
        parentWidget: Optional[PySide6.QtWidgets.QWidget] = ...,
    ) -> PySide6.QtWidgets.QWidget:
        """
        https://doc.qt.io/qt-6/quiloader.html#load

        **QWidget *QUiLoader::load(QIODevice * device , QWidget * parentWidget =
        nullptr)**

        Loads a form from the given **device** and creates a new widget with the
        given **parentWidget** to hold its contents.

        **See also** **createWidget** () and **errorString** ().
        """
        ...

    @overload
    def load(
        self,
        device: PySide6.QtCore.QIODevice,
        parentWidget: Optional[PySide6.QtWidgets.QWidget] = ...,
    ) -> PySide6.QtWidgets.QWidget:
        """
        https://doc.qt.io/qt-6/quiloader.html#load

        **QWidget *QUiLoader::load(QIODevice * device , QWidget * parentWidget =
        nullptr)**

        Loads a form from the given **device** and creates a new widget with the
        given **parentWidget** to hold its contents.

        **See also** **createWidget** () and **errorString** ().
        """
        ...

    def pluginPaths(self) -> List[str]:
        """
        https://doc.qt.io/qt-6/quiloader.html#pluginPaths

        **QStringList QUiLoader::pluginPaths() const**

        Returns a list naming the paths in which the loader will search when
        locating custom widget plugins.

        **See also** **addPluginPath** () and **clearPluginPaths** ().
        """
        ...

    def registerCustomWidget(self, customWidgetType: object) -> None:
        ...

    def setLanguageChangeEnabled(self, enabled: bool) -> None:
        """
        https://doc.qt.io/qt-6/quiloader.html#setLanguageChangeEnabled

        **void QUiLoader::setLanguageChangeEnabled(bool enabled )**

        If **enabled** is true, user interfaces loaded by this loader will
        automatically retranslate themselves upon receiving a language change
        event. Otherwise, the user interfaces will not be retranslated.

        **See also** **isLanguageChangeEnabled** ().
        """
        ...

    def setTranslationEnabled(self, enabled: bool) -> None:
        ...

    def setWorkingDirectory(self, dir: Union[PySide6.QtCore.QDir, str]) -> None:
        """
        https://doc.qt.io/qt-6/quiloader.html#setWorkingDirectory

        **void QUiLoader::setWorkingDirectory(const QDir & dir )**

        Sets the working directory of the loader to **dir**. The loader will
        look for other resources, such as icons and resource files, in paths
        relative to this directory.

        **See also** **workingDirectory** ().
        """
        ...

    def workingDirectory(self) -> PySide6.QtCore.QDir:
        """
        https://doc.qt.io/qt-6/quiloader.html#workingDirectory

        **QDir QUiLoader::workingDirectory() const**

        Returns the working directory of the loader.

        **See also** **setWorkingDirectory** ().
        """
        ...
