"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtTest, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import Optional, Union, overload
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets
import PySide6.QtTest

bytes = str


class QTest(object):
    """
    https://doc.qt.io/qt-6/qtest.html

    **Detailed Description**

    See the **Qt Test Overview**  for information about how to write unit tests.
    """

    Press: QTest.KeyAction = ...
    Release: QTest.KeyAction = ...
    Click: QTest.KeyAction = ...
    Shortcut: QTest.KeyAction = ...
    MousePress: QTest.MouseAction = ...
    MouseRelease: QTest.MouseAction = ...
    MouseClick: QTest.MouseAction = ...
    MouseDClick: QTest.MouseAction = ...
    MouseMove: QTest.MouseAction = ...
    FramesPerSecond: QTest.QBenchmarkMetric = ...
    BitsPerSecond: QTest.QBenchmarkMetric = ...
    BytesPerSecond: QTest.QBenchmarkMetric = ...
    WalltimeMilliseconds: QTest.QBenchmarkMetric = ...
    CPUTicks: QTest.QBenchmarkMetric = ...
    InstructionReads: QTest.QBenchmarkMetric = ...
    Events: QTest.QBenchmarkMetric = ...
    WalltimeNanoseconds: QTest.QBenchmarkMetric = ...
    BytesAllocated: QTest.QBenchmarkMetric = ...
    CPUMigrations: QTest.QBenchmarkMetric = ...
    CPUCycles: QTest.QBenchmarkMetric = ...
    BusCycles: QTest.QBenchmarkMetric = ...
    StalledCycles: QTest.QBenchmarkMetric = ...
    Instructions: QTest.QBenchmarkMetric = ...
    BranchInstructions: QTest.QBenchmarkMetric = ...
    BranchMisses: QTest.QBenchmarkMetric = ...
    CacheReferences: QTest.QBenchmarkMetric = ...
    CacheReads: QTest.QBenchmarkMetric = ...
    CacheWrites: QTest.QBenchmarkMetric = ...
    CachePrefetches: QTest.QBenchmarkMetric = ...
    CacheMisses: QTest.QBenchmarkMetric = ...
    CacheReadMisses: QTest.QBenchmarkMetric = ...
    CacheWriteMisses: QTest.QBenchmarkMetric = ...
    CachePrefetchMisses: QTest.QBenchmarkMetric = ...
    ContextSwitches: QTest.QBenchmarkMetric = ...
    PageFaults: QTest.QBenchmarkMetric = ...
    MinorPageFaults: QTest.QBenchmarkMetric = ...
    MajorPageFaults: QTest.QBenchmarkMetric = ...
    AlignmentFaults: QTest.QBenchmarkMetric = ...
    EmulationFaults: QTest.QBenchmarkMetric = ...
    RefCPUCycles: QTest.QBenchmarkMetric = ...
    Abort: QTest.TestFailMode = ...
    Continue: QTest.TestFailMode = ...

    class KeyAction(Enum):
        Press: QTest.KeyAction = ...
        Release: QTest.KeyAction = ...
        Click: QTest.KeyAction = ...
        Shortcut: QTest.KeyAction = ...

    class MouseAction(Enum):
        MousePress: QTest.MouseAction = ...
        MouseRelease: QTest.MouseAction = ...
        MouseClick: QTest.MouseAction = ...
        MouseDClick: QTest.MouseAction = ...
        MouseMove: QTest.MouseAction = ...

    class QBenchmarkMetric(Enum):
        FramesPerSecond: QTest.QBenchmarkMetric = ...
        BitsPerSecond: QTest.QBenchmarkMetric = ...
        BytesPerSecond: QTest.QBenchmarkMetric = ...
        WalltimeMilliseconds: QTest.QBenchmarkMetric = ...
        CPUTicks: QTest.QBenchmarkMetric = ...
        InstructionReads: QTest.QBenchmarkMetric = ...
        Events: QTest.QBenchmarkMetric = ...
        WalltimeNanoseconds: QTest.QBenchmarkMetric = ...
        BytesAllocated: QTest.QBenchmarkMetric = ...
        CPUMigrations: QTest.QBenchmarkMetric = ...
        CPUCycles: QTest.QBenchmarkMetric = ...
        BusCycles: QTest.QBenchmarkMetric = ...
        StalledCycles: QTest.QBenchmarkMetric = ...
        Instructions: QTest.QBenchmarkMetric = ...
        BranchInstructions: QTest.QBenchmarkMetric = ...
        BranchMisses: QTest.QBenchmarkMetric = ...
        CacheReferences: QTest.QBenchmarkMetric = ...
        CacheReads: QTest.QBenchmarkMetric = ...
        CacheWrites: QTest.QBenchmarkMetric = ...
        CachePrefetches: QTest.QBenchmarkMetric = ...
        CacheMisses: QTest.QBenchmarkMetric = ...
        CacheReadMisses: QTest.QBenchmarkMetric = ...
        CacheWriteMisses: QTest.QBenchmarkMetric = ...
        CachePrefetchMisses: QTest.QBenchmarkMetric = ...
        ContextSwitches: QTest.QBenchmarkMetric = ...
        PageFaults: QTest.QBenchmarkMetric = ...
        MinorPageFaults: QTest.QBenchmarkMetric = ...
        MajorPageFaults: QTest.QBenchmarkMetric = ...
        AlignmentFaults: QTest.QBenchmarkMetric = ...
        EmulationFaults: QTest.QBenchmarkMetric = ...
        RefCPUCycles: QTest.QBenchmarkMetric = ...

    class QTouchEventSequence(object):
        def commit(self, processEvents: bool = ...) -> None:
            ...

        @overload
        def move(
            self,
            touchId: int,
            pt: PySide6.QtCore.QPoint,
            widget: Optional[PySide6.QtWidgets.QWidget] = ...,
        ) -> PySide6.QtTest.QTest.QTouchEventSequence:
            ...

        @overload
        def move(
            self,
            touchId: int,
            pt: PySide6.QtCore.QPoint,
            window: Optional[PySide6.QtGui.QWindow] = ...,
        ) -> PySide6.QtTest.QTest.QTouchEventSequence:
            ...

        @overload
        def press(
            self,
            touchId: int,
            pt: PySide6.QtCore.QPoint,
            widget: Optional[PySide6.QtWidgets.QWidget] = ...,
        ) -> PySide6.QtTest.QTest.QTouchEventSequence:
            ...

        @overload
        def press(
            self,
            touchId: int,
            pt: PySide6.QtCore.QPoint,
            window: Optional[PySide6.QtGui.QWindow] = ...,
        ) -> PySide6.QtTest.QTest.QTouchEventSequence:
            ...

        @overload
        def release(
            self,
            touchId: int,
            pt: PySide6.QtCore.QPoint,
            widget: Optional[PySide6.QtWidgets.QWidget] = ...,
        ) -> PySide6.QtTest.QTest.QTouchEventSequence:
            ...

        @overload
        def release(
            self,
            touchId: int,
            pt: PySide6.QtCore.QPoint,
            window: Optional[PySide6.QtGui.QWindow] = ...,
        ) -> PySide6.QtTest.QTest.QTouchEventSequence:
            ...

        def stationary(self, touchId: int) -> PySide6.QtTest.QTest.QTouchEventSequence:
            ...

    class TestFailMode(Enum):
        Abort: QTest.TestFailMode = ...
        Continue: QTest.TestFailMode = ...

    @staticmethod
    def addColumnInternal(id: int, name: bytes) -> None:
        ...

    @staticmethod
    def asciiToKey(ascii: int) -> PySide6.QtCore.Qt.Key:
        ...

    @overload
    @staticmethod
    def compare_ptr_helper(
        t1: PySide6.QtCore.QObject,
        t2: PySide6.QtCore.QObject,
        actual: bytes,
        expected: bytes,
        file: bytes,
        line: int,
    ) -> bool:
        ...

    @overload
    @staticmethod
    def compare_ptr_helper(
        t1: int, t2: int, actual: bytes, expected: bytes, file: bytes, line: int
    ) -> bool:
        ...

    @staticmethod
    def compare_string_helper(
        t1: bytes, t2: bytes, actual: bytes, expected: bytes, file: bytes, line: int
    ) -> bool:
        ...

    @staticmethod
    def createTouchDevice(
        devType: PySide6.QtGui.QInputDevice.DeviceType = ...,
        caps: PySide6.QtGui.QInputDevice.Capabilities = ...,
    ) -> PySide6.QtGui.QPointingDevice:
        """
        https://doc.qt.io/qt-6/qtest.html#createTouchDevice

        **[since 5.8] QPointingDevice
        *QTest::createTouchDevice(QInputDevice::DeviceType devType =
        QInputDevice::DeviceType::TouchScreen, QInputDevice::Capabilities caps =
        QInputDevice::Capability::Position)**

        Creates a dummy touch device of type **devType** with capabilities
        **caps** for simulation of touch events.

        The touch device will be registered with the QPA window system
        interface, and deleted automatically when the **QCoreApplication**  is
        deleted. So you should typically use createTouchDevice() to initialize a
        **QPointingDevice**  member variable in your test case class, and use
        the same instance for all tests.

        This function was introduced in Qt 5.8.

        **See also** **QTest::QTouchEventSequence**  and **touchEvent** ().
        """
        ...

    @staticmethod
    def currentAppName() -> bytes:
        """
        https://doc.qt.io/qt-6/qtest.html#currentAppName

        **const char *QTest::currentAppName()**

        Returns the name of the binary that is currently executed.
        """
        ...

    @staticmethod
    def currentDataTag() -> bytes:
        """
        https://doc.qt.io/qt-6/qtest.html#currentDataTag

        **const char *QTest::currentDataTag()**

        Returns the name of the current test data. If the test doesn't have any
        assigned testdata, the function returns 0.
        """
        ...

    @staticmethod
    def currentTestFailed() -> bool:
        """
        https://doc.qt.io/qt-6/qtest.html#currentTestFailed

        **bool QTest::currentTestFailed()**

        Returns `true` if the current test function failed, otherwise false.
        """
        ...

    @staticmethod
    def currentTestFunction() -> bytes:
        """
        https://doc.qt.io/qt-6/qtest.html#currentTestFunction

        **const char *QTest::currentTestFunction()**

        Returns the name of the test function that is currently executed.

        Example:

        void MyTestClass::cleanup()
            {
                if
        (qstrcmp(QTest::currentTestFunction(), "myDatabaseTest") == 0) {
        // clean up all database connections
                    closeAllDatabases();
        }
            }
        """
        ...

    @staticmethod
    def formatString(prefix: bytes, suffix: bytes, numArguments: int) -> bytes:
        ...

    @overload
    @staticmethod
    def ignoreMessage(type: PySide6.QtCore.QtMsgType, message: bytes) -> None:
        """
        https://doc.qt.io/qt-6/qtest.html#ignoreMessage

        **void QTest::ignoreMessage(QtMsgType type , const char * message )**

        Ignores messages created by **qDebug** (), **qInfo** () or **qWarning**
        (). If the **message** with the corresponding **type** is outputted, it
        will be removed from the test log. If the test finished and the
        **message** was not outputted, a test failure is appended to the test
        log.

        **Note:** Invoking this function will only ignore one message. If the
        message you want to ignore is outputted twice, you have to call
        ignoreMessage() twice, too.

        Example:

        **QDir**  dir;
            QTest::ignoreMessage(**QtWarningMsg** , "QDir::mkdir:
        Empty or null file name(s)");
            dir.mkdir("");

        The example above tests that **QDir::mkdir** () outputs the right
        warning when invoked with an invalid file name.
        """
        ...

    @overload
    @staticmethod
    def ignoreMessage(
        type: PySide6.QtCore.QtMsgType,
        messagePattern: Union[PySide6.QtCore.QRegularExpression, str],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtest.html#ignoreMessage-1

        **[since 5.3] void QTest::ignoreMessage(QtMsgType type , const
        QRegularExpression & messagePattern )**

        This is an overloaded function.

        Ignores messages created by **qDebug** (), **qInfo** () or **qWarning**
        (). If the message matching **messagePattern** with the corresponding
        **type** is outputted, it will be removed from the test log. If the test
        finished and the message was not outputted, a test failure is appended
        to the test log.

        **Note:** Invoking this function will only ignore one message. If the
        message you want to ignore is outputted twice, you have to call
        ignoreMessage() twice, too.

        This function was introduced in Qt 5.3.
        """
        ...

    @overload
    @staticmethod
    def keyClick(
        widget: PySide6.QtWidgets.QWidget,
        key: PySide6.QtCore.Qt.Key,
        modifier: PySide6.QtCore.Qt.KeyboardModifiers = ...,
        delay: int = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtest.html#keyClick

        **void QTest::keyClick(QWidget * widget , Qt::Key key ,
        Qt::KeyboardModifiers modifier = Qt::NoModifier, int delay = -1)**

        Simulates clicking of **key** with an optional **modifier** on a
        **widget**. If **delay** is larger than 0, the test will wait for
        **delay** milliseconds before clicking the key.

        Examples:

        QTest::keyClick(myWidget, Qt::Key_Escape);
        QTest::keyClick(myWidget, Qt::Key_Escape, Qt::ShiftModifier, 200);

        The first example above simulates clicking the `escape` key on
        `myWidget` without any keyboard modifiers and without delay. The second
        example simulates clicking `shift-escape` on `myWidget` following a 200
        ms delay of the test.

        **See also** **QTest::keyClicks** ().
        """
        ...

    @overload
    @staticmethod
    def keyClick(
        widget: PySide6.QtWidgets.QWidget,
        key: int,
        modifier: PySide6.QtCore.Qt.KeyboardModifiers = ...,
        delay: int = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtest.html#keyClick-1

        **[since 5.0] void QTest::keyClick(QWindow * window , Qt::Key key ,
        Qt::KeyboardModifiers modifier = Qt::NoModifier, int delay = -1)**

        This is an overloaded function.

        Simulates clicking of **key** with an optional **modifier** on a
        **window**. If **delay** is larger than 0, the test will wait for
        **delay** milliseconds before clicking the key.

        Examples:

        QTest::keyClick(&myWindow, Qt::Key_Escape);
        QTest::keyClick(&myWindow, Qt::Key_Escape, Qt::ShiftModifier, 200);

        The first example above simulates clicking the `escape` key on
        `myWindow` without any keyboard modifiers and without delay. The second
        example simulates clicking `shift-escape` on `myWindow` following a 200
        ms delay of the test.

        This function was introduced in Qt 5.0.

        **See also** **QTest::keyClicks** ().
        """
        ...

    @overload
    @staticmethod
    def keyClick(
        window: PySide6.QtGui.QWindow,
        key: PySide6.QtCore.Qt.Key,
        modifier: PySide6.QtCore.Qt.KeyboardModifiers = ...,
        delay: int = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtest.html#keyClick-2

        **[since 5.0] void QTest::keyClick(QWindow * window , char key ,
        Qt::KeyboardModifiers modifier = Qt::NoModifier, int delay = -1)**

        This is an overloaded function.

        Simulates clicking of **key** with an optional **modifier** on a
        **window**. If **delay** is larger than 0, the test will wait for
        **delay** milliseconds before clicking the key.

        Example:

        **QWidget**  myWindow;
            QTest::keyClick(&myWindow, Qt::Key_Tab);

        The example above simulates clicking `a` on `myWindow` without any
        keyboard modifiers and without delay of the test.

        This function was introduced in Qt 5.0.

        **See also** **QTest::keyClicks** ().
        """
        ...

    @overload
    @staticmethod
    def keyClick(
        window: PySide6.QtGui.QWindow,
        key: int,
        modifier: PySide6.QtCore.Qt.KeyboardModifiers = ...,
        delay: int = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtest.html#keyClick-3

        **void QTest::keyClick(QWidget * widget , char key ,
        Qt::KeyboardModifiers modifier = Qt::NoModifier, int delay = -1)**

        This is an overloaded function.

        Simulates clicking of **key** with an optional **modifier** on a
        **widget**. If **delay** is larger than 0, the test will wait for
        **delay** milliseconds before clicking the key.

        Example:

        QTest::keyClick(myWidget, 'a');

        The example above simulates clicking `a` on `myWidget` without any
        keyboard modifiers and without delay of the test.

        **See also** **QTest::keyClicks** ().
        """
        ...

    @staticmethod
    def keyClicks(
        widget: PySide6.QtWidgets.QWidget,
        sequence: str,
        modifier: PySide6.QtCore.Qt.KeyboardModifiers = ...,
        delay: int = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtest.html#keyClicks

        **void QTest::keyClicks(QWidget * widget , const QString & sequence ,
        Qt::KeyboardModifiers modifier = Qt::NoModifier, int delay = -1)**

        Simulates clicking a **sequence** of keys on a **widget**. Optionally, a
        keyboard **modifier** can be specified as well as a **delay** (in
        milliseconds) of the test before each key click.

        Example:

        QTest::keyClicks(myWidget, "hello world");

        The example above simulates clicking the sequence of keys representing
        "hello world" on `myWidget` without any keyboard modifiers and without
        delay of the test.

        **See also** **QTest::keyClick** ().
        """
        ...

    @overload
    @staticmethod
    def keyEvent(
        action: PySide6.QtTest.QTest.KeyAction,
        widget: PySide6.QtWidgets.QWidget,
        ascii: int,
        modifier: PySide6.QtCore.Qt.KeyboardModifiers = ...,
        delay: int = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtest.html#keyEvent

        **void QTest::keyEvent(QTest::KeyAction action , QWidget * widget ,
        Qt::Key key , Qt::KeyboardModifiers modifier = Qt::NoModifier, int delay
        = -1)**

        Sends a Qt key event to **widget** with the given **key** and an
        associated **action**. Optionally, a keyboard **modifier** can be
        specified, as well as a **delay** (in milliseconds) of the test before
        sending the event.
        """
        ...

    @overload
    @staticmethod
    def keyEvent(
        action: PySide6.QtTest.QTest.KeyAction,
        widget: PySide6.QtWidgets.QWidget,
        key: PySide6.QtCore.Qt.Key,
        modifier: PySide6.QtCore.Qt.KeyboardModifiers = ...,
        delay: int = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtest.html#keyEvent-1

        **[since 5.0] void QTest::keyEvent(QTest::KeyAction action , QWindow *
        window , char ascii , Qt::KeyboardModifiers modifier = Qt::NoModifier,
        int delay = -1)**

        This is an overloaded function.

        Sends a Qt key event to **window** with the given key **ascii** and an
        associated **action**. Optionally, a keyboard **modifier** can be
        specified, as well as a **delay** (in milliseconds) of the test before
        sending the event.

        This function was introduced in Qt 5.0.
        """
        ...

    @overload
    @staticmethod
    def keyEvent(
        action: PySide6.QtTest.QTest.KeyAction,
        window: PySide6.QtGui.QWindow,
        ascii: int,
        modifier: PySide6.QtCore.Qt.KeyboardModifiers = ...,
        delay: int = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtest.html#keyEvent-2

        **[since 5.0] void QTest::keyEvent(QTest::KeyAction action , QWindow *
        window , Qt::Key key , Qt::KeyboardModifiers modifier = Qt::NoModifier,
        int delay = -1)**

        This is an overloaded function.

        Sends a Qt key event to **window** with the given **key** and an
        associated **action**. Optionally, a keyboard **modifier** can be
        specified, as well as a **delay** (in milliseconds) of the test before
        sending the event.

        This function was introduced in Qt 5.0.
        """
        ...

    @overload
    @staticmethod
    def keyEvent(
        action: PySide6.QtTest.QTest.KeyAction,
        window: PySide6.QtGui.QWindow,
        key: PySide6.QtCore.Qt.Key,
        modifier: PySide6.QtCore.Qt.KeyboardModifiers = ...,
        delay: int = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtest.html#keyEvent-3

        **void QTest::keyEvent(QTest::KeyAction action , QWidget * widget , char
        ascii , Qt::KeyboardModifiers modifier = Qt::NoModifier, int delay =
        -1)**

        This is an overloaded function.

        Sends a Qt key event to **widget** with the given key **ascii** and an
        associated **action**. Optionally, a keyboard **modifier** can be
        specified, as well as a **delay** (in milliseconds) of the test before
        sending the event.
        """
        ...

    @overload
    @staticmethod
    def keyPress(
        widget: PySide6.QtWidgets.QWidget,
        key: PySide6.QtCore.Qt.Key,
        modifier: PySide6.QtCore.Qt.KeyboardModifiers = ...,
        delay: int = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtest.html#keyPress

        **void QTest::keyPress(QWidget * widget , Qt::Key key ,
        Qt::KeyboardModifiers modifier = Qt::NoModifier, int delay = -1)**

        Simulates pressing a **key** with an optional **modifier** on a
        **widget**. If **delay** is larger than 0, the test will wait for
        **delay** milliseconds before pressing the key.

        **Note:** At some point you should release the key using **keyRelease**
        ().

        **See also** **QTest::keyRelease** () and **QTest::keyClick** ().
        """
        ...

    @overload
    @staticmethod
    def keyPress(
        widget: PySide6.QtWidgets.QWidget,
        key: int,
        modifier: PySide6.QtCore.Qt.KeyboardModifiers = ...,
        delay: int = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtest.html#keyPress-1

        **[since 5.0] void QTest::keyPress(QWindow * window , char key ,
        Qt::KeyboardModifiers modifier = Qt::NoModifier, int delay = -1)**

        This is an overloaded function.

        Simulates pressing a **key** with an optional **modifier** on a
        **window**. If **delay** is larger than 0, the test will wait for
        **delay** milliseconds before pressing the key.

        **Note:** At some point you should release the key using **keyRelease**
        ().

        This function was introduced in Qt 5.0.

        **See also** **QTest::keyRelease** () and **QTest::keyClick** ().
        """
        ...

    @overload
    @staticmethod
    def keyPress(
        window: PySide6.QtGui.QWindow,
        key: PySide6.QtCore.Qt.Key,
        modifier: PySide6.QtCore.Qt.KeyboardModifiers = ...,
        delay: int = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtest.html#keyPress-2

        **[since 5.0] void QTest::keyPress(QWindow * window , Qt::Key key ,
        Qt::KeyboardModifiers modifier = Qt::NoModifier, int delay = -1)**

        This is an overloaded function.

        Simulates pressing a **key** with an optional **modifier** on a
        **window**. If **delay** is larger than 0, the test will wait for
        **delay** milliseconds before pressing the key.

        **Note:** At some point you should release the key using **keyRelease**
        ().

        This function was introduced in Qt 5.0.

        **See also** **QTest::keyRelease** () and **QTest::keyClick** ().
        """
        ...

    @overload
    @staticmethod
    def keyPress(
        window: PySide6.QtGui.QWindow,
        key: int,
        modifier: PySide6.QtCore.Qt.KeyboardModifiers = ...,
        delay: int = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtest.html#keyPress-3

        **void QTest::keyPress(QWidget * widget , char key ,
        Qt::KeyboardModifiers modifier = Qt::NoModifier, int delay = -1)**

        This is an overloaded function.

        Simulates pressing a **key** with an optional **modifier** on a
        **widget**. If **delay** is larger than 0, the test will wait for
        **delay** milliseconds before pressing the key.

        **Note:** At some point you should release the key using **keyRelease**
        ().

        **See also** **QTest::keyRelease** () and **QTest::keyClick** ().
        """
        ...

    @overload
    @staticmethod
    def keyRelease(
        widget: PySide6.QtWidgets.QWidget,
        key: PySide6.QtCore.Qt.Key,
        modifier: PySide6.QtCore.Qt.KeyboardModifiers = ...,
        delay: int = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtest.html#keyRelease

        **void QTest::keyRelease(QWidget * widget , Qt::Key key ,
        Qt::KeyboardModifiers modifier = Qt::NoModifier, int delay = -1)**

        Simulates releasing a **key** with an optional **modifier** on a
        **widget**. If **delay** is larger than 0, the test will wait for
        **delay** milliseconds before releasing the key.

        **See also** **QTest::keyPress** () and **QTest::keyClick** ().
        """
        ...

    @overload
    @staticmethod
    def keyRelease(
        widget: PySide6.QtWidgets.QWidget,
        key: int,
        modifier: PySide6.QtCore.Qt.KeyboardModifiers = ...,
        delay: int = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtest.html#keyRelease-1

        **[since 5.0] void QTest::keyRelease(QWindow * window , char key ,
        Qt::KeyboardModifiers modifier = Qt::NoModifier, int delay = -1)**

        This is an overloaded function.

        Simulates releasing a **key** with an optional **modifier** on a
        **window**. If **delay** is larger than 0, the test will wait for
        **delay** milliseconds before releasing the key.

        This function was introduced in Qt 5.0.

        **See also** **QTest::keyClick** ().
        """
        ...

    @overload
    @staticmethod
    def keyRelease(
        window: PySide6.QtGui.QWindow,
        key: PySide6.QtCore.Qt.Key,
        modifier: PySide6.QtCore.Qt.KeyboardModifiers = ...,
        delay: int = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtest.html#keyRelease-2

        **[since 5.0] void QTest::keyRelease(QWindow * window , Qt::Key key ,
        Qt::KeyboardModifiers modifier = Qt::NoModifier, int delay = -1)**

        This is an overloaded function.

        Simulates releasing a **key** with an optional **modifier** on a
        **window**. If **delay** is larger than 0, the test will wait for
        **delay** milliseconds before releasing the key.

        This function was introduced in Qt 5.0.

        **See also** **QTest::keyPress** () and **QTest::keyClick** ().
        """
        ...

    @overload
    @staticmethod
    def keyRelease(
        window: PySide6.QtGui.QWindow,
        key: int,
        modifier: PySide6.QtCore.Qt.KeyboardModifiers = ...,
        delay: int = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtest.html#keyRelease-3

        **void QTest::keyRelease(QWidget * widget , char key ,
        Qt::KeyboardModifiers modifier = Qt::NoModifier, int delay = -1)**

        This is an overloaded function.

        Simulates releasing a **key** with an optional **modifier** on a
        **widget**. If **delay** is larger than 0, the test will wait for
        **delay** milliseconds before releasing the key.

        **See also** **QTest::keyClick** ().
        """
        ...

    @overload
    @staticmethod
    def keySequence(
        widget: PySide6.QtWidgets.QWidget,
        keySequence: Union[
            PySide6.QtGui.QKeySequence,
            PySide6.QtCore.QKeyCombination,
            PySide6.QtGui.QKeySequence.StandardKey,
            str,
            int,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtest.html#keySequence

        **[since 5.10] void QTest::keySequence(QWindow * window , const
        QKeySequence & keySequence )**

        This is an overloaded function.

        Simulates typing of **keySequence** into a **window**.

        This function was introduced in Qt 5.10.

        **See also** **QTest::keyClick** () and **QTest::keyClicks** ().
        """
        ...

    @overload
    @staticmethod
    def keySequence(
        window: PySide6.QtGui.QWindow,
        keySequence: Union[
            PySide6.QtGui.QKeySequence,
            PySide6.QtCore.QKeyCombination,
            PySide6.QtGui.QKeySequence.StandardKey,
            str,
            int,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtest.html#keySequence-1

        **[since 5.10] void QTest::keySequence(QWidget * widget , const
        QKeySequence & keySequence )**

        This is an overloaded function.

        Simulates typing of **keySequence** into a **widget**.

        This function was introduced in Qt 5.10.

        **See also** **QTest::keyClick** () and **QTest::keyClicks** ().
        """
        ...

    @staticmethod
    def keyToAscii(key: PySide6.QtCore.Qt.Key) -> int:
        ...

    @overload
    @staticmethod
    def mouseClick(
        widget: PySide6.QtWidgets.QWidget,
        button: PySide6.QtCore.Qt.MouseButton,
        stateKey: PySide6.QtCore.Qt.KeyboardModifiers = ...,
        pos: PySide6.QtCore.QPoint = ...,
        delay: int = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtest.html#mouseClick

        **void QTest::mouseClick(QWidget * widget , Qt::MouseButton button ,
        Qt::KeyboardModifiers modifier = Qt::KeyboardModifiers(), QPoint pos =
        QPoint(), int delay = -1)**

        Simulates clicking a mouse **button** with an optional **modifier** on a
        **widget**. The position of the click is defined by **pos** ; the
        default position is the center of the widget. If **delay** is specified,
        the test will wait for the specified amount of milliseconds before
        pressing and before releasing the button.

        **See also** **QTest::mousePress** () and **QTest::mouseRelease** ().
        """
        ...

    @overload
    @staticmethod
    def mouseClick(
        window: PySide6.QtGui.QWindow,
        button: PySide6.QtCore.Qt.MouseButton,
        stateKey: PySide6.QtCore.Qt.KeyboardModifiers = ...,
        pos: PySide6.QtCore.QPoint = ...,
        delay: int = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtest.html#mouseClick-1

        **[since 5.0] void QTest::mouseClick(QWindow * window , Qt::MouseButton
        button , Qt::KeyboardModifiers stateKey = Qt::KeyboardModifiers(),
        QPoint pos = QPoint(), int delay = -1)**

        This is an overloaded function.

        Simulates clicking a mouse **button** with an optional **stateKey**
        modifier on a **window**. The position of the click is defined by
        **pos** ; the default position is the center of the window. If **delay**
        is specified, the test will wait for the specified amount of
        milliseconds before pressing and before releasing the button.

        This function was introduced in Qt 5.0.

        **See also** **QTest::mousePress** () and **QTest::mouseRelease** ().
        """
        ...

    @overload
    @staticmethod
    def mouseDClick(
        widget: PySide6.QtWidgets.QWidget,
        button: PySide6.QtCore.Qt.MouseButton,
        stateKey: PySide6.QtCore.Qt.KeyboardModifiers = ...,
        pos: PySide6.QtCore.QPoint = ...,
        delay: int = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtest.html#mouseDClick

        **void QTest::mouseDClick(QWidget * widget , Qt::MouseButton button ,
        Qt::KeyboardModifiers modifier = Qt::KeyboardModifiers(), QPoint pos =
        QPoint(), int delay = -1)**

        Simulates double clicking a mouse **button** with an optional
        **modifier** on a **widget**. The position of the click is defined by
        **pos** ; the default position is the center of the widget. If **delay**
        is specified, the test will wait for the specified amount of
        milliseconds before each press and release.

        **See also** **QTest::mouseClick** ().
        """
        ...

    @overload
    @staticmethod
    def mouseDClick(
        window: PySide6.QtGui.QWindow,
        button: PySide6.QtCore.Qt.MouseButton,
        stateKey: PySide6.QtCore.Qt.KeyboardModifiers = ...,
        pos: PySide6.QtCore.QPoint = ...,
        delay: int = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtest.html#mouseDClick-1

        **[since 5.0] void QTest::mouseDClick(QWindow * window , Qt::MouseButton
        button , Qt::KeyboardModifiers stateKey = Qt::KeyboardModifiers(),
        QPoint pos = QPoint(), int delay = -1)**

        This is an overloaded function.

        Simulates double clicking a mouse **button** with an optional
        **stateKey** modifier on a **window**. The position of the click is
        defined by **pos** ; the default position is the center of the window.
        If **delay** is specified, the test will wait for the specified amount
        of milliseconds before each press and release.

        This function was introduced in Qt 5.0.

        **See also** **QTest::mouseClick** ().
        """
        ...

    @overload
    @staticmethod
    def mouseEvent(
        action: PySide6.QtTest.QTest.MouseAction,
        widget: PySide6.QtWidgets.QWidget,
        button: PySide6.QtCore.Qt.MouseButton,
        stateKey: PySide6.QtCore.Qt.KeyboardModifiers,
        pos: PySide6.QtCore.QPoint,
        delay: int = ...,
    ) -> None:
        ...

    @overload
    @staticmethod
    def mouseEvent(
        action: PySide6.QtTest.QTest.MouseAction,
        window: PySide6.QtGui.QWindow,
        button: PySide6.QtCore.Qt.MouseButton,
        stateKey: PySide6.QtCore.Qt.KeyboardModifiers,
        pos: PySide6.QtCore.QPoint,
        delay: int = ...,
    ) -> None:
        ...

    @overload
    @staticmethod
    def mouseMove(
        widget: PySide6.QtWidgets.QWidget,
        pos: PySide6.QtCore.QPoint = ...,
        delay: int = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtest.html#mouseMove

        **void QTest::mouseMove(QWidget * widget , QPoint pos = QPoint(), int
        delay = -1)**

        Moves the mouse pointer to a **widget**. If **pos** is not specified,
        the mouse pointer moves to the center of the widget. If a **delay** (in
        milliseconds) is given, the test will wait before moving the mouse
        pointer.
        """
        ...

    @overload
    @staticmethod
    def mouseMove(
        window: PySide6.QtGui.QWindow,
        pos: PySide6.QtCore.QPoint = ...,
        delay: int = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtest.html#mouseMove-1

        **[since 5.0] void QTest::mouseMove(QWindow * window , QPoint pos =
        QPoint(), int delay = -1)**

        This is an overloaded function.

        Moves the mouse pointer to a **window**. If **pos** is not specified,
        the mouse pointer moves to the center of the window. If a **delay** (in
        milliseconds) is given, the test will wait before moving the mouse
        pointer.

        This function was introduced in Qt 5.0.
        """
        ...

    @overload
    @staticmethod
    def mousePress(
        widget: PySide6.QtWidgets.QWidget,
        button: PySide6.QtCore.Qt.MouseButton,
        stateKey: PySide6.QtCore.Qt.KeyboardModifiers = ...,
        pos: PySide6.QtCore.QPoint = ...,
        delay: int = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtest.html#mousePress

        **void QTest::mousePress(QWidget * widget , Qt::MouseButton button ,
        Qt::KeyboardModifiers modifier = Qt::KeyboardModifiers(), QPoint pos =
        QPoint(), int delay = -1)**

        Simulates pressing a mouse **button** with an optional **modifier** on a
        **widget**. The position is defined by **pos** ; the default position is
        the center of the widget. If **delay** is specified, the test will wait
        for the specified amount of milliseconds before the press.

        **See also** **QTest::mouseRelease** () and **QTest::mouseClick** ().
        """
        ...

    @overload
    @staticmethod
    def mousePress(
        window: PySide6.QtGui.QWindow,
        button: PySide6.QtCore.Qt.MouseButton,
        stateKey: PySide6.QtCore.Qt.KeyboardModifiers = ...,
        pos: PySide6.QtCore.QPoint = ...,
        delay: int = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtest.html#mousePress-1

        **[since 5.0] void QTest::mousePress(QWindow * window , Qt::MouseButton
        button , Qt::KeyboardModifiers stateKey = Qt::KeyboardModifiers(),
        QPoint pos = QPoint(), int delay = -1)**

        This is an overloaded function.

        Simulates pressing a mouse **button** with an optional **stateKey**
        modifier on a **window**. The position is defined by **pos** ; the
        default position is the center of the window. If **delay** is specified,
        the test will wait for the specified amount of milliseconds before the
        press.

        This function was introduced in Qt 5.0.

        **See also** **QTest::mouseRelease** () and **QTest::mouseClick** ().
        """
        ...

    @overload
    @staticmethod
    def mouseRelease(
        widget: PySide6.QtWidgets.QWidget,
        button: PySide6.QtCore.Qt.MouseButton,
        stateKey: PySide6.QtCore.Qt.KeyboardModifiers = ...,
        pos: PySide6.QtCore.QPoint = ...,
        delay: int = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtest.html#mouseRelease

        **void QTest::mouseRelease(QWidget * widget , Qt::MouseButton button ,
        Qt::KeyboardModifiers modifier = Qt::KeyboardModifiers(), QPoint pos =
        QPoint(), int delay = -1)**

        Simulates releasing a mouse **button** with an optional **modifier** on
        a **widget**. The position of the release is defined by **pos** ; the
        default position is the center of the widget. If **delay** is specified,
        the test will wait for the specified amount of milliseconds before
        releasing the button.

        **See also** **QTest::mousePress** () and **QTest::mouseClick** ().
        """
        ...

    @overload
    @staticmethod
    def mouseRelease(
        window: PySide6.QtGui.QWindow,
        button: PySide6.QtCore.Qt.MouseButton,
        stateKey: PySide6.QtCore.Qt.KeyboardModifiers = ...,
        pos: PySide6.QtCore.QPoint = ...,
        delay: int = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtest.html#mouseRelease-1

        **[since 5.0] void QTest::mouseRelease(QWindow * window ,
        Qt::MouseButton button , Qt::KeyboardModifiers stateKey =
        Qt::KeyboardModifiers(), QPoint pos = QPoint(), int delay = -1)**

        This is an overloaded function.

        Simulates releasing a mouse **button** with an optional **stateKey**
        modifier on a **window**. The position of the release is defined by
        **pos** ; the default position is the center of the window. If **delay**
        is specified, the test will wait for the specified amount of
        milliseconds before releasing the button.

        This function was introduced in Qt 5.0.

        **See also** **QTest::mousePress** () and **QTest::mouseClick** ().
        """
        ...

    @staticmethod
    def qCleanup() -> None:
        ...

    @staticmethod
    def qElementData(elementName: bytes, metaTypeId: int) -> int:
        ...

    @staticmethod
    def qExpectFail(
        dataIndex: bytes,
        comment: bytes,
        mode: PySide6.QtTest.QTest.TestFailMode,
        file: bytes,
        line: int,
    ) -> bool:
        ...

    @overload
    @staticmethod
    def qFindTestData(
        basepath: str,
        file: Optional[bytes] = ...,
        line: int = ...,
        builddir: Optional[bytes] = ...,
        sourcedir: Optional[bytes] = ...,
    ) -> str:
        ...

    @overload
    @staticmethod
    def qFindTestData(
        basepath: bytes,
        file: Optional[bytes] = ...,
        line: int = ...,
        builddir: Optional[bytes] = ...,
        sourcedir: Optional[bytes] = ...,
    ) -> str:
        ...

    @staticmethod
    def qGlobalData(tagName: bytes, typeId: int) -> int:
        ...

    @staticmethod
    def qRun() -> int:
        ...

    @staticmethod
    def qSkip(message: bytes, file: bytes, line: int) -> None:
        ...

    @overload
    @staticmethod
    def qWaitForWindowActive(
        widget: PySide6.QtWidgets.QWidget, timeout: int = ...
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qtest.html#qWaitForWindowActive

        **[since 5.0] bool QTest::qWaitForWindowActive(QWindow * window , int
        timeout = 5000)**

        Waits for **timeout** milliseconds or until the **window** is active.

        Returns `true` if `window` is active within **timeout** milliseconds,
        otherwise returns `false`.

        This function was introduced in Qt 5.0.

        **See also** **qWaitForWindowExposed** () and **QWindow::isActive** ().
        """
        ...

    @overload
    @staticmethod
    def qWaitForWindowActive(window: PySide6.QtGui.QWindow, timeout: int = ...) -> bool:
        """
        https://doc.qt.io/qt-6/qtest.html#qWaitForWindowActive-1

        **[since 5.0] bool QTest::qWaitForWindowActive(QWidget * widget , int
        timeout = 5000)**

        Waits for **timeout** milliseconds or until the **widget** 's window is
        active.

        Returns `true` if `widget`'s window is active within **timeout**
        milliseconds, otherwise returns `false`.

        This function was introduced in Qt 5.0.

        **See also** **qWaitForWindowExposed** () and
        **QWidget::isActiveWindow** ().
        """
        ...

    @overload
    @staticmethod
    def qWaitForWindowExposed(
        widget: PySide6.QtWidgets.QWidget, timeout: int = ...
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qtest.html#qWaitForWindowExposed

        **[since 5.0] bool QTest::qWaitForWindowExposed(QWindow * window , int
        timeout = 5000)**

        Waits for **timeout** milliseconds or until the **window** is exposed.
        Returns `true` if `window` is exposed within **timeout** milliseconds,
        otherwise returns `false`.

        This is mainly useful for asynchronous systems like X11, where a window
        will be mapped to screen some time after being asked to show itself on
        the screen.

        Note that a window that is mapped to screen may still not be considered
        exposed if the window client area is completely covered by other
        windows, or if the window is otherwise not visible. This function will
        then time out when waiting for such a window.

        This function was introduced in Qt 5.0.

        **See also** **qWaitForWindowActive** () and **QWindow::isExposed** ().
        """
        ...

    @overload
    @staticmethod
    def qWaitForWindowExposed(
        window: PySide6.QtGui.QWindow, timeout: int = ...
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qtest.html#qWaitForWindowExposed-1

        **[since 5.0] bool QTest::qWaitForWindowExposed(QWidget * widget , int
        timeout = 5000)**

        Waits for **timeout** milliseconds or until the **widget** 's window is
        exposed. Returns `true` if `widget`'s window is exposed within
        **timeout** milliseconds, otherwise returns `false`.

        This is mainly useful for asynchronous systems like X11, where a window
        will be mapped to screen some time after being asked to show itself on
        the screen.

        Note that a window that is mapped to screen may still not be considered
        exposed if the window client area is completely covered by other
        windows, or if the window is otherwise not visible. This function will
        then time out when waiting for such a window.

        A specific configuration where this happens is when using QGLWidget as a
        viewport widget on macOS: The viewport widget gets the expose event, not
        the parent widget.

        This function was introduced in Qt 5.0.

        **See also** **qWaitForWindowActive** ().
        """
        ...

    @overload
    @staticmethod
    def sendKeyEvent(
        action: PySide6.QtTest.QTest.KeyAction,
        widget: PySide6.QtWidgets.QWidget,
        code: PySide6.QtCore.Qt.Key,
        ascii: int,
        modifier: PySide6.QtCore.Qt.KeyboardModifiers,
        delay: int = ...,
    ) -> None:
        ...

    @overload
    @staticmethod
    def sendKeyEvent(
        action: PySide6.QtTest.QTest.KeyAction,
        widget: PySide6.QtWidgets.QWidget,
        code: PySide6.QtCore.Qt.Key,
        text: str,
        modifier: PySide6.QtCore.Qt.KeyboardModifiers,
        delay: int = ...,
    ) -> None:
        ...

    @overload
    @staticmethod
    def sendKeyEvent(
        action: PySide6.QtTest.QTest.KeyAction,
        window: PySide6.QtGui.QWindow,
        code: PySide6.QtCore.Qt.Key,
        ascii: int,
        modifier: PySide6.QtCore.Qt.KeyboardModifiers,
        delay: int = ...,
    ) -> None:
        ...

    @overload
    @staticmethod
    def sendKeyEvent(
        action: PySide6.QtTest.QTest.KeyAction,
        window: PySide6.QtGui.QWindow,
        code: PySide6.QtCore.Qt.Key,
        text: str,
        modifier: PySide6.QtCore.Qt.KeyboardModifiers,
        delay: int = ...,
    ) -> None:
        ...

    @staticmethod
    def setBenchmarkResult(
        result: float, metric: PySide6.QtTest.QTest.QBenchmarkMetric
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtest.html#setBenchmarkResult

        **void QTest::setBenchmarkResult(qreal result , QTest::QBenchmarkMetric
        metric )**

        Sets the benchmark result for this test function to **result**.

        Use this function if you want to report benchmark results without using
        the QBENCHMARK macro. Use **metric** to specify how Qt Test should
        interpret the results.

        The context for the result will be the test function name and any data
        tag from the _data function. This function can only be called once in
        each test function, subsequent calls will replace the earlier reported
        results.

        Note that the -iterations command line argument has no effect on test
        functions without the QBENCHMARK macro.
        """
        ...

    @staticmethod
    def setMainSourcePath(file: bytes, builddir: Optional[bytes] = ...) -> None:
        ...

    @overload
    @staticmethod
    def simulateEvent(
        widget: PySide6.QtWidgets.QWidget,
        press: bool,
        code: int,
        modifier: PySide6.QtCore.Qt.KeyboardModifiers,
        text: str,
        repeat: bool,
        delay: int = ...,
    ) -> None:
        ...

    @overload
    @staticmethod
    def simulateEvent(
        window: PySide6.QtGui.QWindow,
        press: bool,
        code: int,
        modifier: PySide6.QtCore.Qt.KeyboardModifiers,
        text: str,
        repeat: bool,
        delay: int = ...,
    ) -> None:
        ...

    @staticmethod
    def testObject() -> PySide6.QtCore.QObject:
        ...

    @staticmethod
    def toPrettyCString(unicode: bytes, length: int) -> bytes:
        ...

    @overload
    @staticmethod
    def touchEvent(
        widget: PySide6.QtWidgets.QWidget,
        device: PySide6.QtGui.QPointingDevice,
        autoCommit: bool = ...,
    ) -> PySide6.QtTest.QTest.QTouchEventSequence:
        """
        https://doc.qt.io/qt-6/qtest.html#touchEvent

        **QTest::QTouchEventWidgetSequence QTest::touchEvent(QWidget * widget ,
        QPointingDevice * device , bool autoCommit = true)**

        Creates and returns a **QTouchEventSequence**  for the **device** to
        simulate events for **widget**.

        When adding touch events to the sequence, **widget** will also be used
        to translate the position provided to screen coordinates, unless another
        widget is provided in the respective calls to press(), move() etc.

        The touch events are committed to the event system when the destructor
        of the **QTouchEventSequence**  is called (ie when the object returned
        runs out of scope), unless **autoCommit** is set to false. When
        **autoCommit** is false, commit() has to be called manually.

        **createTouchDevice** () can be called to create a test touch device for
        use with this function.
        """
        ...

    @overload
    @staticmethod
    def touchEvent(
        window: PySide6.QtGui.QWindow,
        device: PySide6.QtGui.QPointingDevice,
        autoCommit: bool = ...,
    ) -> PySide6.QtTest.QTest.QTouchEventSequence:
        """
        https://doc.qt.io/qt-6/qtest.html#touchEvent-1

        **[since 5.0] QTest::QTouchEventSequence QTest::touchEvent(QWindow *
        window , QPointingDevice * device , bool autoCommit = true)**

        Creates and returns a **QTouchEventSequence**  for the **device** to
        simulate events for **window**.

        When adding touch events to the sequence, **window** will also be used
        to translate the position provided to screen coordinates, unless another
        window is provided in the respective calls to press(), move() etc.

        The touch events are committed to the event system when the destructor
        of the **QTouchEventSequence**  is called (ie when the object returned
        runs out of scope), unless **autoCommit** is set to false. When
        **autoCommit** is false, commit() has to be called manually.

        **createTouchDevice** () can be called to create a test touch device for
        use with this function.

        This function was introduced in Qt 5.0.
        """
        ...
