"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtSvgWidgets, except for defaults which are replaced by "...".
"""
from typing import Optional, Union, overload
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets
import PySide6.QtSvg
import PySide6.QtSvgWidgets

bytes = str


class QSvgWidget(PySide6.QtWidgets.QWidget):
    """
    https://doc.qt.io/qt-6/qsvgwidget.html

    **Detailed Description**

    This class enables developers to display SVG drawings alongside standard
    widgets, and is used in much the same way as **QLabel**  is used for
    displaying text and bitmap images.

    Since QSvgWidget is a subclass of **QWidget** , SVG drawings are rendered
    using the properties of the display. More control can be exercised over the
    rendering process with the **QSvgRenderer**  class, as this can be used to
    paint onto other paint devices, such as **QImage**  and QGLWidget. The
    renderer used by the widget can be obtained with the **renderer** ()
    function.

    Each QSvgWidget can be constructed with the file name of a SVG file, or they
    can be constructed without a specific file to render and one can be supplied
    later. The **load** () functions provide two different ways to load an SVG
    file: they accept either the file name of an SVG file or a **QByteArray**
    containing the serialized XML representation of an SVG file.

    By default, the widget provides a size hint to reflect the size of the
    drawing that it displays. If no data has been loaded, the widget provides
    the default **QWidget**  size hint. Subclass this class and reimplement
    **sizeHint** () if you need to customize this behavior.

    **See also** **QSvgRenderer** , **Qt SVG C++ Classes** , and **QPicture** .
    """

    @overload
    def __init__(
        self, file: str, parent: Optional[PySide6.QtWidgets.QWidget] = ...
    ) -> None:
        """
        https://doc.qt.io/qt-6/qsvgwidget.html#QSvgWidget

        **QSvgWidget::QSvgWidget(QWidget * parent = nullptr)**

        Constructs a new SVG display widget with the given **parent**.
        """
        ...

    @overload
    def __init__(self, parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qsvgwidget.html#QSvgWidget-1

        **QSvgWidget::QSvgWidget(const QString & file , QWidget * parent =
        nullptr)**

        Constructs a new SVG display widget with the given **parent** and loads
        the contents of the specified **file**.
        """
        ...

    @overload
    def load(self, contents: Union[PySide6.QtCore.QByteArray, bytes]) -> None:
        """
        https://doc.qt.io/qt-6/qsvgwidget.html#load

        **[slot] void QSvgWidget::load(const QString & file )**

        Loads the contents of the specified SVG **file** and updates the widget.
        """
        ...

    @overload
    def load(self, file: str) -> None:
        """
        https://doc.qt.io/qt-6/qsvgwidget.html#load-1

        **[slot] void QSvgWidget::load(const QByteArray & contents )**

        Loads the specified SVG format **contents** and updates the widget.
        """
        ...

    def paintEvent(self, event: PySide6.QtGui.QPaintEvent) -> None:
        """
        https://doc.qt.io/qt-6/qsvgwidget.html#paintEvent

        **[override virtual protected] void QSvgWidget::paintEvent(QPaintEvent *
        event )**

        Reimplements: **QWidget::paintEvent** (QPaintEvent *event).
        """
        ...

    def renderer(self) -> PySide6.QtSvg.QSvgRenderer:
        """
        https://doc.qt.io/qt-6/qsvgwidget.html#renderer

        **QSvgRenderer *QSvgWidget::renderer() const**

        Returns the renderer used to display the contents of the widget.
        """
        ...

    def sizeHint(self) -> PySide6.QtCore.QSize:
        """
        https://doc.qt.io/qt-6/qsvgwidget.html#sizeHint

        **[override virtual] QSize QSvgWidget::sizeHint() const**

        Reimplements an access function for property: **QWidget::sizeHint** .
        """
        ...
