"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtSvg, except for defaults which are replaced by "...".
"""
from typing import Optional, Union, overload
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtSvg

bytes = str


class QSvgRenderer(PySide6.QtCore.QObject):
    """
    https://doc.qt.io/qt-6/qsvgrenderer.html

    **Detailed Description**

    Using QSvgRenderer, Scalable Vector Graphics (SVG) can be rendered onto any
    **QPaintDevice**  subclass, including **QWidget** , **QImage** , and
    QGLWidget.

    QSvgRenderer provides an API that supports basic features of SVG rendering,
    such as loading and rendering of static drawings, and more interactive
    features like animation. Since the rendering is performed using **QPainter**
    , SVG drawings can be rendered on any subclass of **QPaintDevice** .

    SVG drawings are either loaded when an QSvgRenderer is constructed, or
    loaded later using the **load** () functions. Data is either supplied
    directly as serialized XML, or indirectly using a file name. If a valid file
    has been loaded, either when the renderer is constructed or at some later
    time, **isValid** () returns true; otherwise it returns false. QSvgRenderer
    provides the **render** () slot to render the current document, or the
    current frame of an animated document, using a given painter.

    The **defaultSize** () function provides information about the amount of
    space that is required to render the currently loaded SVG file. This is
    useful for paint devices, such as **QWidget** , that often need to supply a
    size hint to their parent layout. The default size of a drawing may differ
    from its visible area, found using the **viewBox**  property.

    Animated SVG drawings are supported, and can be controlled with a simple
    collection of functions and properties:

    * The **animated** () function indicates whether a drawing contains
    animation information.
      * The **framesPerSecond**  property contains the
    rate at which the animation plays.

    Finally, the QSvgRenderer class provides the **repaintNeeded** () signal
    which is emitted whenever the rendering of the document needs to be updated.

    **See also** **QSvgWidget** , **Qt SVG C++ Classes** , **SVG Viewer
    Example** , and **QPicture** .
    """

    @overload
    def __init__(
        self,
        contents: PySide6.QtCore.QXmlStreamReader,
        parent: Optional[PySide6.QtCore.QObject] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qsvgrenderer.html#QSvgRenderer

        **QSvgRenderer::QSvgRenderer(QObject * parent = nullptr)**

        Constructs a new renderer with the given **parent**.
        """
        ...

    @overload
    def __init__(
        self,
        contents: Union[PySide6.QtCore.QByteArray, bytes],
        parent: Optional[PySide6.QtCore.QObject] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qsvgrenderer.html#QSvgRenderer-1

        **QSvgRenderer::QSvgRenderer(const QString & filename , QObject * parent
        = nullptr)**

        Constructs a new renderer with the given **parent** and loads the
        contents of the SVG file with the specified **filename**.
        """
        ...

    @overload
    def __init__(
        self, filename: str, parent: Optional[PySide6.QtCore.QObject] = ...
    ) -> None:
        """
        https://doc.qt.io/qt-6/qsvgrenderer.html#QSvgRenderer-2

        **QSvgRenderer::QSvgRenderer(const QByteArray & contents , QObject *
        parent = nullptr)**

        Constructs a new renderer with the given **parent** and loads the SVG
        data from the byte array specified by **contents**.
        """
        ...

    @overload
    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qsvgrenderer.html#QSvgRenderer-3

        **QSvgRenderer::QSvgRenderer(QXmlStreamReader * contents , QObject *
        parent = nullptr)**

        Constructs a new renderer with the given **parent** and loads the SVG
        data using the stream reader specified by **contents**.
        """
        ...

    def animated(self) -> bool:
        """
        https://doc.qt.io/qt-6/qsvgrenderer.html#animated

        **bool QSvgRenderer::animated() const**

        Returns true if the current document contains animated elements;
        otherwise returns false.

        **See also** **framesPerSecond** ().
        """
        ...

    def animationDuration(self) -> int:
        ...

    def aspectRatioMode(self) -> PySide6.QtCore.Qt.AspectRatioMode:
        """
        https://doc.qt.io/qt-6/qsvgrenderer.html#aspectRatioMode-prop

        **[since 5.15] aspectRatioMode : Qt::AspectRatioMode**

        how rendering adheres to the SVG view box aspect ratio

        The accepted modes are:

        * **Qt::IgnoreAspectRatio**  (the default): the aspect ratio is ignored
        and the rendering is stretched to the target bounds.
          *
        **Qt::KeepAspectRatio** : rendering is centered and scaled as large as
        possible within the target bounds while preserving aspect ratio.

        This property was introduced in Qt 5.15.

        **Access functions:**

        Qt::AspectRatioMode **aspectRatioMode** () const
        void
        **setAspectRatioMode** (Qt::AspectRatioMode **mode** )
        """
        ...

    def boundsOnElement(self, id: str) -> PySide6.QtCore.QRectF:
        """
        https://doc.qt.io/qt-6/qsvgrenderer.html#boundsOnElement

        **QRectF QSvgRenderer::boundsOnElement(const QString & id ) const**

        Returns bounding rectangle of the item with the given **id**. The
        transformation matrix of parent elements is not affecting the bounds of
        the element.

        **See also** **transformForElement** ().
        """
        ...

    def currentFrame(self) -> int:
        ...

    def defaultSize(self) -> PySide6.QtCore.QSize:
        """
        https://doc.qt.io/qt-6/qsvgrenderer.html#defaultSize

        **QSize QSvgRenderer::defaultSize() const**

        Returns the default size of the document contents.
        """
        ...

    def elementExists(self, id: str) -> bool:
        """
        https://doc.qt.io/qt-6/qsvgrenderer.html#elementExists

        **bool QSvgRenderer::elementExists(const QString & id ) const**

        Returns true if the element with the given **id** exists in the
        currently parsed SVG file and is a renderable element.

        Note: this method returns true only for elements that can be rendered.
        Which implies that elements that are considered part of the fill/stroke
        style properties, e.g. radialGradients even tough marked with "id"
        attributes will not be found by this method.
        """
        ...

    def framesPerSecond(self) -> int:
        """
        https://doc.qt.io/qt-6/qsvgrenderer.html#framesPerSecond-prop

        **framesPerSecond : int**

        This property holds the number of frames per second to be shown

        The number of frames per second is 0 if the current document is not
        animated.

        **Access functions:**

        int **framesPerSecond** () const
        void **setFramesPerSecond** (int
        **num** )

        **See also** **animated** ().
        """
        ...

    def isValid(self) -> bool:
        """
        https://doc.qt.io/qt-6/qsvgrenderer.html#isValid

        **bool QSvgRenderer::isValid() const**

        Returns true if there is a valid current document; otherwise returns
        false.
        """
        ...

    @overload
    def load(self, contents: PySide6.QtCore.QXmlStreamReader) -> bool:
        """
        https://doc.qt.io/qt-6/qsvgrenderer.html#load

        **[slot] bool QSvgRenderer::load(const QString & filename )**

        Loads the SVG file specified by **filename** , returning true if the
        content was successfully parsed; otherwise returns false.
        """
        ...

    @overload
    def load(self, contents: Union[PySide6.QtCore.QByteArray, bytes]) -> bool:
        """
        https://doc.qt.io/qt-6/qsvgrenderer.html#load-1

        **[slot] bool QSvgRenderer::load(const QByteArray & contents )**

        Loads the specified SVG format **contents** , returning true if the
        content was successfully parsed; otherwise returns false.
        """
        ...

    @overload
    def load(self, filename: str) -> bool:
        """
        https://doc.qt.io/qt-6/qsvgrenderer.html#load-2

        **[slot] bool QSvgRenderer::load(QXmlStreamReader * contents )**

        Loads the specified SVG in **contents** , returning true if the content
        was successfully parsed; otherwise returns false.

        The reader will be used from where it currently is positioned. If
        **contents** is `null`, behavior is undefined.
        """
        ...

    @overload
    def render(self, p: PySide6.QtGui.QPainter) -> None:
        """
        https://doc.qt.io/qt-6/qsvgrenderer.html#render

        **[slot] void QSvgRenderer::render(QPainter * painter )**

        Renders the current document, or the current frame of an animated
        document, using the given **painter**.
        """
        ...

    @overload
    def render(
        self,
        p: PySide6.QtGui.QPainter,
        bounds: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qsvgrenderer.html#render-1

        **[slot] void QSvgRenderer::render(QPainter * painter , const QRectF &
        bounds )**

        Renders the current document, or the current frame of an animated
        document, using the given **painter** on the specified **bounds** within
        the painter. If **bounds** is not empty, the output will be scaled to
        fill it, ignoring any aspect ratio implied by the SVG.
        """
        ...

    @overload
    def render(
        self,
        p: PySide6.QtGui.QPainter,
        elementId: str,
        bounds: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qsvgrenderer.html#render-2

        **[slot] void QSvgRenderer::render(QPainter * painter , const QString &
        elementId , const QRectF & bounds = QRectF())**

        Renders the given element with **elementId** using the given **painter**
        on the specified **bounds**. If the bounding rectangle is not specified
        the SVG element is mapped to the whole paint device.
        """
        ...

    def setAspectRatioMode(self, mode: PySide6.QtCore.Qt.AspectRatioMode) -> None:
        """
        https://doc.qt.io/qt-6/qsvgrenderer.html#aspectRatioMode-prop

        **[since 5.15] aspectRatioMode : Qt::AspectRatioMode**

        how rendering adheres to the SVG view box aspect ratio

        The accepted modes are:

        * **Qt::IgnoreAspectRatio**  (the default): the aspect ratio is ignored
        and the rendering is stretched to the target bounds.
          *
        **Qt::KeepAspectRatio** : rendering is centered and scaled as large as
        possible within the target bounds while preserving aspect ratio.

        This property was introduced in Qt 5.15.

        **Access functions:**

        Qt::AspectRatioMode **aspectRatioMode** () const
        void
        **setAspectRatioMode** (Qt::AspectRatioMode **mode** )
        """
        ...

    def setCurrentFrame(self, arg__1: int) -> None:
        ...

    def setFramesPerSecond(self, num: int) -> None:
        """
        https://doc.qt.io/qt-6/qsvgrenderer.html#framesPerSecond-prop

        **framesPerSecond : int**

        This property holds the number of frames per second to be shown

        The number of frames per second is 0 if the current document is not
        animated.

        **Access functions:**

        int **framesPerSecond** () const
        void **setFramesPerSecond** (int
        **num** )

        **See also** **animated** ().
        """
        ...

    @overload
    def setViewBox(self, viewbox: PySide6.QtCore.QRect) -> None:
        """
        https://doc.qt.io/qt-6/qsvgrenderer.html#viewBox

        **QRect QSvgRenderer::viewBox() const**

        Returns **viewBoxF** ().toRect().

        **See also** **setViewBox** () and **viewBoxF** ().
        """
        ...

    @overload
    def setViewBox(
        self, viewbox: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qsvgrenderer.html#viewBox-prop

        **viewBox : QRectF**

        This property holds the rectangle specifying the visible area of the
        document in logical coordinates

        **Access functions:**

        QRectF **viewBoxF** () const
        void **setViewBox** (const QRect &
        **viewbox** )
        void **setViewBox** (const QRectF & **viewbox** )

        **Member Function Documentation**
        """
        ...

    def transformForElement(self, id: str) -> PySide6.QtGui.QTransform:
        """
        https://doc.qt.io/qt-6/qsvgrenderer.html#transformForElement

        **[since 5.15] QTransform QSvgRenderer::transformForElement(const
        QString & id ) const**

        Returns the transformation matrix for the element with the given **id**.
        The matrix is a product of the transformation of the element's parents.
        The transformation of the element itself is not included.

        To find the bounding rectangle of the element in logical coordinates,
        you can apply the matrix on the rectangle returned from
        **boundsOnElement** ().

        This function was introduced in Qt 5.15.

        **See also** **boundsOnElement** ().
        """
        ...

    def viewBox(self) -> PySide6.QtCore.QRect:
        """
        https://doc.qt.io/qt-6/qsvgrenderer.html#viewBox

        **QRect QSvgRenderer::viewBox() const**

        Returns **viewBoxF** ().toRect().

        **See also** **setViewBox** () and **viewBoxF** ().
        """
        ...

    def viewBoxF(self) -> PySide6.QtCore.QRectF:
        ...

    @property
    def repaintNeeded(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qsvgrenderer.html#repaintNeeded

        **[signal] void QSvgRenderer::repaintNeeded()**

        This signal is emitted whenever the rendering of the document needs to
        be updated, usually for the purposes of animation.
        """
        ...
