"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtStateMachine, except for defaults which are replaced by "...".
"""
from typing import Optional, overload
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtStateMachine

bytes = str


class QMouseEventTransition(PySide6.QtStateMachine.QEventTransition):
    """
    https://doc.qt.io/qt-6/qmouseeventtransition.html

    **Detailed Description**

    QMouseEventTransition is part of **Qt State Machine Framework** .

    **See also** **QState::addTransition** ().
    """

    @overload
    def __init__(
        self,
        object: PySide6.QtCore.QObject,
        type: PySide6.QtCore.QEvent.Type,
        button: PySide6.QtCore.Qt.MouseButton,
        sourceState: Optional[PySide6.QtStateMachine.QState] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qmouseeventtransition.html#QMouseEventTransition

        **QMouseEventTransition::QMouseEventTransition(QState * sourceState =
        nullptr)**

        Constructs a new mouse event transition with the given **sourceState**.
        """
        ...

    @overload
    def __init__(
        self, sourceState: Optional[PySide6.QtStateMachine.QState] = ...
    ) -> None:
        """
        https://doc.qt.io/qt-6/qmouseeventtransition.html#QMouseEventTransition-
        1

        **QMouseEventTransition::QMouseEventTransition(QObject * object ,
        QEvent::Type type , Qt::MouseButton button , QState * sourceState =
        nullptr)**

        Constructs a new mouse event transition for events of the given **type**
        for the given **object** , with the given **button** and
        **sourceState**.
        """
        ...

    def button(self) -> PySide6.QtCore.Qt.MouseButton:
        """
        https://doc.qt.io/qt-6/qmouseeventtransition.html#button

        **Qt::MouseButton QMouseEventTransition::button() const**

        Returns the button that this mouse event transition checks for.

        **Note:** Getter function for property button.

        **See also** **setButton** ().
        """
        ...

    def eventTest(self, event: PySide6.QtCore.QEvent) -> bool:
        """
        https://doc.qt.io/qt-6/qmouseeventtransition.html#eventTest

        **[override virtual protected] bool
        QMouseEventTransition::eventTest(QEvent * event )**

        Reimplements: **QEventTransition::eventTest** (QEvent *event).
        """
        ...

    def hitTestPath(self) -> PySide6.QtGui.QPainterPath:
        """
        https://doc.qt.io/qt-6/qmouseeventtransition.html#hitTestPath

        **QPainterPath QMouseEventTransition::hitTestPath() const**

        Returns the hit test path for this mouse event transition.

        **See also** **setHitTestPath** ().
        """
        ...

    def modifierMask(self) -> PySide6.QtCore.Qt.KeyboardModifiers:
        """
        https://doc.qt.io/qt-6/qmouseeventtransition.html#modifierMask

        **Qt::KeyboardModifiers QMouseEventTransition::modifierMask() const**

        Returns the keyboard modifier mask that this mouse event transition
        checks for.

        **Note:** Getter function for property modifierMask.

        **See also** **setModifierMask** ().
        """
        ...

    def onTransition(self, event: PySide6.QtCore.QEvent) -> None:
        """
        https://doc.qt.io/qt-6/qmouseeventtransition.html#onTransition

        **[override virtual protected] void
        QMouseEventTransition::onTransition(QEvent * event )**

        Reimplements: **QEventTransition::onTransition** (QEvent *event).
        """
        ...

    def setButton(self, button: PySide6.QtCore.Qt.MouseButton) -> None:
        """
        https://doc.qt.io/qt-6/qmouseeventtransition.html#setButton

        **void QMouseEventTransition::setButton(Qt::MouseButton button )**

        Sets the **button** that this mouse event transition will check for.

        **Note:** Setter function for property **button** .

        **See also** **button** ().
        """
        ...

    def setHitTestPath(self, path: PySide6.QtGui.QPainterPath) -> None:
        """
        https://doc.qt.io/qt-6/qmouseeventtransition.html#setHitTestPath

        **void QMouseEventTransition::setHitTestPath(const QPainterPath & path
        )**

        Sets the hit test path for this mouse event transition to **path**. If a
        valid path has been set, the transition will only trigger if the mouse
        event position (**QMouseEvent::pos** ()) is inside the path.

        **See also** **hitTestPath** () and **QPainterPath::contains** ().
        """
        ...

    def setModifierMask(self, modifiers: PySide6.QtCore.Qt.KeyboardModifiers) -> None:
        """
        https://doc.qt.io/qt-6/qmouseeventtransition.html#setModifierMask

        **void QMouseEventTransition::setModifierMask(Qt::KeyboardModifiers
        modifierMask )**

        Sets the keyboard modifier mask that this mouse event transition will
        check for to **modifierMask**.

        **Note:** Setter function for property **modifierMask** .

        **See also** **modifierMask** ().
        """
        ...
