"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtStateMachine, except for defaults which are replaced by "...".
"""
from typing import Optional, overload
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtStateMachine

bytes = str


class QKeyEventTransition(PySide6.QtStateMachine.QEventTransition):
    """
    https://doc.qt.io/qt-6/qkeyeventtransition.html

    **Detailed Description**

    QKeyEventTransition is part of **Qt State Machine Framework** .

    **See also** **QState::addTransition** ().
    """

    @overload
    def __init__(
        self,
        object: PySide6.QtCore.QObject,
        type: PySide6.QtCore.QEvent.Type,
        key: int,
        sourceState: Optional[PySide6.QtStateMachine.QState] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qkeyeventtransition.html#QKeyEventTransition

        **QKeyEventTransition::QKeyEventTransition(QState * sourceState =
        nullptr)**

        Constructs a new key event transition with the given **sourceState**.
        """
        ...

    @overload
    def __init__(
        self, sourceState: Optional[PySide6.QtStateMachine.QState] = ...
    ) -> None:
        """
        https://doc.qt.io/qt-6/qkeyeventtransition.html#QKeyEventTransition-1

        **QKeyEventTransition::QKeyEventTransition(QObject * object ,
        QEvent::Type type , int key , QState * sourceState = nullptr)**

        Constructs a new key event transition for events of the given **type**
        for the given **object** , with the given **key** and **sourceState**.
        """
        ...

    def eventTest(self, event: PySide6.QtCore.QEvent) -> bool:
        """
        https://doc.qt.io/qt-6/qkeyeventtransition.html#eventTest

        **[override virtual protected] bool
        QKeyEventTransition::eventTest(QEvent * event )**

        Reimplements: **QEventTransition::eventTest** (QEvent *event).
        """
        ...

    def key(self) -> int:
        """
        https://doc.qt.io/qt-6/qkeyeventtransition.html#key

        **int QKeyEventTransition::key() const**

        Returns the key that this key event transition checks for.

        **Note:** Getter function for property key.

        **See also** **setKey** ().
        """
        ...

    def modifierMask(self) -> PySide6.QtCore.Qt.KeyboardModifiers:
        """
        https://doc.qt.io/qt-6/qkeyeventtransition.html#modifierMask

        **Qt::KeyboardModifiers QKeyEventTransition::modifierMask() const**

        Returns the keyboard modifier mask that this key event transition checks
        for.

        **Note:** Getter function for property modifierMask.

        **See also** **setModifierMask** ().
        """
        ...

    def onTransition(self, event: PySide6.QtCore.QEvent) -> None:
        """
        https://doc.qt.io/qt-6/qkeyeventtransition.html#onTransition

        **[override virtual protected] void
        QKeyEventTransition::onTransition(QEvent * event )**

        Reimplements: **QEventTransition::onTransition** (QEvent *event).
        """
        ...

    def setKey(self, key: int) -> None:
        """
        https://doc.qt.io/qt-6/qkeyeventtransition.html#setKey

        **void QKeyEventTransition::setKey(int key )**

        Sets the **key** that this key event transition will check for.

        **Note:** Setter function for property **key** .

        **See also** **key** ().
        """
        ...

    def setModifierMask(self, modifiers: PySide6.QtCore.Qt.KeyboardModifiers) -> None:
        """
        https://doc.qt.io/qt-6/qkeyeventtransition.html#setModifierMask

        **void QKeyEventTransition::setModifierMask(Qt::KeyboardModifiers
        modifierMask )**

        Sets the keyboard modifier mask that this key event transition will
        check for to **modifierMask**.

        **Note:** Setter function for property **modifierMask** .

        **See also** **modifierMask** ().
        """
        ...
