"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtStateMachine, except for defaults which are replaced by "...".
"""
from typing import Optional
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtStateMachine

bytes = str


class QFinalState(PySide6.QtStateMachine.QAbstractState):
    """
    https://doc.qt.io/qt-6/qfinalstate.html

    **Detailed Description**

    A final state is used to communicate that (part of) a **QStateMachine**  has
    finished its work. When a final top-level state is entered, the state
    machine's **finished** () signal is emitted. In general, when a final
    substate (a child of a **QState** ) is entered, the parent state's
    **finished** () signal is emitted. QFinalState is part of **Qt State Machine
    Framework** .

    To use a final state, you create a QFinalState object and add a transition
    to it from another state. Example:

    **QPushButton**  button;

        **QStateMachine**  machine;
        **QState**
    *s1 = new **QState** ();
        **QFinalState**  *s2 = new **QFinalState** ();
    s1->addTransition(&button, SIGNAL(clicked()), s2);
        machine.addState(s1);
    machine.addState(s2);

        **QObject** ::connect(&machine,
    SIGNAL(finished()), **QApplication** ::instance(), SLOT(quit()));
    machine.setInitialState(s1);
        machine.start();

    **See also** **QState::finished** ().
    """

    def __init__(self, parent: Optional[PySide6.QtStateMachine.QState] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qfinalstate.html#QFinalState

        **QFinalState::QFinalState(QState * parent = nullptr)**

        Constructs a new QFinalState object with the given **parent** state.
        """
        ...

    def event(self, e: PySide6.QtCore.QEvent) -> bool:
        """
        https://doc.qt.io/qt-6/qfinalstate.html#event

        **[override virtual protected] bool QFinalState::event(QEvent * e )**

        Reimplements: **QAbstractState::event** (QEvent *e).
        """
        ...

    def onEntry(self, event: PySide6.QtCore.QEvent) -> None:
        """
        https://doc.qt.io/qt-6/qfinalstate.html#onEntry

        **[override virtual protected] void QFinalState::onEntry(QEvent * event
        )**

        Reimplements: **QAbstractState::onEntry** (QEvent *event).
        """
        ...

    def onExit(self, event: PySide6.QtCore.QEvent) -> None:
        """
        https://doc.qt.io/qt-6/qfinalstate.html#onExit

        **[override virtual protected] void QFinalState::onExit(QEvent * event
        )**

        Reimplements: **QAbstractState::onExit** (QEvent *event).
        """
        ...
