"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtSql, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import Any, Optional, Union, overload
import PySide6.QtCore
import PySide6.QtWidgets
import PySide6.QtSql

bytes = str


class QSqlTableModel(PySide6.QtSql.QSqlQueryModel):
    """
    https://doc.qt.io/qt-6/qsqltablemodel.html

    **Detailed Description**

    QSqlTableModel is a high-level interface for reading and writing database
    records from a single table. It is built on top of the lower-level
    **QSqlQuery**  and can be used to provide data to view classes such as
    **QTableView** . For example:

    **QSqlTableModel**  *model = new **QSqlTableModel** ;
    model->setTable("employee");
    model->setEditStrategy(**QSqlTableModel** ::OnManualSubmit);
    model->select();
            model->setHeaderData(0, Qt::Horizontal,
    tr("Name"));
            model->setHeaderData(1, Qt::Horizontal, tr("Salary"));
    **QTableView**  *view = new **QTableView** ;
            view->setModel(model);
    view->hideColumn(0); // don't show the ID
            view->show();

    We set the SQL table's name and the edit strategy, then we set up the labels
    displayed in the view header. The edit strategy dictates when the changes
    done by the user in the view are actually applied to the database. The
    possible values are **OnFieldChange** , **OnRowChange** , and
    **OnManualSubmit** .

    QSqlTableModel can also be used to access a database programmatically,
    without binding it to a view:

    **QSqlTableModel**  model;
            model.setTable("employee");
    model.select();
            int salary =
    model.record(4).value("salary").toInt();

    The code snippet above extracts the `salary` field from record 4 in the
    result set of the query `SELECT * from employee`.

    It is possible to set filters using **setFilter** (), or modify the sort
    order using **setSort** (). At the end, you must call **select** () to
    populate the model with data.

    The **tablemodel**  example illustrates how to use QSqlTableModel as the
    data source for a **QTableView** .

    QSqlTableModel provides no direct support for foreign keys. Use the
    **QSqlRelationalTableModel**  and **QSqlRelationalDelegate**  if you want to
    resolve foreign keys.

    **See also** **QSqlRelationalTableModel** , **QSqlQuery** , **Model/View
    Programming** , **Table Model Example** , and **Cached Table Example** .
    """

    OnFieldChange: QSqlTableModel.EditStrategy = ...
    OnRowChange: QSqlTableModel.EditStrategy = ...
    OnManualSubmit: QSqlTableModel.EditStrategy = ...

    class EditStrategy(Enum):
        OnFieldChange: QSqlTableModel.EditStrategy = ...
        OnRowChange: QSqlTableModel.EditStrategy = ...
        OnManualSubmit: QSqlTableModel.EditStrategy = ...

    def __init__(
        self,
        parent: Optional[PySide6.QtCore.QObject] = ...,
        db: PySide6.QtSql.QSqlDatabase = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qsqltablemodel.html#QSqlTableModel

        **QSqlTableModel::QSqlTableModel(QObject * parent = nullptr, const
        QSqlDatabase & db = QSqlDatabase())**

        Creates an empty QSqlTableModel and sets the parent to **parent** and
        the database connection to **db**. If **db** is not valid, the default
        database connection will be used.

        The default edit strategy is **OnRowChange** .
        """
        ...

    def clear(self) -> None:
        """
        https://doc.qt.io/qt-6/qsqltablemodel.html#clear

        **[override virtual] void QSqlTableModel::clear()**

        Reimplements: **QSqlQueryModel::clear** ().
        """
        ...

    def clearItemData(
        self,
        index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex],
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qsqltablemodel.html#clearItemData

        **[override virtual] bool QSqlTableModel::clearItemData(const
        QModelIndex & index )**

        Reimplements: **QAbstractItemModel::clearItemData** (const QModelIndex
        &index).
        """
        ...

    def data(
        self,
        idx: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex],
        role: int = ...,
    ) -> Any:
        """
        https://doc.qt.io/qt-6/qsqltablemodel.html#data

        **[override virtual] QVariant QSqlTableModel::data(const QModelIndex &
        index , int role = Qt::DisplayRole) const**

        Reimplements: **QSqlQueryModel::data(const QModelIndex &item, int role)
        const** .

        **See also** **setData** ().
        """
        ...

    def database(self) -> PySide6.QtSql.QSqlDatabase:
        """
        https://doc.qt.io/qt-6/qsqltablemodel.html#database

        **QSqlDatabase QSqlTableModel::database() const**

        Returns the model's database connection.
        """
        ...

    def deleteRowFromTable(self, row: int) -> bool:
        """
        https://doc.qt.io/qt-6/qsqltablemodel.html#deleteRowFromTable

        **[virtual protected] bool QSqlTableModel::deleteRowFromTable(int row
        )**

        Deletes the given **row** from the currently active database table.

        This is a low-level method that operates directly on the database and
        should not be called directly. Use **removeRow** () or **removeRows** ()
        to delete values. The model will decide depending on its edit strategy
        when to modify the database.

        Returns `true` if the row was deleted; otherwise returns `false`.

        **See also** **removeRow** () and **removeRows** ().
        """
        ...

    def editStrategy(self) -> PySide6.QtSql.QSqlTableModel.EditStrategy:
        """
        https://doc.qt.io/qt-6/qsqltablemodel.html#editStrategy

        **QSqlTableModel::EditStrategy QSqlTableModel::editStrategy() const**

        Returns the current edit strategy.

        **See also** **setEditStrategy** ().
        """
        ...

    def fieldIndex(self, fieldName: str) -> int:
        """
        https://doc.qt.io/qt-6/qsqltablemodel.html#fieldIndex

        **int QSqlTableModel::fieldIndex(const QString & fieldName ) const**

        Returns the index of the field **fieldName** , or -1 if no corresponding
        field exists in the model.
        """
        ...

    def filter(self) -> str:
        """
        https://doc.qt.io/qt-6/qsqltablemodel.html#filter

        **QString QSqlTableModel::filter() const**

        Returns the currently set filter.

        **See also** **setFilter** () and **select** ().
        """
        ...

    def flags(
        self,
        index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex],
    ) -> PySide6.QtCore.Qt.ItemFlags:
        """
        https://doc.qt.io/qt-6/qsqltablemodel.html#flags

        **[override virtual] Qt::ItemFlags QSqlTableModel::flags(const
        QModelIndex & index ) const**

        Reimplements: **QAbstractTableModel::flags(const QModelIndex &index)
        const** .
        """
        ...

    def headerData(
        self, section: int, orientation: PySide6.QtCore.Qt.Orientation, role: int = ...
    ) -> Any:
        """
        https://doc.qt.io/qt-6/qsqltablemodel.html#headerData

        **[override virtual] QVariant QSqlTableModel::headerData(int section ,
        Qt::Orientation orientation , int role = Qt::DisplayRole) const**

        Reimplements: **QSqlQueryModel::headerData(int section, Qt::Orientation
        orientation, int role) const** .
        """
        ...

    def indexInQuery(
        self,
        item: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex],
    ) -> PySide6.QtCore.QModelIndex:
        """
        https://doc.qt.io/qt-6/qsqltablemodel.html#indexInQuery

        **[override virtual protected] QModelIndex
        QSqlTableModel::indexInQuery(const QModelIndex & item ) const**

        Reimplements: **QSqlQueryModel::indexInQuery(const QModelIndex &item)
        const** .

        Returns the index of the value in the database result set for the given
        **item** in the model.

        The return value is identical to **item** if no columns or rows have
        been inserted, removed, or moved around.

        Returns an invalid model index if **item** is out of bounds or if
        **item** does not point to a value in the result set.

        **See also** **QSqlQueryModel::indexInQuery** ().
        """
        ...

    def insertRecord(self, row: int, record: PySide6.QtSql.QSqlRecord) -> bool:
        """
        https://doc.qt.io/qt-6/qsqltablemodel.html#insertRecord

        **bool QSqlTableModel::insertRecord(int row , const QSqlRecord & record
        )**

        Inserts the **record** at position **row**. If **row** is negative, the
        record will be appended to the end. Calls **insertRows** () and
        **setRecord** () internally.

        Returns `true` if the record could be inserted, otherwise false.

        Changes are submitted immediately for **OnFieldChange**  and
        **OnRowChange** . Failure does not leave a new row in the model.

        **See also** **insertRows** (), **removeRows** (), and **setRecord** ().
        """
        ...

    def insertRowIntoTable(self, values: PySide6.QtSql.QSqlRecord) -> bool:
        """
        https://doc.qt.io/qt-6/qsqltablemodel.html#insertRowIntoTable

        **[virtual protected] bool QSqlTableModel::insertRowIntoTable(const
        QSqlRecord & values )**

        Inserts the values **values** into the currently active database table.

        This is a low-level method that operates directly on the database and
        should not be called directly. Use **insertRow** () and **setData** ()
        to insert values. The model will decide depending on its edit strategy
        when to modify the database.

        Returns `true` if the values could be inserted, otherwise false. Error
        information can be retrieved with **lastError** ().

        **See also** **lastError** (), **insertRow** (), and **insertRows** ().
        """
        ...

    def insertRows(
        self,
        row: int,
        count: int,
        parent: Union[
            PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex
        ] = ...,
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qsqltablemodel.html#insertRows

        **[override virtual] bool QSqlTableModel::insertRows(int row , int count
        , const QModelIndex & parent = QModelIndex())**

        Reimplements: **QAbstractItemModel::insertRows** (int row, int count,
        const QModelIndex &parent).

        Inserts **count** empty rows at position **row**. Note that **parent**
        must be invalid, since this model does not support parent-child
        relations.

        For edit strategies **OnFieldChange**  and **OnRowChange** , only one
        row may be inserted at a time and the model may not contain other cached
        changes.

        The **primeInsert** () signal will be emitted for each new row. Connect
        to it if you want to initialize the new row with default values.

        Does not submit rows, regardless of edit strategy.

        Returns `false` if the parameters are out of bounds or the row cannot be
        inserted; otherwise returns `true`.

        **See also** **primeInsert** () and **insertRecord** ().
        """
        ...

    @overload
    def isDirty(self) -> bool:
        """
        https://doc.qt.io/qt-6/qsqltablemodel.html#isDirty

        **bool QSqlTableModel::isDirty(const QModelIndex & index ) const**

        Returns `true` if the value at the index **index** is dirty, otherwise
        false. Dirty values are values that were modified in the model but not
        yet written into the database.

        If **index** is invalid or points to a non-existing row, false is
        returned.
        """
        ...

    @overload
    def isDirty(
        self,
        index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex],
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qsqltablemodel.html#isDirty-1

        **[since 5.0] bool QSqlTableModel::isDirty() const**

        This is an overloaded function.

        Returns `true` if the model contains modified values that have not been
        committed to the database, otherwise false.

        This function was introduced in Qt 5.0.
        """
        ...

    def orderByClause(self) -> str:
        """
        https://doc.qt.io/qt-6/qsqltablemodel.html#orderByClause

        **[virtual protected] QString QSqlTableModel::orderByClause() const**

        Returns an SQL `ORDER BY` clause based on the currently set sort order.

        **See also** **setSort** () and **selectStatement** ().
        """
        ...

    def primaryKey(self) -> PySide6.QtSql.QSqlIndex:
        """
        https://doc.qt.io/qt-6/qsqltablemodel.html#primaryKey

        **QSqlIndex QSqlTableModel::primaryKey() const**

        Returns the primary key for the current table, or an empty **QSqlIndex**
        if the table is not set or has no primary key.

        **See also** **setTable** (), **setPrimaryKey** (), and
        **QSqlDatabase::primaryIndex** ().
        """
        ...

    def primaryValues(self, row: int) -> PySide6.QtSql.QSqlRecord:
        """
        https://doc.qt.io/qt-6/qsqltablemodel.html#primaryValues

        **[protected, since 5.1] QSqlRecord QSqlTableModel::primaryValues(int
        row ) const**

        Returns a record containing the fields represented in the primary key
        set to the values at **row**. If no primary key is defined, the returned
        record will contain all fields.

        This function was introduced in Qt 5.1.

        **See also** **primaryKey** ().
        """
        ...

    @overload
    def record(self) -> PySide6.QtSql.QSqlRecord:
        """
        https://doc.qt.io/qt-6/qsqltablemodel.html#record

        **QSqlRecord QSqlTableModel::record() const**

        This is an overloaded function.

        It returns an empty record, having only the field names. This function
        can be used to retrieve the field names of a record.

        **See also** **setRecord** () and **QSqlRecord::isEmpty** ().
        """
        ...

    @overload
    def record(self, row: int) -> PySide6.QtSql.QSqlRecord:
        """
        https://doc.qt.io/qt-6/qsqltablemodel.html#record-1

        **[since 5.0] QSqlRecord QSqlTableModel::record(int row ) const**

        Returns the record at **row** in the model.

        If **row** is the index of a valid row, the record will be populated
        with values from that row.

        If the model is not initialized, an empty record will be returned.

        This function was introduced in Qt 5.0.

        **See also** **QSqlRecord::isEmpty** ().
        """
        ...

    def removeColumns(
        self,
        column: int,
        count: int,
        parent: Union[
            PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex
        ] = ...,
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qsqltablemodel.html#removeColumns

        **[override virtual] bool QSqlTableModel::removeColumns(int column , int
        count , const QModelIndex & parent = QModelIndex())**

        Reimplements: **QSqlQueryModel::removeColumns** (int column, int count,
        const QModelIndex &parent).

        Removes **count** columns from the **parent** model, starting at index
        **column**.

        Returns if the columns were successfully removed; otherwise returns
        `false`.

        **See also** **removeRows** ().
        """
        ...

    def removeRows(
        self,
        row: int,
        count: int,
        parent: Union[
            PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex
        ] = ...,
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qsqltablemodel.html#removeRows

        **[override virtual] bool QSqlTableModel::removeRows(int row , int count
        , const QModelIndex & parent = QModelIndex())**

        Reimplements: **QAbstractItemModel::removeRows** (int row, int count,
        const QModelIndex &parent).

        Removes **count** rows starting at **row**. Since this model does not
        support hierarchical structures, **parent** must be an invalid model
        index.

        When the edit strategy is **OnManualSubmit** , deletion of rows from the
        database is delayed until **submitAll** () is called.

        For **OnFieldChange**  and **OnRowChange** , only one row may be deleted
        at a time and only if no other row has a cached change. Deletions are
        submitted immediately to the database. The model retains a blank row for
        successfully deleted row until refreshed with **select** ().

        After failed deletion, the operation is not reverted in the model. The
        application may resubmit or revert.

        Inserted but not yet successfully submitted rows in the range to be
        removed are immediately removed from the model.

        Before a row is deleted from the database, the **beforeDelete** ()
        signal is emitted.

        If row < 0 or row + count > **rowCount** (), no action is taken and
        false is returned. Returns `true` if all rows could be removed;
        otherwise returns `false`. Detailed database error information can be
        retrieved using **lastError** ().

        **See also** **removeColumns** () and **insertRows** ().
        """
        ...

    def revert(self) -> None:
        """
        https://doc.qt.io/qt-6/qsqltablemodel.html#revert

        **[override virtual slot] void QSqlTableModel::revert()**

        Reimplements: **QAbstractItemModel::revert** ().

        This reimplemented slot is called by the item delegates when the user
        canceled editing the current row.

        Reverts the changes if the model's strategy is set to **OnRowChange**
        or **OnFieldChange** . Does nothing for the **OnManualSubmit**
        strategy.

        Use **revertAll** () to revert all pending changes for the
        **OnManualSubmit**  strategy or **revertRow** () to revert a specific
        row.

        **See also** **submit** (), **submitAll** (), **revertRow** (), and
        **revertAll** ().
        """
        ...

    def revertAll(self) -> None:
        """
        https://doc.qt.io/qt-6/qsqltablemodel.html#revertAll

        **[slot] void QSqlTableModel::revertAll()**

        Reverts all pending changes.

        **See also** **revert** (), **revertRow** (), and **submitAll** ().
        """
        ...

    def revertRow(self, row: int) -> None:
        """
        https://doc.qt.io/qt-6/qsqltablemodel.html#revertRow

        **[virtual] void QSqlTableModel::revertRow(int row )**

        Reverts all changes for the specified **row**.

        **See also** **revert** (), **revertAll** (), **submit** (), and
        **submitAll** ().
        """
        ...

    def rowCount(
        self,
        parent: Union[
            PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex
        ] = ...,
    ) -> int:
        """
        https://doc.qt.io/qt-6/qsqltablemodel.html#rowCount

        **[override virtual] int QSqlTableModel::rowCount(const QModelIndex &
        parent = QModelIndex()) const**

        Reimplements: **QSqlQueryModel::rowCount(const QModelIndex &parent)
        const** .
        """
        ...

    def select(self) -> bool:
        """
        https://doc.qt.io/qt-6/qsqltablemodel.html#select

        **[virtual slot] bool QSqlTableModel::select()**

        Populates the model with data from the table that was set via
        **setTable** (), using the specified filter and sort condition, and
        returns `true` if successful; otherwise returns `false`.

        **Note:** Calling select() will revert any unsubmitted changes and
        remove any inserted columns.

        **See also** **setTable** (), **setFilter** (), and **selectStatement**
        ().
        """
        ...

    def selectRow(self, row: int) -> bool:
        """
        https://doc.qt.io/qt-6/qsqltablemodel.html#selectRow

        **[virtual slot, since 5.0] bool QSqlTableModel::selectRow(int row )**

        Refreshes **row** in the model with values from the database table row
        matching on primary key values. Without a primary key, all column values
        must match. If no matching row is found, the model will show an empty
        row.

        Returns `true` if successful; otherwise returns `false`.

        This function was introduced in Qt 5.0.

        **See also** **select** ().
        """
        ...

    def selectStatement(self) -> str:
        """
        https://doc.qt.io/qt-6/qsqltablemodel.html#selectStatement

        **[virtual protected] QString QSqlTableModel::selectStatement() const**

        Returns the SQL `SELECT` statement used internally to populate the
        model. The statement includes the filter and the `ORDER BY` clause.

        **See also** **filter** () and **orderByClause** ().
        """
        ...

    def setData(
        self,
        index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex],
        value: Any,
        role: int = ...,
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qsqltablemodel.html#setData

        **[override virtual] bool QSqlTableModel::setData(const QModelIndex &
        index , const QVariant & value , int role = Qt::EditRole)**

        Reimplements: **QAbstractItemModel::setData** (const QModelIndex &index,
        const QVariant &value, int role).

        Sets the data for the item **index** for the role **role** to **value**.

        For edit strategy **OnFieldChange** , an index may receive a change only
        if no other index has a cached change. Changes are submitted
        immediately. However, rows that have not yet been inserted in the
        database may be freely changed and are not submitted automatically.
        Submitted changes are not reverted upon failure.

        For **OnRowChange** , an index may receive a change only if no other row
        has a cached change. Changes are not submitted automatically.

        Returns `true` if **value** is equal to the current value. However, the
        value will not be submitted to the database.

        Returns `true` if the value could be set or false on error, for example
        if **index** is out of bounds.

        Returns `false` if the role is not **Qt::EditRole** . To set data for
        roles other than EditRole, either use a custom proxy model or subclass
        **QSqlTableModel** .

        **See also** **editStrategy** (), **data** (), **submit** (),
        **submitAll** (), and **revertRow** ().
        """
        ...

    def setEditStrategy(
        self, strategy: PySide6.QtSql.QSqlTableModel.EditStrategy
    ) -> None:
        """
        https://doc.qt.io/qt-6/qsqltablemodel.html#setEditStrategy

        **[virtual] void
        QSqlTableModel::setEditStrategy(QSqlTableModel::EditStrategy strategy
        )**

        Sets the strategy for editing values in the database to **strategy**.

        This will revert any pending changes.

        **See also** **editStrategy** () and **revertAll** ().
        """
        ...

    def setFilter(self, filter: str) -> None:
        """
        https://doc.qt.io/qt-6/qsqltablemodel.html#setFilter

        **[virtual] void QSqlTableModel::setFilter(const QString & filter )**

        Sets the current filter to **filter**.

        The filter is a SQL `WHERE` clause without the keyword `WHERE` (for
        example, `name='Josephine')`.

        If the model is already populated with data from a database, the model
        re-selects it with the new filter. Otherwise, the filter will be applied
        the next time **select** () is called.

        **See also** **filter** (), **select** (), **selectStatement** (), and
        **orderByClause** ().
        """
        ...

    def setPrimaryKey(self, key: PySide6.QtSql.QSqlIndex) -> None:
        """
        https://doc.qt.io/qt-6/qsqltablemodel.html#setPrimaryKey

        **[protected] void QSqlTableModel::setPrimaryKey(const QSqlIndex & key
        )**

        Protected method that allows subclasses to set the primary key to
        **key**.

        Normally, the primary index is set automatically whenever you call
        **setTable** ().

        **See also** **primaryKey** () and **QSqlDatabase::primaryIndex** ().
        """
        ...

    def setQuery(self, query: PySide6.QtSql.QSqlQuery) -> None:
        """
        https://doc.qt.io/qt-6/qsqltablemodel.html#setQuery

        **[protected] void QSqlTableModel::setQuery(const QSqlQuery & query )**

        This function simply calls **QSqlQueryModel::setQuery** ( **query** ).
        You should normally not call it on a **QSqlTableModel** . Instead, use
        **setTable** (), **setSort** (), **setFilter** (), etc., to set up the
        query.

        **See also** **selectStatement** ().
        """
        ...

    def setRecord(self, row: int, record: PySide6.QtSql.QSqlRecord) -> bool:
        """
        https://doc.qt.io/qt-6/qsqltablemodel.html#setRecord

        **bool QSqlTableModel::setRecord(int row , const QSqlRecord & values )**

        Applies **values** to the **row** in the model. The source and target
        fields are mapped by field name, not by position in the record.

        Note that the generated flags in **values** are preserved to determine
        whether the corresponding fields are used when changes are submitted to
        the database. By default, it is set to `true` for all fields in a
        **QSqlRecord** . You must set the flag to `false` using **setGenerated**
        (false) for any value in **values** , to save changes back to the
        database.

        For edit strategies **OnFieldChange**  and **OnRowChange** , a row may
        receive a change only if no other row has a cached change. Changes are
        submitted immediately. Submitted changes are not reverted upon failure.

        Returns `true` if all the values could be set; otherwise returns false.

        **See also** **record** () and **editStrategy** ().
        """
        ...

    def setSort(self, column: int, order: PySide6.QtCore.Qt.SortOrder) -> None:
        """
        https://doc.qt.io/qt-6/qsqltablemodel.html#setSort

        **[virtual] void QSqlTableModel::setSort(int column , Qt::SortOrder
        order )**

        Sets the sort order for **column** to **order**. This does not affect
        the current data, to refresh the data using the new sort order, call
        **select** ().

        **See also** **sort** (), **select** (), and **orderByClause** ().
        """
        ...

    def setTable(self, tableName: str) -> None:
        """
        https://doc.qt.io/qt-6/qsqltablemodel.html#setTable

        **[virtual] void QSqlTableModel::setTable(const QString & tableName )**

        Sets the database table on which the model operates to **tableName**.
        Does not select data from the table, but fetches its field information.

        To populate the model with the table's data, call **select** ().

        Error information can be retrieved with **lastError** ().

        **See also** **select** (), **setFilter** (), and **lastError** ().
        """
        ...

    def sort(self, column: int, order: PySide6.QtCore.Qt.SortOrder) -> None:
        """
        https://doc.qt.io/qt-6/qsqltablemodel.html#sort

        **[override virtual] void QSqlTableModel::sort(int column ,
        Qt::SortOrder order )**

        Reimplements: **QAbstractItemModel::sort** (int column, Qt::SortOrder
        order).

        Sorts the data by **column** with the sort order **order**. This will
        immediately select data, use **setSort** () to set a sort order without
        populating the model with data.

        **See also** **setSort** (), **select** (), and **orderByClause** ().
        """
        ...

    def submit(self) -> bool:
        """
        https://doc.qt.io/qt-6/qsqltablemodel.html#submit

        **[override virtual slot] bool QSqlTableModel::submit()**

        Reimplements: **QAbstractItemModel::submit** ().

        This reimplemented slot is called by the item delegates when the user
        stopped editing the current row.

        Submits the currently edited row if the model's strategy is set to
        **OnRowChange**  or **OnFieldChange** . Does nothing for the
        **OnManualSubmit**  strategy.

        Use **submitAll** () to submit all pending changes for the
        **OnManualSubmit**  strategy.

        Returns `true` on success; otherwise returns `false`. Use **lastError**
        () to query detailed error information.

        Does not automatically repopulate the model. Submitted rows are
        refreshed from the database on success.

        **See also** **revert** (), **revertRow** (), **submitAll** (),
        **revertAll** (), and **lastError** ().
        """
        ...

    def submitAll(self) -> bool:
        """
        https://doc.qt.io/qt-6/qsqltablemodel.html#submitAll

        **[slot] bool QSqlTableModel::submitAll()**

        Submits all pending changes and returns `true` on success. Returns
        `false` on error, detailed error information can be obtained with
        **lastError** ().

        In **OnManualSubmit** , on success the model will be repopulated. Any
        views presenting it will lose their selections.

        Note: In **OnManualSubmit**  mode, already submitted changes won't be
        cleared from the cache when submitAll() fails. This allows transactions
        to be rolled back and resubmitted without losing data.

        **See also** **revertAll** () and **lastError** ().
        """
        ...

    def tableName(self) -> str:
        """
        https://doc.qt.io/qt-6/qsqltablemodel.html#tableName

        **QString QSqlTableModel::tableName() const**

        Returns the name of the currently selected table.
        """
        ...

    def updateRowInTable(self, row: int, values: PySide6.QtSql.QSqlRecord) -> bool:
        """
        https://doc.qt.io/qt-6/qsqltablemodel.html#updateRowInTable

        **[virtual protected] bool QSqlTableModel::updateRowInTable(int row ,
        const QSqlRecord & values )**

        Updates the given **row** in the currently active database table with
        the specified **values**. Returns `true` if successful; otherwise
        returns `false`.

        This is a low-level method that operates directly on the database and
        should not be called directly. Use **setData** () to update values. The
        model will decide depending on its edit strategy when to modify the
        database.

        Note that only values that have the generated-flag set are updated. The
        generated-flag can be set with **QSqlRecord::setGenerated** () and
        tested with **QSqlRecord::isGenerated** ().

        **See also** **QSqlRecord::isGenerated** () and **setData** ().
        """
        ...

    @property
    def beforeDelete(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qsqltablemodel.html#beforeDelete

        **[signal] void QSqlTableModel::beforeDelete(int row )**

        This signal is emitted by **deleteRowFromTable** () before the **row**
        is deleted from the currently active database table.
        """
        ...

    @property
    def beforeInsert(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qsqltablemodel.html#beforeInsert

        **[signal] void QSqlTableModel::beforeInsert(QSqlRecord & record )**

        This signal is emitted by **insertRowIntoTable** () before a new row is
        inserted into the currently active database table. The values that are
        about to be inserted are stored in **record** and can be modified before
        they will be inserted.
        """
        ...

    @property
    def beforeUpdate(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qsqltablemodel.html#beforeUpdate

        **[signal] void QSqlTableModel::beforeUpdate(int row , QSqlRecord &
        record )**

        This signal is emitted by **updateRowInTable** () before the **row** is
        updated in the currently active database table with the values from
        **record**.

        Note that only values that are marked as generated will be updated. The
        generated flag can be set with **QSqlRecord::setGenerated** () and
        checked with **QSqlRecord::isGenerated** ().

        **See also** **QSqlRecord::isGenerated** ().
        """
        ...

    @property
    def primeInsert(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qsqltablemodel.html#primeInsert

        **[signal] void QSqlTableModel::primeInsert(int row , QSqlRecord &
        record )**

        This signal is emitted by **insertRows** (), when an insertion is
        initiated in the given **row** of the currently active database table.
        The **record** parameter can be written to (since it is a reference),
        for example to populate some fields with default values and set the
        generated flags of the fields. Do not try to edit the record via other
        means such as **setData** () or **setRecord** () while handling this
        signal.
        """
        ...
