"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtSql, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import Any, List, overload
import PySide6.QtCore
import PySide6.QtWidgets
import PySide6.QtSql

bytes = str


class QSqlQuery(object):
    """
    https://doc.qt.io/qt-6/qsqlquery.html

    **Detailed Description**

    QSqlQuery encapsulates the functionality involved in creating, navigating
    and retrieving data from SQL queries which are executed on a
    **QSqlDatabase** . It can be used to execute DML (data manipulation
    language) statements, such as `SELECT`, `INSERT`, `UPDATE` and `DELETE`, as
    well as DDL (data definition language) statements, such as `CREATE` `TABLE`.
    It can also be used to execute database-specific commands which are not
    standard SQL (e.g. `SET DATESTYLE=ISO` for PostgreSQL).

    Successfully executed SQL statements set the query's state to active so that
    **isActive** () returns `true`. Otherwise the query's state is set to
    inactive. In either case, when executing a new SQL statement, the query is
    positioned on an invalid record. An active query must be navigated to a
    valid record (so that **isValid** () returns `true`) before values can be
    retrieved.

    For some databases, if an active query that is a `SELECT` statement exists
    when you call **commit** () or **rollback** (), the commit or rollback will
    fail. See **isActive** () for details.

    Navigating records is performed with the following functions:

    * **next** ()
      * **previous** ()
      * **first** ()
      * **last** ()
      *
    **seek** ()

    These functions allow the programmer to move forward, backward or
    arbitrarily through the records returned by the query. If you only need to
    move forward through the results (e.g., by using **next** ()), you can use
    **setForwardOnly** (), which will save a significant amount of memory
    overhead and improve performance on some databases. Once an active query is
    positioned on a valid record, data can be retrieved using **value** (). All
    data is transferred from the SQL backend using QVariants.

    For example:

    **QSqlQuery**  query("SELECT country FROM artist");
            while
    (query.next()) {
                **QString**  country =
    query.value(0).toString();
                doSomething(country);
            }

    To access the data returned by a query, use value(int). Each field in the
    data returned by a `SELECT` statement is accessed by passing the field's
    position in the statement, starting from 0. This makes using `SELECT *`
    queries inadvisable because the order of the fields returned is
    indeterminate.

    For the sake of efficiency, there are no functions to access a field by name
    (unless you use prepared queries with names, as explained below). To convert
    a field name into an index, use **record** ().**indexOf** (), for example:

    **QSqlQuery**  query("SELECT * FROM artist");
            int fieldNo =
    query.record().indexOf("country");
            while (query.next()) {
    **QString**  country = query.value(fieldNo).toString();
    doSomething(country);
            }

    QSqlQuery supports prepared query execution and the binding of parameter
    values to placeholders. Some databases don't support these features, so for
    those, Qt emulates the required functionality. For example, the Oracle and
    ODBC drivers have proper prepared query support, and Qt makes use of it; but
    for databases that don't have this support, Qt implements the feature
    itself, e.g. by replacing placeholders with actual values when a query is
    executed. Use **numRowsAffected** () to find out how many rows were affected
    by a non-`SELECT` query, and **size** () to find how many were retrieved by
    a `SELECT`.

    Oracle databases identify placeholders by using a colon-name syntax, e.g
    `:name`. ODBC simply uses `?` characters. Qt supports both syntaxes, with
    the restriction that you can't mix them in the same query.

    You can retrieve the values of all the fields in a single variable using
    **boundValues** ().

    **Note:** Not all SQL operations support binding values. Refer to your
    database system's documentation to check their availability.

    **Approaches to Binding Values**

    Below we present the same example using each of the four different binding
    approaches, as well as one example of binding values to a stored procedure.

    **Named binding using named placeholders:**

    **QSqlQuery**  query;
            query.prepare("INSERT INTO person (id,
    forename, surname) "
                          "VALUES (:id, :forename,
    :surname)");
            query.bindValue(":id", 1001);
    query.bindValue(":forename", "Bart");
            query.bindValue(":surname",
    "Simpson");
            query.exec();

    **Positional binding using named placeholders:**

    **QSqlQuery**  query;
            query.prepare("INSERT INTO person (id,
    forename, surname) "
                          "VALUES (:id, :forename,
    :surname)");
            query.bindValue(0, 1001);
            query.bindValue(1,
    "Bart");
            query.bindValue(2, "Simpson");
            query.exec();

    **Binding values using positional placeholders (version 1):**

    **QSqlQuery**  query;
            query.prepare("INSERT INTO person (id,
    forename, surname) "
                          "VALUES (?, ?, ?)");
    query.bindValue(0, 1001);
            query.bindValue(1, "Bart");
    query.bindValue(2, "Simpson");
            query.exec();

    **Binding values using positional placeholders (version 2):**

    **QSqlQuery**  query;
            query.prepare("INSERT INTO person (id,
    forename, surname) "
                          "VALUES (?, ?, ?)");
    query.addBindValue(1001);
            query.addBindValue("Bart");
    query.addBindValue("Simpson");
            query.exec();

    **Binding values to a stored procedure:**

    This code calls a stored procedure called `AsciiToInt()`, passing it a
    character through its in parameter, and taking its result in the out
    parameter.

    **QSqlQuery**  query;
            query.prepare("CALL AsciiToInt(?, ?)");
    query.bindValue(0, "A");
            query.bindValue(1, 0, QSql::Out);
    query.exec();
            int i = query.boundValue(1).toInt(); // i is 65

    Note that unbound parameters will retain their values.

    Stored procedures that uses the return statement to return values, or return
    multiple result sets, are not fully supported. For specific details see
    **SQL Database Drivers** .

    **Warning:** You must load the SQL driver and open the connection before a
    QSqlQuery is created. Also, the connection must remain open while the query
    exists; otherwise, the behavior of QSqlQuery is undefined.

    **See also** **QSqlDatabase** , **QSqlQueryModel** , **QSqlTableModel** ,
    and **QVariant** .
    """

    ValuesAsRows: QSqlQuery.BatchExecutionMode = ...
    ValuesAsColumns: QSqlQuery.BatchExecutionMode = ...

    class BatchExecutionMode(Enum):
        ValuesAsRows: QSqlQuery.BatchExecutionMode = ...
        ValuesAsColumns: QSqlQuery.BatchExecutionMode = ...

    @overload
    def __init__(self, db: PySide6.QtSql.QSqlDatabase) -> None:
        """
        https://doc.qt.io/qt-6/qsqlquery.html#QSqlQuery

        **QSqlQuery::QSqlQuery(QSqlResult * result )**

        Constructs a QSqlQuery object which uses the **QSqlResult**  **result**
        to communicate with a database.
        """
        ...

    @overload
    def __init__(self, other: PySide6.QtSql.QSqlQuery) -> None:
        """
        https://doc.qt.io/qt-6/qsqlquery.html#QSqlQuery-1

        **QSqlQuery::QSqlQuery(const QString & query = QString(), const
        QSqlDatabase & db = QSqlDatabase())**

        Constructs a QSqlQuery object using the SQL **query** and the database
        **db**. If **db** is not specified, or is invalid, the application's
        default database is used. If **query** is not an empty string, it will
        be executed.

        **See also** **QSqlDatabase** .
        """
        ...

    @overload
    def __init__(self, query: str = ..., db: PySide6.QtSql.QSqlDatabase = ...) -> None:
        """
        https://doc.qt.io/qt-6/qsqlquery.html#QSqlQuery-2

        **QSqlQuery::QSqlQuery(const QSqlDatabase & db )**

        Constructs a QSqlQuery object using the database **db**. If **db** is
        invalid, the application's default database will be used.

        **See also** **QSqlDatabase** .
        """
        ...

    @overload
    def __init__(self, r: PySide6.QtSql.QSqlResult) -> None:
        """
        https://doc.qt.io/qt-6/qsqlquery.html#QSqlQuery-4

        **[since 6.2] QSqlQuery::QSqlQuery(QSqlQuery && other )**

        Move-constructs a QSqlQuery from **other**.

        This function was introduced in Qt 6.2.
        """
        ...

    @staticmethod
    def __copy__() -> None:
        ...

    def addBindValue(self, val: Any, type: PySide6.QtSql.QSql.ParamType = ...) -> None:
        """
        https://doc.qt.io/qt-6/qsqlquery.html#addBindValue

        **void QSqlQuery::addBindValue(const QVariant & val , QSql::ParamType
        paramType = QSql::In)**

        Adds the value **val** to the list of values when using positional value
        binding. The order of the addBindValue() calls determines which
        placeholder a value will be bound to in the prepared query. If
        **paramType** is **QSql::Out**  or **QSql::InOut** , the placeholder
        will be overwritten with data from the database after the **exec** ()
        call.

        To bind a NULL value, use a null **QVariant** ; for example, use
        `QVariant(QMetaType::QString)` if you are binding a string.

        **See also** **bindValue** (), **prepare** (), **exec** (),
        **boundValue** (), and **boundValues** ().
        """
        ...

    def at(self) -> int:
        """
        https://doc.qt.io/qt-6/qsqlquery.html#at

        **int QSqlQuery::at() const**

        Returns the current internal position of the query. The first record is
        at position zero. If the position is invalid, the function returns
        **QSql::BeforeFirstRow**  or **QSql::AfterLastRow** , which are special
        negative values.

        **See also** **previous** (), **next** (), **first** (), **last** (),
        **seek** (), **isActive** (), and **isValid** ().
        """
        ...

    @overload
    def bindValue(
        self, placeholder: str, val: Any, type: PySide6.QtSql.QSql.ParamType = ...
    ) -> None:
        """
        https://doc.qt.io/qt-6/qsqlquery.html#bindValue

        **void QSqlQuery::bindValue(const QString & placeholder , const QVariant
        & val , QSql::ParamType paramType = QSql::In)**

        Set the placeholder **placeholder** to be bound to value **val** in the
        prepared statement. Note that the placeholder mark (e.g `:`) must be
        included when specifying the placeholder name. If **paramType** is
        **QSql::Out**  or **QSql::InOut** , the placeholder will be overwritten
        with data from the database after the **exec** () call. In this case,
        sufficient space must be pre-allocated to store the result into.

        To bind a NULL value, use a null **QVariant** ; for example, use
        `QVariant(QMetaType::QString)` if you are binding a string.

        **See also** **addBindValue** (), **prepare** (), **exec** (),
        **boundValue** (), and **boundValues** ().
        """
        ...

    @overload
    def bindValue(
        self, pos: int, val: Any, type: PySide6.QtSql.QSql.ParamType = ...
    ) -> None:
        """
        https://doc.qt.io/qt-6/qsqlquery.html#bindValue-1

        **void QSqlQuery::bindValue(int pos , const QVariant & val ,
        QSql::ParamType paramType = QSql::In)**

        Set the placeholder in position **pos** to be bound to value **val** in
        the prepared statement. Field numbering starts at 0. If **paramType** is
        **QSql::Out**  or **QSql::InOut** , the placeholder will be overwritten
        with data from the database after the **exec** () call.
        """
        ...

    @overload
    def boundValue(self, placeholder: str) -> Any:
        """
        https://doc.qt.io/qt-6/qsqlquery.html#boundValue

        **QVariant QSqlQuery::boundValue(const QString & placeholder ) const**

        Returns the value for the **placeholder**.

        **See also** **boundValues** (), **bindValue** (), and **addBindValue**
        ().
        """
        ...

    @overload
    def boundValue(self, pos: int) -> Any:
        """
        https://doc.qt.io/qt-6/qsqlquery.html#boundValue-1

        **QVariant QSqlQuery::boundValue(int pos ) const**

        Returns the value for the placeholder at position **pos**.
        """
        ...

    def boundValues(self) -> List[Any]:
        """
        https://doc.qt.io/qt-6/qsqlquery.html#boundValues

        **[since 6.0] QVariantList QSqlQuery::boundValues() const**

        Returns a list of bound values.

        The order of the list is in binding order, irrespective of whether named
        or positional binding is used.

        The bound values can be examined in the following way:

        QVariantList list = query.boundValues();
                for (int i = 0; i <
        list.size(); ++i)
                    cout << i << ": " <<
        list.at(i).toString().toUtf8().data() << "\\n";

        This function was introduced in Qt 6.0.

        **See also** **boundValue** (), **bindValue** (), and **addBindValue**
        ().
        """
        ...

    def clear(self) -> None:
        """
        https://doc.qt.io/qt-6/qsqlquery.html#clear

        **void QSqlQuery::clear()**

        Clears the result set and releases any resources held by the query. Sets
        the query state to inactive. You should rarely if ever need to call this
        function.
        """
        ...

    def driver(self) -> PySide6.QtSql.QSqlDriver:
        """
        https://doc.qt.io/qt-6/qsqlquery.html#driver

        **const QSqlDriver *QSqlQuery::driver() const**

        Returns the database driver associated with the query.
        """
        ...

    @overload
    def exec(self) -> bool:
        """
        https://doc.qt.io/qt-6/qsqlquery.html#exec

        **bool QSqlQuery::exec(const QString & query )**

        Executes the SQL in **query**. Returns `true` and sets the query state
        to **active**  if the query was successful; otherwise returns `false`.
        The **query** string must use syntax appropriate for the SQL database
        being queried (for example, standard SQL).

        After the query is executed, the query is positioned on an **invalid**
        record and must be navigated to a valid record before data values can be
        retrieved (for example, using **next** ()).

        Note that the last error for this query is reset when exec() is called.

        For SQLite, the query string can contain only one statement at a time.
        If more than one statement is given, the function returns `false`.

        Example:

        **QSqlQuery**  query;
                query.exec("INSERT INTO employee (id,
        name, salary) "
                           "VALUES (1001, 'Thad Beaumont',
        65000)");

        **See also** **isActive** (), **isValid** (), **next** (), **previous**
        (), **first** (), **last** (), and **seek** ().
        """
        ...

    @overload
    def exec(self, query: str) -> bool:
        """
        https://doc.qt.io/qt-6/qsqlquery.html#exec-1

        **bool QSqlQuery::exec()**

        Executes a previously prepared SQL query. Returns `true` if the query
        executed successfully; otherwise returns `false`.

        Note that the last error for this query is reset when exec() is called.

        **See also** **prepare** (), **bindValue** (), **addBindValue** (),
        **boundValue** (), and **boundValues** ().
        """
        ...

    def execBatch(self, mode: PySide6.QtSql.QSqlQuery.BatchExecutionMode = ...) -> bool:
        """
        https://doc.qt.io/qt-6/qsqlquery.html#execBatch

        **bool QSqlQuery::execBatch(QSqlQuery::BatchExecutionMode mode =
        ValuesAsRows)**

        Executes a previously prepared SQL query in a batch. All the bound
        parameters have to be lists of variants. If the database doesn't support
        batch executions, the driver will simulate it using conventional
        **exec** () calls.

        Returns `true` if the query is executed successfully; otherwise returns
        `false`.

        Example:

        **QSqlQuery**  q;
            q.prepare("insert into myTable values (?, ?)");
        QVariantList ints;
            ints << 1 << 2 << 3 << 4;
        q.addBindValue(ints);

            QVariantList names;
            names << "Harald"
        << "Boris" << "Trond" << **QVariant** (**QMetaType** ::**QString** );
        q.addBindValue(names);

            if (!q.execBatch())
                **qDebug**
        () << q.lastError();

        The example above inserts four new rows into `myTable`:

        1  Harald
            2  Boris
            3  Trond
            4  NULL

        To bind NULL values, a null **QVariant**  of the relevant type has to be
        added to the bound QVariantList; for example,
        `QVariant(QMetaType::QString)` should be used if you are using strings.

        **Note:** Every bound QVariantList must contain the same amount of
        variants.

        **Note:** The type of the QVariants in a list must not change. For
        example, you cannot mix integer and string variants within a
        QVariantList.

        The **mode** parameter indicates how the bound QVariantList will be
        interpreted. If **mode** is `ValuesAsRows`, every variant within the
        QVariantList will be interpreted as a value for a new row.
        `ValuesAsColumns` is a special case for the Oracle driver. In this mode,
        every entry within a QVariantList will be interpreted as array-value for
        an IN or OUT value within a stored procedure. Note that this will only
        work if the IN or OUT value is a table-type consisting of only one
        column of a basic type, for example `TYPE myType IS TABLE OF VARCHAR(64)
        INDEX BY BINARY_INTEGER;`

        **See also** **prepare** (), **bindValue** (), and **addBindValue** ().
        """
        ...

    @overload
    def exec_(self) -> bool:
        """
        https://doc.qt.io/qt-6/qsqlquery.html#exec

        **bool QSqlQuery::exec(const QString & query )**

        Executes the SQL in **query**. Returns `true` and sets the query state
        to **active**  if the query was successful; otherwise returns `false`.
        The **query** string must use syntax appropriate for the SQL database
        being queried (for example, standard SQL).

        After the query is executed, the query is positioned on an **invalid**
        record and must be navigated to a valid record before data values can be
        retrieved (for example, using **next** ()).

        Note that the last error for this query is reset when exec() is called.

        For SQLite, the query string can contain only one statement at a time.
        If more than one statement is given, the function returns `false`.

        Example:

        **QSqlQuery**  query;
                query.exec("INSERT INTO employee (id,
        name, salary) "
                           "VALUES (1001, 'Thad Beaumont',
        65000)");

        **See also** **isActive** (), **isValid** (), **next** (), **previous**
        (), **first** (), **last** (), and **seek** ().
        """
        ...

    @overload
    def exec_(self, arg__1: str) -> bool:
        """
        https://doc.qt.io/qt-6/qsqlquery.html#exec

        **bool QSqlQuery::exec(const QString & query )**

        Executes the SQL in **query**. Returns `true` and sets the query state
        to **active**  if the query was successful; otherwise returns `false`.
        The **query** string must use syntax appropriate for the SQL database
        being queried (for example, standard SQL).

        After the query is executed, the query is positioned on an **invalid**
        record and must be navigated to a valid record before data values can be
        retrieved (for example, using **next** ()).

        Note that the last error for this query is reset when exec() is called.

        For SQLite, the query string can contain only one statement at a time.
        If more than one statement is given, the function returns `false`.

        Example:

        **QSqlQuery**  query;
                query.exec("INSERT INTO employee (id,
        name, salary) "
                           "VALUES (1001, 'Thad Beaumont',
        65000)");

        **See also** **isActive** (), **isValid** (), **next** (), **previous**
        (), **first** (), **last** (), and **seek** ().
        """
        ...

    def executedQuery(self) -> str:
        """
        https://doc.qt.io/qt-6/qsqlquery.html#executedQuery

        **QString QSqlQuery::executedQuery() const**

        Returns the last query that was successfully executed.

        In most cases this function returns the same string as **lastQuery** ().
        If a prepared query with placeholders is executed on a DBMS that does
        not support it, the preparation of this query is emulated. The
        placeholders in the original query are replaced with their bound values
        to form a new query. This function returns the modified query. It is
        mostly useful for debugging purposes.

        **See also** **lastQuery** ().
        """
        ...

    def finish(self) -> None:
        """
        https://doc.qt.io/qt-6/qsqlquery.html#finish

        **void QSqlQuery::finish()**

        Instruct the database driver that no more data will be fetched from this
        query until it is re-executed. There is normally no need to call this
        function, but it may be helpful in order to free resources such as locks
        or cursors if you intend to re-use the query at a later time.

        Sets the query to inactive. Bound values retain their values.

        **See also** **prepare** (), **exec** (), and **isActive** ().
        """
        ...

    def first(self) -> bool:
        """
        https://doc.qt.io/qt-6/qsqlquery.html#first

        **bool QSqlQuery::first()**

        Retrieves the first record in the result, if available, and positions
        the query on the retrieved record. Note that the result must be in the
        **active**  state and **isSelect** () must return true before calling
        this function or it will do nothing and return false. Returns `true` if
        successful. If unsuccessful the query position is set to an invalid
        position and false is returned.

        **See also** **next** (), **previous** (), **last** (), **seek** (),
        **at** (), **isActive** (), and **isValid** ().
        """
        ...

    def isActive(self) -> bool:
        """
        https://doc.qt.io/qt-6/qsqlquery.html#isActive

        **bool QSqlQuery::isActive() const**

        Returns `true` if the query is **active**. An active **QSqlQuery**  is
        one that has been **exec()'d**  successfully but not yet finished with.
        When you are finished with an active query, you can make the query
        inactive by calling **finish** () or **clear** (), or you can delete the
        **QSqlQuery**  instance.

        **Note:** Of particular interest is an active query that is a `SELECT`
        statement. For some databases that support transactions, an active query
        that is a `SELECT` statement can cause a **commit** () or a **rollback**
        () to fail, so before committing or rolling back, you should make your
        active `SELECT` statement query inactive using one of the ways listed
        above.

        **See also** **isSelect** ().
        """
        ...

    def isForwardOnly(self) -> bool:
        """
        https://doc.qt.io/qt-6/qsqlquery.html#isForwardOnly

        **bool QSqlQuery::isForwardOnly() const**

        Returns `true` if you can only scroll forward through a result set;
        otherwise returns `false`.

        **See also** **setForwardOnly** () and **next** ().
        """
        ...

    @overload
    def isNull(self, field: int) -> bool:
        """
        https://doc.qt.io/qt-6/qsqlquery.html#isNull

        **bool QSqlQuery::isNull(int field ) const**

        Returns `true` if the query is not **active** , the query is not
        positioned on a valid record, there is no such **field** , or the
        **field** is null; otherwise `false`. Note that for some drivers,
        isNull() will not return accurate information until after an attempt is
        made to retrieve data.

        **See also** **isActive** (), **isValid** (), and **value** ().
        """
        ...

    @overload
    def isNull(self, name: str) -> bool:
        """
        https://doc.qt.io/qt-6/qsqlquery.html#isNull-1

        **bool QSqlQuery::isNull(const QString & name ) const**

        This is an overloaded function.

        Returns `true` if there is no field with this **name** ; otherwise
        returns isNull(int index) for the corresponding field index.

        This overload is less efficient than **isNull** ()
        """
        ...

    def isSelect(self) -> bool:
        """
        https://doc.qt.io/qt-6/qsqlquery.html#isSelect

        **bool QSqlQuery::isSelect() const**

        Returns `true` if the current query is a `SELECT` statement; otherwise
        returns `false`.
        """
        ...

    def isValid(self) -> bool:
        """
        https://doc.qt.io/qt-6/qsqlquery.html#isValid

        **bool QSqlQuery::isValid() const**

        Returns `true` if the query is currently positioned on a valid record;
        otherwise returns `false`.
        """
        ...

    def last(self) -> bool:
        """
        https://doc.qt.io/qt-6/qsqlquery.html#last

        **bool QSqlQuery::last()**

        Retrieves the last record in the result, if available, and positions the
        query on the retrieved record. Note that the result must be in the
        **active**  state and **isSelect** () must return true before calling
        this function or it will do nothing and return false. Returns `true` if
        successful. If unsuccessful the query position is set to an invalid
        position and false is returned.

        **See also** **next** (), **previous** (), **first** (), **seek** (),
        **at** (), **isActive** (), and **isValid** ().
        """
        ...

    def lastError(self) -> PySide6.QtSql.QSqlError:
        """
        https://doc.qt.io/qt-6/qsqlquery.html#lastError

        **QSqlError QSqlQuery::lastError() const**

        Returns error information about the last error (if any) that occurred
        with this query.

        **See also** **QSqlError**  and **QSqlDatabase::lastError** ().
        """
        ...

    def lastInsertId(self) -> Any:
        """
        https://doc.qt.io/qt-6/qsqlquery.html#lastInsertId

        **QVariant QSqlQuery::lastInsertId() const**

        Returns the object ID of the most recent inserted row if the database
        supports it. An invalid **QVariant**  will be returned if the query did
        not insert any value or if the database does not report the id back. If
        more than one row was touched by the insert, the behavior is undefined.

        For MySQL databases the row's auto-increment field will be returned.

        **Note:** For this function to work in PSQL, the table table must
        contain OIDs, which may not have been created by default. Check the
        `default_with_oids` configuration variable to be sure.

        **See also** **QSqlDriver::hasFeature** ().
        """
        ...

    def lastQuery(self) -> str:
        """
        https://doc.qt.io/qt-6/qsqlquery.html#lastQuery

        **QString QSqlQuery::lastQuery() const**

        Returns the text of the current query being used, or an empty string if
        there is no current query text.

        **See also** **executedQuery** ().
        """
        ...

    def next(self) -> bool:
        """
        https://doc.qt.io/qt-6/qsqlquery.html#next

        **bool QSqlQuery::next()**

        Retrieves the next record in the result, if available, and positions the
        query on the retrieved record. Note that the result must be in the
        **active**  state and **isSelect** () must return true before calling
        this function or it will do nothing and return false.

        The following rules apply:

        * If the result is currently located before the first record, e.g.
        immediately after a query is executed, an attempt is made to retrieve
        the first record.
          * If the result is currently located after the last
        record, there is no change and false is returned.
          * If the result is
        located somewhere in the middle, an attempt is made to retrieve the next
        record.

        If the record could not be retrieved, the result is positioned after the
        last record and false is returned. If the record is successfully
        retrieved, true is returned.

        **See also** **previous** (), **first** (), **last** (), **seek** (),
        **at** (), **isActive** (), and **isValid** ().
        """
        ...

    def nextResult(self) -> bool:
        """
        https://doc.qt.io/qt-6/qsqlquery.html#nextResult

        **bool QSqlQuery::nextResult()**

        Discards the current result set and navigates to the next if available.

        Some databases are capable of returning multiple result sets for stored
        procedures or SQL batches (a query strings that contains multiple
        statements). If multiple result sets are available after executing a
        query this function can be used to navigate to the next result set(s).

        If a new result set is available this function will return true. The
        query will be repositioned on an **invalid** record in the new result
        set and must be navigated to a valid record before data values can be
        retrieved. If a new result set isn't available the function returns
        `false` and the query is set to inactive. In any case the old result set
        will be discarded.

        When one of the statements is a non-select statement a count of affected
        rows may be available instead of a result set.

        Note that some databases, i.e. Microsoft SQL Server, requires non-
        scrollable cursors when working with multiple result sets. Some
        databases may execute all statements at once while others may delay the
        execution until the result set is actually accessed, and some databases
        may have restrictions on which statements are allowed to be used in a
        SQL batch.

        **See also** **QSqlDriver::hasFeature** (), **setForwardOnly** (),
        **next** (), **isSelect** (), **numRowsAffected** (), **isActive** (),
        and **lastError** ().
        """
        ...

    def numRowsAffected(self) -> int:
        """
        https://doc.qt.io/qt-6/qsqlquery.html#numRowsAffected

        **int QSqlQuery::numRowsAffected() const**

        Returns the number of rows affected by the result's SQL statement, or -1
        if it cannot be determined. Note that for `SELECT` statements, the value
        is undefined; use **size** () instead. If the query is not **active** ,
        -1 is returned.

        **See also** **size** () and **QSqlDriver::hasFeature** ().
        """
        ...

    def numericalPrecisionPolicy(self) -> PySide6.QtSql.QSql.NumericalPrecisionPolicy:
        """
        https://doc.qt.io/qt-6/qsqlquery.html#numericalPrecisionPolicy

        **QSql::NumericalPrecisionPolicy QSqlQuery::numericalPrecisionPolicy()
        const**

        Returns the current precision policy.

        **See also** **QSql::NumericalPrecisionPolicy**  and
        **setNumericalPrecisionPolicy** ().
        """
        ...

    def prepare(self, query: str) -> bool:
        """
        https://doc.qt.io/qt-6/qsqlquery.html#prepare

        **bool QSqlQuery::prepare(const QString & query )**

        Prepares the SQL query **query** for execution. Returns `true` if the
        query is prepared successfully; otherwise returns `false`.

        The query may contain placeholders for binding values. Both Oracle style
        colon-name (e.g., `:surname`), and ODBC style (`?`) placeholders are
        supported; but they cannot be mixed in the same query. See the
        **Detailed Description**  for examples.

        Portability notes: Some databases choose to delay preparing a query
        until it is executed the first time. In this case, preparing a
        syntactically wrong query succeeds, but every consecutive **exec** ()
        will fail. When the database does not support named placeholders
        directly, the placeholder can only contain characters in the range
        [a-zA-Z0-9**_** ].

        For SQLite, the query string can contain only one statement at a time.
        If more than one statement is given, the function returns `false`.

        Example:

        **QSqlQuery**  query;
                query.prepare("INSERT INTO person (id,
        forename, surname) "
                              "VALUES (:id, :forename,
        :surname)");
                query.bindValue(":id", 1001);
        query.bindValue(":forename", "Bart");
        query.bindValue(":surname", "Simpson");
                query.exec();

        **See also** **exec** (), **bindValue** (), and **addBindValue** ().
        """
        ...

    def previous(self) -> bool:
        """
        https://doc.qt.io/qt-6/qsqlquery.html#previous

        **bool QSqlQuery::previous()**

        Retrieves the previous record in the result, if available, and positions
        the query on the retrieved record. Note that the result must be in the
        **active**  state and **isSelect** () must return true before calling
        this function or it will do nothing and return false.

        The following rules apply:

        * If the result is currently located before the first record, there is
        no change and false is returned.
          * If the result is currently located
        after the last record, an attempt is made to retrieve the last record.
        * If the result is somewhere in the middle, an attempt is made to
        retrieve the previous record.

        If the record could not be retrieved, the result is positioned before
        the first record and false is returned. If the record is successfully
        retrieved, true is returned.

        **See also** **next** (), **first** (), **last** (), **seek** (), **at**
        (), **isActive** (), and **isValid** ().
        """
        ...

    def record(self) -> PySide6.QtSql.QSqlRecord:
        """
        https://doc.qt.io/qt-6/qsqlquery.html#record

        **QSqlRecord QSqlQuery::record() const**

        Returns a **QSqlRecord**  containing the field information for the
        current query. If the query points to a valid row (**isValid** ()
        returns true), the record is populated with the row's values. An empty
        record is returned when there is no active query (**isActive** ()
        returns false).

        To retrieve values from a query, **value** () should be used since its
        index-based lookup is faster.

        In the following example, a `SELECT * FROM` query is executed. Since the
        order of the columns is not defined, **QSqlRecord::indexOf** () is used
        to obtain the index of a column.

        **QSqlQuery**  q("select * from employees");
            **QSqlRecord**  rec =
        q.record();

            **qDebug** () << "Number of columns: " <<
        rec.count();

            int nameCol = rec.indexOf("name"); // index of the
        field "name"
            while (q.next())
                **qDebug** () <<
        q.value(nameCol).toString(); // output all names

        **See also** **value** ().
        """
        ...

    def result(self) -> PySide6.QtSql.QSqlResult:
        """
        https://doc.qt.io/qt-6/qsqlquery.html#result

        **const QSqlResult *QSqlQuery::result() const**

        Returns the result associated with the query.
        """
        ...

    def seek(self, i: int, relative: bool = ...) -> bool:
        """
        https://doc.qt.io/qt-6/qsqlquery.html#seek

        **bool QSqlQuery::seek(int index , bool relative = false)**

        Retrieves the record at position **index** , if available, and positions
        the query on the retrieved record. The first record is at position 0.
        Note that the query must be in an **active**  state and **isSelect** ()
        must return true before calling this function.

        If **relative** is false (the default), the following rules apply:

        * If **index** is negative, the result is positioned before the first
        record and false is returned.
          * Otherwise, an attempt is made to move
        to the record at position **index**. If the record at position **index**
        could not be retrieved, the result is positioned after the last record
        and false is returned. If the record is successfully retrieved, true is
        returned.

        If **relative** is true, the following rules apply:

        * If the result is currently positioned before the first record and:
        * **index** is negative or zero, there is no change, and false is
        returned.
            * **index** is positive, an attempt is made to position
        the result at absolute position **index** \\- 1, following the sames rule
        for non relative seek, above.
          * If the result is currently positioned
        after the last record and:
            * **index** is positive or zero, there is
        no change, and false is returned.
            * **index** is negative, an
        attempt is made to position the result at **index** \\+ 1 relative
        position from last record, following the rule below.
          * If the result
        is currently located somewhere in the middle, and the relative offset
        **index** moves the result below zero, the result is positioned before
        the first record and false is returned.
          * Otherwise, an attempt is
        made to move to the record **index** records ahead of the current record
        (or **index** records behind the current record if **index** is
        negative). If the record at offset **index** could not be retrieved, the
        result is positioned after the last record if **index** >= 0, (or before
        the first record if **index** is negative), and false is returned. If
        the record is successfully retrieved, true is returned.

        **See also** **next** (), **previous** (), **first** (), **last** (),
        **at** (), **isActive** (), and **isValid** ().
        """
        ...

    def setForwardOnly(self, forward: bool) -> None:
        """
        https://doc.qt.io/qt-6/qsqlquery.html#setForwardOnly

        **void QSqlQuery::setForwardOnly(bool forward )**

        Sets forward only mode to **forward**. If **forward** is true, only
        **next** () and **seek** () with positive values, are allowed for
        navigating the results.

        Forward only mode can be (depending on the driver) more memory efficient
        since results do not need to be cached. It will also improve performance
        on some databases. For this to be true, you must call `setForwardOnly()`
        before the query is prepared or executed. Note that the constructor that
        takes a query and a database may execute the query.

        Forward only mode is off by default.

        Setting forward only to false is a suggestion to the database engine,
        which has the final say on whether a result set is forward only or
        scrollable. **isForwardOnly** () will always return the correct status
        of the result set.

        **Note:** Calling setForwardOnly after execution of the query will
        result in unexpected results at best, and crashes at worst.

        **Note:** To make sure the forward-only query completed successfully,
        the application should check **lastError** () for an error not only
        after executing the query, but also after navigating the query results.

        **Warning:** PostgreSQL: While navigating the query results in forward-
        only mode, do not execute any other SQL command on the same database
        connection. This will cause the query results to be lost.

        **See also** **isForwardOnly** (), **next** (), **seek** (), and
        **QSqlResult::setForwardOnly** ().
        """
        ...

    def setNumericalPrecisionPolicy(
        self, precisionPolicy: PySide6.QtSql.QSql.NumericalPrecisionPolicy
    ) -> None:
        """
        https://doc.qt.io/qt-6/qsqlquery.html#setNumericalPrecisionPolicy

        **void
        QSqlQuery::setNumericalPrecisionPolicy(QSql::NumericalPrecisionPolicy
        precisionPolicy )**

        Instruct the database driver to return numerical values with a precision
        specified by **precisionPolicy**.

        The Oracle driver, for example, can retrieve numerical values as strings
        to prevent the loss of precision. If high precision doesn't matter, use
        this method to increase execution speed by bypassing string conversions.

        Note: Drivers that don't support fetching numerical values with low
        precision will ignore the precision policy. You can use
        **QSqlDriver::hasFeature** () to find out whether a driver supports this
        feature.

        Note: Setting the precision policy doesn't affect the currently active
        query. Call **exec** (QString) or **prepare** () in order to activate
        the policy.

        **See also** **QSql::NumericalPrecisionPolicy**  and
        **numericalPrecisionPolicy** ().
        """
        ...

    def size(self) -> int:
        """
        https://doc.qt.io/qt-6/qsqlquery.html#size

        **int QSqlQuery::size() const**

        Returns the size of the result (number of rows returned), or -1 if the
        size cannot be determined or if the database does not support reporting
        information about query sizes. Note that for non-`SELECT` statements
        (**isSelect** () returns `false`), size() will return -1. If the query
        is not active (**isActive** () returns `false`), -1 is returned.

        To determine the number of rows affected by a non-`SELECT` statement,
        use **numRowsAffected** ().

        **See also** **isActive** (), **numRowsAffected** (), and
        **QSqlDriver::hasFeature** ().
        """
        ...

    def swap(self, other: PySide6.QtSql.QSqlQuery) -> None:
        """
        https://doc.qt.io/qt-6/qsqlquery.html#swap

        **[since 6.2] void QSqlQuery::swap(QSqlQuery & other )**

        Swaps **other** to this object. This operation is very fast and never
        fails.

        This function was introduced in Qt 6.2.
        """
        ...

    @overload
    def value(self, i: int) -> Any:
        """
        https://doc.qt.io/qt-6/qsqlquery.html#value

        **QVariant QSqlQuery::value(int index ) const**

        Returns the value of field **index** in the current record.

        The fields are numbered from left to right using the text of the
        `SELECT` statement, e.g. in

        SELECT forename, surname FROM people;

        field 0 is `forename` and field 1 is `surname`. Using `SELECT *` is not
        recommended because the order of the fields in the query is undefined.

        An invalid **QVariant**  is returned if field **index** does not exist,
        if the query is inactive, or if the query is positioned on an invalid
        record.

        **See also** **previous** (), **next** (), **first** (), **last** (),
        **seek** (), **isActive** (), and **isValid** ().
        """
        ...

    @overload
    def value(self, name: str) -> Any:
        """
        https://doc.qt.io/qt-6/qsqlquery.html#value-1

        **QVariant QSqlQuery::value(const QString & name ) const**

        This is an overloaded function.

        Returns the value of the field called **name** in the current record. If
        field **name** does not exist an invalid variant is returned.

        This overload is less efficient than **value** ()
        """
        ...
